program Sample;

(*

 This is a sample program that demonstrates the usage of the sample database
 code provided for developers with Wildcat 4.0. The main unit upon which
 the sample database code is built upon is the WcDb unit. This unit contains
 an object that encapsulates a IsamFileBlockPtr that the main database
 routines in Btree Filer utilize.


***** TFileBlock *****

 Here is a list of routines in TFileBlock object contained in WcDb and
 their instructions

 procedure Lock;
   {-Locks the fileblock of the current database. This routine can be
     called multiple times and it will increment a lock count. Unlock
     must be called the same number of times to unlock the database}

 procedure Unlock;
   {-Unlocks the fileblock of the database}

 function BuildKey(const Data; Key : Integer) : IsamKeyStr; virtual;
   {-Builds a database key based on the record passed into the Data
     parameter and the Key that is specified. This routine is overriden
     in each of the database units to returns the proper type of key for
     each database}

 {The following routines work exactly like their counterparts in Filer
  (BtGetRec, BtAddRec, BtPutRec) except you don't have to pass in the
  FileBlockPtr because it is part of the object. In the TVFileBlock
  object these routines are overriden to call the appropriate Filer
  routines from the VRec unit}
 procedure GetRec(RefNr : LongInt; var Data); virtual;
 procedure AddRec(var RefNr : LongInt; var Data); virtual;
 procedure PutRec(RefNr : LongInt; var Data); virtual;


 {The following routines work exactly like their counterparts in
  Filer (BtDeleteRec, BtAddKey, BtDeleteKey, BtDeleteAllKeys, BtRecLen,
  BtFileLen, BtFreeRecs, BtUsedRecs, BtUsedKeys, BtClearKey, BtNextDiffKey,
  BtPrevDiffKey, BtSearchKey, BtKeyExists) except that you don't have to
  pass in the IsamFileBlockPtr parameter that the Filer versions require}
 procedure DelRec(RefNr : LongInt); virtual;
 procedure AddKey(KeyNr : Integer; RefNr : LongInt; Key : IsamKeyStr);
 procedure DeleteKey(KeyNr : Integer; RefNr : LongInt; Key : IsamKeyStr);
 procedure DeleteAllKeys(KeyNr : Integer);
 function RecLen : Word;
 function FileLen : LongInt;
 function FreeRecs : LongInt;
 function UsedRecs : LongInt;
 function UsedKeys(KeyNr : Integer) : LongInt;
 procedure ClearKey(KeyNr : Integer);
 procedure NextDiffKey(KeyNr : Integer; var RefNr : LongInt; var Key : IsamKeyStr);
 procedure PrevDiffKey(KeyNr : Integer; var RefNr : LongInt; var Key : IsamKeyStr);
 procedure SearchKey(KeyNr : Integer; var RefNr : LongInt; var Key : IsamKeyStr);
 function KeyExists(KeyNr : Integer; RefNr : LongInt; Key : IsamKeyStr) : Boolean;


 {The following routines work exactly like their counterparts in
  Filer (BtFindKey, BtNextKey, BtPrevKey) except that you don't have to
  pass the IsamFileBlockPtr to them like the Filer routines. Also these
  routines all return a parameter indicating the success of the operation}
 function FindKey(KeyNr : Integer; var RefNr : LongInt; Key : IsamKeyStr) : Boolean;
 function NextKey(KeyNr : Integer; var RefNr : LongInt; var Key : IsamKeyStr) : Boolean;
 function PrevKey(KeyNr : Integer; var RefNr : LongInt; var Key : IsamKeyStr) : Boolean;

 {The following routines are high level routines for adding, deleting, and
  updating records in the database. Each of these routines will automatically
  add or delete keys for the record in the database. You should use these
  routines for adding, deleting, or updating records in the database
  rather then the lower level versions above}

 function AddRecord(var RefNr : LongInt; var Data) : Boolean; virtual;
  {-Adds a new record to the database and the keys for the record. RefNr
    returns the reference to the new record is added. Data is record to be
    added}
 procedure UpdateRecord(var OldData, NewData);
  {-Update a record in the database, automatically deletes the old
    keys and adds new keys if necessary. OldData is the old record,
    NewData is the new record}
 procedure UpdateRecordKey(const Key : IsamKeyStr; var NewData);
  {-Does a search on the primary key for the database and updates the
    record that the key points to with the new record contained in
    NewData. Automatically updates any keys}
 function DeleteRecord(var Data) : Boolean;
  {-Delete the record Data that is passed in and removes any keys
    associated with that record}
 function DeleteRecordKey(const Key : IsamKeyStr) : Boolean;
  {-Does a search on the primary key of the database and deletes the
    record that uses the Key that is passed in}

 {The following routines are used internally by the database object
  and it's various decendents. You should not have to call these
  routines when using the object}

 procedure FatalDBError(const S : String); virtual;
 procedure LogDBError(const S : String); virtual;
 procedure GetCreateInfo(var Len : Word; var Keys : Integer; var IID : IsamIndDescr); virtual;
 procedure PostCreate; virtual;
 function LockOkay : Boolean;
 procedure PutRecordPrim(RefNr : LongInt; var OldData, NewData); virtual;
 procedure DeleteRecordPrim(RefNr : LongInt; var Data); virtual;

(*************************** TVFileBlock *****************************

 Here is a list of routines from the TVFileBlock object. The TVFileBlock
 object is a object that encapulates a Filer IsamFileBlockPtr that is
 being used to access a database that contains variable sized records using
 the VRec unit that comes with Btree Filer:

 function DataLen(const Data) : Word; virtual;
  {-Returns the len of the variable sized record that is passed in the
    Data parameter}
 procedure GetRec(RefNr : LongInt; var Data); virtual;
  {-Overrides the TFileBlock.GetRec and makes the proper call to load a
    variable sized record}
 procedure AddRec(var RefNr : LongInt; var Data); virtual;
  {-Overrides the TFileBlock.AddRec and makes the proper call to load a
    variable sized record}
 procedure PutRec(RefNr : LongInt; var Data); virtual;
  {-Overrides the TFileBlock.PutRec and makes the proper call to load a
    variable sized record}
 procedure DelRec(RefNr : LongInt); virtual;
  {-Overrides the TFileBlock.DelRec and makes the proper call to load a
    variable sized record}
 procedure GetRecPart(RefNr : LongInt; var Data; Len : Word);
  {-Exactly the same as the BtGetVariableRecPart routine that is in the VRec
    unit except that you don't have to pass the IsamFileBlockPtr paramter}

 {the following routines allow you to get, add, delete, and update fixed
  sized records in a VRec database}
 procedure GetFixedRec(RefNr : LongInt; var Data);
 procedure AddFixedRec(var RefNr : LongInt; var Data);
 procedure DelFixedRec(RefNr : LongInt);
 procedure PutFixedRec(RefNr : LongInt; var Data);

(*************************** TFileDb *****************************

 The TFileDb object is used in accessing the file database. It is
 derived from the TVFileBlock and the TFileBlock objects. This means
 that you can call any routines that are in those objects from this
 object.

 The only methods in this object override methods from the other
 two objects. You should add, delete, and update records in the
 file database calling the high level database routines in the TFileBlock.

 Here is an example of using the file database object:

 var
   RefNr : LongInt;
   Key : IsamKeyStr;


 if FileDb.Init then


(*************************** TUserDb *****************************

 The TUserDb object is used in accessing the user database. It is
 derived from the TFileBlock objects This means that you can call any
 routines that are in TFileBlock from this object.

 The only methods in this object override methods from the other
 two objects. You should add, delete, and update records in the
 user database calling the high level database routines in the TFileBlock.

 The user database only offers access to the fixed portion of a user record.
 Wildcat also keeps a secondary database to store the data that Wildcat
 stores on a conference by conference basis. In order to access this
 information on a user you need to use the TUserWrapper object which hides
 all of the messy stuff for getting access to the conference data. In order
 to construct a TUserWrapper you must first have a TUserRec filled with
 User information from the user database.

 To load a user record you might do something like this:

 var
   RefNr : LongInt;
   UserRec : TUserRec;
   LastRead : Word;

 if not UserDb.Init then begin
   WriteLn('Unable to open the user database');
   Exit;
 end;
 if UserDb.FindKey(UserRealKey, RefNr, 'SCOTT HUNTER') then begin
   UserDb.GetRec(RefNr, UserRec);

 At this point we have a user record loaded and now we will create a
 UserWrapper to access the conference data such as the users last message
 read in a conference.

 UserConfPtr = New(TUserWrapper, Init(@UserRec));
 if UserConfPtr = nil then begin
   {out of memory, display error message}
   Exit;
 end;

 LastRead := UserConfPtr^.GetLastRead(4); {this gets the users last read
                                           message from conference 4}

 Then when we are done with accessing the user record we free the pointer
 to the TUserWrapper:

 Dispose(UserConfPtr, Done);

 Note: You only have to do the work of allocating a UserWrapper if you need
 access to the conference members of a user record. For just accessing a
 TUserRec you don't need any of the following steps.


 constructor Init(var UserRec : TUserRec);
  {-This is used to initial a TUserWrapper for use, pass in the UserRec
    parameter the user whom you wish to do operations on}
 destructor Done; virtual;
  {-Call this when you no longer need your user wrapper}
 procedure SetDirty;
  {-The user wrapper caches data in pages in order to be fast, however
    sometimes you need to force a reload of the data from disk to see
    if changed}
 function GetFlags(Conf : Word) : Byte;
  {-Returns the conference flags for a user in Conf conference. See the
    cuf* flags in WCTYPE.PAS for these flags}
 function FlagIsSet(Mask : Byte; Conf : Word) : Boolean;
  {-Returns a boolean indicating if the flags passed in Mask are set in Conf
   for the user}
 function NextSet(Mask : Byte; Current : Word) : Word;
  {-Will return the next conference after Current that the flags set in
    Mask are set. If none are found the routine will return NoMoreBits}
 function PrevSet(Mask : Byte; Current : Word) : Word;
  {-Will return the previous conference before Current that the flags set in
   Mask are set. If none are found the routine will return NoMoreBits}
 function FirstSet(Mask : Byte) : Word;
  {-Returns the first conference the user has the flags set in Mask set.
    If none are found the routine will return NoMoreBits}
 function LastSet(Mask : Byte) : Word;
  {-Returns the first conference the user has the flags set in Mask set.
    If none are found the routine will return NoMoreBits}
 function FlagsSet(Mask : Byte) : Word;
  {-Returns a count of how many conference the flags past in Mask are set
    for the user}
 procedure SetAllFlags(Mask : Byte);
  {-Sets the flags specified in Mask for all conferences}
 procedure ClearAllFlags(Mask : Byte);
  {-Clears the flags specified in Mask for all conferences}
 procedure ToggleFlag(Mask : Byte; Conf : Word);
  {-Toggles the flags specified in Mask for all conferences}
 function GetLastRead(Conf : Word) : Word;
  {-Returns the user last message read pointer for Conf conference}
 function GetFirstUnread(Conf : Word) : Word;
  {-Returns the first unread message # to the user in conference Conf}
 procedure SetFlags(Conf : Word; NewFlags : Byte);
  {-Sets the flags in NewFlags for the user in conference Conf}
 procedure SetLastRead(Conf, NewLastRead : Word);
  {-Sets the users last read pointer in conference Conf to NewLastRead}
 procedure SetFirstUnread(Conf, NewFirstUnread: Word);
  {-Sets the users first unread pointer in conference Conf to NewFirstUnread}
 procedure SetFlags_LastRead(Conf : Word; NewFlags : Byte; NewLastRead : Word);
  {-Set the users flags to NewFlags and last message read to NewLastRead
    in conference Conf}

 {The following routines are used internally by the user wrapper and
  should not be called directly by your code}
 function GetConfPage(Conf : Word) : Integer;
 procedure LoadConfPage(Conf : Word; ForceLoad : Boolean);
 procedure SaveConfPage;

*)

(*************************** TMsgDb *****************************

 The TMsgDb object is a special object in that with Wildcat 4.0 for the
 first time we are not using Btree Filer for the message sub-system. We
 now use a flat file message system that allows for much faster adding
 of messages to the database. This object still behaves very much like
 a Filer object. You can check IsamOk to check for errors just like you
 would in the other objects. To use the object you call the contructor
 with the conference you wish to access and then call the various members.

 Here is a short example of opening a conference and reading message
 number 100 from conference 0.

 var
   RefNr : LongInt;
   MsgHdr : TMsgHeader;


 if not MsgDb.Init(0) then begin
   WriteLn('Unable to open the message database');
   Exit;
 end;
 RefNr := FindMsg(100);
 if IsamOk then begin
    GetMsgHeaderAndText(RefNr, MsgHdr, 0, SizeOf(Buffer));
    if not IsamOk then
      WriteLn('Error loading message');
 end else
   WriteLn('Unable to find message 100');


 constructor Init(AConf : Word);
  {-Initialize a message database object for the given conference number}
 destructor Done; virtual;
  {-Shut down a conference object, must be called to close files}
 procedure Lock;
  {-Lock the database, used internally by AddMsg and MarkMsgRead}
 procedure Unlock;
  {-Unlock the database}
 function AddMsg(var ref: Longint; var msg: TMsgHeader; msgtext: PMsgText) : Boolean;
  {-Add a message to the database given a message header (msg) and text (msgtext).
    Returns the new reference number in ref}
 function FindMsg(msgnum: Word): Longint;
  {-Given a message number, this returns the reference number at which
    it was found}
 function SearchMsg(msgnum: Word): Longint;
  {-Given a message number, this returns the reference number of the
    message that has the same or a higher message number (if the
    requested message number doesn't exist}
 procedure NextMsg(var ref: Longint);
  {-This will increment a reference number to point to the next message}
 procedure PrevMsg(var ref: Longint);
  {-This will decrement a reference number to point to the previous message}
 procedure GetMsgStatus(var msr: TMsgStatus);
  {-This will return the lowest, highest, and number of active (not
    deleted) messages in the database}
 procedure GetMsgHeader(ref: Longint; var msg: TMsgHeader);
  {-This will get the message header for a given reference number}
 procedure GetMsgHeaderAndText(ref: Longint; var msg: TMsgHeader; buffer: PMsgText; offset, len: Word);
  {-Reads the message header and the text for a given reference number.
    The offset and len parameters tell the procedure

*)

uses
  Dos,
  Crt,
  WcType,
  WcGlobal,
  WcFileDb,
  WcUserDb,
  WcMsgDb,
  WcMisc,
  Filer;


  function InitFiler : Boolean;
  begin
    BtInitIsam(NetSupportType(MwConfig.Network), MinimizeUseOfNormalHeap, 0);
    InitFiler := IsamOk;
  end;


  function LoadMakeWild(var MwConfig : TMakewildRec) : Boolean;
  var
    F : File of TMakewildRec;
    SaveFileMode : Word;

  begin
    LoadMakewild := False;
    Assign(F, 'MAKEWILD.DAT');
    SaveFileMode := FileMode;
    FileMode := ShareMode;
    Reset(F);
    FileMode := SaveFileMode;
    if IoResult <> 0 then
      Exit;
    Read(F, MwConfig);
    LoadMakewild := IoResult = 0;
    Close(F);
    if IoResult = 0 then
      {ignore};
  end;


  function Register : Boolean;
  begin
    Register := False;
    if not LoadMakeWild(MwConfig) then
      Exit;
    if not InitFiler then
      Exit;
    OpenFile(NodeInfoFile, MwConfig.NodeInfoPath+'NODEINFO.DAT', SizeOf(TMasterInfo));
    Register := True;
  end;


  procedure UnRegister;
  begin
    CloseFile(NodeInfoFile);
  end;

var
  HighPtr : Word;
  RefNr : LongInt;
  KeyStr : IsamKeyStr;
  UserRec : TUserRec;


  procedure CheckConference(const Name : String; Conf, FirstUnread : Word);
  var
    Count : Word;
    RefNr : LongInt;
    MsgHdr : TMsgHeader;

  begin
    if MsgDb.Open(Conf, False) then
      begin
        Count := 0;
        RefNr := MsgDb.FindMsg(FirstUnread);
        if not IsamOk then
          WriteLn('Unable to find first message');
        while IsamOk do
          begin
            Inc(Count);
            MsgDB.GetMsgHeader(RefNr, MsgHdr);
            with MsgHdr do
              if FlagIsSet(mFlags, mfReceived) then
                WriteLn('Msg ', MsgNumber:5, ' is marked as received, prev link = ',
                        PrevUnread:5, ' next link = ', NextUnread:5)
              else
                WriteLn('Msg ', MsgNumber:5, ' is unread            , prev link = ',
                        PrevUnread:5, ' next link = ', NextUnread:5);
            if MsgHdr.NextUnread > MsgHdr.MsgNumber then
              begin
                RefNr := MsgDb.FindMsg(MsgHdr.NextUnread);
                if not IsamOk then
                  WriteLn('Error find next message in chain');
              end
            else
              IsamOk := False;
          end;
        if Count = 0 then
          WriteLn('No messages found, firstunread is wrong');
        MsgDb.Done;
      end
    else
      WriteLn('Unable to access conference ', Conf);
  end;

var
  Len,
  I           : Byte;
  Name        : String[25];
  Io,
  FirstUnread : Word;
  F           : File;
  Found       : Boolean;


begin
  if not Register then
    begin
      WriteLn('Unable to initialize.');
      Exit;
    end;

  {user database sample}
  if not UserDb.Init then
    begin
      WriteLn('Unable to open the user database.');
      Exit;
    end;

  I := 1;
  while I <= ParamCount do
    begin
      Name := Name + ' ' + Trim(ParamStr(I));
      Inc(I);
    end;

  if Length(Name) = 0 then
    Name := 'Paul Davis';

  Name := Trim(Name);
  WriteLn(Name);
  Found := False;

  MsgDb.Init; {Initialize MsgDB object}

  if UserDb.FindKey(UserRealKey, RefNr, StUpcase(Name)) then
    begin
      UserDb.GetRec(RefNr, UserRec);
      if IsamOk then
        begin
          UserConfPtr := New(PUserWrapper, Init(UserRec));
          for I := 0 to MwConfig.MaxConfAreas - 1 do
            begin
              FirstUnread := UserConfPtr^.GetFirstUnread(I);
              if FirstUnread > 0 then
                begin
                  WriteLn('Mail in ', I);
                  CheckConference(Name, I, FirstUnread);
                  Found := True;
                end;
            end;
          if not Found then
            WriteLn('User has no mail waiting');
          Dispose(UserConfPtr, Done);
        end;
    end
  else
    WriteLn('Unable to find ', Name);

  UnRegister;
end.
