program MsgCheck;

uses
  Crt,
  QxIndex,
  QxStub,
  WcType,
  WcGlobal,
  WcFileDb,
  WcUserDb,
  WcMsgDb,
  WcMisc,
  Filer;

  function InitFiler : Boolean;
  begin
    BtInitIsam(NetSupportType(MwConfig.Network), MinimizeUseOfNormalHeap, 0);
    InitFiler := IsamOk;
  end;

  function LoadMakeWild(var MwConfig : TMakewildRec) : Boolean;
  var
    F : File of TMakewildRec;
    SaveFileMode : Word;

  begin
    LoadMakewild := False;
    Assign(F, 'MAKEWILD.DAT');
    SaveFileMode := FileMode;
    FileMode := ShareMode;
    Reset(F);
    FileMode := SaveFileMode;
    if IoResult <> 0 then
      Exit;
    Read(F, MwConfig);
    LoadMakewild := IoResult = 0;
    Close(F);
    if IoResult = 0 then
      {ignore};
  end;


  function Register : Boolean;
  begin
    Register := False;
    if not LoadMakeWild(MwConfig) then
      Exit;
    if not InitFiler then
      Exit;
    OpenFile(NodeInfoFile, MwConfig.NodeInfoPath+'NODEINFO.DAT', SizeOf(TMasterInfo));
    Register := True;
  end;


  procedure UnRegister;
  begin
    CloseFile(NodeInfoFile);
  end;

var
  X        : Word;
  MsgStats : TMsgStatus;
  Conf     : TConfDesc;

begin
  MsgDb.Init;   {Must do this to start the message databases}

  if not Register then
    begin
      WriteLn('Unable to register');
      Exit;
    end;
  Writeln('Conferences that should be renumbered:');
  for x := 1 to MwConfig.MaxConfAreas do
    if LoadConfDesc(Conf, x) and (Conf.Confname <> '') then
      if MsgDB.Open(x, False) then
        begin
          Write(Pad(Long2Str(x),5),' ',Pad(Conf.Confname,25),'  High Msg - ',MsgStats.HighMsg);
          ClrEol;
          MsgDB.GetMsgStatus(MsgStats);
          If MsgStats.HighMsg > 60000 then
            Writeln
          else
            Gotoxy(1,WhereY);
          MsgDB.Done;
        end;
  UnRegister;
end.
