program ListFile;

uses
  QxIndex,
  QxStub,
  WcType,
  WcGlobal,
  WcFileDb,
  WcUserDb,
  WcMisc,
  Filer;

  function InitFiler : Boolean;
  begin
    BtInitIsam(NetSupportType(MwConfig.Network), MinimizeUseOfNormalHeap, 0);
    InitFiler := IsamOk;
  end;


  function LoadMakeWild(var MwConfig : TMakewildRec) : Boolean;
  var
    F : File of TMakewildRec;
    SaveFileMode : Word;

  begin
    LoadMakewild := False;
    Assign(F, 'MAKEWILD.DAT');
    SaveFileMode := FileMode;
    FileMode := ShareMode;
    Reset(F);
    FileMode := SaveFileMode;
    if IoResult <> 0 then
      Exit;
    Read(F, MwConfig);
    LoadMakewild := IoResult = 0;
    Close(F);
    if IoResult = 0 then
      {ignore};
  end;


  function Register : Boolean;
  begin
    Register := False;
    if not LoadMakeWild(MwConfig) then
      Exit;
    if not InitFiler then
      Exit;
    OpenFile(NodeInfoFile, MwConfig.NodeInfoPath+'NODEINFO.DAT', SizeOf(TMasterInfo));
    Register := True;
  end;


  procedure UnRegister;
  begin
    CloseFile(NodeInfoFile);
  end;

var
  MatchStr,
  FileKey,
  UserKey  : IsamKeyStr;
  FileRef,
  UserRef  : LongInt;
  FileInfo : TFileRec;
  User     : TUserRec;

begin
  if not Register then
    begin
      WriteLn('Unable to register');
      Exit;
    end;

  if not UserDB.Init then
    begin
      WriteLn('Could not init USERDB');
      Exit;
    end;


  if not FileDB.Init then
    begin
      WriteLn('Could not init FILEDB');
      Exit;
    end;

  FileDB.ClearKey(FileAreaKey);

  FileDB.NextKey(FileAreaKey, FileRef, FileKey);

  if not IsamOk then
    WriteLn('No Files Found In System');

  while IsamOk do
    begin
      FileDB.GetRec(FileRef, FileInfo);
      WriteLn('Found File : '+FileInfo.FileName);
      if (FileInfo.UploaderID = 0) and (FileInfo.Uploader <> '') then
        begin
          UserKey := FileInfo.Uploader;
          UserDB.SearchKey(UserNameKey, UserRef, UserKey);

          if IsamOk then
            begin
              UserDb.GetRec(UserRef, User);
              WriteLn('Uploader: '+User.UserName);
            end
          else
            WriteLn('Uploader: None Found');
        end
      else
        begin
          UserKey := Long2Str(FileInfo.UploaderID);
          if UserDB.FindKey(UserIdKey, UserRef, UserKey) then
            begin
              UserDb.GetRec(UserRef, User);
              WriteLn('Uploader: '+User.UserName);
            end
          else
            WriteLn('Uploader: None Found');
        end;
      if IsamOk then ;

      FileDB.NextKey(FileAreaKey, FileRef, FileKey);
    end;

  UnRegister;
end.