/* Function prototype for precompiling a program from CA-Visual Realia    
    Last change:  RAS  29 Jun 94   11:53 am
 */


// The return codes should be returned from the precompiler DLL                               
#define RESPONSE_SUCCESS    (0)                               
#define RESPONSE_WARNING    (4)                               
#define RESPONSE_ERROR      (8)                               


                               
// Callback procedure function protogype.  The callback procedure and its
// parameters are described below.
typedef BOOL (FAR PASCAL *PRECOMPCALLBACK)( const LPSTR lpszStatusMessage,
                                            const short nPerCentComplete);


// This structure corresponds to the parameters passed to this precompiler
// by CA-Visual Realia.  Each parameter is described in the comments following
// the structure definition.
typedef struct tagParam
{
    HWND    hwndParent; 
    LPSTR   lpszFullFileName; 
    LPSTR   lpszInputFileName;
    LPSTR   lpszOutputFileName;
    LPSTR   lpszListingFileName;
    LPSTR   lpszErrorFileName;
    LPSTR   lpszOptionsBlock; 
    LPSTR   lpszProgramName;
    LPSTR   lpszPrecompilerName;
    PRECOMPCALLBACK lpfnPreCompCallback;
} PRECOMPINFO, FAR * LPPRECOMPINFO;

     
// hwndParent           will be the window handle of the VR main window.
//
// lpszFullFileName     will be a pointer to the fully qualified file name of 
//                      the original COBOL program being compiled. If this is not 
//                      the first precompiler step for this program, the name of 
//                      the input file will differ from this.
//
// lpszInputFileName    will be a pointer to the fully qualified file name of the 
//                      input source file.
//
// lpszOutputFileName   will be a pointer to the fully qualified file name to be 
//                      created as a generated COBOL source file. 
//
// lpszListingFileName  will be a pointer to the fully qualified file name to be 
//                      created as a listing file. If the precompiler definition 
//                      file defines ErrorMerge=YES, this listing file must be in 
//                      a compatible format for extracting errors and merging them 
//                      with the original source file. 
//
// lpszErrorFileName    will be a pointer to the fully qualified file name to be 
//                      created as an error file. If the precompiler definition file 
//                      does not define ErrorMerge=YES, this file will be displayed 
//                      to the user when there are precompiler errors.
//
// lpszOptionsBlock     will be a pointer to a buffer of options settings. This is 
//                      the same format as passed to the options dialog and returned 
//                      from it. It contains a series of strings, each null terminated. 
//                      An extra trailing null is placed after the last string to denote 
//                      the end of the buffer. VR will automatically add the options 
//                      APOST=Y|N and CA_PRODUCT_NAME=CAVR to the buffer. The variable 
//                      CA_OPTIONS_FILE= will be set to the name of the file containing 
//                      the compiler and precompiler options. 
//
// lpszProgramName      will be a pointer to the file name and extension of the program 
//                      being precompiled. This may be used for listings or error report 
//                      headings.
//
// lpszPrecompilerName  will be a pointer to the step name of the precompiler being 
//                      executed. This may be used for listings or error report headings.
//
// lpfnPreCompCallback  will be the address of a callback routine within Visual Realia. 
//                      A precompiler should call this function periodically during a 
//                      precompilation. The routine will allow any outstanding Windows 
//                      messages to be processed, and will allow other applications to 
//                      run, to prevent the system from being locked during a possibly 
//                      lengthy precompile. The function prototype is:
//
//                      typedef BOOL (CALLBACK* PRECOMPCALLBACK)    
//                          ( const LPSTR lpszStatusMessage,       
//                            const SHORT nPerCentComplete );
//
//                      The call to the callback function from the precompiler DLL may 
//                      provide a status message to be displayed on the CA-Visual Realia 
//                      status line at the bottom of the project manager window. The 
//                      precompiler should pass NULL if no message is to be shown. The 
//                      callback function will return TRUE if the precompile is to continue, 
//                      and FALSE if the user has requested to terminate the build. If FALSE, 
//                      the precompiler may immediately terminate or continue processing; in 
//                      either case the build will end after the precompiler returns to 
//                      CA-Visual Realia, without proceeding to the next step of the build.
//
//                      The parameter nPerCentComplete is not processed by CA-Visual Realia 
//                      at this time.  The parameter may assume values from 0 to 100.  Any 
//                      other value will be ignored. When supported, this will control the 
//                      display of a status bar in the CA-Visual Realia project manager 
//                      window. Until this parameter is honored, the caller should place the 
//                      percentage completed in the status message shown to the user.  
//
//                      Only one of lpszStatus Message and nPerCentComplete will be processed. 
//                      Currently, nPerCentComplete will always be ignored and the parameter 
//                      lpszStatusMessage will be processed. When support is provided for 
//                      nPerCentComplete, the status bar will be shown if the value is 0 to 
//                      100. If any other value is passed (for example -1), then the status 
//                      bar will not be shown, and lpszStatusMessage will be processed as 
//                      described above.                     
//
//




UINT FAR PASCAL __export 
ProcessPrecompile(  const HWND  hwndParent, 
                    const LPSTR lpszFullFileName, 
                    const LPSTR lpszInputFileName,
                    const LPSTR lpszOutputFileName,
                    const LPSTR lpszListingFileName,
                    const LPSTR lpszErrorFileName,
                    const LPSTR lpszOptionsBlock, 
                    const LPSTR lpszProgramName,
                    const LPSTR lpszPrecompilerName, 
                    const PRECOMPCALLBACK lpfnPreCompCallback);

