/* Function prototype for Options Dialog processing
	Last change:  RAS  29 Jun 94    1:35 pm
 */

// Symbols for the maximum options block that can be provided and
// saved by CA-Visual Realia.                                 
#define MAXOPTIONSBLOCKSIZE 4096                               
#define UPDATABLE           (0)
#define READONLY            (1)
                               
// This structure has a data item for each parameter passed by 
// CA-Visual Realia.  Each parameter is described in the comments following
// the structure definition.                               
typedef struct tagParam
{
    HWND    hwndParent; 
    LPSTR   lpszOldOptionsBlock; 
    LPSTR   lpszNewOptionsBlock;
    LPSTR   lpszProgramName;
    LPSTR   lpszPrecompilerName;
    LPSTR   lpszHelpFileName;
    unsigned short  fReadOnly;
} OPTIONINFO, FAR * LPOPTIONINFO;        

     
// hwndParent           will be the window handle of the VR main window.
//
// lpszOldOptionsBlock  will be a pointer to a buffer of the current options settings. 
//                      It contains a series of null terminated strings. An extra 
//                      trailing null is placed after the last string to denote the 
//                      end of the buffer. 
//
// lpszNewOptionsBlock  will be a pointer to a buffer that has been provided by VR to 
//                      hold new options settings. The options DLL must format the new 
//                      options settings in the same way as the input settings, and 
//                      copy the settings to this storage area. The data copied must 
//                      not exceed 4096 characters, including trailing NULL characters. 
//
// lpszProgramName      will be a pointer to the file name and extension of the program 
//                      being precompiled. This may be used for listings or error report 
//                      headings.
//
// lpszPrecompilerName  will be a pointer to the step name of the precompiler being 
//                      executed. This may be used for listings or error report headings.
//
// lpszHelpFileName     will be a pointer to the file name and extension of a help file. 
//                      The name is picked up from the HELP= entry in the precompiler 
//                      definition file. VR will locate the file and pass the full name. 
//                      If the file cannot be located, the help file name will be a string 
//                      with zero length.
//
// fReadOnly            will be a Boolean flag indicating whether the options are changeable 
//                      or read-only. If the options are read-only, the dialog should 
//                      prevent the options from being updated. 

BOOL FAR PASCAL __export 
ProcessOptionsDialog(const  HWND    hwndParent, 
                     const  LPSTR   lpszOldOptionsBlock, 
                            LPSTR   lpszNewOptionsBlock,
                     const  LPSTR   lpszProgramName,
                     const  LPSTR   lpszPrecompilerName,
                     const  LPSTR   lpszHelpFileName,
                     const  BOOL    fReadOnly);
