#if 0
---------------------------------------------------------------------------
fmtrfile.h  - Struct and associated defs for transfer file list

---------------------------------------------------------------------------
Changes:
  EOE 07JUL92****: Beta C Freeze
										2.05 release freeze
  EOE 14MAY92/001: ADD: support also Tiff files
---------------------------------------------------------------------------
#endif

#ifndef __FMTRFILE_H__
#define __FMTRFILE_H__

#include "fmlist.h"

// Indexes into the handle array
#define TRFI_NAME 	0
#define TRFI_TITLE	1
#define TRFI_MAX  	TRFI_TITLE
#define TRF_BADI(i) (i < 0 || i >TRFI_MAX)

// Enum types to describe each file in a list
// EOE 14MAY92/001: ADD: support also Tiff files
enum filetype {ftypeASCII=0, ftypePCX, ftypeDCX, ftypeTIFF, ftypePCL=16, ftypeOTHER=129};

enum membertype {normal, logo, covertext, listhead};

typedef struct trfile {
	FMLIST  _list;
	BYTE 		filetype;
	BYTE	 	subtype;
	WORD 		pages;
	HANDLE  handles[TRFI_MAX+1];
} TRFILE, FAR* LPTRFILE;

typedef HANDLE HTRFILE;

#define FMTRF_LOCK(hTrfile)   	(LPTRFILE)  FmListLock((LISTHANDLE)hTrfile)
#define FMTRF_UNLOCK(lpTrfile)  (HTRFILE)   FmListUnlock((LPFMLIST)lpTrfile)
#define FMTRF_DELETEH(hTrfile)              FmTrfDelete(FMTRF_LOCK(hTrfile))
#define FMTRF_LISTRESET()             			FmListReset(FMLIST_TRFILE)
#define FMTRF_LISTNEXT()  			(LPTRFILE)  FmListNext(FMLIST_TRFILE)
#define FMTRF_NEW()       			(LPTRFILE)  FmListNew(FMLIST_TRFILE,\
																						sizeof(TRFILE), LISTF_INSTAIL)
#define FMTRF_COUNT()                 			FmListCount(FMLIST_TRFILE)

#ifdef __cplusplus                      // TpO 13Aug93 added for C comp
extern "C" {
#endif
int FAR PASCAL _export FmTrfDelete(LPTRFILE lpTrfile);
int FAR PASCAL _export FmTrfGetIndexField(LPTRFILE lpTrfile, int iIndex, LPSTR lpBuffer, int len);
int FAR PASCAL _export FmTrfSetIndexField(LPTRFILE lpTrfile, int iIndex, LPSTR lpBuffer, int len);
int FAR PASCAL _export FmTrfListDelete(void);
#ifdef __cplusplus                      // TpO 13Aug93 added for C comp
}
#endif

#endif
