; ---------------------------------------------------------------------
;
; MathGlue.Asm - Math Components App Glue - QuickTime for Windows
;
;                Version 1.0
;
;                (c) 1988-1993 Apple Computer, Inc. All Rights Reserved.
;
; ---------------------------------------------------------------------


        .MODEL SMALL, C
        .386

        .DATA
EXTERN   lpfnQTComponentManager:DWORD  ; pointer to CompMgr EntryPoint


        .CODE

         ASSUME DS: DGROUP


;///////////////////////////////////////////////////////////////////////////
; ComponentFunc Macro
;   Define code used for each glue function

ComponentFunc MACRO sel:req, name:req
name  PROC FAR                         ; define as public far function
   push  ds                            ; save current DS
   mov   bx, sel                       ; load function selector
   mov   ax, 2                         ; generic component ID
   call  DWORD PTR lpfnQTComponentManager ; call the Component Manager
   pop   ds                            ; restore DS
   ret                                 ; far return
name  ENDP
   EVEN                                ; make sure aligned on even boundary
ENDM


;///////////////////////////////////////////////////////////////////////////
; Add Glue Functions
;   Including functions expands macro into function definitions

   EVEN                                ; make sure aligned on even boundary
   INCLUDE addfs.inc


;///////////////////////////////////////////////////////////////////////////
; Sum Glue Functions
;   Including functions expands macro into function definitions

   EVEN                                ; make sure aligned on even boundary
   INCLUDE sumfs.inc

END
