' Require that all variables be declared
Option Explicit

' Style flag used by the Show Method
Global Const MODELESS = 0
Global Const MODAL = 1

' Picture display time in milliseconds
Global Const DISPLAYTIME = 8000

' Global data
Global BorderWidth As Integer     ' Width of frmEachPic border
Global BorderHeight As Integer    ' Height of frmEachPic border

Global PictureCount As Integer    ' Count of Pictures in PicturePath
Global PictureNum As Integer      ' Current Picture number

Global PicturePath As String      ' Path containing the Pictures
Global PictureName() As String    ' Picture name array

Sub DisplayThePictures ()
    Dim FileName As String      ' Current picture file name
    
'   Initialize the picture count data
    PictureCount = 0
    PictureNum = 0

'   Find the first Picture in the Picture path
    FileName = Dir$(PicturePath + "\*.PIC")

'   Loop through the path to get a count of the Pictures
    While (FileName <> "")
        PictureCount = PictureCount + 1
        FileName = Dir$
    Wend

'   Let the user know if there's no Pictures in this directory,
'   then end the program

    If PictureCount = 0 Then
        MsgBox "There are no pictures in directory " + PicturePath, 0, "EachPic"
        End
    End If

'   Dimension the PictureName array depending on the number
'   of Pictures in the path
    ReDim PictureName(PictureCount) As String

'   One more time, get the first Picture in the path
    FileName = Dir$(PicturePath + "\*.Pic")

'   Load the PictureName array with all the Picture names
    While (FileName <> "")
        PictureName(PictureNum) = FileName
        PictureNum = PictureNum + 1
        FileName = Dir$
    Wend

'   Go to the first picture and show it
    PictureNum = 0
    ShowPicture
End Sub

Sub Main ()
'   Calculate the frame border width and height
    BorderWidth = frmEachPic.Width - frmEachPic.ScaleWidth
    BorderHeight = frmEachPic.Height - frmEachPic.ScaleHeight

'   Load the directory form
    frmEachPicDir.Show MODAL

'   Load the picture form; display the pictures
    Load frmEachPic
    DisplayThePictures
End Sub

Sub ShowPicture ()
'   Frame coordinate data
    Dim formLeft As Long, formTop As Long
    Dim formWidth As Long, formHeight As Long

'   If the Picture number exceeds the array limit, we're done
    If PictureNum >= PictureCount Then End

'   Hide the Picture form so we can adjust its size and location
    frmEachPic.Hide

'   Set the Picture name from the array
    frmEachPic!QTPicture1.PictureName = PicturePath + "\" + PictureName(PictureNum)

'   Calculate the frame dimensions to exactly fit the Picture
    formWidth = frmEachPic!QTPicture1.Width + BorderWidth
    If formWidth > Screen.Width Then formWidth = Screen.Width

    formHeight = frmEachPic!QTPicture1.Height + BorderHeight
    If formHeight > Screen.Height Then formHeight = Screen.Height

'   Calculate the frame position at screen center
    formLeft = (Screen.Width - formWidth) / 2
    If formLeft < 0 Then formLeft = 0

    formTop = (Screen.Height - formHeight) / 2
    If formTop < 0 Then formTop = 0

'   Move the frame
    frmEachPic.Move formLeft, formTop, formWidth, formHeight

'   Show the Picture frame
    frmEachPic.Show MODELESS

'   On the first picture, set the timer interval
    If PictureNum = 0 Then
        frmEachPic!tmrPicture.Interval = DISPLAYTIME
    End If
End Sub

