' Require that all variables be declared
Option Explicit

' Style flag used by the Show Method
Global Const MODELESS = 0
Global Const MODAL = 1

' Global data
Global BorderWidth As Integer   ' Width of frmEachMov border
Global BorderHeight As Integer  ' Height of frmEachMov border

Global MovieCount As Integer    ' Count of movies in MoviePath
Global MovieNum As Integer      ' Current movie number

Global MoviePath As String      ' Path containing the movies
Global MovieName() As String    ' Movie name array

Sub Main ()
'   Calculate the frame border width and height
    BorderWidth = frmEachMov.Width - frmEachMov.ScaleWidth
    BorderHeight = frmEachMov.Height - frmEachMov.ScaleHeight

'   Load the directory form
    frmEachMovDir.Show MODAL

'   Load the movie form; start playing the movies
    Load frmEachMov
    StartTheMovies
End Sub

Sub PlayMovie ()
'   Frame coordinate data
    Dim formLeft As Long, formTop As Long
    Dim formWidth As Long, formHeight As Long

'   If the movie number exceeds the array limit, we're done
    If MovieNum >= MovieCount Then End

'   Hide the movie form so we can adjust its size and location
    frmEachMov.Hide

'   Set the movie name from the array
    frmEachMov!QTMovie1.MovieName = MoviePath + "\" + MovieName(MovieNum)

'   Suppress the movie controller
    frmEachMov!QTMovie1.Visible = False

'   Calculate the frame dimensions to exactly fit the movie
    formWidth = frmEachMov!QTMovie1.Width + BorderWidth
    If formWidth > Screen.Width Then formWidth = Screen.Width
    formHeight = frmEachMov!QTMovie1.Height + BorderHeight
    If formHeight > Screen.Height Then formHeight = Screen.Height

'   Calculate the frame position at screen center
    formLeft = (Screen.Width - formWidth) / 2
    If formLeft < 0 Then formLeft = 0

    formTop = (Screen.Height - formHeight) / 2
    If formTop < 0 Then formTop = 0

'   Move the frame
    frmEachMov.Move formLeft, formTop, formWidth, formHeight

'   Show the movie frame
    frmEachMov.Show MODELESS
End Sub

Sub StartTheMovies ()
    Dim FileName As String      ' Current movie file name
    
'   Initialize the movie count data
    MovieCount = 0
    MovieNum = 0

'   Find the first movie in the movie path
    FileName = Dir$(MoviePath + "\*.mov")

'   Loop through the path to get a count of the movies
    While (FileName <> "")
        MovieCount = MovieCount + 1
        FileName = Dir$
    Wend

'   Let the user know if there's no movies in this directory,
'   then end the program

    If MovieCount = 0 Then
        MsgBox "There are no movies in directory " + MoviePath, 0, "EachMov"
        End
    End If

'   Dimension the MovieName array depending on the number
'   of movies in the path
    ReDim MovieName(MovieCount) As String

'   One more time, get the first movie in the path
    FileName = Dir$(MoviePath + "\*.mov")

'   Load the MovieName array with all the movie names
    While (FileName <> "")
        MovieName(MovieNum) = FileName
        MovieNum = MovieNum + 1
        FileName = Dir$
    Wend

'   Go to the first movie and play it
    MovieNum = 0

'   Set the timer interval to start the next movie
    frmEachMov!tmrMovie.Interval = 1
End Sub

