
; ---------------------------------------------------------------------
;
; DISPATCH.ASM - QuickTime for Windows Sample Decompressor
;
;                Version 1.1
;
;                (c) 1988-1993 Apple Computer, Inc. All Rights Reserved.
;
; ---------------------------------------------------------------------


INCLUDE  QTMACROS.INC

ComponentFunc MACRO Sel:req, Name:req
codec&Name EQU   Sel              ;; define selector
         ENDM
INCLUDE  CDFUNCS.INC

DGROUP   GROUP   _DATA
_DATA    SEGMENT PARA PUBLIC 'DATA'
_DATA    ENDS

CODESEG  SEGMENT PARA USE16 PUBLIC 'CODE'
         OPTION LANGUAGE:C
        .386
         ASSUME  DS:DGROUP
INCLUDE  SCSTABLE.INC             ; Must be in code segment

         EXTERN  C cfBandDecompress:NEAR
         EXTERN  C cfGetCodecInfo:NEAR
         EXTERN  C cfPreDecompress:NEAR
         EXTERN  C cfSequenceBusy:NEAR

CodecEntry PROC  FAR
         TEST  BX, BX             ; Is selector negative?
         JL    NegativeSelector   ; Skip if selector is negative
         MOV   AX, DGROUP         ; Set DS for this DLL
         MOV   DS, AX
         CMP   BX, codecPreDecompress  ; Test for implemented functions
         JE    cfPreDecompress    ; Dispatch if it matches
         CMP   BX, codecBandDecompress
         JE    cfBandDecompress
         CMP   BX, codecGetCodecInfo
         JE    cfGetCodecInfo
         CMP   BX, codecCDSequenceBusy
         JE    cfSequenceBusy
                                  ; Bad selector
         MOV   DX, 8000h          ; Load special error return
         MOV   AX, 8002h          ; badComponentSelector
         RET
NegativeSelector:
         NEG   BX                 ; Make positive
         DEC   BX                 ; One relative to zero relative
         ADD   BX, BX             ; WORD offset to byte offset
         MOV   AX, DGROUP         ; Set DS for this DLL
         MOV   DS, AX
         JMP   WORD PTR cs:SelectorTable [BX]    ; Jump into selector function
CodecEntry ENDP
CODESEG  ENDS
         END
