{$DEFINE NODPMI}
{$I DEFINE.INC}

program StarDrek;

{ FastVGA 1.0, (C)1993, 1994 by Tal Cohen }

{------------------------------------------------------------------

 STAR DREK : ALGORITHMICAL NOTES
 -------------------------------

 Star Drek is a demo game for the FastVGA toolkit, version 1.0. The
 name "Star Drek," by the way, is a pun that speakers of Hebrew and
 German should understand. Here are a few notes about how Star Drek
 implements various features of different FastVGA units:

 1. CLIPPING THE SPRITES TO A LIMITED SCREEN AREA: You probably
    noticed that the two sprites in the game, the spaceship and the
    aim, are clipped to a limited area on the screen (the "Main
    Screen.") As a matter of fact, the sprites are moved and drawn
    normally; on Page 2, the sprites sometimes move "out" of this
    main screen and cover areas of the control panel. The trick is
    not to refresh the entire screen; we only copy from Page 2 the
    desired screen area. This is done by modifying the values of
    LoX, LoY, HiX, and HiY before calling GoMoveSprites, in the
    "GO" step of the animation cycle.

    If you want to see the "behind-the-scenes," just comment out
    the assignments to LoX and Co. and then recompile the program.
    When the program runs, you'll notice three effects: (a) The
    sprites sometimes cover parts of the control panel. This
    relates to the clipping, (b) the starfield is updated only in
    parts of the Main Screen. This is further explained in section
    2, and (c) there are parts of the laser shots left behind. This
    is explained in section 3.

 2. THE STARFIELD EFFECT: The mathematics behind this starfield
    effect are really simple, so I won't explain them here. What
    I'd like to point out is that, since the stars are drawn in
    the background, they are drawn on Page 2, between the READY and
    the SET steps of the animation cycle. By assigning values to
    LoX and co. that cover then entire "Main Screen," as detailed
    in section 1, we make sure that all star updates are copied to
    the first page when we use GoMoveSprites.

 3. THE LASER SHOTS: To speed up things, a little trick is used
    here: the laser shots are drawn to Page 1, after the animation
    cycle is complete. They are instantly erased in the next
    interation's GO step, since they are not stored on Page 2, and
    the GO step copies the image stored on Page 2. This is why
    commenting out the LoX etc. assignments causes the lasers to
    leave marks behind - only part of the needed Page 2 area was
    copied.

 4. CHECKING FOR HITS: The player scores a hit if a certain pixel,
    relative to the Aim sprite's position, is part of the Ship
    sprite. Generally, we could test for the hit using the
    SpritePixel function. However, we use a faster, more simple
    method. The pixels in the ship's sprite are all use colors 62
    and above. No other items in the Main Screen have such pixel
    values (the stars all use lower color codes,) so just checking
    the color can tell us if a pixel belongs to the ship.

 5. SOUND SUPPORT FOR PC-SPEAKER: There's no internal sound support
    for the PC's speaker in FastVGA. The program uses Crt unit's
    Sound and NoSound procedures to generate various effects. Note
    that many modern games do not include even minor effects on the
    speaker; your options are limited to a sound card or complete
    silence.

}

uses { FastVGA globals: }
     FastGlobals,
     { FastVGA graphics and system: }
     FastVGA,FastKeys,FastTimer,PCXUnit,
     { FastVGA sound: }
     SoundGlobals,VOCUnit,CMFUnit,
     { SUMAKER-made sprite units: }
     DemoSprites,AimSprUnit,
     { Normal TP units: }
     Crt;

type StarRec = record
                x,y,a,d:Real;
                Color:Byte;
               end;

var Star:array [1..25] of StarRec;
    i,ShipImage:Byte;
    Ship,Aim:Sprite;
    ShipMvX,ShipMvY,AimMvX,AimMvY:ShortInt;
    Temp,PitchDir:Integer;
    Pitch:Word;
    Pal:PaletteType;
    Shots,Hits:LongInt;
    Noisy,SDown,MDown:Boolean;
    F:File;  { Used for loading VOC files into memory }
    Voc1,Voc2:Pointer;
    Voc1Size,Voc2Size:Word;
    k:Char;

begin
 TextAttr:=Cyan;
 Write ('Fast');
 TextAttr:=LightCyan;
 Write ('VGA');
 TextAttr:=LightGray;
 WriteLn (' 1.0: "Star Drek" Game Demo');
 WriteLn;
 if not FastVGARegistered then
  begin
   WriteLn ('This program must be compiled with the registered version of FastVGA.');
   WriteLn;
   Halt;
  end;
 if TestVGA=0 then
  begin
   WriteLn ('This program requires a VGA/MCGA card.');
   Halt;
  end;
 WriteLn ('In the following game, move the aim (looks like a plus sign) using the numeric');
 WriteLn ('keypad, and press space to fire. Try to maintain a high hit ratio!');
 WriteLn;
 WriteLn ('Use "P" to pause the game, "S" to toggle the sound on/off, "M" to toggle the');
 WriteLn ('music on/off, and Esc to quit.');
 WriteLn;
 Write ('Do you have a Sound Blaster card (Y/N)?');
 repeat
  k:=UpCase(ReadKey);
 until (k in ['Y','N']);
 WriteLn (k);
 if k='Y' then
  TestSound:=2  { Assume SB 1.x, since we use no special features of
                  the SB Pro or SB 2.x }
 else
  TestSound:=0;
 if (TestSound>=2) then { Sound Blaster found, load VOCs to memory }
  begin
   {$I-}
   Assign(F,'DREK1.VOC');
   Reset(F,1);
   Voc1Size:=FileSize(F);
   GetMem(Voc1,Voc1Size);
   BlockRead(F,Voc1^,Voc1Size,Voc1Size);
   Close(F);
   Assign(F,'DREK2.VOC');
   Reset(F,1);
   Voc2Size:=FileSize(F);
   GetMem(Voc2,Voc2Size);
   BlockRead(F,Voc2^,Voc2Size,Voc2Size);
   Close(F);
   if IOResult<>0 then
    begin
     WriteLn ('I/O error reading .VOC files.');
     Halt;
    end;
  end;
 Randomize;
 InstallFastKeys;
 GoVGA256;
 FillChar (Pal,SizeOf(Pal),0); { Zero the Pal variable }
 SetActivePalette (Pal,0,255); { Make all colors black,
                                                    so nothing is visible }
 FVCheck (LoadPCXPage2 ('DREK1.PCX',Pal)); { Load PCX into page 2 }
 CopyFromPage2; { Copy image to page 1. All colors are black, so nothing
                                                   is really seen on-screen }
 TextAttr:=64; { In this PCX's palette, color #64 is white }
 DirectVideo:=False; { This MUST be done to write on the graphical screen }
 GotoXY (1,25);
 Write ('  Version 1.0     Press Space ...'); { All black, so it's unseen }
 FadeToPalette (Pal,0,255,12); { Make real colors visible, with a fade }
 repeat until Key[scSpace]; { Wait for a Space press ... }
 FadeOut (12); { Fade to black }
 ClrVGAScr; ClrPage2Scr; { Clear both screens }
 FVCheck (LoadPCXPage2 ('DREK2.PCX',Pal)); { Load new image }
 SetActivePalette (Pal,0,255); { Activate palette. Page 1 is still cleared,
                                                      so nothing is visible }
 Shots:=0; Hits:=0; { Zero variables. Shots is set to one to prevent
                                                    division-by-zero errors }
 for i:=1 to 25 do { Select random stars }
  with Star[i] do
   begin
    x:=Random (20)+150;
    y:=Random (20)+65;
    if x=160 then a:=1e8 else a:=(y-75)/(x-160);
    Color:=Random (10)+52;
    Page2^[Round(y)][Round(x)]:=Color; { Put Pixel on Page 2 }
   end;
 CopyFromPage2; { Copy Page 2, making the complete picture visible }
 ShipImage:=1; { There are 4 different ship sprites; use #1 now }
 AssignSprite (@Ship,@ShipBMP[1]); { Assign the bitmap to the sprite }
 PutSprite (@Ship,120,70); { Show the sprite }
 { Assign and show the aim sprite: }
 AssignSprite (@Aim,@AimSprite);
 PutSprite (@Aim,137,47);

 { Initialize some variables: }
 Pitch:=0;
 Noisy:=True;
 SDown:=True; { When SDown is true, "S" can be used to toggle sound }
 MDown:=True; { Same for "M" for toggling music }

 { Zero on-screen counters: }

 GotoXY (10,20); Write (0:10);
 GotoXY (10,24); Write (0:10);
 GotoXY (26,22); Write (0.0:5:1,'%');

 if TestSound>=2 then
  FVCheck (BackPlayCMF ('STARDREK.CMF',Loop));

 repeat { Main loop }

  StartTimer;

  { READY Step: }

  ReadyMoveSprite (@Aim);
  ReadyMoveSprite (@Ship);

  { Make changes to background, ONLY to page 2: }

  for i:=1 to 25 do
   with Star[i] do
    begin
     Page2^ [Round(y)][Round(x)]:=0;  { Clear old star position }
     x:=x-160;
     x:=x*1.1;
     y:=a*x+75;
     x:=x+160;
     if (x<70) or (x>250) or (y<20) or (y>130) then
      begin
       x:=Random (20)+150; if Round(x)=160 then x:=161;
       y:=Random (20)+65;
       if x=160 then a:=1e8 else a:=(y-75)/(x-160);
       Color:=Random (10)+52;
      end;
     Page2^ [Round(y)][Round(x)]:=Color;
    end;

  { The 72,152 to 239,191 block contains the counters (Shots, Hits, and
    Ratio). For syncronizing the two pages, we copy from page 1 (where
    the text was written) to page 2: }

  CopyBlockToPage2 (72,152,247,191);

  { Calculate sprite movements }

  AimMvX:=0; AimMvY:=0;

  if Key[scLeft]  or Key[scHome] or Key[scEnd]  then  Dec(AimMvX,2);
  if Key[scRight] or Key[scPgUp] or Key[scPgDn] then  Inc(AimMvX,2);
  if Key[scUp]    or Key[scHome] or Key[scPgUp] then  Dec(AimMvY,2);
  if Key[scDown]  or Key[scEnd]  or Key[scPgDn] then  Inc(AimMvY,2);

  if (Aim.X<48)  and (AimMvX<0) then AimMvX:=0 else
  if (Aim.X>226) and (AimMvX>0) then AimMvX:=0;

  if (Aim.Y<-10) and (AimMvY<0) then AimMvY:=0 else
  if (Aim.Y>98)  and (AimMvY>0) then AimMvY:=0;

  if Random<0.1 then ShipMvX:=Random(7)-3; { 10% likely to change X speed }

  { Check we're not out-of-bound in the X axis: }
  Temp:=Ship.X+ShipMvX;
  if (Temp<50) or (Temp>240) then ShipMvX:=0;

  if Random<0.1 then ShipMvY:=Random(7)-3; { 10% likely to change Y speed }

  { Check we're not out-of-bound in the Y axis: }
  Temp:=Ship.Y+ShipMvY;
  if (Temp<-13) or (Temp>105) then ShipMvY:=0;

  { SET Step: }

  SetMoveSprite (@Ship,ShipMvX,ShipMvY);
  SetMoveSprite (@Aim,AimMvX,AimMvY);

  { GO Step: }

  { When calling GoMoveSprites, we'd like the program to update the entire
    70,20 to 250,130 block (this is the "Main Screen".) So, we set LoX and
    co: }

  LoX:=70;
  LoY:=20;
  HiX:=250-SprXLen;
  HiY:=130-SprYLen;

  GoMoveSprites;

  if (Key[scSpace]) then { If Space is pressed, the player FIRED }
   begin
    Inc (Shots);
    GotoXY (10,20);
    Write (Shots:10);

    { We check for a hit by checking the color. The ship's color values
      are all greater than 50: }
    if VGAScreen[Aim.Y+31][Aim.X+23]>61 then { Hit }
     begin
      { All those settings to Pitch and PitchDir simply set the sound }
      if (TestSound>=2) then
       if Noisy then
        FVCheck (BackPlayVOC(Voc1,False))
       else
      else
       begin
        PitchDir:=15;
        if Pitch>150 then Pitch:=100;
       end;
      Inc (Hits);
      GotoXY (10,24);
      Write (Hits:10);
     end
    else { Shot, but no hit }
     if TestSound>=2 then
      if Noisy then
       FVCheck (BackPlayVOC(Voc2,False))
      else
     else
      begin
       if Pitch<475 then Pitch:=500;
       PitchDir:=-10;
      end;
    { Display new ratio: }
    GotoXY (26,22);
    Write ((Hits/Shots)*100:5:1);

    { We draw the "lasers" on page 1, so they'll soon be erased: }

    VGAColor:=Random(256);
    Line (250,130,Aim.X+23,Aim.Y+31);
    Line ( 70,130,Aim.X+23,Aim.Y+31);
   end;

  { Assign new ship image: }

  Inc (ShipImage);
  if ShipImage=5 then ShipImage:=1;
  AssignSprite (@Ship,@ShipBMP[ShipImage]);

  { Wait for a clocktick to pass since the call to StartTimer: }

  WaitFor (1);

  { Check for Pause: }

  if Key[scP] then
   begin
    NoSound; { Leaving the Buzzer on can be a nightmare ... }
    repeat until not Key[scP];  { Wait for key release }
    repeat until Key[scP];      { Wait for another press ... }
    repeat until not Key[scP];  { and release }
   end;

  { Check for sound toggle: }

  if not Key[scS] then SDown:=True; { If the S key was released, we can
                                             accept sound-toggle commands }
  if Key[scS] and SDown then
   begin
    Noisy:=not Noisy; { Sound mode is toggled }
    if not Noisy then NoSound; { Silence speaker if needed }
    SDown:=False; { Until the S key is released, further S pressed should
                                                                be ignored }
   end;

  { Check for music toggle: }

  if not Key[scM] then MDown:=True; { If the M key was released, we can
                                             accept sound-toggle commands }
  if Key[scM] and MDown then
   begin
    if CMFPaused then ResumeCMF else PauseCMF;
    MDown:=False; { Until the M key is released, further M pressed should
                                                                be ignored }
   end;

  if Noisy then
   if ((Pitch<450) and (PitchDir<0)) or ((Pitch>200) and (PitchDir>0)) then
    begin
     NoSound;
     Pitch:=0;
     PitchDir:=0;
    end
   else
    begin
     Sound(Pitch);
     Inc (Pitch,PitchDir);
    end;

 until Key[scEsc]; { Only the Esc key breaks this loop }

 { Wind down: }

 NoSound;
 StopCMF;
 StopVOC;
 TextMode (Co80);
 WriteLn (' ... to boldly go where no DOS has gone before!(TM)');
 RestoreKeyboard;
end.
