{$I DEFINE.INC}

program DemoVOC;

{ FastVGA 1.0, (C)1993, 1994 by Tal Cohen }

uses FastGlobals,SoundGlobals,VOCUnit;

var Er:Byte;
    F:File;
    Buffer:Pointer;

begin
 WriteLn;
 if ParamCount<>1 then
  begin
   WriteLn ('Systax: DEMOVOC <filename>.VOC');
   WriteLn;
   WriteLn ('For example: DEMOVOC BART.VOC');
   Exit;
  end;

 if TestSound=0 then
  begin
   WriteLn ('Sound Blaster not found or BLASTER variable not set.');
   Halt;
  end;

 { Load the file to memory: }
 Assign (F,ParamStr(1));
 Reset (F,1);
 if IOResult<>0 then
  begin
   WriteLn ('File not found.');
   Exit;
  end;
 if FileSize (F)>65535 then
  begin
   WriteLn ('File bigger than 64K.');
   Exit;
   { VOCUnit can handle files bigger than 64K, but you'll
     have to find a way to load them into memory. }
  end;
 GetMem (Buffer,FileSize(F));
 BlockRead (F,Buffer^,FileSize(F));
 Close (F);
 if IOResult<>0 then
  begin
   WriteLn ('I/O error.');
   Exit;
  end;

 { This single command is what it takes to play the .VOC in
   the background, complete with error checking and reporting: }
 FVCheck (BackPlayVOC (Buffer,Loop));

 WriteLn ('While the VOC file is playing, the computer is working normally.');
 WriteLn ('Try typing something; press Enter to stop.');
 ReadLn;
 StopVOC;
end.
