{$I DEFINE.INC}

program DemoSFX;

{ FastVGA 1.0, (C)1993, 1994 by Tal Cohen }

uses FastGlobals,SoundGlobals,FastSFX,VOCUnit;

var
  Buffer,Buffer2:Pointer;
  F:file;
  Size,Rate:Word;
  Mode:Byte;

procedure PlayIt(s:string);
begin
  Write(s);
  ReadLn;
  FVCheck (MemPlaySAM(Buffer,Rate,Mode,Size,AnyKeyExits,Once));
  { Restore the original sound, for the next effect: }
  Move(Buffer2^,Buffer^,Size);
end;

begin
 WriteLn;
 if TestSound=0 then
  begin
   WriteLn ('Sound card not found or BLASTER variable not set.');
   Exit;
  end;
 FVCheck (PlayVOC ('FASTVGA.VOC',NoExit,Once));
 Assign(F,'BART.VOC');
 Reset(F,1);
 Size:=FileSize(F);
 GetMem(Buffer,Size);
 GetMem(Buffer2,Size);
 BlockRead(F,Buffer^,Size);
 Close(F);
 if IOResult<>0 then
  begin
   WriteLn ('Error loading BART.VOC.');
   Exit;
  end;
 if VOCToSAM(Buffer,Rate,Mode,Size)<>0 then
  begin
   WriteLn('Error converting VOC to SAM.');
   Exit;
  end;
 { Store a copy of the original sound: }
 Move(Buffer^,Buffer2^,Size);

 { First, play the sound unchanged: }
 PlayIt('Introducing: Bart Simpson! (Press Enter after each line).');

 { Now, let's SFX! }
 FadeSAMOut(Buffer,Size);  { Fade-out. }
 PlayIt('Fade out!');
 FadeSAMIn(Buffer,Size);  { Fade-in. }
 PlayIt('Fade in!');
 EchoSAM(Buffer, Size, 1500, 250, Once);  { Non-repitive echo. }
 PlayIt('Echo! (Echo!)');
 EchoSAM(Buffer, Size, 1500, 250, Loop);  { Repitive echo. }
 PlayIt('Echo! (Echo! Echo! Echo!)');
 EchoSAM(Buffer, Size, 150, 230, Loop);  { Robot effect. }
 PlayIt('Bardroid');
 AmplifySAM(Buffer, Size, 4096);  { Amplify 1600%. }
 PlayIt('Pump up the volume!');
 AmplifySAM(Buffer, Size, 64);    { Deamplify 400%. }
 PlayIt('QUITE!');
 ReverseSAM(Buffer, Size);
 PlayIt('Reverse: !nam iH');
 Write ('That''s all, folks!');
 ReadLn;
end.
