{$I DEFINE.INC}

program DemoPal3;

{ FastVGA 1.0, (C)1993, 1994 by Tal Cohen }

{ This program shows one way to create a shadow for a sprite
  using palette effects.

  Palette effects are an easy way to create great-looking
  effects that require nearly no CPU time. }

uses FastGlobals,FastVGA,FastTimer,FLIUnit,Crt;

var Pal:PaletteType;
    Shadow:Pointer;
    Plane:Pixie;
    PBmp:PixieBitmap;
    XMove,YMove:ShortInt;
    x,y:Word;
    ShadowPos,OldShadow:ShortInt;
    K:Char;

procedure MakeBackground;
 { This procedure draws the background used in
   the demo, and sets up the palette used. Note
   that normally, you'll use calculations like
   these to draw the background and set the
   palette only once, and then save it to a .PCX
   file. }

 var i,Darker:Byte;
     x,y:Word;

 begin
  { Load a background image: }
  FVCheck (LoadFlicFrame ('MOUNT.FLI',7));

  { Load the base palette: }
  FVCheck (LoadFlicPalette ('MOUNT.FLI',@Pal));

  { Colors 0 thru 127 are the useable colors.
    Colors 128 thru 255 are darker shades of the
    very same colors; that is, a given color
    value plus 128 yields a darker shade of the
    same color. We create the darker shades by
    using 70% of the original RGB values: }
  for i:=0 to 127 do
   begin
    Darker:=i+128;
    Pal[Darker][RGBRed]  :=Round(Pal[i][RGBRed]  *0.7);
    Pal[Darker][RGBGreen]:=Round(Pal[i][RGBGreen]*0.7);
    Pal[Darker][RGBBlue] :=Round(Pal[i][RGBBlue] *0.7);
   end;

  { We DO NOT want the plane to cast a shadow over
    the sky or the sun! To prevent this we restore
    the darker shade of color 9 (sky) and colors
    64 thru 79 (sun) to their normal equivalents.
    Try disalbing this piece of code and see what
    happens ... }

  Pal[9+128]:=Pal[9];
  for i:=64 to 79 do
   Pal[i+128]:=Pal[i];

  SetActivePalette (Pal,0,255);
  { Note that when using bytes, a given color plus
    128 is ready that color OR 128 (boolean OR.)
    Thus, 128 is the magic value used by the Shadow
    image. }

 end;

procedure CreateShadow;
 { This procedure creates the image used for
   the shadow, and stores it (with GetImage)
   at Shadow^. Work is done on Page 2 to save
   the user from seeing it done. }

 var x,y:Word;

 begin
  ClrPage2Scr;
  { We create an image of the pixie, with
    the value 128 replacing any non-zero
    pixel: }
  StampPixiePage2 (@Plane,0,0);
  for x:=0 to PixXLen-1 do
   for y:=0 to PixYLen-1 do
    if Page2^[y][x]>0 then
     Page2^[y][x]:=128;
  { Now we allocate the needed memory and
    call GetImagePage2. }
  GetMem (Shadow,ImageSize (0,0,PixXLen-1,PixYLen-1));
  GetImagePage2 (0,0,PixXLen-1,PixYLen-1,Shadow^);
 end;

begin
 WriteLn ('This little demo shows one way to create a shadow,');
 WriteLn ('using palette effects. Note that the shadow is NOT');
 WriteLn ('drawn on the sky or the sun.');
 WriteLn;
 WriteLn ('Use Plus and Minus to change the shadow''s position.');
 Write ('Press Enter ... ');
 ReadLn;
 GoVGA256;
 MakeBackground;
 FVCheck (LoadPIX (@PBmp,'PLANE.PIX',1));
 AssignPixie (@Plane,@PBmp);
 CreateShadow;
 CopyToPage2;
 ShadowPos:=6; OldShadow:=ShadowPos;
 { Putting the shadow, on Page 2: }
 PutImagePage2 (160+ShadowPos,100+ShadowPos,Shadow^,XORPut);
 { On top of that, we put the plane: }
 PutPixie (@Plane,160,100);
 XMove:=1;
 YMove:=1;
 K:=#0;
 repeat
  StartTimer;

  { READY step: }
  ReadyMoveSprites;

  { First background change to Page 2 -
    removing the old shadow: }
  PutImagePage2 (Plane.X+OldShadow,Plane.Y+OldShadow,Shadow^,XORPut);
  { We use the fact that Xor undoes itself. }

  if Random<0.1 then { 10% likely to change direction }
   begin
    Inc(XMove,Random(3)-1); { Add 1, -1, or none }
    Inc(YMove,Random(3)-1);
    { Max.Speed: 3 Pixels }
    if XMove>3 then XMove:=3; if XMove<-3 then XMove:=-3;
    if YMove>3 then YMove:=3; if YMove<-3 then YMove:=-3;
   end;

  { Range Checking: }

  if (Plane.X+XMove<0) or (Plane.X+XMove>320)
     or (Plane.X+XMove+ShadowPos<1) then XMove:=-XMove;
  if (Plane.Y+YMove<0) or (Plane.Y+YMove>120)
     or (Plane.Y+YMove+ShadowPos<1) then YMove:=-YMove;

  if KeyPressed then
   begin
    K:=ReadKey;
    case K of
     '+':if ShadowPos<10 then
          Inc(ShadowPos);
     '-':if ShadowPos>-10 then
          Dec(ShadowPos);
    end;
   end;
  { Background change to Page 2 --
    putting the shadow }
  PutImagePage2 (Plane.X+ShadowPos+XMove,Plane.Y+ShadowPos+YMove,
                 Shadow^,XORPut);
  OldShadow:=ShadowPos;

  { SET step: }
  SetMovePixie (@Plane,XMove,YMove);

  { GO step: }
  CopyFromPage2;

  WaitFor (1);
 until K=#27;
 RestoreMode;
end.

{ Note: When multiple sprites cast multiple shadows, this algorithm creates
        a problem when shadows intersect. One solution is two create TWO
        shadow bitmaps: one containing 128, like the bitmap used in this
        demo, and one containing 127. To remove the shadows, use the second
        (127) bitmap with an AndPut; to draw them, you should use the the
        first (128) bitmap with an OrPut. }
