{$I DEFINE.INC}

program DemoPal1;

{ FastVGA 1.0, (C)1993, 1994 by Tal Cohen }

{ This program shows one of the amazing effects that can be
  created with palette sliding, and also demonstrates a simple
  scrolling effect. }

{ The main magic for the "flame" effect in this demo is really
  in the DEMOPAL1.PCX image file. In this file, the text
  "FastVGA Ver. 1.0" is stored, with the letters cut out of a
  plasma PCX. Many graphic utilities, including several shareware
  and public domain ones, let you to create such plasma images.

  To see how the colors in DEMOPAL1.PCX are arranged, load it
  and restore the normal (default) palette. You'll see the blue
  text isn't really single-colored.

  Colors 100 thru 109 in DEMOPAL1.PCX are used for the scrolling
  text. Colors 5 thru 65 are used for the burning main text.
  Colors 66 thru 75 are meaningless in the PCX itself, but used
  by the program to store the trailing flame colors. }

uses FastGlobals,FastVGA,FastFonts,PCXUnit,Crt;

const Trail = 10;

type RGB10 = array [1..Trail] of PaletteElement;
     RGB10Ptr = ^RGB10;

var i,Pass:Byte;
    a,b:Word;
    P,Black:PaletteType;
    Fade,DoneFade,Done,Flip:Boolean;
    OldRGB:RGB10;

    { These global variables are used
      by the ScrollLine procedure: }
    C,            { A pointer to the current character
                    in the scroll string, ScrlText. }
    FontColor,    { The current text color for the scroll. }
    LineNo:Byte;  { The number of the current vertical line
                    inside the current character. }

const ScrlText:String =
 '        ~9Fast~4VGA ~2makes this ~6real~2 easy .....        ';
 { In this string, a "~" sign marks a color change. The next
   character is the number of the new color (0 thru 9.) }

procedure ScrollLine; { Scrolls the text line in the bottom by 1 pixel }
 begin
  { First, we wait for vertical sync, to prevent screen
    flicker and to provide timing as well. }
  VSync;

  { Now, we scroll the existing image on screen: }
  ScrollLeft (0,184,319,199,1);

  { We erase the rightmost column, where
    a new column will soon appear: }
  VGAColor:=0;
  VLine (319,184,199);

  { Set the color for the new column: }
  VGAColor:=FontColor;

  { If the line number is 0, it's the extra space
    line added to each character by the VGA card
    in text mode. Otherwise, it's part of the
    character, and we must draw it: }
  if LineNo<>0 then FontVLine (319,184,ScrlText[C],LineNo);

  if LineNo=8 then { We just showed the last line of the character }
   begin
    LineNo:=0;  { We move to line 0 of ... }
    Inc(C);     { ... the next character.  }

    if ScrlText[C]='~' then
     { If we hit the character "~", this is the
       code for a color change. }
     begin
      Inc(C);
      { C now points to a character from '0' to '9',
        which is the color code. The text colors are
        stored in the palette at positions 100 thru 109. }
      FontColor:=Byte(ScrlText[C])-Byte('0')+100;
      Inc(C);
      { C now points to the real next character to show. }
     end;

    if C>Length(ScrlText) then C:=1;  { If needed, restart the scroll loop }
   end
  else { LineNo<>8 }
   Inc(LineNo);                    { Just a new line in the same char }
 end;

begin
 if TestVGA=0 then
  begin
   WriteLn ('This program requires a VGA/MCGA card.');
   Halt;
  end;
 Randomize;
 GoVGA256;
 SystemFontInit; { Load the system default VGA font. }

 { We load the PCX into Page 2, storing the palette
   in the variable "Black": }
 FVCheck (LoadPCXPage2 ('PALDEMO1.PCX',Black));

 FillChar (P,300,0); { Zero out colors 0 thru 99 (the first
                       300 bytes) in the palette variable "P". }

 { Copy colors 100 thru 109, used as colors for the
   scrolling text, from the PCX's palette to "P": }
 for i:=100 to 109 do
  P[i]:=Black[i];

 SetActivePalette (P,0,255); { Set the active palette to P. }
 { The screen is all black, and colors 0 thru 99 are black, too. }

 CopyBlockFromPage2 (42,19,151,61); { The word "Fast" is copied. }
 { Nothing is seen on-screen, since the word uses colors 0-99,
   which are set to black in the active palette. }

 { The "fire-trail" colors are stored
   in palette elements 66 to 75. }
 for i:=0 to Trail-2 do
  begin
   P[66+i][RGBRed]:=i*5+17;
   b:=9-i; if b>7 then b:=7;
   P[66+i][RGBGreen]:=b;
   P[66+i][RGBBlue]:=63-i*7;
  end;
 P[65+Trail][RGBRed]:=63;
 P[65+Trail][RGBGreen]:=63;
 P[65+Trail][RGBBlue]:=10;

 { Set up parameters for the burning fire: }
 a:=5;    { The color code to start with. }
 Fade:=False;
 Done:=False;
 DoneFade:=False;
 Pass:=1; { The current loop iteration number. }

 { Set up parameters for the scrolling text: }
 FontColor:=102;
 LineNo:=0; C:=1;

 { The first loop shows the words "FastVGA Ver. 1.0" appearing. }
 repeat
  { Store the original 10 colors P[a] thru P[a+9] in "OldRGB": }
  OldRGB:=RGB10Ptr(@P[a])^;

  { Copy the flaming colors, P[66]-P[75], to P[a]-P[a+9]: }
  Move (P[66],P[a],SizeOf(RGB10));

  { Show the flames on the newly-burnt colors: }
  SetActivePalette (P,a-1,a+Trail);
  { (we start from a-1 to clear the tracks of the previous cycle. }

  { Restore the original colors: }
  RGB10Ptr(@P[a])^:=OldRGB;

  Inc (a);
  if (a=65) then  { A loop is done }
   begin
    a:=5; { Start all over again, with color 5. }
    Done:=DoneFade; { We're done if the fade-in is complete. }
    Inc (Pass);
    case Pass of
     { On Pass #2, we copy the word "VGA"; on #3, the "Ver.1.0" thing. }
     2:CopyBlockFromPage2 (154,18,277,61);
     3:CopyBlockFromPage2 (95,77,208,109);
    end;
   end;
  if Pass>2 then
   begin
    { On pass 2 and higher, we pull the colors 5-65 towards
      those in the original picture's palette (blue.) A pull
      is performed every other iteration (that's what we use
      "Flip" for.) "DoneFade" is set to True once the pull
      is complete. }
    Flip:=not Flip;
    if Flip then
     PullToPalette (P,Black,5,65,DoneFade);
   end;
  if KeyPressed then Done:=True; { Automatic exit on keypress. }
  ScrollLine; { Scroll the text line at the bottom. }
 until Done;

 { When we're at this point, the burning text is visible on screen.
   Now, we do the normal burning, and when a key is pressed, the
   burn-out effect. }

 Fade:=False;
 Done:=False;
 DoneFade:=False;
 FillChar (Black,SizeOf(Black),0); { The "Black" palette is
                                     now really all black. }

 { This is the main loop. }
 repeat
  { Store the original 10 colors P[a] thru P[a+9] in "OldRGB": }
  OldRGB:=RGB10Ptr(@P[a])^;

  { Copy the flaming colors, P[66]-P[75], to P[a]-P[a+9]: }
  Move (P[66],P[a],SizeOf(RGB10));

  { Show the flames on the newly-burnt colors: }
  SetActivePalette (P,a-1,a+Trail);
  { (we start from a-1 to clear the tracks of the previous cycle. }

  { Restore the original colors: }
  RGB10Ptr(@P[a])^:=OldRGB;

  Inc (a);  { Burn the next set of colors }
  if (a=65) then { If a cycle is done, restart it: }
   begin
    a:=5;
    Done:=DoneFade;  { We're done only if the fade-out is done. }
   end;

  { If a key is pressed, we start the fade-out: }
  if KeyPressed then Fade:=True;

  if Fade then
   begin
    Flip:=not Flip;
    if Flip then
     begin
      { Fade out the scrolling-text colors: }
      PullToPalette (P,Black,100,109,DoneFade);
      SetActivePalette (P,100,109);
      { Fade out the burning-text colors: }
      PullToPalette (P,Black,5,65,DoneFade);
      { These colors are actually set during
        the normal burn cycle operations. }
     end;
   end;
  ScrollLine;
 until Done;

 FontDone; { Shut down the font system. }

 RestoreMode; { Return to text mode. }
end.
