{$I DEFINE.INC}

program Demo1;

{ FastVGA 1.0, (C)1993, 1994 by Tal Cohen }

{ This program demonstrates the following points:

   Using sprites and creating simply animations.
   Loading PCX files.
   Easy error checking with FVCheck.
   Fade-ins and fade-outs.

}

uses { FastVGA units: }
     FastVGA,FastGlobals,FastTimer,PCXUnit,
     { Borland Pascal units: }
     Crt,
     { Sprites unit: }
     DemoSprites;

var i,Speed:Byte;
    P1:PaletteType;
    Ship:Sprite;
    XMove,YMove:ShortInt;
    K:Char;

begin
 if TestVGA=0 then
  begin
   WriteLn ('This program requires a VGA/MCGA card.');
   Halt;
  end;
 WriteLn ('In the following demo program, use the PLUS key to put the ship in high');
 WriteLn ('gear, and the MINUS key to return it to low gear. Use ESC to exit.');
 WriteLn ('Please note that on slow system (esp. XTs) the difference between "Slow"');
 WriteLn ('and "Fast" ship speeds is hardly noticeable.');
 WriteLn;
 Write ('Press any key to start ... ');
 ReadKey;
 GoVGA256;
 FadeToRGB (63,63,63,36);  { 2 seconds fade to white }
 FVCheck (LoadPCXPage2 ('FASTVGA.PCX',P1));
 CopyFromPage2;  { Nothing will be shown, since the entire palette is white }
 FadeToPalette (P1,0,255,73); { 4 seconds fade into picture }
 i:=1;
 AssignSprite (@Ship,@ShipBMP[i]);
 PutSprite (@Ship,160,100);
 XMove:=1;
 YMove:=1;
 Speed:=1;
 K:=#0;
 repeat
  StartTimer;
  Inc(i);
  if i>4 then i:=1;
  AssignSprite (@Ship,@ShipBMP[i]);
  if Random<0.1 then { 10% likely to change direction }
   begin
    Inc(XMove,Random(3)-1); { Add 1, -1, or none }
    Inc(YMove,Random(3)-1);
    { Max.Speed: 3 Pixels }
    if XMove>3 then XMove:=3; if XMove<-3 then XMove:=-3;
    if YMove>3 then YMove:=3; if YMove<-3 then YMove:=-3;
   end;

  { Range Checking: }

  if (Ship.X+XMove<0) or (Ship.X+XMove>320) then XMove:=-XMove;
  if (Ship.Y+YMove<0) or (Ship.Y+YMove>200) then YMove:=-YMove;

  MoveSprite (@Ship,XMove,YMove);

  SlidePalette (P1,160,175);     { Change the color of the ship's Headlight }
  SetActivePalette (P1,160,175);
  if KeyPressed then
   begin
    K:=ReadKey;
    if K='+' then Speed:=0 { High speed }
    else if K='-' then Speed:=1; { Low speed }
   end;
  WaitFor (Speed); { Wait 1 or no clock-ticks }
 until K=#27;
 FadeOut (73); { 4 seconds fade out }
 TextMode (Co80);
end.
