{$I DEFINE.INC}

program DemoFont;

{ FastVGA 1.0, (C)1993, 1994 by Tal Cohen }

uses FastGlobals,FastVGA,FastFonts,FastTimer,Crt;

var x,y:Integer;
    P:PaletteType;
    Er:Byte;

procedure RightFont;
 begin
  {$IFDEF DPMI}   { Since we cannot use SystemFontInit in DPMI mode,
                    we load a disk font. }
  FVCheck (LoadBIN16 (ActiveFont16^,'COMPUTER.BIN'));
  {$ELSE}
  SystemFontInit;
  {$ENDIF}
 end;

procedure Intro;
 procedure EnWhite (n:Byte); { Procedure to fade a given color to white }
  var C:PaletteType;
      Done:Boolean;

  begin
   C[n][RGBRed]:=63;    { Set color "n" of palette "C" to white }
   C[n][RGBGreen]:=63;
   C[n][RGBBlue]:=63;
   repeat
    StartTimer;
    PullToPalette (P,C,n,n,Done);
    SetActivePalette (P,n,n);
    WaitFor (25);
   until Done;
  end;

 procedure RevealLine (y:Integer; c:Byte; S:String);
  var x:Integer;

  begin
   VGAColor:=c;
   x:=(320-Length(S)*9) div 2;
   FontWrite (x,y,S);
   EnWhite (c);
  end;

 begin
  FillChar (P,SizeOf(P),0);
  SetActivePalette (P,0,255);
  RevealLine ( 50, 1,'Hello, and welcome to the FastVGA');
  RevealLine ( 66, 2,'Fonts demo. This short and simple');
  RevealLine ( 82, 3,'demo will show you just some of');
  RevealLine ( 98, 4,'the things you can do with the');
  RevealLine (114, 5,'FastFonts unit of FastVGA. Watch');
  RevealLine (130, 6,'and enjoy!');
  ReadKey;
 end;

procedure Welcome;
 begin
  GoVGA256; { Restore the original color palette }
  for x:=0 to 130 do
   begin
    VGAColor:=x;
    FontWrite (x,x,'Welcome to FastVGA!');
   end;
  VGAColor:=15;  { Final time, in pure white: }
  FontWrite (131,131,'Welcome to FastVGA!');
  ReadKey;
 end;

procedure ShowOff;
 var Er:Byte;

 begin
  GoVGA256;
  FVCheck (LoadFNT (17,17,32,90,'SNAKES.FNT'));
  FontWrite (0,0,'FASTVGA SUPPORTS');
  FVCheck (LoadFNT (16,19,32,90,'SHINE.FNT'));
  FontWrite (0,20,'MULTI-COLORED, FAST,');
  FVCheck (LoadFNT (18,17,32,90,'BOXI.FNT'));
  FontWrite (0,43,'ANY-SIZED FONTS!');
  RightFont;
  ReadKey;
 end;

procedure SineWave;
 const S:String = ' Sine Wave!';

 var Ch,Line:Byte;
     Rad:Integer;

 begin
  Rad:=-75;
  while Rad<=80 do
   begin
    Ch:=1;
    Line:=0;
    VGAColor:=30-Abs(Rad div 10);
    for x:=0 to 319 do
     begin
      y:=100+Round(Rad*Sin(x*Pi/180));
      if Line<>0 then FontVLine (x,y,S[Ch],Line);
      Inc (Line);
      if Line=9 then
       begin
        Line:=0;
        Inc (Ch);
        if Ch>Length(S) then Ch:=1;
       end;
     end;
    Inc (Rad,15);
    ReadKey;
   end;
 end;

procedure Scroll;
 const S:String ='Scrolling ';

 var Ch,Line:Byte;

 begin
  Ch:=1;
  Line:=0;
  repeat
   VGAColor:=15;
   if Line<>0 then
    begin
     FontVLine (319,120,S[Ch],Line);
     FontVLine (0,80,S[Ch],Line);
    end;
   VSync;        { Wait for syncronization - important for scrolling! }
   ScrollLeft (0,120,319,135,1);
   VSync;
   ScrollRight (0,80,319,95,1);
   VGAColor:=0;
   VLine (319,120,135);
   VLine (0,80,95);
   Inc (Line);
   if Line>8 then
    begin
     Line:=0;
     Inc (Ch);
     if Ch>Length(S) then Ch:=1;
    end;
  until KeyPressed;
 end;

begin
 if TestVGA=0 then
  begin
   WriteLn ('This program requires a VGA/MCGA card.');
   Halt;
  end;
 GoVGA256;
 InstallFastTimer;
 FVCheck (LoadBIN16 ('COMPUTER.BIN'));
 Intro;
 RightFont;
 Welcome;
 ShowOff;
 ClrVGAScr;
 SineWave;
 ClrVGAScr;
 Scroll;
 FontDone;
 RestoreTimer;
 TextMode (Co80);
 WriteLn ('That''s all folks!');
 WriteLn;
end.
