{$I DEFINE.INC}

program Demo4;

{ FastVGA 1.0, (C)1993, 1994 by Tal Cohen }

{ This program demonstrates the following points:

   Using the FastKeys unit.
   Animating pixies (or sprites) on top of FLI animation files.

}

uses FastGlobals,FastVGA,FastTimer,PCXUnit,FLIUnit,FastKeys,Crt;

var j,Speed:Byte;
    P1:PaletteType;
    Plane:Pixie;
    PBmp:PixieBitmap;
    XMove,YMove:ShortInt;
    K:Char;
    Flic:File;

begin
 if TestVGA=0 then
  begin
   WriteLn ('This program requires a VGA/MCGA card.');
   Halt;
  end;
 WriteLn ('This simple demo shows you how easily can sprites and pixies be');
 WriteLn ('animated while a flic (FLI or FLC) file is running in the background.');
 WriteLn ('Use the arrow keys to control the plane (since the FastKeys unit is');
 WriteLn ('used, you can press two or more keys simultaneously.) Use Esc to exit');
 WriteLn ('the demo. Press Space to fire!.');
 WriteLn;
 WriteLn ('Use P to pause the demo, Space to resume.');
 WriteLn;
 WriteLn ('As with former demos, you can use the Plus and Minus keys to set the');
 WriteLn ('animation''s speed.');
 WriteLn;
 Write ('Press any key to begin ... ');
 ReadKey;
 { Read PLANE.PIX: }
 FVCheck (LoadPIX (@PBmp,'PLANE.PIX',1));
 AssignPixie (@Plane,@PBmp);

 GoVGA256;
 FVCheck (StartFlic (Flic,'MOUNT.FLI',OnPage2,Loop));  { The first frame is
                                                         now on page 2 }
 CopyFromPage2;   { Pages must be syncronized! }
 PutPixie (@Plane,20,20);

 XMove:=1;
 YMove:=1;
 Speed:=1;
 K:=#0;
 InstallFastKeys;
 repeat
  StartTimer;
  XMove:=0;
  YMove:=0;
  if Key[scDown] or Key[scEnd] or Key[scPgDn] then Inc(YMove,2);
  if Key[scUp] or key[scHome] or key[scPgUp] then Dec(YMove,2);
  if Key[scLeft] or key[scHome] or key[scEnd] then Dec(XMove,2);
  if Key[scRight] or key[scPgUp] or key[scPgDn] then Inc(XMove,2);

  if (Key[scSpace]) and (Plane.X<288) then
   begin
     VGAColor:=VGAColor+1;
     if VGAColor=16 then VGAColor:=1;
     HLine(Plane.X+32,Plane.Y+5,319);
   end;

  { Range Checking: }

  if (Plane.X+XMove<0) or (Plane.X+XMove>320) then XMove:=0;
  if (Plane.Y+YMove<0) or (Plane.Y+YMove>200) then YMove:=0;

  { Step 1 of sprite animation: READY }

  ReadyMoveSprites;

  { Flic animation occurs here - on page 2 }

  FVCheck (AdvanceFlic (Flic));

  { Steps 2 & 3 of sprite animation: SET & GO}
  SetMovePixie (@Plane,XMove,YMove);
  CopyFromPage2; { We update the entire page, so CopyFromPage2 is used
                   rather than GoMoveSprites }

  { Check for speed chages: }
  if Key[scEqual] or Key[scGrayPlus] then Speed:=0
  else if Key[scMinus] or Key[scGrayMinus] then Speed:=1;

  { Delay: }
  WaitFor (Speed);  { A single frame will take about Speed/18th of a second }

  { Check for pause: }
  if Key[scP] then                 { P can be used to pause, }
   repeat until Key[scSpace];      { and Space will exit the pause }
 until Key[scEsc];
 FVCheck (CloseFlic (Flic));
 RestoreKeyboard;
 TextMode (Co80);
end.
