{$I DEFINE.INC}

program BabyWalk;

{ FastVGA 1.0, (C)1993, 1994 by Tal Cohen }

uses FastGlobals,FastVGA,FastKeys,FastTimer,Crt,PCXUnit;

const Left  = 1;
      Right = 2;
      Up    = 3;
      Down  = 4;

      Max:array [Left..Down] of Byte = (7,7,4,4);

type WalkArray = array [1..7] of SpriteBitmapPtr;

var Baby:Sprite;
    i,OldI,Dir,OldDir,BabySpeed:Byte;
    P:PaletteType;
    Walk:array [Left..Down] of WalkArray;
    x,y:Word;
    K:Char;
    XMove,YMove:Integer;
    Sign:Pointer;
    SignFirst,AnyChange:Boolean;
    SignPut:Byte;

procedure ReadSprites (FName:String; var WA:WalkArray; Count:Byte);
 var i:Byte;

 begin
  for i:=1 to Count do
   begin
    New (WA[i]);
    FVCheck (LoadSPR (WA[i],FName,i));
   end;
 end;

begin
 if TestVGA=0 then
  begin
   WriteLn ('This program requires a VGA/MCGA card.');
   Halt;
  end;
 WriteLn ('Welcome to the BabyWalk demo program. In the following screen, use the arrow');
 WriteLn ('keys (including the diagonals, PgDn, PgUp etc.) to move the child around the');
 WriteLn ('screen. Use Esc to exit the demo.');
 WriteLn;
 WriteLn ('In the middle of the screen there''ll be a sign (the child can walk around it,');
 Write ('but not through it.) Would you like the sign to be transparent (Y/N)? ');
 repeat
  K:=UpCase(ReadKey);
 until (K in ['Y','N']);
 WriteLn (K);
 if K='Y' then SignPut:=TransPut else SignPut:=NormalPut;

 ReadSprites ('BABY1.SPR',Walk[Left],Max[Left]);
 ReadSprites ('BABY2.SPR',Walk[Right],Max[Right]);
 ReadSprites ('BABY3.SPR',Walk[Up],Max[Up]);
 ReadSprites ('BABY4.SPR',Walk[Down],Max[Down]);
 AssignSprite (@Baby,Walk[Left,1]);
 GoVGA256;
 FVCheck (LoadCOL (P,'BABYWALK.COL'));
 SetActivePalette (P,0,255);
 x:=160-SprXLen div 2;
 y:=80-SprYLen div 2;   { Screen Center }

 { Draw the sign }

 VGAColor:=4;
 TextAttr:=4;
 DirectVideo:=False;
 GotoXY (7,15);
 Write ('Press "1" for running speed,');
 GotoXY (7,16);
 Write ('"2" for normal walking speed,');
 GotoXY (7,17);
 Write ('or "0" for Turbo-Baby speed.');
 HLine (46,110,278);
 HLine (46,137,278);
 VLine (46,110,137);
 VLine (278,110,137);

 CopyToPage2; { Pages MUST be syncronized! }

 { Capture the Sign image: }

 GetMem (Sign,ImageSize (46,110,278,137));
 GetImage (46,110,278,137,Sign^);

 PutSprite (@Baby,x,y);
 Dir:=Left;
 i:=1;
 BabySpeed:=2;
 InstallFastKeys;
 repeat
  StartTimer;
  AnyChange:=False;

  { Store old values and init new ones: }

  OldDir:=Dir;
  x:=Baby.X; y:=Baby.Y;
  OldI:=i;
  XMove:=0; YMove:=0;

  { Check for speed keys: }

  if Key[sc1] then BabySpeed:=1
  else if Key[sc2] then BabySpeed:=2
  else if Key[sc0] then BabySpeed:=0;

  { Check for arrow keys: }

  if (Key[scLeft])  or (Key[scHome]) or (Key[scEnd])  then Dec (XMove);
  if (Key[scRight]) or (Key[scPgUp]) or (Key[scPgDn]) then Inc (XMove);
  if (Key[scUp])    or (Key[scHome]) or (Key[scPgUp]) then Dec (YMove);
  if (Key[scDown])  or (Key[scEnd])  or (Key[scPgDn]) then Inc (YMove);
  if XMove=0 then YMove:=YMove*3
  else if YMove=0 then XMove:=XMove*3
  else XMove:=XMove*2;
  if XMove<0 then Dir:=Left
  else if XMove>0 then Dir:=Right
  else if YMove<0 then Dir:=Up
  else if YMove>0 then Dir:=Down;

  { Range Checking: }

  if ((Baby.X+XMove)>320-SprXLen) or ((Baby.X+XMove)<0) then XMove:=0;
  if ((Baby.Y+YMove)>200-SprYLen) or ((Baby.Y+YMove)<0) then YMove:=0;

  { Now, make sure we don't move through the glass sign: }

  if (Baby.X>10) and (Baby.X<265) then
   if (Baby.Y>86) and (Baby.Y<92) and (YMove>0) then YMove:=0
   else if (Baby.Y<96) and (Baby.Y>88) and (YMove<0) then YMove:=0;

  if (XMove<>0) or (YMove<>0) then
   begin
    if Dir<>OldDir then
     i:=1
    else
     begin
      Inc(i);
      if i>Max[Dir] then i:=1;
     end;
   end
  else
   i:=1;

  { Check for any changes }

  AnyChange:=(OldI<>i) or (x<>Baby.X+XMove) or
             (y<>Baby.Y+YMove) or (Dir<>OldDir);


  if AnyChange then
   begin
    SignFirst:=((Baby.Y+YMove)<90);  { Should we draw the sign first? }

    AssignSprite (@Baby,Walk[Dir][i]);
    ReadyMoveSprite (@Baby);

    { This is the place to draw background items. If the sign is in the
      background, we draw it now: }

    if not SignFirst then PutImagePage2 (46,110,Sign^,SignPut);

    SetMoveSprite (@Baby,XMove,YMove);

    { If the sign is in front of the baby, we draw it now: }

    if SignFirst then PutImagePage2 (46,110,Sign^,SignPut);

    GoMoveSprites;

    WaitFor (BabySpeed);
   end;

 until Key[scEsc];
 RestoreKeyboard;
 TextMode (Co80);
end.
