Program gridwarp;
uses crt;
var
  pthname,flname,st1,st2,st3:string[128];
  dimx,dimz,typ,verts,i:integer;
  xsc,zsc,xr,yr,zr:real;
  yfile:text;
begin
  clrscr;gotoxy(5,1);textcolor(15);
  writeln('SAMPLE PROGRAM FOR MAKING A .DTA FILE FOR THE GRID TRANSFORMATION OPTION');
  writeln;textcolor(14);
  writeln(' For x and z between -1 and 1, the function y=c*sin(1.5*pi*(abs(x)+abs(z)))');
  writeln('is used to determine the y values. For type 1 files, only the y');
  writeln('value is placed in the file. For type 2 files, the x and z coordinates of');
  writeln('the grid are warped and all 3 coordinate are placed in the file.');
  textcolor(15);

  gotoxy(1,wherey+2);write('Enter a name for the file: ');readln(flname);
  write('Enter the path (e.g. C:\AR):  ');readln(pthname);writeln;
  clrscr;
  repeat
    gotoxy(1,4);write('Enter the transformation type (1 or 2): ');
    readln(typ)
  until typ in [1..2];
  write('Enter the number of values in the X direction (xdim): ');
  readln(dimx);
  write('Enter the number of values in the Z direction (zdim): ');
  readln(dimz);

  assign(yfile,pthname+'\'+flname+'.dta');
  rewrite(yfile);
  writeln(yfile,'File name: '+flname+'.dta');
  str(typ,st1);writeln(yfile,st1);
  str(dimx,st1);str(dimz,st2);writeln(yfile,st1+' '+st2);

  verts:=dimx*dimz;
  for i:=1 to verts do
    begin
      xsc:=-1+2.0*((i-1) div dimz)/(dimx-1);   {SCALE PARAMETERS SO THAT THE DOMAIN}
      zsc:=-1+2.0*((i-1) mod dimz)/(dimz-1);   {OF THE FUNCTION IS -1<=XSC,ZSC,<=1 }

      yr:=5000*sin(1.5*pi*(abs(xsc)+abs(zsc)));  {<-- HERE IS THE FUNCTION}

      case typ of
        1:begin
            str(yr:7:2,st2);writeln(yfile,st2)
          end;
        2:begin
            xr:=6000*xsc;str(xr:7:2,st1);
            zr:=6000*zsc;str(zr:7:2,st3);
            str(xr:7:2,st1);str(yr:7:2,st2);str(zr:7:2,st3);
            writeln(yfile,st1,' ',st2,' ',st3);
          end;
      end;
    end;
  close(yfile);
end.