/*  Copyright (C) Hummingbird Communications Ltd. 1990-1994	       */

/*  the preprocessor variable LIMIT is used to remove the -f option.
    This option uses the stat and system functions to do directory
    checking and wildcard expansion.  While there are obviously much
    better ways to implement this functionality, this method SHOULD work
    on almost every system

    If the program does not compile, remove the comment from the next
    preprocessor statement
*/

/*  #define LIMIT   1	*/


#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "extend.h"

extern XID dosid;
extern Display *dpy;
extern int maxeXtDOSbuf;
extern int eXtinterrupt;
extern char *FilenamePart();
extern int RbufLen;

int version = {0x303};

struct known_struct {
    int     qual;
    char    *tag;
    struct  known_struct *next;
};

struct known_struct *khead = {NULL};

#ifndef LIMIT
#include    <sys/types.h>
#include    <sys/stat.h>
#define MAXOPTS 15
char dummyFile[256], cmdLine[256];
#else
#define MAXOPTS 13
#endif

struct OptionDef opts[MAXOPTS] = {
    {"display", 1},
    {"pw", 1},
    {"b", 0},
    {"nv", 0},
    {"p", 0},
    {"size", 1},
    {"np", 0},
    {"a", 0},
    {"v", 0},
    {"nk", 0},
    {"k", 1},
    {"ka", 0},
    {"nka", 0}
#ifndef LIMIT
    ,{"q", 1}
    ,{"f", 1}
#endif
};

char *myname;
static char buffer[MAXBUF+2];

char **parm;

usage()
{
    fprintf(stderr, "usage: %s [options] src... dst\n", myname);
    fprintf(stderr, "  -display display-name\n");
    fprintf(stderr, "  -pw  password\n");
    fprintf(stderr, "  -a               ascii file transfer (default)\n");
    fprintf(stderr, "  -b               binary file transfer\n");
    fprintf(stderr, "  -p               displays the name of each file being copied\n");
    fprintf(stderr, "  -np              does not display the name of each file. (default)\n");
    fprintf(stderr, "  -v               verify file deletions. (default)\n");
    fprintf(stderr, "  -nv              do not verify file deletions.\n");
    fprintf(stderr, "  -size size       transfer block size\n");
    fprintf(stderr, "  -k file          'file' contains 'known' extensions\n");
    fprintf(stderr, "  -nk              ignore any known extensions\n");
    fprintf(stderr, "  -ka              prompt for transfer type for unknown extensions\n");
    fprintf(stderr, "  -nka             disable -ka functionality\n");
#ifndef LIMIT
    fprintf(stderr, "  -q file          copy arguments to file\n");
    fprintf(stderr, "  -f file          file is a description file\n");
#endif
    fprintf(stderr, "  \nResolve codes:\n");
    fprintf(stderr, "  A                ASCII\n");
    fprintf(stderr, "  A+               ASCII for subsequent transfers\n");
    fprintf(stderr, "  A++              same as A+ and save in known file if used\n");
    fprintf(stderr, "  B[+][+]          same as A, but Binary\n");
    fprintf(stderr, "  S                skip the file\n");
#ifndef LIMIT
    fprintf(stderr, "\nDescription file line format:\n");
    fprintf(stderr, "  src  dst         source and destination spec\n");
    fprintf(stderr, "  src              source spec, dst assumed to be '*.*'\n");
#endif
    exit(1);
}

addNode(qual, tag)
int qual;
char *tag;
{
    struct known_struct *k;

    k = (struct known_struct *)Xmalloc(sizeof(struct known_struct));
    if (!k) {
er:	fprintf(stderr, "%s: insufficient memory to store known entries\n",myname);
	return(0);
    }
    if (qual == 'S')
	k->qual = -1;
    else
	k->qual = qual - 'A';
    k->tag = (char *)Xmalloc(strlen(tag)+1);
    if (!k->tag) goto er;
    strcpy(k->tag, tag);
    k->next = khead;
    khead = k;
    return(1);
}

int readKnown()
{
    FILE *kfile;
    char name[256];
    struct known_struct *k;

    kfile = fopen(opts[10].data, "r");
    if (!kfile) {
	if (opts[11].found)
	    return(1);
	else {
	    fprintf(stderr, "%s: cannot open '%s'\n", myname, opts[10].data);
	    return(0);
	}
    }
    while (fscanf(kfile, "%s", name) != EOF) {
	if (islower(name[0]))
	    name[0] = toupper(name[0]);
	if ((name[0] != 'A' && name[0] != 'B' && name[0] != 'S')
			|| name[1] != '.') {
ie:	    fprintf(stderr, "%s: invalid entry in 'known' file '%s'\n", myname, name);
	    return(0);
	}
	for (k = khead; k; k = k->next) {
	    if (strcmp(k->tag, &name[2]) == 0) {
		fprintf(stderr, "%s: known entry specified more than once '%s'\n",
			    myname, &name[2]);
		return(0);
	    }
	}
	if (!addNode(name[0], &name[2]))
	    return(0);
    }
    fclose(kfile);
    return(1);
}


addEntry(qual, tag, strong)
int qual, strong;
char *tag;
{
    FILE *kfile;

    if (opts[10].found && strong) {
	kfile = fopen(opts[10].data, "a");
	if (!kfile) {
	    fprintf(stderr, "%s: cannot open/create '%s'\n", myname, opts[10].data);
	    eXtinterrupt = 1;
	    return;
	}
	fprintf(kfile, " %c.%s\n", qual, tag);
	fclose(kfile);
    }
    addNode(qual, tag);
}

int resolve_type(path)
char *path;
{
    char *tag, *ptr;
    int i, addit, strong;
    struct known_struct *k;
    char buffer[80];

    ptr = NULL;
    for (i = strlen(path) - 1; i; --i) {
	if (path[i] == '.') {
	    ptr = &path[i+1];
	    break;
	}
	else if (path[i] == '/')
	    break;
    }
    if (ptr)
	tag = ptr;
    else
	tag = "";
    for (k = khead; k; k = k->next)
	if (strcmp(tag, k->tag) == 0)
	    return(k->qual);
    if (opts[11].found) {
	for ( ; ; ) {
	    printf("%s: Resolve extension for '%s'\n", myname, path);
	    printf("\t\tEnter A[+][+]=ASCII B[+][+]=Binary S[+][+]=skip: ");
	    buffer[0] = 0;
	    fgets(buffer, 80, stdin);
	    if (islower(buffer[0]))
		buffer[0] = toupper(buffer[0]);
	    if (buffer[1] == '+') {
		addit = 1;
		if (buffer[2] == '+')
		    strong = 1;
		else
		    strong = 0;
	    }
	    else
		strong = addit = 0;
	    switch(buffer[0]) {
	    case 'A':
		if (addit) addEntry('A', tag, strong);
		return(0);
	    case 'B':
		if (addit) addEntry('B', tag, strong);
		return(1);
	    case 'S':
		if (addit) addEntry('S', tag, strong);
		return(-1);
	    }
	    if (eXtinterrupt) break;
	}
    }
    return(opts[2].found);
}

static do1(src, dst, qual)
char *src, *dst;
int qual;
{
    int buflen, count;
    FILE *sf;
    XID dst_fid;
    char *p, path[256];

#ifndef LIMIT
    struct stat sbuf;

    if (stat(src, &sbuf)) {
	printf("%s: no match for '%s'\n", myname, src);
	eXtinterrupt = 1;
	return;
    }
    if (sbuf.st_mode & S_IFDIR) {
	printf("%s: '%s' is a directory\n", myname, src);
	eXtinterrupt = 1;
	return;
    }
#endif
    EstablishDest(src, dst, path);
    dst = path;
    if (!opts[3].found && !verify_deletion(dst)) return;
    sf = fopen(src, "r");
    if (sf == NULL) {
	fprintf(stderr, "%s: cannot open '%s'\n", myname, src);
	eXtinterrupt = 1;
	return;
    }
    if (opts[4].found)
	printf("%s: copying %s %s to %s ...\n",
	    myname, (qual ? "Binary" : "ASCII "), src, dst);
    dst_fid = XeXtOpenDOSFile(dpy, dosid, dst, qual, 1);
    if (dst_fid == -1) {
	fprintf(stderr, "%s: cannot create '%s'\n", myname, dst);
	fclose(sf);
	eXtinterrupt = 1;
	return;
    }
    buflen = maxeXtDOSbuf;
    if (RbufLen < buflen) buflen = RbufLen;
    for( ; ; ) {
	if (eXtinterrupt) break;
	count = fread(buffer, 1, buflen, sf);
	if (ferror(sf)) {
	    fprintf(stderr, "%s: error reading '%s'\n", myname, src);
	    eXtinterrupt = 1;
	    break;
	}
	if (XeXtWriteDOSFile(dpy, dosid, dst_fid, buffer, count) == -1) {
	    fprintf(stderr, "%s: error writing '%s'\n", myname, dst);
	    eXtinterrupt = 1;
	    break;
	}
	if (feof(sf)) break;
    }
    fclose(sf);
    if (XeXtCloseDOSFile(dpy, dosid, dst_fid) == -1) {
	fprintf(stderr, "%s: error closing destination '%s'\n", myname, dst);
	eXtinterrupt = 1;
    }
}

#ifndef LIMIT

/*  this routine uses time() to generate a remporary filename.	 We could
    have used tmpnam() but it is not totally portable
*/

get_a_temp()
{
    unsigned long t;

    time(&t);
    sprintf(dummyFile, "u2dos%x.tmp", t);
}

#endif



main(argc, argv)
unsigned int argc;
char *argv[];
{
    int count, i, dest, qual, dof, line, dummy, err;
    char *p;
    char path[256], tbuf[256], ibuffer[256], src[256], dst[256];
    FILE *df, *tf;

    myname = argv[0];
    count = option_test(argc, argv, opts, MAXOPTS, &parm, -1);
#ifndef LIMIT
    dof = opts[14].found;
    if (opts[13].found) {
	df = fopen(opts[13].data, "w");
	if (!df) {
	    fprintf(stderr, "%s-q: cannot create '%s'\n", myname, opts[13].data);
	    return(1);
	}
	for (i = 0; i < count; ++i)
	    fprintf(df, "%s\n", parm[i]);
	fclose(df);
	return(0);
    }
#else
    dof = 0;
#endif
    if (!dof && count < 2)
	usage();
    openDisplay(opts[0].data, opts[1].data);
    resolve_option(opts, 2, 7, "format", "binary");
    resolve_option(opts, 4, 6, "prompt", "yes");
    resolve_option(opts, 9, 8, "verify", "no");
    resolve_option(opts, 11, 12, "ask", "yes");
    setup_size(5, opts);
    if (opts[9].found) {
	opts[10].found = 0;
    }
    else if (!opts[10].found) {
	opts[10].data = XGetDefault(dpy, myname, "known");
	if (opts[10].data)
	    opts[10].found = 1;
    }
    if (opts[10].found) {
	if (!readKnown()) {
	    eXtinterrupt = 1;
	    goto getout;
	}
    }
    if (!dof) {
	dest = --count;
	err = XeXtIsDOSDir(dpy, dosid, parm[dest]);
	if (err > 0) {
	    strcpy(tbuf, parm[dest]);
	    strcat(tbuf, "/*.*");
	    parm[dest] = tbuf;
	}
	else if (err < 0)
	    goto getout;
	for (i = 0; !eXtinterrupt && i < count; ++i) {
	    qual = resolve_type(parm[i]);
	    if (eXtinterrupt) goto getout;
	    if (qual == -1) continue;
	    EstablishDest(parm[i], parm[dest], path);
	    do1(parm[i], path, qual);
	}
    }
#ifndef LIMIT
    else {
	df = fopen(opts[14].data, "r");
	if (!df) {
	    fprintf(stderr, "%s: Cannot open -f '%s'\n", myname, opts[14].data);
	    goto getout;
	}
	line = 0;
	get_a_temp();
	while (fgets(ibuffer, sizeof(ibuffer), df)) {
	    ++line;
	    count = sscanf(ibuffer, " %s %s %c", src, dst, &dummy);
	    if (count == 0 || count == EOF) continue;
	    if (count < 1 || count > 2) {
		fprintf(stderr, "%s: syntax error on line %d '%s'\n",
			    myname, line, opts[14].data);
		break;
	    }
	    if (count == 1)
		strcpy(dst, "*.*");
	    err = XeXtIsDOSDir(dpy, dosid, dst);
	    if (err > 0) {
		strcpy(tbuf, dst);
		strcat(tbuf, "/*.*");
		strcpy(dst, tbuf);
	    }
	    else if (err < 0)
		goto getout;
	    sprintf(cmdLine, "u2dos -q %s %s", dummyFile, src);
	    system(cmdLine);
	    tf = fopen(dummyFile, "r");
	    if (!tf) {
		fprintf(stderr, "%s: cannot open '%s'\n", myname, dummyFile);
		eXtinterrupt = 1;
		goto getout;
	    }
	    while (fscanf(tf, "%s", tbuf) != EOF) {
		qual = resolve_type(tbuf);
		if (eXtinterrupt) goto getout;
		if (qual == -1) continue;
		EstablishDest(tbuf, dst, path);
		do1(tbuf, path, qual);
		if (eXtinterrupt) break;
	    }
	    fclose(tf);
	    unlink(dummyFile);
	}
	fclose(df);
    }
#endif
getout:
    XCloseDisplay(dpy);
    return(eXtinterrupt);
}
