/*  Copyright (C) Hummingbird Communications Ltd. 1990-1993  */

/*     setup options and parameters  */

#include <stdio.h>
#include <signal.h>
#include "extend.h"

extern usage();             /* this routine must not return */
extern char *getenv();
extern int handler();
extern int version;
extern char *myname;
extern int atoi();
extern Display *dpy;
extern int eXtinterrupt;
extern XID dosid;

static char OOM[] = "%s: Out of memory\n";
int RbufLen = DEFBUF;	      /* default buffer size */

/*  argc            from main
    argv            from main
    options            array of OptionDef
    numoptions            number of options in above array
			  must be >= 2 where display == [0]
					     pw      == [1]

    params	    returned pointer to an array of parameter pointers
		    allways has one element allocated
    maxparams	    maximum number of parameters or -1 for indefinite

    returns the number of found parmeters (NOT options)
*/

int option_test(argc, argv, options, numoptions, params, maxparams)
int argc;
char *argv[];
struct OptionDef options[];
int numoptions;
char ***params;
int maxparams;
{
    int i, t, count, repoint;
    char *p;

    signal(SIGINT, handler);
    if (maxparams > 0)
	i = maxparams;
    else
	i = 1;
    *params = (char **)Xmalloc(i * sizeof(char *));
    if (*params == NULL) {
	fprintf(stderr, OOM, myname);
	exit(1);
    }
    repoint = i + 1;
    count = 0;
    for (i = 0; i < numoptions; ++i) {
        options[i].found = 0;
        options[i].data = NULL;
    }
    for (i = 1; i < argc; ++i) {
        p = argv[i];
        if (*p == '-') {
            ++p;
            for (t = 0; t < numoptions; ++t) {
		if (strcmp(p, "ver") == 0) {
		    fprintf(stderr, "%s: Version %d.%d\n",
			    myname,
			    (version >> 8) & 0xFF,
			    version & 0xFF);
		    exit(1);
		}
                if (strcmp(p, options[t].name) == 0) {
                    if (options[t].NeedText != 0) {
                        ++i;
                        if (i >= argc)
                            usage();
                        p = argv[i];
                        if (*p == '-')
                            usage();
                        options[t].data = p;
                    }
                    options[t].found = 1;
                    break;
                }
            }
            if (t == numoptions)
                usage();
        }
        else if (count == maxparams)
            usage();
	else {
	    if (++count >= repoint) {
		*params = (char **)Xrealloc(*params, count * sizeof(char *));
		if (*params == NULL) {
		    fprintf(stderr, OOM, myname);
		    exit(1);
		}
	    }
	    *(*params+count-1) = p;
	}
    }
    if (!options[1].found) {
	p = getenv("DOSPW");
        if (p)
	    options[1].data = p;
        else
	    options[1].data = "";
    } 
    return(count);
}


setup_size(index, opts)
int index;
struct OptionDef opts[];
{
    char *p;

    p = NULL;
    if (!opts[index].found)
	p = XGetDefault(dpy, myname, "size");
    else
	p = opts[index].data;
    if (p != NULL)
	RbufLen = atoi(p);
    if (RbufLen <= 0 || RbufLen > MAXBUF) {
	fprintf(stderr, "%s: Invalid -size option or %s.size resource", myname, myname);
	exit(1);
    }
}


resolve_option(opts, maini, seci, option, value)
struct OptionDef opts[];
int maini, seci;
char *option, *value;
{
    char *p;

    if (!opts[maini].found && !opts[seci].found) {
	p = XGetDefault(dpy, myname, option);
	if (p) {
	    if (strcmp(p, value) == 0)
		opts[maini].found = 1;
	}
    }
}

int verify_deletion(path)
char *path;
{
    char buffer[80];
    int count;

    count = XeXtDoesExist(dpy, dosid, path);
    if (count > 0) {
	printf("%s: delete existing %s? ", myname, path);
	buffer[0] = 0;
	fgets(buffer, 80, stdin);
	if (buffer[0] != 'Y' && buffer[0] != 'y')
	    return(0);
	else
	    return(1);
    }
    else if (count < 0) {
	fprintf(stderr, "%s: error searching directory\n", myname);
	eXtinterrupt = 1;
	return(0);
    }
    else
	return(1);
}
