/*  Copyright (C) Hummingbird Communications Ltd. 1991-1994  */

#include <stdio.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>

extern char *getenv();

#define isYes(p) (*(p) == 'y' || *(p) == 'Y')

#define MAXPARMS		25

Display *dpy = {NULL};	    /* the display! */

char *myname;		    /* name of this program, used in error reporting */

struct OptionDef {
    char *name; 	    /* name of option */
    char **data;	    /* address of pointer to data*/
    char *def;		    /* default value for parameterless options */
};

/*  option text */

char *opt_display = {NULL};
char *opt_name	  = {NULL};
char *opt_state   = {NULL};
char *opt_icon	  = {NULL};
char *opt_nocolor = {NULL};
char *opt_log     = {NULL};
char *parms[MAXPARMS];

static char DefLog[256];		    /* default log */

struct {
    char *name; 	    /* name of option */
    char **data;	    /* address of pointer to data*/
    char *def;		    /* default value for parameterless options */
} opts[] = {
    {"display", &opt_display, NULL},
    {"name", &opt_name, NULL},
    {"active", &opt_state, "y"},
    {"inactive", &opt_state, "n"},
    {"iconic", &opt_icon, "y"},
    {"normal", &opt_icon, "n"},
    {"color",  &opt_nocolor,  "n"},
    {"nocolor", &opt_nocolor, "y"},
    {"log", &opt_log, NULL},
    {NULL, NULL, NULL}
};

static char LogMsg[] = "Command: %s\n";
static XSetWindowAttributes att;	    /* attributes */
static int first;			    /* first try for selection */
static char *Home;			    /* HOME directory */
static FILE *errfile;			    /* stderr */
static FILE *outfile;			    /* stdout */
static int startIconic; 		    /* start iconic flag */
static int nocolor;			    /* no green, red, yellow if true */
static int DS_state = {0};		    /* 0=inactive,1=active,2=blocked */
static long enable_color;		    /* green */
static long disable_color;		    /* red */
static long blocked_color;		    /* yellow */
static Window rootwin;			    /* the root */
static Window win;			    /* the utility window */
static Atom hwmRPS_atom;		    /* property to monitor */
static Atom hwmDname_atom;		    /* property to place display name */
static Colormap cmap;			    /* the default colormap */
static int scrin;			    /* the screen */
static char rbuf[1025]; 		    /* a temporary buffer */
static char nbuf[256];			    /* namebuf */
static char bitmap_data[] = {3, 3, 0xC, 0xC};	/* a simple stipple bitmap */
#define BITMAP_SQUARE	4		    /* bitmap height and width */
static Pixmap pmap;			    /* a pixmap to contain the above */
static Window owner = {0};		    /* selection owner */
static Time ownerTime;			    /* time of selection aquisition */
static int lastIconState = {-1};	    /* last icon name state */
static char *dstr;			    /* display name string */

static char *option_text[] = {		    /* list of options */
"  -display display-name",
"  -name win-name   window name. default hwmRPS",
"  -active          initially active. default",
"  -inactive        initially inactive",
"  -iconic          start as icon",
"  -normal          do not start as icon. default",
"  -color           enabled=green, disabled=red, blocked=yellow. default",
"  -nocolor         enabled=server foreground, disabled=server background",
"                   blocked=stipple",
"  -log log-name    errors to named log file (.err)(.out)",
"  -log none        no redirection of output",
"  -log default     output to $(HOME)/hwmrps.log(.err)(.out). default",
NULL
};

/*  in case of error */

usage()
{
    int i;

    fprintf(errfile, "usage: %s [options]\n", myname);
    for (i = 0; option_text[i]; ++i)
	fprintf(errfile, "%s\n", option_text[i]);
    fflush(errfile);
    exit(1);
}

/*  process command line options */

option_test(argc, argv)
int argc;
char *argv[];
{
    int i, t;
    char *p;

    for (i = 1; i < argc; ++i) {
        p = argv[i];
        if (*p == '-') {
            ++p;
	    for (t = 0; ; ++t) {
		if (!opts[t].name)
		    usage();
		if (strcmp(p, opts[t].name) == 0) {
		    if (opts[t].def)
			*opts[t].data = opts[t].def;
		    else {
			++i;
			if (i >= argc)
			    usage();
			p = argv[i];
			if (*p == '-')
			    usage();
			*opts[t].data = p;
		    }
                    break;
                }
            }
        }
	else
            usage();
    }
}

/*  alloc a color by name, return the index or -1 */

int docolor(colorStr)
char *colorStr;
{
    XColor sdef, edef;

    if (!XAllocNamedColor(dpy, cmap, colorStr, &sdef, &edef)) {
	fprintf(errfile, "%s: Cannot allocate color %s\n", myname, colorStr);
	fflush(errfile);
	return(-1);
    }
    return(sdef.pixel);
}


/*  display the simple window */

dispWin(code)
int code;
{
    unsigned long pixval;

    switch(code) {
    case 0:			/* force disabled */
	XSetWindowBackground(dpy, win, disable_color);
	break;
    case 1:			/* force enabled */
	XSetWindowBackground(dpy, win, enable_color);
	break;
    case 2:			/* force blocked */
	if (!nocolor)
	    XSetWindowBackground(dpy, win, blocked_color);
	else
	    XSetWindowBackgroundPixmap(dpy, win, pmap);
	break;
    }
    XClearWindow(dpy, win);	/* clear the window */
    XFlush(dpy);
}


/*  Get the property data */

gprop()
{
    int format, bad;
    Atom atomret;
    char *buf;
    long niterm, bytesAfter;

    bad = 1;
    if (XGetWindowProperty(dpy, rootwin, hwmRPS_atom, 0, sizeof(rbuf)-1,
	    True, AnyPropertyType, &atomret,
	    &format, &niterm, &bytesAfter, &buf) != Success)
	fprintf(errfile, "%s: error reading property\n", myname);
    else if (format != 8)
	fprintf(errfile, "%s: invalid property format type\n", myname);
    else if (bytesAfter)
	fprintf(errfile, "%s: data too large\n", myname);
    else if (niterm) {
	dispWin(2);
	strncpy(rbuf, buf, niterm);
	XFree(buf);
	rbuf[niterm] = 0;
	if (opt_log) {
	    fprintf(errfile, LogMsg, rbuf);
	    fprintf(outfile, LogMsg, rbuf);
	}
	system(rbuf);
	DS_state = getSel(0);
	dispWin(DS_state);
	bad = 0;
    }
    if (bad)
	XBell(dpy, 100);
    fflush(errfile);
    fflush(outfile);
}

/*  get a default if necessary */

GetOp(dest, res, def)
char **dest;			    /* pointer to null or established data */
char *res;			    /* the resource name */
char *def;			    /* the default text */
{
    char *p;

    if (!*dest) {
	p = XGetDefault(dpy, myname, res);
	if (!p)
	    p = def;
	*dest = p;
    }
}

/*  process all options */

setup_options()
{
    unsigned long pixvals[3];
    int count;

    GetOp(&opt_log, "log", DefLog);
    GetOp(&opt_state, "active", "y");
    first = isYes(opt_state);
    GetOp(&opt_icon, "iconic", "n");
    startIconic = isYes(opt_icon);
    GetOp(&opt_nocolor, "nocolor", "n");
    nocolor = isYes(opt_nocolor);
    GetOp(&opt_name, "name", "HRPS");
    strcpy(nbuf+1, opt_name);
    nbuf[0] = '*';
    if (!nocolor) {
	disable_color = blocked_color = -1;
	enable_color = docolor("green");
	if (enable_color != -1)
	    disable_color = docolor("red");
	    if (disable_color != -1)
		blocked_color = docolor("yellow");

	if (enable_color == -1 || disable_color == -1 || blocked_color == -1) {
	    count = 0;
	    if (enable_color != -1)
		pixvals[count++] = enable_color;
	    if (disable_color != -1)
		pixvals[count++] = disable_color;
	    if (blocked_color != -1)
		pixvals[count++] = blocked_color;
	    if (count)
		XFreeColors(dpy, cmap, pixvals, count, 0);
	    nocolor = 1;
	}
    }
}

/*  set icon name */

setIconName(on)
int on;
{
    on = !on;
    if (on != lastIconState) {
	XChangeProperty(dpy, win, XA_WM_ICON_NAME, XA_STRING, 8,
			PropModeReplace, nbuf+on, strlen(nbuf));
	lastIconState = on;
    }
}


/*  setup window information */

setup_windows()
{
    static GC gc1;
    Pixmap pmap1;

    att.event_mask = PropertyChangeMask;
    XChangeWindowAttributes(dpy, rootwin, CWEventMask, &att);
    att.event_mask = ButtonPressMask | ButtonReleaseMask |
			LeaveWindowMask | PropertyChangeMask;
    win = XCreateWindow(dpy, rootwin, 0, 0, 50, 50,
	      0, CopyFromParent, InputOutput, CopyFromParent,
	      CWEventMask, &att);
    if (nocolor) {
	enable_color = XWhitePixel(dpy, scrin);
	disable_color = XBlackPixel(dpy, scrin);
	pmap1 = XCreateBitmapFromData(dpy, win, bitmap_data, BITMAP_SQUARE,
	    BITMAP_SQUARE);
	pmap = XCreatePixmap(dpy, win, BITMAP_SQUARE, BITMAP_SQUARE,
	    DisplayPlanes(dpy, 0));
	gc1 = XCreateGC(dpy, win, 0, NULL);
	XCopyPlane(dpy, pmap1, pmap, gc1, 0, 0, BITMAP_SQUARE, BITMAP_SQUARE,
	    0, 0, 1);
	XFreePixmap(dpy, pmap1);
	XFreeGC(dpy, gc1);
    }
    XChangeProperty(dpy, win, XA_WM_NAME, XA_STRING, 8,
		    PropModeReplace, opt_name, strlen(opt_name));
    setIconName(0);
}

/* redirect stream */

FILE * redirect_stream(Stream, fname, ext)
FILE * Stream;
char * fname;
char * ext;
{
    strcpy(rbuf, fname);
    strcat(rbuf, ext);
    return(freopen(rbuf, "w", Stream));
}

/*  get the selection */

int getSel(set)
int set;
{
    if (set) {
	XSetSelectionOwner(dpy, hwmRPS_atom, win, ownerTime);
	XChangeProperty(dpy, rootwin, hwmDname_atom, XA_STRING, 8,
	    PropModeReplace, dstr, strlen(dstr));
    }
    owner = XGetSelectionOwner(dpy, hwmRPS_atom);
    set = (owner == win);
    setIconName(set);
    return(set);
}

/*  give up the selection */

giveUpSelection(forced)
int forced;
{
    if (owner && !forced) {
	XSetSelectionOwner(dpy, hwmRPS_atom, None, ownerTime);
	XDeleteProperty(dpy, rootwin, hwmDname_atom);
    }
    owner = 0;
    att.event_mask = 0;
    XChangeWindowAttributes(dpy, rootwin, CWEventMask, &att);
    DS_state = 0;
    dispWin(0);
    setIconName(0);
}


/*  main and event loop */

main(argc, argv)
int argc;
char *argv[];
{
    int button_down;
    XEvent event;
    XWMHints wmh;

    myname = argv[0];
    errfile = stderr;
    option_test(argc, argv);

    Home = getenv("HOME");
    if (!Home)
	Home = ".";
    strcpy(DefLog, Home);
    strcat(DefLog, "/hwmrps.log");
    if ((dpy = XOpenDisplay(opt_display)) == NULL) {
	fprintf(errfile, "%s: Cannot Open Display %s\n", myname,
		opt_display ? opt_display : "(null)");
	return(1);
    }
    dstr = XDisplayString(dpy);
    if (dstr == NULL) dstr = "";
    rootwin = XDefaultRootWindow(dpy);
    scrin = XDefaultScreen(dpy);
    cmap =  XDefaultColormap(dpy, scrin);
    setup_options();
    if (strcmp(opt_log, "none") == 0)
	opt_log = NULL;
    else if (strcmp(opt_log, "default") == 0)
	opt_log = DefLog;
    if (opt_log) {
	errfile = redirect_stream(stderr, opt_log, ".err");
	outfile = redirect_stream(stdout, opt_log, ".out");
	if (!errfile || !outfile) {
	    fprintf(stderr, "Cannot redirect stderr or stdout\n");
	    return(1);
	}
    }
    else {
	outfile = stdout;
	errfile = stderr;
    }

    hwmRPS_atom = XInternAtom(dpy, "_HCL_HWMRPS", False);
    hwmDname_atom = XInternAtom(dpy, "_HCL_HWMRPS2", False);

    setup_windows();

    if (startIconic) {
	wmh.flags = StateHint;
	wmh.initial_state = IconicState;
	XSetWMHints(dpy, win, &wmh);
    }

    XMapWindow(dpy, win);
    dispWin(0);

    button_down = 0;
    while (1) {
	XNextEvent(dpy, &event);
	switch(event.type) {
	case SelectionClear:
	    giveUpSelection(1);
	    break;
	case LeaveNotify:
	    button_down = 0;
	    break;
	case ButtonPress:
	    if (event.xbutton.button == 1)
		button_down = 1;
	    break;
	case ButtonRelease:
	    if (event.xbutton.button == 1 && button_down) {
		button_down = 0;
		if (!DS_state) {
		    if (owner != win) {
			ownerTime = event.xbutton.time;
			if (!getSel(1)) {
			    XBell(dpy, 100);
			    break;
			}
		    }
		    else if (!getSel(0)) {
			if (!getSel(1)) {
			    XBell(dpy, 100);
			    break;
			}
		    }
		    first = 0;
		    att.event_mask = PropertyChangeMask;
		    XChangeWindowAttributes(dpy, rootwin, CWEventMask, &att);
		    DS_state = 1;
		    dispWin(DS_state);
		}
		else
		    giveUpSelection(0);
	    }
	    break;
	case PropertyNotify:
	    if (event.xproperty.window == win) {
		if (first) {
		    ownerTime = event.xproperty.time;
		    if (getSel(1)) {
			DS_state = 1;
			dispWin(1);
		    }
		    else
			XBell(dpy, 100);
		    first = 0;
		    att.event_mask = ButtonPressMask | ButtonReleaseMask |
					LeaveWindowMask;
		    XChangeWindowAttributes(dpy, win, CWEventMask, &att);
		}
	    }
	    else if (DS_state &&
		    event.xproperty.atom == hwmRPS_atom &&
		    event.xproperty.window == rootwin &&
		    event.xproperty.state == PropertyNewValue) {
		gprop();
	    }
	    break;
	} /* switch */
    } /* loop */
}
