/*  Copyright (C) Hummingbird Communications Ltd. 1990-1993	 */

#include <stdio.h>
#include <signal.h>
#include <string.h>
#include "extend.h"

int eXtinterrupt = 0;
char DirNewPath[256];

static int flag;
static int tlen;

extern char *myname;

int dontCheckForSubDir = {0};

handler()
{
    eXtinterrupt = 1;
    signal(SIGINT, handler);
}

extern int eXt_major_code;

extern errno;

int maxeXtDOSbuf;

struct linkage *head;
int entries;

MKpath(opath, name, path, all)
char *opath, *name, *path;
int all;
{
    char *base;

    if (all) {
	strcpy(path, opath);
	base = path + strlen(path) - 1;
	if (*base != '/' && *base != '\\' && *base != ':') {
	    ++base;
	    *base = '/';
	}
	++base;
    }
    else {
	for (base = path; *opath; ++opath, ++path) {
	    *path = *opath;
	    if (*path == '/' || *path == '\\' || *path == ':')
		base = path+1;
	}
    }
    strcpy(base, name);
}

XID XeXtStartDOS(dpy, name)
Display *dpy;
char *name;
{
    register xStartDOSReq *req;
    xDOSReply rep;
    int tlen;
    int ok;
    
    LockDisplay(dpy);
    GetReq(StartDOS, req);
    req->DOSid = XAllocID(dpy);
    req->minorCode = StartDOS_num;
    tlen = strlen(name) + 1;
    req->length += ((tlen + 3) >> 2);
    _XSend(dpy, (char *)name, tlen);
    ok = _XReply(dpy, &rep, 0, True);
    UnlockDisplay(dpy);
    SyncHandle();
    if (!ok) {
	fprintf(stderr, "%s: Error from _XReply:StartDOS\n", myname);
	exit(1);
    }
    if(rep.errno) {
        errno = rep.errno;
	  return((XID)0);
    }
    maxeXtDOSbuf = rep.size;
    return(req->DOSid);
}

static int DirTest(dpy, dosid, name)
Display *dpy;
XID dosid;
char *name;
{
    register xReadDOSDirReq *req;
    xDOSDirReply rep;
    char *ptemp;
    int ret;
        
    if (*name == 0) return(0);
    for (ptemp = name; *ptemp; ++ptemp)
	if (*ptemp == '*' || *ptemp == '?') return(0);
    LockDisplay(dpy);
    GetReq(ReadDOSDir, req);
    req->DOSid = dosid;
    req->minorCode = ReadDOSDir_num;
    tlen = strlen(name) + 1;
    req->length += ((tlen + 3) >> 2);
    req->attribute = 0xff;
    Data(dpy, (char *)name, tlen);
    flag = 0;
    ret = 0;
    for (tlen = 0;;) {
	if (!_XReply(dpy, &rep, 0, True)) {
	    fprintf(stderr, "%s: Error from _XReply:ReadDOSDir\n", myname);
	    ret = -1;
	    eXtinterrupt = 1;
	    errno = -1;
	    break;
	}
	if (rep.next == 0) break;
        if (rep.errno) {
            errno = rep.errno;
	    fprintf(stderr, "%s: Error from ReadDOSDir (errno=%d)", myname, errno);
	    ret = -1;
	    eXtinterrupt = 1;
	    break;
	}
	++tlen;
	if (rep.attribute & 0x10)
	    flag = 1;
    }
    UnlockDisplay(dpy);
    SyncHandle();
    return(0);
}

int XeXtIsDOSDir(dpy, dosid, name)
Display *dpy;
XID dosid;
char *name;
{
    if (DirTest(dpy, dosid, name) == -1) return(-1);
    return(flag && (tlen == 1));
}

int XeXtDoesExist(dpy, dosid, name)
Display *dpy;
XID dosid;
char *name;
{
    if (DirTest(dpy, dosid, name) == -1) return(-1);
    return(tlen);
}

char *FilenamePart(ptr)
char *ptr;
{
    char *base;

    for (base = ptr; *ptr; ) {
	switch(*ptr++) {
	case '/':
	case '\\':
	case ':':
	    base = ptr;
	    break;
	}
    }
    return(base);
}

XeXtReadDOSDir(dpy, dosid, name, attr)
Display *dpy;
XID dosid;
char *name;
int attr;
{
    register xReadDOSDirReq *req;
    xDOSDirReply rep;
    int i, tlen, err;
    struct linkage *cur, *p, *c;

    strcpy(DirNewPath, name);
    if (*FilenamePart(DirNewPath) == 0)
	strcat(DirNewPath,"*.*");
    else if (dontCheckForSubDir)
	dontCheckForSubDir = 0;
    else {
	err = XeXtIsDOSDir(dpy, dosid, name);
	if (err == -1)
	    return(-1);
	else if (err)
	    strcat(DirNewPath, "/*.*"); 	 /* it's a subdir */
    }
    head = NULL;
    entries = 0;
    LockDisplay(dpy);
    GetReq(ReadDOSDir, req);
    req->DOSid = dosid;
    req->minorCode = ReadDOSDir_num;
    tlen = strlen(DirNewPath) + 1;
    req->length += ((tlen + 3) >> 2);
    req->attribute = attr;
    Data(dpy, (char *)DirNewPath, tlen);
    err = 0;
    for (; ; ) {
	if (!_XReply(dpy, &rep, 0, True)) {
	    err = 1;
	    errno = -1;
	    fprintf(stderr, "%s: Error from _XReply:ReadDOSDir\n", myname);
	    break;
	}
	if (rep.next == 0) break;
        if (rep.errno) {
            errno = rep.errno;
	    err = 1;
	    break;
        }
        cur = (struct linkage *)Xmalloc(sizeof(struct linkage));
        if (cur == NULL) {
            errno = ENOMEM;
	    err = 1;
	    break;
        }
        cur->r = rep;
	for (p = NULL, c = head; c; p = c, c = c->next)
            if (strcmp(cur->r.name, c->r.name) < 0)
                break;
	++entries;
        cur->next = c;
        if (!p) 
            head = cur;
        else
            p->next = cur;
    }
getout:
    UnlockDisplay(dpy);
    SyncHandle();
    return(err);
}

XID XeXtOpenDOSFile(dpy, dosid, filename, binary, write)
Display *dpy;
XID dosid;
char *filename;
int binary, write;
{
    register xOpenDOSFileReq *req;
    xDOSReply rep;
    int tlen;
    XID ret;

    LockDisplay(dpy);
    GetReq(OpenDOSFile, req);
    req->DOSid = dosid;
    req->fid = XAllocID(dpy);
    req->minorCode = OpenDOSFile_num;
    tlen = strlen(filename) + 1;
    req->length += ((tlen + 3) >> 2);
    req->binary = binary;
    req->write = write;
    _XSend(dpy, (char *)filename, tlen);
    ret = (XID)(0L);
    if (!_XReply(dpy, &rep, 0, True)) {
	errno = -1;
	fprintf(stderr, "%s: Error from _XReply:OpenDOSFile\n", myname);
	ret = (XID)(-1L);
    }
    UnlockDisplay(dpy);
    SyncHandle();
    if (!ret) {
	if (rep.errno) {
	    errno = rep.errno;
	    ret = (XID)(-1L);
	}
	else
	    ret = req->fid;
    }
    return(ret);
}

int XeXtCloseDOSFile(dpy, dosid, fid)
Display *dpy;
XID dosid, fid;
{
    register xCloseDOSFileReq *req;
    xDOSReply rep;
    int ret;

    LockDisplay(dpy);
    GetReq(CloseDOSFile, req);
    req->DOSid = dosid;
    req->fid = fid;
    req->minorCode = CloseDOSFile_num;
    ret = 0;
    if (!_XReply(dpy, &rep, 0, True)) {
	errno = -1;
	fprintf(stderr, "%s: Error from _XReply:CloseDOSFile\n", myname);
	ret = -1;
    }
    UnlockDisplay(dpy);
    SyncHandle();
    if (!ret && rep.errno) {
        errno = rep.errno;
	ret = -1;
    }
    return(ret);
}

int xGetBlockDeviceVector(dpy, dosid, vector)
Display *dpy;
XID dosid;
unsigned long *vector;
{
    register xBlockDeviceVectorReq *req;
    xBlockDeviceVectorReply rep;
    char *p;
    unsigned int count;
    int ret;

    LockDisplay(dpy);
    GetReq(BlockDeviceVector, req);
    req->DOSid = dosid;
    req->minorCode = BlockDeviceVector_num;
    ret = 0;
    if (!_XReply(dpy, &rep, 0, True)) {
	errno = -1;
	fprintf(stderr, "%s: Error from _XReply:BlockDeviceVector\n", myname);
	ret = -1;
    }
    UnlockDisplay(dpy);
    SyncHandle();
    if (!ret) {
	*vector = rep.vector;
	if (rep.errno) {
	    errno = rep.errno;
	    ret = -1;
	}
    }
    return(ret);
}

int XeXtIdent(dpy, dosid, buffer, homePathSize, userPathSize, fileSystemSize)
Display *dpy;
XID dosid;
char **buffer;
int *homePathSize;
int *userPathSize;
int *fileSystemSize;
{
    register xIdentReq *req;
    xIdentReply rep;
    char *p;
    unsigned int count;
    int ret;

    LockDisplay(dpy);
    GetReq(Ident, req);
    req->DOSid = dosid;
    req->minorCode = Ident_num;
    if (!_XReply(dpy, &rep, 0, False)) {
	errno = -1;
	fprintf(stderr, "%s: Error from _XReply:Ident\n", myname);
	ret = -1;
    }
    else if (rep.errno) {
	errno = rep.errno;
	ret = -1;
    }
    else {
	ret = 0;
	count = rep.length << 2;
	*buffer = (char *)Xmalloc(count);
	if (*buffer == NULL) {
	    errno = ENOMEM;
	    ret = -1;
	}
	else {
	    _XRead(dpy, *buffer, (long)count);
	    ret = rep.version;
	    if (ret <= 3)
		*homePathSize = 0;
	    else
		*homePathSize = rep.homePathSize;
	    *userPathSize = rep.userPathSize;
	    *fileSystemSize = rep.fileSystemSize;
	}
    }
    UnlockDisplay(dpy);
    SyncHandle();
    return(ret);
}

int XeXtReadDOSFile(dpy, dosid, fid, buff, count)
Display *dpy;
XID dosid, fid;
char *buff;
unsigned int count;
{
    register xReadDOSFileReq *req;
    xDOSReply rep;
    int npad;
    char scrap[4];

    LockDisplay(dpy);
    GetReq(ReadDOSFile, req);
    req->DOSid = dosid;
    req->fid = fid;
    req->minorCode = ReadDOSFile_num;
    req->nbytes = count;
    if (!_XReply(dpy, &rep, 0, False)) {
	errno = -1;
	fprintf(stderr, "%s: Error from _XReply:ReadDOSFile\n", myname);
	count = -1;
    }
    else {
	count = rep.size;
	if (rep.size == 0xffff) {
	    errno = rep.errno;
	    count = -1;
	}
	else {
	    _XRead(dpy, buff, (long)count);
	    npad = (4 - (count & 3)) & 3;
	    if (npad)
		_XRead(dpy, scrap, (long)npad);
	}
    }
    UnlockDisplay(dpy);
    SyncHandle();
    return(count);
}

int XeXtPCint(dpy, dosid, func, control, status, inbuf, len, outbuf)
Display *dpy;
XID dosid;
unsigned int func;
unsigned int *control;
unsigned int *status;
char *inbuf;
unsigned int *len;
char *outbuf;
{
    register xPCintReq *req;
    xPCintReply rep;
    unsigned int useLen;
    char scrap[4];
    int npad;

    LockDisplay(dpy);
    GetReq(PCint, req);
    req->DOSid = dosid;
    req->func = func;
    req->minorCode = PCint_num;
    req->control = *control;
    req->status = *status;
    if (func == 0 || func == 1)
	useLen = 0;
    else
	useLen = *len;
    req->dataLen = useLen;
    req->length += ((useLen + 3) >> 2);
    if (useLen)
	_XSend(dpy, inbuf, useLen);
    if (!_XReply(dpy, &rep, 0, False)) {
	fprintf(stderr, "%s: Error from _XReply:PCint\n", myname);
	rep.errno = -1;
    }
    else {
	if (func != 0 && func != 1 && (!rep.errno || rep.errno == ERANGE)
		    && rep.dataLen) {
	    _XRead(dpy, outbuf, rep.dataLen);
	    npad = 4 - (rep.dataLen & 3);
	    if (npad)
		_XRead(dpy, scrap, npad);
	}
	*control = rep.control;
	*status = rep.status;
	*len = rep.dataLen;
    }
    UnlockDisplay(dpy);
    SyncHandle();
    return(rep.errno);
}

int XeXtWriteDOSFile(dpy, dosid, fid, buff, count)
Display *dpy;
XID dosid, fid;
char *buff;
unsigned int count;
{
    register xWriteDOSFileReq *req;
    xDOSReply rep;
    int ok;

    LockDisplay(dpy);
    GetReq(WriteDOSFile, req);
    req->DOSid = dosid;
    req->fid = fid;
    req->minorCode = WriteDOSFile_num;
    req->nbytes = count;
    req->length += ((count + 3) >> 2);
    _XSend(dpy, buff, count);
    ok = _XReply(dpy, &rep, 0, True);
    UnlockDisplay(dpy);
    SyncHandle();
    if (!ok) {
	errno = -1;
	fprintf(stderr, "%s: Error from _XReply:WriteDOSFile\n", myname);
	return(-1);
    }
    count = rep.size;
    if (rep.size == 0xffff) {
	errno = rep.errno;
	return(-1);
    }
    return(count);
}

int XeXtMakeDOSDir(dpy, dosid, name)
Display *dpy;
XID dosid;
char *name;
{
    register xMakeDOSDirReq *req;
    xDOSReply rep;
    int tlen;
    int ok;

    LockDisplay(dpy);
    GetReq(MakeDOSDir, req);
    req->DOSid = dosid;
    req->minorCode = MakeDOSDir_num;
    tlen = strlen(name) + 1;
    req->length += ((tlen + 3) >> 2);
    _XSend(dpy, name, tlen);
    ok = _XReply(dpy, &rep, 0, True);
    UnlockDisplay(dpy);
    SyncHandle();
    if (!ok) {
	errno = -1;
	fprintf(stderr, "%s: Error from _XReply:MakeDOSDir\n", myname);
	return(-1);
    }
    if (rep.errno) {
        errno = rep.errno;
        return(-1);
    }
    return(0);
}

int XeXtRemoveDOSDir(dpy, dosid, name)
Display *dpy;
XID dosid;
char *name;
{
    register xRemoveDOSDirReq *req;
    xDOSReply rep;
    int tlen;
    int ok;

    LockDisplay(dpy);
    GetReq(RemoveDOSDir, req);
    req->DOSid = dosid;
    req->minorCode = RemoveDOSDir_num;
    tlen = strlen(name) + 1;
    req->length += ((tlen + 3) >> 2);
    _XSend(dpy, name, tlen);
    ok = _XReply(dpy, &rep, 0, True);
    UnlockDisplay(dpy);
    SyncHandle();
    if (!ok) {
	errno = -1;
	fprintf(stderr, "%s: Error from _XReply:RemoveDOSDir\n", myname);
	return(-1);
    }
    if (rep.errno) {
        errno = rep.errno;
        return(-1);
    }
    return(0);
}

int XeXtChangeDOSDir(dpy, dosid, name)
Display *dpy;
XID dosid;
char *name;
{
    register xChangeDOSDirReq *req;
    xDOSReply rep;
    int tlen;
    int ok;

    LockDisplay(dpy);
    GetReq(ChangeDOSDir, req);
    req->DOSid = dosid;
    req->minorCode = ChangeDOSDir_num;
    tlen = strlen(name) + 1;
    req->length += ((tlen + 3) >> 2);
    _XSend(dpy, name, tlen);
    ok = _XReply(dpy, &rep, 0, True);
    UnlockDisplay(dpy);
    SyncHandle();
    if (!ok) {
	errno = -1;
	fprintf(stderr, "%s: Error from _XReply:ChangeDOSDir\n", myname);
	return(-1);
    }
    if (rep.errno) {
        errno = rep.errno;
        return(-1);
    }
    return(0);
}

int XeXtGetDOSDir(dpy, dosid, buff, n)
Display *dpy;
XID dosid;
char *buff;
int n;			/* n should be multiple of 4 */
{
    register xGetDOSDirReq *req;
    xDOSReply rep;
    int length;
    int ret;

    LockDisplay(dpy);
    GetReq(GetDOSDir, req);
    req->DOSid = dosid;
    req->minorCode = GetDOSDir_num;
    ret = 0;
    if (!_XReply(dpy, &rep, 0, False)) {
	errno = -1;
	fprintf(stderr, "%s: Error from _XReply:GetDOSDir\n", myname);
	ret = -1;
    }
    else if (rep.errno) {
        errno = rep.errno;
	ret = -1;
    }
    else {
	length = rep.length << 2;
	if (n < length) {
	    errno = ERANGE;
	    ret = -1;
	}
	_XRead(dpy, buff, length);
    }
    UnlockDisplay(dpy);
    SyncHandle();
    return(ret);
}

int XeXtChangeDOSDrive(dpy, dosid, drivename)
Display *dpy;
XID dosid;
char drivename;
{
    register xChangeDOSDriveReq *req;
    xDOSReply rep;
    char offset;
    int ok;

    offset = (drivename > 'Z' ? 'a' : 'A');
    LockDisplay(dpy);
    GetReq(ChangeDOSDrive, req);
    req->DOSid = dosid;
    req->minorCode = ChangeDOSDrive_num;
    req->drivenum = (drivename - offset + 1);
    ok = _XReply(dpy, &rep, 0, True);
    UnlockDisplay(dpy);
    SyncHandle();
    if (!ok) {
	errno = -1;
	fprintf(stderr, "%s: Error from _XReply:ChangeDOSDrive\n", myname);
	return(-1);
    }
    if (rep.errno) {
        errno = rep.errno;
        return(-1);
    }
    return(0);
}

int XeXtTouchFile(dpy, dosid, path, year, month, day, hour, mins, sec)
Display *dpy;
char *path;
XID dosid;
int year, month, day, hour, mins, sec;
{
    register xTouchFileReq *req;
    xDOSReply rep;
    int tlen;
    int ok;

    LockDisplay(dpy);
    GetReq(TouchFile, req);
    req->DOSid = dosid;
    req->minorCode = TouchFile_num;
    req->ymd = (year << 16) | (month << 8) | day;
    req->hours = hour;
    req->mins = mins;
    req->secs = sec;
    tlen = strlen(path) + 1;
    req->length += (tlen + 3) >> 2;
    _XSend(dpy, path, tlen);
    ok = _XReply(dpy, &rep, 0, True);
    UnlockDisplay(dpy);
    SyncHandle();
    if (!ok) {
	errno = -1;
	fprintf(stderr, "%s: Error from _XReply:TouchFile\n", myname);
	return(-1);
    }
    if (rep.errno) {
        errno = rep.errno;
        return(-1);
    }
    return(0);
}

int XeXtSetFileAttr(dpy, dosid, path, attr)
Display *dpy;
char *path;
XID dosid;
char attr;
{
    register xSetFileAttrReq *req;
    xDOSReply rep;
    int tlen;
    int ok;

    LockDisplay(dpy);
    GetReq(SetFileAttr, req);
    req->DOSid = dosid;
    req->minorCode = SetFileAttr_num;
    req->attr = attr;
    tlen = strlen(path) + 1;
    req->length += ((tlen + 3) >> 2);
    _XSend(dpy, path, tlen);
    ok = _XReply(dpy, &rep, 0, True);
    UnlockDisplay(dpy);
    SyncHandle();
    if (!ok) {
	errno = -1;
	fprintf(stderr, "%s: Error from _XReply:SetFileAttr\n", myname);
	return(-1);
    }
    if (rep.errno) {
        errno = rep.errno;
        return(-1);
    }
    return(0);
}

int XeXtGetDiskInfo(dpy, dosid, drivename, dfree, dtotal)
Display *dpy;
XID dosid;
char drivename;
long *dfree;
long *dtotal;
{
    register xGetDiskInfoReq *req;
    xGetDiskInfoReply rep;
    int offset;
    int ok;

    if (drivename == 0)
	offset = 1;
    else
	offset = (drivename > 'Z' ? 'a' : 'A');
    LockDisplay(dpy);
    GetReq(GetDiskInfo, req);
    req->DOSid = dosid;
    req->minorCode = GetDiskInfo_num;
    req->drivenum = (drivename - offset + 1);
    ok = _XReply(dpy, &rep, 0, True);
    UnlockDisplay(dpy);
    SyncHandle();
    if (!ok) {
	fprintf(stderr, "%s: Error from _XReply:GetDiskInfo\n", myname);
	errno = -1;
	return(-1);
    }
    if (rep.errno) {
        errno = rep.errno;
        return(-1);
    }
    *dtotal = rep.totalSpace;
    *dfree = rep.freeSpace;
    return(0);
}

int XeXtDelDOSFile(dpy, dosid, filename)
Display *dpy;
XID dosid;
char *filename;
{
    register xDelDOSFileReq *req;
    xDOSReply rep;
    int tlen;
    int ok;

    LockDisplay(dpy);
    GetReq(DelDOSFile, req);
    req->DOSid = dosid;
    req->minorCode = DelDOSFile_num;
    tlen = strlen(filename) + 1;
    req->length += ((tlen + 3) >> 2);
    _XSend(dpy, (char *)filename, tlen);
    ok = _XReply(dpy, &rep, 0, True);
    UnlockDisplay(dpy);
    SyncHandle();
    if (!ok) {
	errno = -1;
	fprintf(stderr, "%s: Error from _XReply:DelDOSFile\n", myname);
	return(-1);
    }
    if (rep.errno) {
        errno = rep.errno;
        return(-1);
    }
    return(0);
}

int XeXtRenDOSFile(dpy, dosid, bothfilename, length)
Display *dpy;
XID dosid;
char *bothfilename;
int length;  /* length should include two '\0' (nullterminate) */
{
    register xRenDOSFileReq *req;
    xDOSReply rep;
    int ok;

    LockDisplay(dpy);
    GetReq(RenDOSFile, req);
    req->DOSid = dosid;
    req->minorCode = RenDOSFile_num;
    req->length += ((length + 3) >> 2);
    _XSend(dpy, (char *)bothfilename, length);
    ok = _XReply(dpy, &rep, 0, True);
    UnlockDisplay(dpy);
    SyncHandle();
    if (!ok) {
	errno = -1;
	fprintf(stderr, "%s: Error from _XReply:RenDOSFile\n", myname);
	return(-1);
    }
    if (rep.errno) {
        errno = rep.errno;
        return(-1);
    }
    return(0);
}

int XeXtDOSLog(dpy, dosid, pposition, buff, count)
Display *dpy;
XID dosid;
long *pposition;
char *buff;
int count;
{
    register xDOSLogReq *req;
    xDOSReply rep;
    int npad;
    char scrap[4];

    LockDisplay(dpy);
    GetReq(DOSLog, req);
    req->DOSid = dosid;
    req->minorCode = DOSLog_num;
    req->readpos = *pposition;
    req->nbytes = count;
    if (!_XReply(dpy, &rep, 0, False)) {
	errno = -1;
	count = -1;
	fprintf(stderr, "%s: Error from _XReply:DOSLog\n", myname);
    }
    else {
	if (rep.errno) {
	    errno = rep.errno;
	    count = -1;
	}
	else {
	    count = rep.size;
	    *pposition = rep.nextpos;
	    _XRead(dpy, buff, (long)count);
	    npad = (4 - (count & 3)) & 3;
	    if (npad)
		_XRead(dpy, scrap, (long)npad);
	}
    }
    UnlockDisplay(dpy);
    SyncHandle();
    return(count);
}

int XeXtpush(dpy, dosid, cmd, version)
Display *dpy;
XID dosid;
char *cmd;
int *version;
{
    register xDOSPushReq *req;
    xDOSPushReply rep;
    int tlen;
    int ok;

    LockDisplay(dpy);
    GetReq(DOSPush, req);
    req->DOSid = dosid;
    req->minorCode = DOSPush_num;
    tlen = strlen(cmd) + 1;
    req->length += ((tlen + 3) >> 2);
    _XSend(dpy, (char *)cmd, tlen);
    ok = _XReply(dpy, &rep, 0, True);
    UnlockDisplay(dpy);
    SyncHandle();
    if (!ok) {
	fprintf(stderr, "%s: Error from _XReply:DOSPush\n", myname);
	rep.errno = -1;
    }
    else
	*version = rep.version;
    return((int)rep.errno);
}

int wildcards(name)
char *name;
{
    for (; *name; ++name)
	if (*name == '*' || *name == '?')
	    return(1);
    return(0);
}

static Fname(s, buf)
char *s, *buf;
{
    int i;

    for (i = 0; i < 8 && *s && *s != '.'; ++i)
	*buf++ = *s++;
    *buf = 0;
}

static Fext(s, buf)
char *s, *buf;
{
    int i;

    while (*s && *s != '.') ++s;
    if (*s == '.') ++s;
    for (i = 0; i < 3 && *s; ++i)
	*buf++ = *s++;
    *buf = 0;
}

static Merge(buf, src, pat, mlen)
char *buf, *src, *pat;
int mlen;
{
    char *ibuf = buf;

    while (*pat) {
	switch(*pat) {
	case '?':
	    if (*src != 0)
		*buf++ = *src++;
	    ++pat;
	    break;
	case '*':
	    while(*src)
		*buf++ = *src++;
	    pat = "";
	    break;
	default:
	    *buf++ = *pat++;
	    if (*src) ++src;
	    break;
	}
    }
    *buf = 0;
    if (strlen(ibuf) > mlen) ibuf[mlen] = 0;
}

/*  called when the destination is DOS */

EstablishDest(src, dst, path)
char *src, *dst, *path;
{
    char nname[13], *s, *d;
    char dname[9], sname[9], dext[4], sext[4];

    d = FilenamePart(dst);
    if (*d == 0) d = "*.*";
    Fname(d, dname);
    Fext(d, dext);
    s = FilenamePart(src);
    if (*s == 0) s = "*.*";
    Fname(s, sname);
    Fext(s, sext);
    Merge(path, sname, dname, 8);
    strcpy(nname, path);
    strcat(nname, ".");
    Merge(path, sext, dext, 3);
    strcat(nname, path);
    MKpath(dst, nname, path, 0);
}

/*  called when the destination is UNIX */

EstablishUnixDest(src, dst, path)
char *src, *dst, *path;
{
    char nname[64], *s, *d;

    d = FilenamePart(dst);
    if (*d == 0) d = "*";
    s = FilenamePart(src);
    if (*s == 0) s = "*";
    Merge(nname, s, d, 63);
    MKpath(dst, nname, path, 0);
}
