/*  Copyright (C) Hummingbird Communications Ltd. 1990-1993	       */

#include <stdio.h>
#include "extend.h"

extern XID dosid;
extern Display *dpy;

int version = {0x204};

char *myname;

struct OptionDef opts[3] = {
    {"display", 1},
    {"pw", 1},
    {"version", 0}};

char **parm;

usage()
{
    fprintf(stderr, "usage: %s [-display host] [-pw password] [-version] [cmd]\n", myname);
    exit(1);
}

main(argc, argv)
unsigned int argc;
char *argv[];
{
    int count, err, len, tlen, i, version;
    char cmd[129];
    char *p;

    myname = argv[0];
    count = option_test(argc, argv, opts, 3, &parm, -1);
    openDisplay(opts[0].data, opts[1].data);
    p = XGetDefault(dpy, myname, "cmd");
    if (p) {
	strcpy(cmd, p);
	len = strlen(cmd);
    }
    else {
	cmd[0] = 0;
	len = 0;
    }
    if (opts[2].found)
	count = 0;
    else if (count == 0 && len == 0) {
	count = 1;
	parm[0] = "command.com";
    }
    for (i = 0; i < count; ++i) {
	tlen = strlen(parm[i]);
	if (len != 0) ++tlen;
	if ((len + tlen) > 128) {
	    fprintf(stderr, "%s: Command line too long\n", myname);
	    return(1);
	}
	if (len != 0) strcat(cmd, " ");
	len += tlen;
	strcat(cmd, parm[i]);
    }
    err = 1;
    switch(i = XeXtpush(dpy, dosid, cmd, &version)) {
    case 7:
	fprintf(stderr, "%s: Argument list too large\n", myname);
	break;
    case 2:
	fprintf(stderr, "%s: Cannot find command.com\n", myname);
	break;
    case 8:
	fprintf(stderr, "%s: command.com is damaged\n", myname);
	break;
    case 12:
	fprintf(stderr, "%s: Not enough DOS memory to run\n", myname);
	break;
    case 36:
	fprintf(stderr, "%s: Pending request\n", myname);
	break;
    case 0:
	if (cmd[0] == 0)
	    printf("Version = %d\n", version);
	err = 0;
	break;
    case 13:
	fprintf(stderr, "%s: Invalid access\n", myname);
	break;
    default:
	fprintf(stderr, "%s: Return code %d\n", myname, i);
	break;
    }
    XCloseDisplay(dpy);
    return(err);
}
