/*  Copyright (C) Hummingbird Communications Ltd. 1990-1993	       */

#include <stdio.h>
#include <string.h>
#include "extend.h"

extern XID dosid;
extern Display *dpy;
extern int maxeXtDOSbuf;
extern int eXtinterrupt;
extern int RbufLen;

struct OptionDef opts[5] = {
    {"display", 1},
    {"pw", 1},
    {"size", 1},
    {"a", 0},
    {"c", 0}};

int version = {0x201};

char *myname;
static char temp[MAXBUF], buf[MAXBUF+2];
static int bsize = 0;
static XID dst_fid;
static int buflen;

char **parm;

usage()
{
    fprintf(stderr, "usage: %s [-display host] [-pw password] [-size size] [-a] [-c] dst\n", myname);
    fprintf(stderr, "  -c               create a new file. (DEFAULT)\n");
    fprintf(stderr, "  -a               append to the file if it exists.\n");
    exit(1);
}

static dowr()
{
    if (bsize == 0 || eXtinterrupt) return;
    if (XeXtWriteDOSFile(dpy, dosid, dst_fid, buf, bsize) == -1) {
	fprintf(stderr, "%s: write error\n", myname);
	eXtinterrupt = 1;
    }
}

static dob()
{
    int tlen, size;

    tlen = strlen(temp);
    if (tlen == 0) return;
    if (tlen + bsize > RbufLen)
	size = RbufLen - bsize;
    else
	size = tlen;
    if (size != 0) {
	strncpy(buf+bsize, temp, size);
	bsize += size;
    }
    if (bsize == RbufLen) {
	dowr();
	if (size != tlen) {
	    strcpy(buf, temp+size);
	    bsize = tlen - size;
	}
    }
}

main(argc, argv)
unsigned int argc;
char *argv[];
{
    int count, i;
    char *p;
    char fname[256], p0tmp[256], path[256];

    myname = argv[0];
    count = option_test(argc, argv, opts, 5, &parm, 1);
    if (count != 1) usage();
    openDisplay(opts[0].data, opts[1].data);
    setup_size(2, opts);
    resolve_option(opts, 3, 4, "append", "yes");
    dst_fid = XeXtOpenDOSFile(dpy, dosid, parm[0], 0, opts[3].found ? 2 : 1);
    if (dst_fid == (XID)(-1L)) {
	fprintf(stderr, "%s: cannot create '%s'\n", myname, parm[0]);
	eXtinterrupt = 1;
    }
    else {
	buflen = maxeXtDOSbuf;
	if (RbufLen < buflen) buflen = RbufLen;
	do {
	    fgets(temp, RbufLen, stdin);
	    dob();
	} while (!eXtinterrupt && !feof(stdin));
	dowr();
	if (XeXtCloseDOSFile(dpy, dosid, dst_fid) == -1) {
	    fprintf(stderr, "%s: error closing destination '%s'\n", myname, parm[0]);
	    eXtinterrupt = 1;
	}
    }
    XCloseDisplay(dpy);
    return(eXtinterrupt);
}
