/*  Copyright (C) Hummingbird Communications Ltd. 1990-1993  */

#include <stdio.h>
#include <string.h>
#include "extend.h"

extern XID dosid;
extern Display *dpy;
extern int maxeXtDOSbuf;
extern int eXtinterrupt;
extern struct linkage *head;
extern int entries;
extern int RbufLen;
extern char DirNewPath[256];

static char buffer[MAXBUF];
static int buflen;
static XID dst_fid;
char *myname;
static char header[1024];
static char trailer[1024];
static int header_len = 0;
static int trailer_len = 0;

int version = {0x106};

struct OptionDef opts[12] = {
    {"display", 1},
    {"pw", 1},
    {"ff", 0},
    {"p", 0},
    {"size", 1},
    {"nff", 0},
    {"np", 0},
    {"device", 1},
    {"header", 1},
    {"trailer", 1},
    {"a", 0},
    {"b", 0}};

char **parm;

usage()
{
    fprintf(stderr, "usage: %s [options] spec\n", myname);
    fprintf(stderr, "  -display display-name\n");
    fprintf(stderr, "  -pw  password\n");
    fprintf(stderr, "  -p               displays the name of each file being copied\n");
    fprintf(stderr, "  -np              does not display the name of each file. (default)\n");
    fprintf(stderr, "  -size size       transfer block size\n");
    fprintf(stderr, "  -ff              emit form-feed after every file\n");
    fprintf(stderr, "  -nff             do not emit form-feed after every file (default).\n");
    fprintf(stderr, "  -device name     set logical device. default = PRN\n");
    fprintf(stderr, "  -header data     data to be used as a header. \\ supported\n");
    fprintf(stderr, "  -trailer data    data to be used as a trailer. \\ supported\n");
    fprintf(stderr, "  -a               ascii file transfer (default)\n");
    fprintf(stderr, "  -b               binary file transfer\n");
    exit(1);
}

do1(pname)
char *pname;
{
    int count;
    XID src_fid;
    char name[256];

    MKpath(DirNewPath, pname, name, 0);
    if (opts[3].found)
	printf("%s: printing %s ...\n", myname, name);
    src_fid = XeXtOpenDOSFile(dpy, dosid, name, 0, 0);
    if (src_fid == (XID)(-1L)) {
	fprintf(stderr, "%s: cannot open '%s'\n", myname, name);
	eXtinterrupt = 1;
	return;
    }
    if (header_len)
	if (XeXtWriteDOSFile(dpy, dosid, dst_fid, header, header_len) == -1) {
	    fprintf(stderr, "%s: error printing\n", myname);
	    eXtinterrupt = 1;
	}
    for ( ; !eXtinterrupt;) {
	count = XeXtReadDOSFile(dpy, dosid, src_fid, buffer, buflen);
	if (count == 0) break;
	if (count < 0) {
	    fprintf(stderr, "%s: error reading '%s'\n", myname, name);
	    eXtinterrupt = 1;
	}
	else if (XeXtWriteDOSFile(dpy, dosid, dst_fid, buffer, count) == -1) {
	    fprintf(stderr, "%s: error printing\n", myname);
	    eXtinterrupt = 1;
	}
    }
    if (!eXtinterrupt && trailer_len)
	if (XeXtWriteDOSFile(dpy, dosid, dst_fid, trailer, trailer_len) == -1) {
	    fprintf(stderr, "%s: error printing\n", myname);
	    eXtinterrupt = 1;
	}
    if (XeXtCloseDOSFile(dpy, dosid, src_fid) == -1) {
	fprintf(stderr, "%s: error closing '%s'\n", myname, name);
	eXtinterrupt = 1;
    }
}

build_hdr_ftr(dest, destlen, src)
char *dest;
int *destlen;
char *src;
{
    int i, c;

    *destlen = 0;
    while (*src) {
	c = *src++;
	if (c == '\\' && *src) {
	    c = *src++;
	    switch(c) {
	    case 'f':	c = '\f';   break;
	    case 'r':	c = '\r';   break;
	    case 'n':	c = '\n';   break;
	    case 't':	c = '\t';   break;
	    case 'b':	c = '\b';   break;
	    default:
		if (*src >= '0' && *src <= '7') {
		    for (c = i = 0; i < 3 && *src >= '0' && *src <= '7'; ++i)
			c = (c * 8) + *src++ - '0';
		}
		break;
	    }
	}
	*dest++ = c;
	++*destlen;
    }
}


main(argc, argv)
unsigned int argc;
char *argv[];
{
    char *device;
    char *p;

    myname = argv[0];
    if (option_test(argc, argv, opts, 12, &parm, 1) != 1) usage();
    openDisplay(opts[0].data, opts[1].data);
    resolve_option(opts, 2, 5, "auto_ff", "yes");
    resolve_option(opts, 3, 6, "prompt", "yes");
    setup_size(4, opts);

    resolve_option(opts, 11, 10, "format", "binary");

    if (opts[2].found) {
	trailer_len = 1;
	trailer[0] = '\f';
    }
    else if (opts[9].found)
	build_hdr_ftr(trailer, &trailer_len, opts[9].data);
    else {
	p = XGetDefault(dpy, myname, "trailer");
	if (p)
	    build_hdr_ftr(trailer, &trailer_len, p);
    }

    if (opts[8].found)
	build_hdr_ftr(header, &header_len, opts[9].data);
    else {
	p = XGetDefault(dpy, myname, "header");
	if (p)
	    build_hdr_ftr(header, &header_len, p);
    }

    if (opts[7].found)
	device = opts[7].data;
    else {
	device = XGetDefault(dpy, myname, "device");
	if (!device)
	    device = "prn";
    }

    if (XeXtReadDOSDir(dpy, dosid, parm[0], 0) == -1) {
	fprintf(stderr, "%s: error performing directory request\n", myname);
	eXtinterrupt = 1;
	goto getout;
    }
    if (entries == 0) {
	fprintf(stderr, "%s: no matching files.\n", myname);
	eXtinterrupt = 1;
	goto getout;
    }
    dst_fid = XeXtOpenDOSFile(dpy, dosid, device, opts[11].found, 1);
    if (dst_fid == (XID)(-1L)) {
	fprintf(stderr, "%s: printer device not ready\n", myname);
	eXtinterrupt = 1;
	goto getout;
    }
    buflen = maxeXtDOSbuf;
    if (RbufLen < buflen) buflen = RbufLen;
    for (; head && !eXtinterrupt; head = head->next)
	do1(head->r.name);
    if (XeXtCloseDOSFile(dpy, dosid, dst_fid) == -1) {
	fprintf(stderr, "%s: error closing printer device\n", myname);
	eXtinterrupt = 1;
    }
getout:
    XCloseDisplay(dpy);
    return(eXtinterrupt);
}
