/*  Copyright (C) Hummingbird Communications Ltd. 1990-1993	       */

#include <stdio.h>
#include <string.h>
#include "extend.h"

extern XID dosid;
extern Display *dpy;
extern int eXtinterrupt;
extern int RbufLen;
extern int maxeXtDOSbuf;

static char buff[MAXBUF];
static int buflen;
char *myname;

int version = {0x103};

struct OptionDef opts[5] = {
    {"display", 1},
    {"pw", 1},
    {"size", 1},
    {"maxsize", 0},
    {"nomax", 0}};

char **parm;

usage()
{
    fprintf(stderr, "usage: %s [options]\n", myname);
    fprintf(stderr, "  -display display-name\n");
    fprintf(stderr, "  -pw  password\n");
    fprintf(stderr, "  -size size       transfer block size\n");
    fprintf(stderr, "  -maxsize         show the server's max transfer size\n");
    fprintf(stderr, "  -nomax           do not show the server's max transfer size (default)\n");
    exit(1);
}


static DumpLog()
{
    long position;
    int nbytes;

    for(position = 0; position != -1; ) {
       if(eXtinterrupt) break;
       nbytes = XeXtDOSLog(dpy, dosid, &position, buff, buflen);
       if (nbytes == -1) {
	   fprintf(stderr, "%s: cannot read log file\n", myname);
           break;
       }
       buff[nbytes] = 0;
       if (!eXtinterrupt) printf("%s", buff);
    }
    if (opts[3].found)
	printf("\nMaximum server read/write buffer size = %d\n", maxeXtDOSbuf);
}

main(argc, argv)
unsigned int argc;
char *argv[];
{
    buff[0] = 0;
    myname = argv[0];
    if (option_test(argc, argv, opts, 5, &parm, 0) != 0) usage();
    openDisplay(opts[0].data, opts[1].data);
    resolve_option(opts, 3, 4, "showmaxsize", "yes");
    setup_size(2, opts);
    buflen = maxeXtDOSbuf;
    if (RbufLen < buflen)
	buflen = RbufLen;
    DumpLog();
    XCloseDisplay(dpy);
    return(eXtinterrupt);
}
