/*  Copyright (C) Hummingbird Communications Ltd. 1990-1993	       */

#include <stdio.h>
#include <string.h>
#include "extend.h"

extern XID dosid;
extern Display *dpy;

char *myname;
static int err = 0;

int version = {0x101};

extern struct linkage *head;
extern int eXtinterrupt;
extern char DirNewPath[256];
extern int dontCheckForSubDir;

struct OptionDef opts[10] = {
    {"display", 1},
    {"pw", 1},
    {"r",  0},
    {"a",  0},
    {"s",  0},
    {"h",  0},
    {"R",  0},
    {"A",  0},
    {"S",  0},
    {"H",  0}
    };

char buff[256];

char **parm;

usage()
{
    fprintf(stderr, "usage: spec [+r|-r] [+a|-a] [+s|-s] [+h|-h] [-display host] [-pw password]\n", myname);
    fprintf(stderr, "\tR\tRead only\n");
    fprintf(stderr, "\tA\tArchive\n");
    fprintf(stderr, "\tS\tSystem\n");
    fprintf(stderr, "\tH\tHidden\n");
    exit(1);
}

main(argc, argv)
unsigned int argc;
char *argv[];
{
    int count, drive;
    char path[256];
    int onmask, offmask, spec, i, attr;

    myname = argv[0];
    count = option_test(argc, argv, opts, 10, &parm, 5);
    offmask = 0;
    if (opts[2].found || opts[6].found)
	offmask |= 1;
    if (opts[3].found || opts[7].found)
	offmask |= 0x20;
    if (opts[4].found || opts[8].found)
	offmask |= 4;
    if (opts[5].found || opts[9].found)
	offmask |= 2;
    onmask = 0;
    spec = -1;
    for (i = 0; i < count; ++i) {
	if (parm[i][0] == '+') {
	    if (strlen(parm[i]) != 2) usage();
	    switch(parm[i][1]) {
	    case 'r':
	    case 'R':
		onmask |= 1;
		break;
	    case 'a':
	    case 'A':
		onmask |= 0x20;
		break;
	    case 's':
	    case 'S':
		onmask |= 4;
		break;
	    case 'h':
	    case 'H':
		onmask |= 2;
		break;
	    default:
		usage();
	    }
	}
	else if (spec != -1)
	    usage();
	else
	    spec = i;
    }
    if (spec == -1) usage();
    if (offmask & onmask) {
	fprintf(stderr, "%s: conflicting attribute settings\n", myname);
	return(0);
    }
    if (!(offmask | onmask)) {
	fprintf(stderr, "%s: no attribute changes specified\n", myname);
	return(0);
    }
    openDisplay(opts[0].data, opts[1].data);
    dontCheckForSubDir = 1;
    if (XeXtReadDOSDir(dpy, dosid, parm[spec], -1) == -1) {
	fprintf(stderr, "%s: error performing directory request\n", myname);
	err = 1;
    }
    else if (head == NULL)
	printf("no matching files for '%s'\n", parm[spec]);
    else {
	for (; head && !eXtinterrupt; head = head->next) {
	    attr = head->r.attribute;
	    attr |= onmask;
	    attr &= ~offmask;
	    MKpath(DirNewPath, head->r.name, path, 0);
	    if (XeXtSetFileAttr(dpy, dosid, path, attr) == -1)
		fprintf(stderr, "%s: Access denied\n", path);
	}
	if (eXtinterrupt)
	    err = 1;
    }
    XCloseDisplay(dpy);
    return(err);
}
