/*  Copyright (C) Hummingbird Communications Ltd. 1990-1993	       */

#include <stdio.h>
#include <string.h>
#include <time.h>
#include "extend.h"

extern XID dosid;
extern Display *dpy;

char *myname;
static int err = 0;

int version = {0x101};

extern struct linkage *head;
extern int eXtinterrupt;
extern char DirNewPath[256];
extern int dontCheckForSubDir;

struct OptionDef opts[2] = {
    {"display", 1},
    {"pw", 1}
    };

char buff[256];

char **parm;

usage()
{
    fprintf(stderr, "usage: %s\n", myname);
    exit(1);
}


main(argc, argv)
unsigned int argc;
char *argv[];
{
    unsigned long vector;
    int i;
    int err = 0;

    myname = argv[0];
    option_test(argc, argv, opts, 2, &parm, 0);
    openDisplay(opts[0].data, opts[1].data);
    if (xGetBlockDeviceVector(dpy, dosid, &vector) == -1) {
	fprintf(stderr, "%s: error getting Block Device Vector\n", myname);
	err = 1;
    }
    else {
	if (!vector)
	    printf("\nNo drives reported\n\n");
	else {
	    printf("\nReported drives:");
	    for (i = 0; vector; ++i) {
		if (vector & 1)
		    printf(" %c", i + 'A');
		vector >>= 1;
	    }
	    printf("\n\n");
	}
    }
    XCloseDisplay(dpy);
    return(err);
}
