/*  Copyright (C) Hummingbird Communications Ltd. 1990-1993	       */

#include <stdio.h>
#include <string.h>
#include "extend.h"

extern XID dosid;
extern Display *dpy;
extern char DirNewPath[256];
extern int eXtinterrupt;
extern struct linkage *head;

int version = {0x103};

char *myname;

struct OptionDef opts[6] = {
    {"display", 1},
    {"pw", 1},
    {"all", 0},
    {"p", 0},
    {"np", 0},
    {"q", 0}};

char **parm;

static DeleteFile(filename)
char *filename;
{
    char buffer[80];
    int dodel;

    if (!opts[2].found) {
	dodel = 0;
	printf("%s: Delete %s? ", myname, filename);
	buffer[0] = 0;
	fgets(buffer, 80, stdin);
	if (buffer[0] == 'Y' || buffer[0] == 'y')
	    dodel = 1;
    }
    else {
	dodel = 1;
	if (opts[3].found)
	    printf("%s: deleting %s ...\n", myname, filename);
    }
    if (dodel)
	if (XeXtDelDOSFile(dpy, dosid, filename) == -1) {
	    fprintf(stderr, "%s: cannot delete file '%s'\n", myname, filename);
	    eXtinterrupt = 1;
	}
}

usage()
{
    fprintf(stderr, "usage: %s [options] spec\n", myname);
    fprintf(stderr, "  -display display-name\n");
    fprintf(stderr, "  -pw  password\n");
    fprintf(stderr, "  -p               displays the name of each file being copied\n");
    fprintf(stderr, "  -np              does not display the name of each file. (default).\n");
    fprintf(stderr, "  -q               confirm file deletions (default).\n");
    fprintf(stderr, "  -all             do not confirm file deletions.\n");
    exit(1);
}

main(argc, argv)
unsigned int argc;
char *argv[];
{
    char path[256];

    myname = argv[0];
    if (option_test(argc, argv, opts, 6, &parm, 1) != 1) usage();
    openDisplay(opts[0].data, opts[1].data);
    resolve_option(opts, 3, 4, "prompt", "yes");
    resolve_option(opts, 2, 5, "query", "no");
    if (XeXtReadDOSDir(dpy, dosid, parm[0], 0) != -1) {
	if (head == 0)
	    fprintf(stderr, "%s: no matching files.\n", myname);
	else for ( ; head && !eXtinterrupt; head = head->next) {
	    MKpath(DirNewPath, head->r.name, path, 0);
	    DeleteFile(path);
	}
    }
    else
	fprintf(stderr, "%s: error performing directory request\n", myname);
    XCloseDisplay(dpy);
    return(eXtinterrupt);
}
