/* static char	Sccsid[] = "@(#)instmast.sql	1.25	4/9/92"; */
use master
go
declare @size int
	select @size = (2048 - sum(size)) / 512
	from sysusages where dbid = 1
if (@size = 1)
begin
/* If a 3 MB master, alter by 2 to make it 5 */
	alter database master on master = 2
end
else if (@size = 2)
begin
/* If a 2MB master, alter by 3 to make it 5 */
	alter database master on master = 3
end
go
print "Warning: if Msg 2812 immediately follows, please disregard it."
go
if exists (select *
	from sysobjects
		where name = 'sp_configure'
			and sysstat & 7 = 4)
begin
	execute sp_configure 'update', 1
end
reconfigure with override
go
/*
** a_aversion 49.1 9/10/91
**
** Copyright Sybase, Inc. 1986, 1987, 1988, 1989
**	All Rights Reserved.
** Use, duplication, or disclosure by the United States Government
** is subject to restrictions as set forth in subdivision (c) (1) (ii)
** of the Rights in Technical Data and Computer Software clause
** at CFR 252.227-7013. Sybase, Inc. 6475 Christie Avenue, Emeryville,
** CA 94608.
**
** Stored procedures for Data Dictionary Operations
*/
go
dump transaction master with truncate_only
go
/* a_permitboth 49.1 9/10/91 */
grant select on sysalternates to public
grant select on syscolumns to public
grant select on syscomments to public
grant select on sysdepends to public
grant select on sysindexes to public
grant select on syskeys to public
grant select on sysobjects to public grant select on sysprocedures to public
grant select on sysprotects to public
grant select on syssegments to public
grant select on systypes to public
grant select on sysusers to public
grant select on syslogs to public
go
/* a_permitmaster 49.1 9/10/91 */
grant select on sysdatabases to public
grant select on sysdevices to public
grant select on syslocks to public
grant select on syslogins to public
revoke select on syslogins(password) to public
grant select on sysmessages to public
grant select on sysprocesses to public
grant select on sysusages to public
grant select on sysconfigures to public
grant select on syscurconfigs to public
grant select on sysservers to public
grant select on sysremotelogins to public
grant select on syslanguages to public
grant select on syscharsets to public
go
/* a_values 49.1 9/10/91 */
set nocount on
go
use master
go
if exists (select *
	from sysobjects
		where name = "spt_values")
begin
	drop table spt_values
end
go
if exists (select *
		from sysobjects
			where name = "spt_monitor")
begin
	drop table spt_monitor
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_validname')
begin
	drop procedure sp_validname
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_validlang')
begin
	drop procedure sp_validlang
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_validaltlang')
begin
	drop procedure sp_validaltlang
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_chklangparam')
begin
	drop procedure sp_chklangparam
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_namecrack')
begin
	drop procedure sp_namecrack
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_addalias')
begin
	drop procedure sp_addalias
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_addgroup')
begin
	drop procedure sp_addgroup
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_addlogin')
begin
	drop procedure sp_addlogin
end
go
dump transaction master with truncate_only
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_addtype')
begin
	drop procedure sp_addtype
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_addumpdevice')
begin
	drop procedure sp_addumpdevice
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_adduser')
begin
	drop procedure sp_adduser
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_addremotelogin')
begin
	drop procedure sp_addremotelogin
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_addsegment')
begin
	drop procedure sp_addsegment
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_addserver')
begin
	drop procedure sp_addserver
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_addlanguage')
begin
	drop procedure sp_addlanguage
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_defaultlanguage')
begin
	drop procedure sp_defaultlanguage
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_helplanguage')
begin
	drop procedure sp_helplanguage
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_droplanguage')
begin
	drop procedure sp_droplanguage
end
go
dump transaction master with truncate_only
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_setlangalias')
begin
	drop procedure sp_setlangalias
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_bindefault')
begin
	drop procedure sp_bindefault
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_bindrule')
begin
	drop procedure sp_bindrule
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_changedbowner')
begin
	drop procedure sp_changedbowner
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_changegroup')
begin
	drop procedure sp_changegroup
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_checknames')
begin
	drop procedure sp_checknames
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_start_xact')
begin
	drop procedure sp_start_xact
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_commit_xact')
begin
	drop procedure sp_commit_xact
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_abort_xact')
begin
	drop procedure sp_abort_xact
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_remove_xact')
begin
	drop procedure sp_remove_xact
end
go
dump transaction master with truncate_only
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_stat_xact')
begin
	drop procedure sp_stat_xact
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_probe_xact')
begin
	drop procedure sp_probe_xact
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_scan_xact')
begin
	drop procedure sp_scan_xact
end
go
/* commit 27.1 3/5/90 */
if exists (select *
		from sysobjects
			where name = "spt_committab"
				and sysstat & 7 = 3)
begin
	drop table spt_committab
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_commonkey')
begin
	drop procedure sp_commonkey
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_configure')
begin
	drop procedure sp_configure
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_dboption')
begin
	drop procedure sp_dboption
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_defaultdb')
begin
	drop procedure sp_defaultdb
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_depends')
begin
	drop procedure sp_depends
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_diskdefault')
begin
	drop procedure sp_diskdefault
end
go
dump transaction master with truncate_only
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_dropalias')
begin
	drop procedure sp_dropalias
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_dropdevice')
begin
	drop procedure sp_dropdevice
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_dropdumpdevice')
begin
	drop procedure sp_dropdumpdevice
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_dropgroup')
begin
	drop procedure sp_dropgroup
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_dropkey')
begin
	drop procedure sp_dropkey
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_droplogin')
begin
	drop procedure sp_droplogin
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_droptype')
begin
	drop procedure sp_droptype
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_dropuser')
begin
	drop procedure sp_dropuser
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_dropremotelogin')
begin
	drop procedure sp_dropremotelogin
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_dropsegment')
begin
	drop procedure sp_dropsegment
end
go
dump transaction master with truncate_only
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_dropserver')
begin
	drop procedure sp_dropserver
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_extendsegment')
begin
	drop procedure sp_extendsegment
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_fixindex')
begin
	drop procedure sp_fixindex
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_foreignkey')
begin
	drop procedure sp_foreignkey
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_helpdb')
begin
	drop procedure sp_helpdb
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_helpdevice')
begin
	drop procedure sp_helpdevice
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_helpgroup')
begin
	drop procedure sp_helpgroup
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_helplog')
begin
	drop procedure sp_helplog
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_helpindex')
begin
	drop procedure sp_helpindex
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_helpjoins')
begin
	drop procedure sp_helpjoins
end
go
dump transaction master with truncate_only
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_helpkey')
begin
	drop procedure sp_helpkey
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_objectsegment')
begin
	drop procedure sp_objectsegment
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_help')
begin
	drop procedure sp_help
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_helprotect')
begin
	drop procedure sp_helprotect
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_helptext')
begin
	drop procedure sp_helptext
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_helpuser')
begin
	drop procedure sp_helpuser
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_lock')
begin
	drop procedure sp_lock
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_logdevice')
begin
	drop procedure sp_logdevice
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_lookup')
begin
	drop procedure sp_lookup
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_helpremotelogin')
begin
	drop procedure sp_helpremotelogin
end
go
dump transaction master with truncate_only
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_helpsegment')
begin
	drop procedure sp_helpsegment
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_helpsort')
begin
	drop procedure sp_helpsort
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_helpserver')
begin
	drop procedure sp_helpserver
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_markreport')
begin
	drop procedure sp_markreport
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_monitor')
begin
	drop procedure sp_monitor
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_password')
begin
	drop procedure sp_password
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_placeobject')
begin
	drop procedure sp_placeobject
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_primarykey')
begin drop procedure sp_primarykey
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_recompile')
begin
	drop procedure sp_recompile
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_remoteoption')
begin
	drop procedure sp_remoteoption
end
go
dump transaction master with truncate_only
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_rename')
begin
	drop procedure sp_rename
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_renamedb')
begin
	drop procedure sp_renamedb
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_serveroption')
begin
	drop procedure sp_serveroption
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_spaceused')
begin
	drop procedure sp_spaceused
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_unbindefault')
begin
	drop procedure sp_unbindefault
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_unbindrule')
begin
	drop procedure sp_unbindrule
end
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_who')
begin
	drop procedure sp_who
end
go
dump transaction master with truncate_only
go

create table spt_values (
name	varchar(20) NULL,
number	int,
type	char(1),
low	int NULL,
high	int NULL)
go
create clustered index spt_valuesclust on spt_values(number, type)
go
insert spt_values(low, high, number, type) values (1, 1, 0, 'P')
go
set nocount on
/*
**insert spt_values(name, number, type)
**	values ("BIT POSITIONS", -1, 'P')
**go
*/
insert spt_values(low, high, number, type) values (1, 2, 1, 'P')
go
insert spt_values(low, high, number, type) values (1, 4, 2, 'P')
go
insert spt_values(low, high, number, type) values (1, 8, 3, 'P')
go
insert spt_values(low, high, number, type) values (1, 16, 4, 'P')
go
insert spt_values(low, high, number, type) values (1, 32, 5, 'P')
go
insert spt_values(low, high, number, type) values (1, 64, 6, 'P')
go
insert spt_values(low, high, number, type) values (1, 128, 7, 'P')
go
/* 8 - 15 */
insert spt_values(low, high, number, type)
select max(low) + 1 + (number / 8), high, number + 1 + max(number), 'P' 
from spt_values
where type = 'P' and number < 8 and number >= 0
go
/* 16 - 31 */
insert spt_values(low, high, number, type)
select max(low) + 1 + (number / 8), high, number + 1 + max(number), 'P' 
from spt_values
where type = 'P' and number < 16 and number >= 0
go
/* 32 - 63 */
insert spt_values(low, high, number, type)
select max(low) + 1 + (number / 8), high, number + 1 + max(number), 'P' 
from spt_values
where type = 'P' and number < 32 and number >= 0
go
/* 64 - 127 */
insert spt_values(low, high, number, type)
select max(low) + 1 + (number / 8), high, number + 1 + max(number), 'P' 
from spt_values
where type = 'P' and number < 64 and number >= 0
go
/* 128 - 255 */
insert spt_values(low, high, number, type)
select max(low) + 1 + (number / 8), high, number + 1 + max(number), 'P' 
from spt_values
where type = 'P' and number < 128 and number >= 0
go

/*
**  Configuration options.
*/
insert spt_values(name, number, type)
  values ("CONFIGURATION OPTIONS", -1, 'C')
go
insert spt_values(name, number, type, low, high)
  values ("recovery interval", 101, 'C', 1, 32767)
go
insert spt_values(name, number, type, low, high)
  values ("allow updates", 102, 'C', 0, 1)
go
insert spt_values(name, number, type, low, high)
  values ("user connections", 103, 'C', 5, @@max_connections)
go
insert spt_values(name, number, type, low, high)
  values ("memory", 104, 'C', 1000, 32000)
go
insert spt_values(name, number, type, low, high)
  values ("open databases", 105, 'C', 5, 100)
go
insert spt_values(name, number, type, low, high)
  values ("locks", 106, 'C', 5000, 500000)
go
insert spt_values(name, number, type, low, high)
  values ("open objects", 107, 'C', 100, 10000)
go
insert spt_values(name, number, type, low, high)
  values ("procedure cache", 108, 'C', 1, 99)
go
insert spt_values(name, number, type, low, high)
  values ("fill factor", 109, 'C', 0, 100)
go
insert spt_values(name, number, type, low, high)
  values ("time slice", 110, 'C', 50, 1000)
go
insert spt_values(name, number, type, low, high)
  values ("database size", 111, 'C', 2, 10000)
go
insert spt_values(name, number, type, low, high)
  values ("tape retention", 112, 'C', 0, 365)
go
insert spt_values(name, number, type, low, high)
  values ("recovery flags", 113, 'C', 0, 1)
go
insert spt_values(name, number, type, low, high)
  values ("serial number", 114, 'C', 1, 999999)
go
insert spt_values(name, number, type, low, high)
  values ("nested triggers", 115, 'C', 0, 1)
go
insert spt_values(name, number, type, low, high)
  values ("devices", 116, 'C', 4, 256)
go
insert spt_values(name, number, type, low, high)
  values ("remote access", 117, 'C', 0, 1)
go
insert spt_values(name, number, type, low, high)
  values ("remote logins", 118, 'C', 0, 4096)
go
insert spt_values(name, number, type, low, high)
  values ("remote sites", 119, 'C', 0, 256)
go
insert spt_values(name, number, type, low, high)
  values ("remote connections", 120, 'C', 0, 4096)
go
insert spt_values(name, number, type, low, high)
  values ("pre-read packets", 121, 'C', 0, 256)
go
insert spt_values(name, number, type, low, high)
  values ("upgrade version", 122, 'C', 0, 2147483647)
go
insert spt_values(name, number, type, low, high)
  values ("default sortorder id", 123, 'C', 0, 255)
go
insert spt_values(name, number, type, low, high)
  values ("default language", 124, 'C', 0, 9999)
go
insert spt_values(name, number, type, low, high)
  values ("language in cache", 125, 'C', 3, 100)
go

/* Token values */
insert spt_values(name, number, type)
  values ("TOKEN VALUES", -1, 'T')
go
insert spt_values(name, number, type)
  values ("Update", 197, 'T')
go
insert spt_values(name, number, type)
  values ("Delete", 196, 'T')
go
insert spt_values(name, number, type)
  values ("Select", 193, 'T')
go
insert spt_values(name, number, type)
  values ("Insert", 195, 'T')
go
insert spt_values(name, number, type)
  values ("Execute", 224, 'T')
go
insert spt_values(name, number, type)
  values ("Grant", 205, 'T')
go
insert spt_values(name, number, type)
  values ("Revoke", 206, 'T')
go
insert spt_values(name, number, type)
  values ("Create Database", 203, 'T')
go
insert spt_values(name, number, type)
  values ("Create Default", 233, 'T')
go
insert spt_values(name, number, type)
  values ("Create Procedure", 222, 'T')
go
insert spt_values(name, number, type)
  values ("Create Rule", 236, 'T')
go
insert spt_values(name, number, type)
  values ("Create Table", 198, 'T')
go
insert spt_values(name, number, type)
  values ("Create View", 207, 'T')
go
insert spt_values(name, number, type)
  values ("Dump Database", 228, 'T')
go
insert spt_values(name, number, type)
  values ("Dump Transaction", 235, 'T')
go

/* Values for syslocks.type */
insert spt_values(name, number, type)
  values ("LOCK TYPES", -1, 'L')
go
insert spt_values(name, number, type)
  values ("Ex_table", 1, 'L')
go
insert spt_values(name, number, type)
  values ("Sh_table", 2, 'L')
go
insert spt_values(name, number, type)
  values ("Ex_intent", 3, 'L')
go
insert spt_values(name, number, type)
  values ("Sh_intent", 4, 'L')
go
insert spt_values(name, number, type)
  values ("Ex_page", 5, 'L')
go
insert spt_values(name, number, type)
  values ("Sh_page", 6, 'L')
go
insert spt_values(name, number, type)
  values ("Update_page", 7, 'L')
go
insert spt_values(name, number, type)
  values ("Ex_extent", 8, 'L')
go
insert spt_values(name, number, type)
  values ("Sh_extent", 9, 'L')
go
insert spt_values(name, number, type)
  values ("Ex_table-blk", 256+1, 'L')
go
insert spt_values(name, number, type)
  values ("Sh_table-blk", 256+2, 'L')
go
insert spt_values(name, number, type)
  values ("Ex_intent-blk", 256+3, 'L')
go
insert spt_values(name, number, type)
  values ("Sh_intent-blk", 256+4, 'L')
go
insert spt_values(name, number, type)
  values ("Ex_page-blk", 256+5, 'L')
go
insert spt_values(name, number, type)
  values ("Sh_page-blk", 256+6, 'L')
go
insert spt_values(name, number, type)
  values ("Update_page-blk", 256+7, 'L')
go
insert spt_values(name, number, type)
  values ("Ex_extent-blk", 256+8, 'L')
go
insert spt_values(name, number, type)
  values ("Sh_extent-blk", 256+9, 'L')
go
insert spt_values(name, number, type)
  values ("Ex_table-demand", 512+1, 'L')
go
insert spt_values(name, number, type)
  values ("Sh_table-demand", 512+2, 'L')
go
insert spt_values(name, number, type)
  values ("Ex_intent-demand", 512+3, 'L')
go
insert spt_values(name, number, type)
  values ("Sh_intent-demand", 512+4, 'L')
go
insert spt_values(name, number, type)
  values ("Ex_page-demand", 512+5, 'L')
go
insert spt_values(name, number, type)
  values ("Sh_page-demand", 512+6, 'L')
go
insert spt_values(name, number, type)
  values ("Update_page-demand", 512+7, 'L')
go
insert spt_values(name, number, type)
  values ("Ex_extent-demand", 512+8, 'L')
go
insert spt_values(name, number, type)
  values ("Sh_extent-demand", 512+9, 'L')
go

/*
**  These values define the status bits in sysindexes.
*/
insert spt_values (name, number, type)
	values ("INDEX TYPES", -1, "I")
go
insert spt_values (name, number, type)
	values ("nonclustered", 0, "I")
go
insert spt_values (name, number, type)
	values ("ignore duplicate keys", 1, "I")
go
insert spt_values (name, number, type)
	values ("unique", 2, "I")
go
insert spt_values (name, number, type)
	values ("ignore duplicate rows", 4, "I")
go
insert spt_values (name, number, type)
	values ("clustered", 16, "I")
go
insert spt_values (name, number, type)
	values ("allow duplicate rows", 64, "I")
go

/*
**  These values define the object type.  The number made from the low
**  3 bits in sysobjects.sysstats indicate the type of object.
*/
insert spt_values (name, number, type)
	values ("OBJECT TYPES", -1, "O")
go
insert spt_values (name, number, type)
	values ("trigger", 0, "O")
go
insert spt_values (name, number, type)
	values ("system table", 1, "O")
go
insert spt_values (name, number, type)
	values ("view", 2, "O")
go
insert spt_values (name, number, type)
	values ("user table", 3, "O")
go
insert spt_values (name, number, type)
	values ("stored procedure",4, "O")
go
/* no number 5 */
insert spt_values (name, number, type)
	values ("default", 6, "O")
go
insert spt_values (name, number, type)
	values ("rule", 7, "O")
go

/*
**  These values translate the object type's userstat bits.  If the high
**  bit is set for a sproc, then it's a report.
*/
insert spt_values (name, number, type)
	values ("REPORT TYPES", -1, "R")
go
insert spt_values (name, number, type)
	values ("", 0, "R")
go
insert spt_values (name, number, type)
	values (" (rpt)", -32768, "R")
go

/*
**  Database status bits.
**  NB -- If you add a bit here make sure you add the value to the value
**	of the ALL SETTABLE option.
*/
insert spt_values (name, number, type)
	values ("DATABASE STATUS", -1, "D")
go
insert spt_values (name, number, type)
	values ("select into/bulkcopy", 4, "D")
go
insert spt_values (name, number, type)
	values ("no chkpt on recovery", 16, "D")
go
insert spt_values (name, number, type)
	values ("don't recover", 32, "D")
go
insert spt_values (name, number, type)
	values ("not recovered", 256, "D")
go
/*
**  NOT IMPLEMENTED BY DATASERVER
**insert spt_values (name, number, type)
**	values ("load only", 512, "D")
**go
*/
insert spt_values (name, number, type)
	values ("read only", 1024, "D")
go
insert spt_values (name, number, type)
	values ("dbo use only", 2048, "D")
go
insert spt_values (name, number, type)
	values ("single user", 4096, "D")
go
insert spt_values (name, number, type)
	values ("dbname has changed", 16384, "D")
go
insert spt_values (name, number, type)
	values ("trunc. log on chkpt.", 8, "D")
go
insert spt_values (name, number, type)
	values ("ALL SETTABLE OPTIONS", 7196, "D")
go

/*
**  Yes or no.
*/
insert spt_values (name, number, type)
	values ("YES OR NO", -1, "B")
go
insert spt_values (name, number, type)
	values ("no", 0, "B")
go
insert spt_values (name, number, type)
	values ("yes", 1, "B")
go

/*
**  Status bits in sysservers
*/
insert spt_values (name, number, type)
	values ("SYSSERVERS TYPES", -1, "A")
go
insert spt_values (name, number, type)
	values ("timeouts", 0, "A")
go
insert spt_values (name, number, type)
	values ("no timeouts", 1, "A")
go

/*
**  Status bits in sysremotelogins
*/
insert spt_values (name, number, type)
	values ("SYSREMOTELOGINS TYPES", -1, "F")
go
insert spt_values (name, number, type)
	values ("", 0, "F")
go
insert spt_values (name, number, type)
	values ("trusted", 1, "F")
go

/*
**  Translate syskeys.type to english.
*/
insert spt_values (name, number, type)
	values ("SYSKEYS TYPES", -1, "K")
go
insert spt_values (name, number, type)
	values ("primary", 1, "K")
go
insert spt_values (name, number, type)
	values ("foreign", 2, "K")
go
insert spt_values (name, number, type)
	values ("common", 3, "K")
go

/*
**  Translate sysdevices.status to english.
*/
insert spt_values (name, number, type)
	values ("SYSDEVICES STATUS", -1, "V")
go
insert spt_values (name, number, type)
	values ("default disk", 1, "V")
go
insert spt_values (name, number, type)
	values ("physical disk", 2, "V")
go
insert spt_values (name, number, type)
	values ("logical disk", 4, "V")
go
insert spt_values (name, number, type)
	values ("skip header", 8, "V")
go
insert spt_values (name, number, type)
	values ("dump device", 16, "V")
go
insert spt_values (name, number, type)
	values ("serial writes", 32, "V")
go
insert spt_values (name, number, type)
	values ("device mirrored", 64, "V")
go
insert spt_values (name, number, type)
	values ("reads mirrored", 128, "V")
go
insert spt_values (name, number, type)
	values ("half-mirror only", 256, "V")
go
insert spt_values (name, number, type)
	values ("mirror enabled", 512, "V")
go

/*
**  Translate @@options bit to english
*/
insert spt_values (name, number, type)
	values ("OPTIONS BITS", -1, "N")
go
insert spt_values (name, number, type)
	values ("showplan", 4, "N")
go
insert spt_values (name, number, type)
	values ("noexec", 8, "N")
go
insert spt_values (name, number, type)
	values ("arithignore", 16, "N")
go
insert spt_values (name, number, type)
	values ("arithabort", 32, "N")
go
insert spt_values (name, number, type)
	values ("background", 64, "N")
go
insert spt_values (name, number, type)
	values ("control", 1024, "N")
go
insert spt_values (name, number, type)
	values ("offsets", 2048, "N")
go
insert spt_values (name, number, type)
	values ("statistics io and time", 4096, "N")
go
insert spt_values (name, number, type)
	values ("parseonly", 8192, "N")
go
insert spt_values (name, number, type)
	values ("procid", 32768, "N")
go
insert spt_values (name, number, type)
	values ("rowcount", 131072, "N")
go
insert spt_values (name, number, type)
	values ("nocount", 524288, "N")
go

/*
**  Set the DataServer machine type
**  spt_values.low is the number of bytes in a DataServer page for the
**  particular DataServer machine.
*/
insert spt_values (name, number, type, low)
	values ("DATASERVER HOST TYPE", -1, "E", 0)
go

/*
**  List the physical types that are compatible.
*/
insert spt_values (name, number, type)
	values ("COMPATIBLE TYPES", -1, "J")
go
insert spt_values (name, number, low, type)
	values ("binary", 1, 45, "J")
go
insert spt_values (name, number, low, type)
	values ("varbinary", 1, 37, "J")
go
insert spt_values (name, number, low, type)
	values ("bit", 2, 50, "J")
go
insert spt_values (name, number, low, type)
	values ("char", 3, 47, "J")
go
insert spt_values (name, number, low, type)
	values ("varchar", 3, 39, "J")
go
insert spt_values (name, number, low, type)
	values ("datetime", 4, 61, "J")
go
insert spt_values (name, number, low, type)
	values ("datetimn", 4, 111, "J")
go
insert spt_values (name, number, low, type)
	values ("smalldatetime", 4, 58, "J")
go
insert spt_values (name, number, low, type)
	values ("float", 5, 62, "J")
go
insert spt_values (name, number, low, type)
	values ("floatn", 5, 109, "J")
go
insert spt_values (name, number, low, type)
	values ("real", 5, 59, "J")
go
insert spt_values (name, number, low, type)
	values ("int", 6, 56, "J")
go
insert spt_values (name, number, low, type)
	values ("intn", 6, 38, "J")
go
insert spt_values (name, number, low, type)
	values ("smallint", 6, 52, "J")
go
insert spt_values (name, number, low, type)
	values ("tinyint", 6, 48, "J")
go
insert spt_values (name, number, low, type)
	values ("money", 7, 60, "J")
go
insert spt_values (name, number, low, type)
	values ("moneyn", 7, 110, "J")
go
insert spt_values (name, number, low, type)
	values ("smallmoney", 7, 122, "J")
go

/*
**  Add some text for sysusages.segmap.
*/
insert into spt_values (name, type, number)
	values ('SYSUSAGES SEGMAP', 'S', -1)
insert into spt_values (name, type, number)
	values ('data only', 'S', 0)
insert into spt_values (name, type, number)
	values ('data only', 'S', 1)
insert into spt_values (name, type, number)
	values ('data only', 'S', 2)
insert into spt_values (name, type, number)
	values ('data only', 'S', 3)
insert into spt_values (name, type, number)
	values ('log only', 'S', 4)
insert into spt_values (name, type, number)
	values ('data only', 'S', 5)
insert into spt_values (name, type, number)
	values ('data only', 'S', 6)
insert into spt_values (name, type, number)
	values ('data and log', 'S', 7)
go

/*
** Features supported on some platforms and not others.  low != 0 means
** supported.  Initialize to 0 here.  Each of these may be reset by platform.
*/
insert into spt_values (name, type, number, low)
	values ('Channel Devices', 'G', 0, 0)
go

/*
**  Create and initialize the table used by the sp_monitor procedure.
*/
create table spt_monitor
(
	lastrun 	datetime,
	cpu_busy 	int,
	io_busy 	int,
	idle 		int,
	pack_received 	int,
	pack_sent 	int,
	connections 	int,
	pack_errors	int,
	total_read 	int,
	total_write 	int,
	total_errors 	int
)
go

grant select on spt_monitor to public
go

insert into spt_monitor
	select
	lastrun = getdate(),
	cpu_busy = @@cpu_busy,
	io_busy = @@io_busy,
	idle = @@idle,
	pack_received = @@pack_received,
	pack_sent = @@pack_sent,
	connections = @@connections,
	pack_errors = @@packet_errors,
	total_read = @@total_read,
	total_write = @@total_write,
	total_errors = @@total_errors
go

set nocount off
go
grant select on spt_values to public
go
dump transaction master with truncate_only
go
/* server_nw386		49.1	9/10/91 */
/*
**  This file contains the necessary modifications to be made for
**  various DataServer host machines.
**  It sets the DataServer host environment to be a sun 386i.
**  spt_values.low is the number of bytes in a DataServer page.
*/
use master
go

delete spt_values
	where type = "E" and number > 0
go
/* data page size for Novell 386 */
insert into spt_values (name, number, type, low)
	values ("Novell ", 1, "E", 2048)

/* Value to set and clear the high bit for int datatypes for novel 386.
** would like to enter -2,147,483,648 to avoid byte order issues, but 
** the server won't take it, even in exponential notation.
*/
insert into spt_values (name, number, type, low)
	values ("int high bit", 2, "E", 0x80000000)

/* Value which gives the byte position of the high byte for int datatypes for 
** novell 386.  This value was changed from 4 (the usual Intel 80x86 order) to 1
** when binary convert routines were changed to reverse the byte order.  So 
** this value is accurate ONLY when ints are converted to binary datatype.
*/
insert into spt_values (name, number, type, low)
	values ("int4 high byte", 3, "E", 1)
go

/*
**  Set the standard device entries to be NetWare compatible
*/
update sysdevices
	set  phyname = "nul"
	where   name = "diskdump"

delete from sysdevices
	where   name like "tape%"

insert into sysdevices (low, high, status, cntrltype, name, phyname)
	values (0, 32, 16, 3, "floppydump", "A:DUMPDATA.DAT")

insert into sysdevices (low, high, status, cntrltype, name, phyname)
	values (0, 32, 16, 3, "floppydumpb", "B:DUMPDATA.DAT")

insert into sysdevices (low, high, status, cntrltype, name, phyname)
	values (0, 0, 16, 2, "sysdump", "SYS:\DUMPDATA.DAT")

insert into sysdevices (low, high, status, cntrltype, name, phyname)
	values (0, 1280, 24, 4, "tapedump", "WANGTEK")

insert into sysdevices (low, high, status, cntrltype, name, phyname)
	values (0, 1280, 24, 5, "scsitape", "DIBIDAI")
go

/* command to fix up freeoff on page 24 in all databases */
dbcc dbrepair (master, fixsysindex)

go


/*
** Update sysconfigures number of disks to be a few more than are actually
** in use.  This prevents useing too much memory for disk service process
** stacks.  This is especially important for the upgrade from 4.0 to 4.0.1
** where 4.0 had a default of 50 disks configured.  The new default is 10.
*/
declare @ndisks int

/* Count the number of disks in use */
select @ndisks = count(*) from sysdevices
	where (status & 2) = 2

/* Add a few, but make sure there are at least 10 */
select @ndisks = 4 + @ndisks
if @ndisks < 10
	select @ndisks = 10

/* Update configured number of disks if it is too high */

if (select value from sysconfigures where config = 116) > @ndisks
begin
	update sysconfigures
		set value = @ndisks
		where config = 116
	print "Configured number of disks was much larger than the number of"
	print "disks actually in use.  Configured valued adjusted downward."
end
go

/* Force recalculation of disks, processes, msgs etc */
reconfigure with override
go

dump transaction master to diskdump with truncate_only
go
dump transaction master with truncate_only
go
/* validname	49.1	9/10/91 */
create procedure sp_validname
@name	varchar(30)
as

/*
**  Check to see that the new name is a legal identifier.
*/

declare @current	int
declare @last		int
declare @curchar	tinyint
declare @underscore	tinyint
declare @poundsign	tinyint
declare @dollarsign	tinyint
declare @big_A		tinyint
declare @small_a	tinyint
declare @big_Z		tinyint
declare @small_z	tinyint
declare @digit_0	tinyint
declare @digit_9	tinyint

declare @csid			tinyint
declare @alpha_2_start		tinyint
declare @alpha_2_end		tinyint
declare @alpha_3_start		tinyint
declare @alpha_3_end		tinyint
declare @alpha_4_start		tinyint
declare @alpha_4_end		tinyint
declare @alpha_5_start		tinyint
declare @alpha_5_end		tinyint
declare @alpha_6_start		tinyint
declare @alpha_6_end		tinyint
declare @alpha_7_start		tinyint
declare @alpha_7_end		tinyint
declare @alpha_s_1		tinyint
declare @alpha_s_2		tinyint
declare @alpha_s_3		tinyint

/*
**  Ensure that the name specified is non-null.
*/
if (@name is null)
begin
	return (1)
end


/*
**  Set up the codepoints that we will need.
*/
select @underscore = 0x5F,
        @poundsign = 0x23,
       @dollarsign = 0x24,
            @big_A = 0x41,
          @small_a = 0x61,
            @big_Z = 0x5A,
          @small_z = 0x7A,
          @digit_0 = 0x30,
          @digit_9 = 0x39

/* Get the Character Set id (csid) */
select @csid = csid from master..syscharsets
	where id = (select value from master..sysconfigures
		where config = 123)

	if @csid = 1
	    /* Set up the alphabetic codepoint ranges for iso_1. */
	    select @alpha_2_start = 0xC0, @alpha_2_end = 0xD6,
		   @alpha_3_start = 0xD8, @alpha_3_end = 0xF6,
	           @alpha_4_start = 0xF8, @alpha_4_end = 0xFF,
	           @alpha_5_start = 0x41, @alpha_5_end = 0x5A,
	           @alpha_6_start = 0x61, @alpha_6_end = 0x7A,
	           @alpha_7_start = 0x61, @alpha_7_end = 0x7A,
		   @alpha_s_1 = 0x41, @alpha_s_2 = 0x41, @alpha_s_3 = 0x41

	if @csid = 2
	    /* Set up the alphabetic codepoint ranges for cp850. */
	    select @alpha_2_start = 0x80, @alpha_2_end = 0x9D,
		   @alpha_3_start = 0xA0, @alpha_3_end = 0xA5,
	           @alpha_4_start = 0xB5, @alpha_4_end = 0xB7,
	           @alpha_5_start = 0xC6, @alpha_5_end = 0xC7,
	           @alpha_6_start = 0xD0, @alpha_6_end = 0xD8,
	           @alpha_7_start = 0xE0, @alpha_7_end = 0xED,
		   @alpha_s_1 = 0xDE, @alpha_s_2 = 0xF4, @alpha_s_3 = 0xF5

	if @csid = 3
	    /* Set up the alphabetic codepoint ranges for cp437. */
	    select @alpha_2_start = 0x80, @alpha_2_end = 0x9A,
		   @alpha_3_start = 0xA0, @alpha_3_end = 0xA5,
	           @alpha_4_start = 0xE0, @alpha_4_end = 0xEE,
	           @alpha_5_start = 0x41, @alpha_5_end = 0x5A,
	           @alpha_6_start = 0x61, @alpha_6_end = 0x7A,
	           @alpha_7_start = 0x61, @alpha_7_end = 0x7A,
		   @alpha_s_1 = 0x9E, @alpha_s_2 = 0x41, @alpha_s_3 = 0x41

/*
**  Check the 1st character.
**  It can be an ASCII letter, #, _, or any character from 0x80-0xFF.
*/
select @curchar = convert(binary(1), substring(@name, 1, 1))

if (not (   (@curchar >= @big_A    and  @curchar <= @big_Z)
	 or (@curchar >= @small_a  and  @curchar <= @small_z)
	 or (@curchar between @alpha_2_start and @alpha_2_end)
	 or (@curchar between @alpha_3_start and @alpha_3_end)
	 or (@curchar between @alpha_4_start and @alpha_4_end)
	 or (@curchar between @alpha_5_start and @alpha_5_end)
	 or (@curchar between @alpha_6_start and @alpha_6_end)
	 or (@curchar between @alpha_7_start and @alpha_7_end)
	 or @curchar = @alpha_s_1
	 or @curchar = @alpha_s_2
	 or @curchar = @alpha_s_3
	 or @curchar = @poundsign
	 or @curchar = @underscore
	)
   )
begin
	return (1)
end

/*
**  Figure out how long the string is.
**  N.B. - replace this once we have strlen()
*/
if (charindex("!", @name) != 0)
begin
	return (1)
end
select @current = 2,
       @last = charindex("!", @name + "!") - 1

/*
**  Now check the rest of the characters.
**  They can be ASCII letters, #, _, $, or any character from 0x80-0xFF.
*/
while @current <= @last
begin
	select @curchar = convert(binary(1), substring(@name, @current, 1))
	if (not (   (@curchar >= @big_A    and  @curchar <= @big_Z)
		 or (@curchar >= @small_a  and  @curchar <= @small_z)
		 or (@curchar >= @digit_0  and  @curchar <= @digit_9)
	 	 or (@curchar between @alpha_2_start and @alpha_2_end)
	 	 or (@curchar between @alpha_3_start and @alpha_3_end)
	 	 or (@curchar between @alpha_4_start and @alpha_4_end)
	 	 or (@curchar between @alpha_5_start and @alpha_5_end)
	 	 or (@curchar between @alpha_6_start and @alpha_6_end)
	 	 or (@curchar between @alpha_7_start and @alpha_7_end)
	 	 or @curchar = @alpha_s_1
	 	 or @curchar = @alpha_s_2
	 	 or @curchar = @alpha_s_3
		 or @curchar = @poundsign
		 or @curchar = @dollarsign
		 or @curchar = @underscore
		)
	   )
	begin
		return (1)
	end

	select @current = @current + 1
end

return (0)
go
grant execute on sp_validname to public
go
/* validlang 49.1 9/10/91 */
create procedure sp_validlang
@name	varchar(30)
as

/* Check to see if this language is in Syslanguages. */
if exists (select *
		from master.dbo.syslanguages
		where name = @name)
begin
	return 0
end
return 1
go
grant execute on sp_validlang to public
go
dump transaction master with truncate_only
go
/* validaltlang 49.1 9/10/91 */
create procedure sp_validaltlang
@name	varchar(30)
as

/* Check to see if this alias is in Syslanguages. */
if exists (select *
		from master.dbo.syslanguages
		where alias = @name)
begin
	return 0
end
return 1
go
grant execute on sp_validaltlang to public
go
/* chklangparam 49.1 9/10/91 */
/*
** sp_checklangparam is called by sp_addlanguage to check the lists of
** full month names, short month names, and day names.  It returns a status
** indicating whether any errors were found:
**	0 - name list is valid
**	1 - spaces were found, which are not allowed
**	2 - not enough names in the list (must be exactly @numnames of them)
**	3 - too many names in the list (must be exactly @numnames of them)
**	4 - some name(s) are too long
**	5 - some name(s) have non-aphabetic characters
*/
create procedure sp_chklangparam
@namelist varchar(251),		/* month or day name list */
@msgparam varchar(30),		/* name of list, for error messages */
@numnames int,			/* correct number of names in the list */
@maxnamelen int			/* maximum length of any name in list */
as

	declare @totallen		int
	declare @mthlen			int
	declare @mthname		varchar(251)
	declare @msg			varchar(255)
	declare @csid			tinyint
	declare @csname			varchar(30)
	declare @alpha_0_start		tinyint
	declare @alpha_0_end		tinyint
	declare @alpha_1_start		tinyint
	declare @alpha_1_end		tinyint
	declare @alpha_2_start		tinyint
	declare @alpha_2_end		tinyint
	declare @alpha_3_start		tinyint
	declare @alpha_3_end		tinyint
	declare @alpha_4_start		tinyint
	declare @alpha_4_end		tinyint
	declare @alpha_5_start		tinyint
	declare @alpha_5_end		tinyint
	declare @alpha_6_start		tinyint
	declare @alpha_6_end		tinyint
	declare @alpha_7_start		tinyint
	declare @alpha_7_end		tinyint
	declare @alpha_s_1		tinyint
	declare @alpha_s_2		tinyint
	declare @alpha_s_3		tinyint
	declare @alpha_s_4		tinyint
	declare @curchar		tinyint
	declare @next			int

	/* Get the Character Set id (csid) */
	select @csid = csid from master..syscharsets
		where id = (select value from master..sysconfigures
			where config = 123)

	/* Get the Character Set Name (csname) */
	select @csname = name from master..syscharsets
		where id = @csid and type < 2000

	/* Make sure the list has no blanks. */
	if ( charindex( " ", @namelist ) != 0 )
	begin
		select @msg = "List of " + @msgparam
			+ " names contains spaces, which are not allowed."
		print @msg
		return 1
	end

	if @csid = 1
	    /* Set up the alphabetic codepoint ranges for iso_1. */
	    select @alpha_0_start = 0x41, @alpha_0_end = 0x5A,
		   @alpha_1_start = 0x61, @alpha_1_end = 0x7A,
		   @alpha_2_start = 0xC0, @alpha_2_end = 0xD6,
		   @alpha_3_start = 0xD8, @alpha_3_end = 0xF6,
	           @alpha_4_start = 0xF8, @alpha_4_end = 0xFF,
	           @alpha_5_start = 0x41, @alpha_5_end = 0x5A,
	           @alpha_6_start = 0x61, @alpha_6_end = 0x7A,
	           @alpha_7_start = 0x61, @alpha_7_end = 0x7A,
		   @alpha_s_1 = 0x41, @alpha_s_2 = 0x41, @alpha_s_3 = 0x41,
		   @alpha_s_4 = 0x2D

	if @csid = 2
	    /* Set up the alphabetic codepoint ranges for cp850. */
	    select @alpha_0_start = 0x41, @alpha_0_end = 0x5A,
		   @alpha_1_start = 0x61, @alpha_1_end = 0x7A,
		   @alpha_2_start = 0x80, @alpha_2_end = 0x9D,
		   @alpha_3_start = 0xA0, @alpha_3_end = 0xA5,
	           @alpha_4_start = 0xB5, @alpha_4_end = 0xB7,
	           @alpha_5_start = 0xC6, @alpha_5_end = 0xC7,
	           @alpha_6_start = 0xD0, @alpha_6_end = 0xD8,
	           @alpha_7_start = 0xE0, @alpha_7_end = 0xED,
		   @alpha_s_1 = 0xDE, @alpha_s_2 = 0xF4, @alpha_s_3 = 0xF5,
		   @alpha_s_4 = 0x2D

	if @csid = 3
	    /* Set up the alphabetic codepoint ranges for cp437. */
	    select @alpha_0_start = 0x41, @alpha_0_end = 0x5A,
		   @alpha_1_start = 0x61, @alpha_1_end = 0x7A,
		   @alpha_2_start = 0x80, @alpha_2_end = 0x9A,
		   @alpha_3_start = 0xA0, @alpha_3_end = 0xA5,
	           @alpha_4_start = 0xE0, @alpha_4_end = 0xEE,
	           @alpha_5_start = 0x41, @alpha_5_end = 0x5A,
	           @alpha_6_start = 0x61, @alpha_6_end = 0x7A,
	           @alpha_7_start = 0x61, @alpha_7_end = 0x7A,
		   @alpha_s_1 = 0x9E, @alpha_s_2 = 0x41, @alpha_s_3 = 0x41,
		   @alpha_s_4 = 0x2D

	select @totallen = datalength( @namelist )
	while ( @totallen > 0 )
	begin
		/* Move to the next name in the list. */
		select @namelist = right( @namelist, @totallen )

		/* If this is not the last name in the list then there must
		** be another comma.
		*/
		if ( @numnames > 1 )
		begin
			select @mthlen = charindex( ",", @namelist ) - 1
			if ( @mthlen < 0 )
			begin
				select @msg = "List of " + @msgparam
					+ " names has too few names."
				print @msg
				return 2
			end
		end

		/* This is the last name in the list, so there cannot be
		** another comma.  This name is all remaining characters
		** in the list.
		*/
		else
		begin
			if ( charindex( ",", @namelist ) != 0 )
			begin
				select @msg = "List of " + @msgparam
					+ " names has too many names."
				print @msg
				return 3
			end
			select @mthlen = @totallen
		end

		/* Check the name length. */
		if ( @mthlen > @maxnamelen )
		begin
			select @msg = "List of " + @msgparam
				+ " names has name(s) which are too long."
			print @msg
			return 4
		end

		/*
		** Check to see that the names contain only true
		** ALPHA-betic characters; not even DIGITs are allowed.
		*/
		select @next = 1
		while ( @next <= @mthlen )
		begin
		    select @curchar = convert(binary(1),
						substring(@namelist, @next, 1))
		    if (not
		    (   
		       (@curchar between @alpha_0_start and @alpha_0_end)
		    or (@curchar between @alpha_1_start and @alpha_1_end)
		    or (@curchar between @alpha_2_start and @alpha_2_end)
		    or (@curchar between @alpha_3_start and @alpha_3_end)
		    or (@curchar between @alpha_4_start and @alpha_4_end)
                    or (@curchar between @alpha_5_start and @alpha_5_end)
		    or (@curchar between @alpha_6_start and @alpha_6_end)
		    or (@curchar between @alpha_7_start and @alpha_7_end)
		    or @curchar = @alpha_s_1
		    or @curchar = @alpha_s_2
		    or @curchar = @alpha_s_3
		    or @curchar = @alpha_s_4
		    )
		    )
		    begin
			select @msg = 'List of ' + @msgparam
				+ ' names contains name(s) which have "'
				+ @csname + '" non-alphabetic characters.'
			print @msg
			return 5
		    end

		    select @next = @next + 1
		end

		/* Move to the next name in the list. */
		select @numnames = @numnames - 1
		select @totallen = @totallen - @mthlen - 1
	end

	/* No problems were found with the name list. */
	return 0
go
dump transaction master with truncate_only
go
/* namecrack 49.1 9/10/91 */
create procedure sp_namecrack
@name	varchar(123),
@site	varchar(30) = null output,
@db	varchar(30) = null output,
@owner	varchar(30) = null output,
@object	varchar(30) = null output
as

select @site = null, @db = null, @owner = null, @object = null

/*
**  Is there a site name?
*/
if @name like "%.%.%.%"
begin
	select @site = substring(@name, 1, charindex(".", @name) - 1)
	select @name = substring(@name, charindex(".", @name) + 1, 125)
end

/*
**  Is there a database name?
*/
if @name like "%.%.%"
begin
	select @db = substring(@name, 1, charindex(".", @name) - 1)
	select @name = substring(@name, charindex(".", @name) + 1, 125)
end

/*
**  Is there a owner?
*/
if @name like "%.%"
begin
	select @owner = substring(@name, 1, charindex(".", @name) - 1)
	select @name = substring(@name, charindex(".", @name) + 1, 125)
end

select @object = @name

return (0)
go
grant execute on sp_namecrack to public
go
/* addalias 49.1 9/10/91 */
create procedure sp_addalias
@loginame varchar(30),		/* the name of the pretender */
@name_in_db varchar(30)		/* who the pretender wants to pretend to be */
as

declare @suid int		/* the suid of the pretender */
declare @asuid int		/* the suid of the person to impersonate */
declare	@msg	varchar(250)

/*
**  You must be SA or the dbo to execute this sproc.
*/
if suser_id() != 1 and user_id() != 1
begin
	print "You must be the System Administrator (SA) or the Database Owner (dbo) to execute this procedure."
	return (1)
end

/*
**  Make sure that the pretender has an account.
*/
select @suid = suid
	from master.dbo.syslogins
where name = @loginame

if @suid is NULL
begin
	print "No login exists with the specified login name."
	return (1)
end

/*
**  Get the suid of the person we want to pretend to be.
**  All user ids are <= 16383 and group ids are > 16383.
*/
select @asuid = suid
	from sysusers
where name = @name_in_db
	and uid <= 16383

/*
**  Does the user to be impersonated exist in the current database?
*/
if @asuid is NULL
begin
	print "No user with the specified name exists in the current database."
	return (1)
end

/*
**  Does the login to do the impersonating already a user in the current db?
*/
if exists (select *
		from sysusers
			where suid = @suid)
begin
	select @msg = "'" + name
		from sysusers
			where suid = @suid
	select @msg = @msg + "' is already a user in the current database."
	print @msg
	return (1)
end

/*
**  Is the person already aliased to a user?
*/
if exists (select *
		from sysalternates
	where suid = @suid)
begin
	print "The specified user name is already aliased."
	return (1)
end

/*
**  Add the alias.
*/
insert into sysalternates (suid, altsuid)
	values (@suid, @asuid)

print "Alias user added."

return (0)
go
grant execute on sp_addalias to public
go
dump transaction master with truncate_only
go
/* addgroup 49.1 9/10/91 */
create procedure sp_addgroup
@grpname varchar(30)			/* new group name */
as

declare @gid int			/* group id */
declare @msg varchar(250)

/*
**  You must be SA or the dbo to execute this sproc.
*/
if suser_id() != 1 and user_id() != 1
begin
	print "You must be the System Administrator (SA) or the Database Owner (dbo) to execute this procedure."
	return (1)
end

/*
**  Check to see that the @grpname is valid.
*/
declare @returncode	int
execute @returncode = sp_validname @grpname
if @returncode != 0
begin
	select @msg = "'" + @grpname + "' is not a valid name."
	print @msg
	return @returncode
end

/*
**  See if the new group name is already being used as a user or group name.
*/
select @gid = uid
	from sysusers
where name = @grpname

/*
**  User ids are >0 and  <= 16383 and group ids are > 16383.
*/
if @gid is not null
begin
	if @gid > 0 and @gid <= 16383
		print "A user with the specified group name already exists."
	else
		print "A group with the specified name already exists."
	return (1)
end

/*
**  Now get the group id for the new group.  It is the current maximum group
**  number + 1.  If this is the first group use the lowest possible group id
**  -- 16384.
*/
select @gid = max(uid)+1
	from sysusers

/*
**  This is the first group.
*/
if @gid < 16384 or @gid = NULL
	select @gid = 16384

/*
**  Create the group.
*/
insert into sysusers (uid, suid, gid, name, environ)
values (@gid, -@gid, @gid, @grpname, "")

print "New group added."

return (0)
go
grant execute on sp_addgroup to public
go
/* addlogin 49.1 9/10/91 */
create procedure sp_addlogin
@loginame varchar(30),			/* login name of the new user */
@passwd varchar(30) = NULL,		/* password of the new user */
@defdb varchar(30) = "master",		/* default db for the new user */
@deflanguage varchar(30) = NULL		/* default language for the new user */
as

declare @msg varchar(250)

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	print "Can't run sp_addlogin from within a transaction."
	return (1)
end

/*
**  Only the system administrator (sa) can run this command.
**  Check to make sure the executor is the sa.
*/
if suser_id() != 1
begin
	print "Only the System Administrator (SA) may execute this procedure."
	return (1)
end

/*
**  Check to see that the @loginame is valid.
*/
declare @returncode	int
execute @returncode = sp_validname @loginame
if @returncode != 0
begin
	select @msg = "'" + @loginame + "' is not a valid name."
	print @msg
	return @returncode
end

/* 
**  Check to see that the @deflanguage is valid.
*/
if @deflanguage is not null
begin
	select @returncode = 0
	execute @returncode = sp_validlang @deflanguage
	if @returncode != 0
	begin
		/* Us_english is always valid */
		if @deflanguage != "us_english"
		begin
			select @msg = "'" + @deflanguage + "' is not a valid official language name."
			print @msg
			return @returncode
		end
	end
end

/*
**  Make sure the login doesn't already exist.
*/
if exists (select *
		  from syslogins
          where name = @loginame)
begin
	print "A user with the specified login name already exists."
	return (1)
end

/*
**  Check that the database name is valid.
*/
if not exists (select *
			from sysdatabases
		where name = @defdb)
begin
	print "Database name not valid -- login not added."
	return (1)
end

/*
**  Create the login.
*/
insert into syslogins(suid, status, accdate, totcpu, totio,
	spacelimit, timelimit, resultlimit, dbname, name, password, language)
select max(suid)+1, 0, getdate(), 0, 0,
	0, 0, 0, @defdb, @loginame, @passwd, @deflanguage
from syslogins

print "New login created."

return (0)
go
dump transaction master with truncate_only
go
/* addtype 49.1 9/10/91 */
create procedure sp_addtype
@typename varchar(30),		/* name of user-defined type */
@phystype varchar(30),		/* physical system type of user-defined type */
@nulltype varchar(8) = "1"	/* default is NO NULLs */
as

declare @len int		/* length of user type */
declare @type tinyint		/* typeid of physical type */
declare @tlen tinyint		/* length of physical type */
declare @typeid smallint	/* user typeid of physical type */
declare @var bit		/* is physical type variable length? */
declare @nonull bit		/* default is to allow NO NULLs */
declare @nullegal bit		/* does physical type allow NULLs? */
declare @msg varchar(250)


/*
**  Does the user type allow NULLs?  The default is to NOT allow NULLs.
**  this is the same default the create table statement uses.
*/
if @nulltype = "null" or @nulltype = "NULL" or @nulltype = null
	select @nonull = 0
else if @nulltype = "not null" or @nulltype = "NOT NULL" or @nulltype = "nonull"
	or @nulltype = "NONULL" or @nulltype = "1"
	select @nonull = 1
else
begin
	print "Usage: sp_addtype name, 'datatype' [,null | nonull]"
	return (1)
end

/*
**  Check to see that the @typename is valid.
*/
declare @returncode	int
execute @returncode = sp_validname @typename
if @returncode != 0
begin
	select @msg = "'" + @typename + "' is not a valid type name."
	print @msg
	return @returncode
end

/*
**  Check to see if the type already exists.
*/
if exists (select *
		from systypes
   	where name = @typename)
begin
	print "A type with the specified name already exists."
	return (1)
end

/*
**  If a length was given with the user datatype, extract it.
*/
if @phystype like "_%(%)"
begin
	select @len = convert(int, substring(@phystype,
		charindex("(",@phystype) + 1,
		charindex(")",@phystype) - 1 - charindex("(",@phystype)))

	/*
	** Extract the physical type name
	*/
	select @phystype = substring(@phystype, 1,
		   charindex("(", @phystype) - 1)
end

/*
**  Make sure that the physical type exists and get its characteristics.
**  DataServer physical types have a usertype < 100 and are owned by the
**  dbo (userid = 1).
*/
select @type = type, @tlen = length, @typeid = usertype,
	@var = variable, @nullegal = allownulls
from systypes
	where usertype < 100 and name = @phystype and uid = 1

if @type = NULL
begin
	print "Physical datatype does not exist."
	return (1)
end

/*
**  Disallow user-defined datatypes on timestamps.  This is done because
**  a timestamp is not a basic type but is really a binary.  There is,
**  therefore, no way to tell if a user-defined datatype is mapped to
**  a binary or a timestamp.  Timestamps can't have rules or defaults.
*/
if @phystype = "timestamp"
begin
	print "User-defined datatypes based on the 'timestamp' datatype are not allowed."
	return (1)
end

/*
**  Check if the NULL status of the user type is consistent with the NULL status
**  of the physical type.  Here are the possible cases.
**
**		   physical type
**		  NULLs	  NONULLs
**	        -----------------
** user	NULLs	|  ok	|  no
** type NONULLs	|  ok	|  ok
*/
if @nonull = 0 and @nullegal = 0
begin
	print "Physical datatype does not allow nulls."
	return (1)
end

/*
**  We'll use the variable @nullegal when we update the systypes table
**  so we need to set it to reflect if NULLs are allowed (@nonull = 0)
**  or NO NULLs are allowed (@nonull = 1).
*/
if @nonull = 0
begin
	select @nullegal = 1
end
else
begin
	select @nullegal = 0
end

/*
**  Typeids 1 (char), 2 (varchar), 3 (binary) and 4 (varbinary) are the
**  only ones which allow a length to be specified.
*/
if @typeid > 4
begin
	/*
	**  We can't use a length and we got one.
	*/
	if @len > 0
	begin
	   print "Physical type is fixed length. You cannot specify the length."
	   return (1)
	end

	/*
	**  Use the fixed length of the physical type.
	*/
	select @len = @tlen
end
else
begin
	/*
	**  We need a length and we didn't get one.
	*/
	if @len = NULL
	begin
		print "You must specify a length with this physical type."
		return (1)
	end

	if @len <= 0 or @len > 255
	begin
		print "Illegal length specified -- must be between 1 and 255."
		return (1)
	end

end


/*
**  Finally, get the maximum existing user type so we use it + 1 for this
**  new type.
*/
select @typeid = max(usertype)
	from systypes

/*
**  There are no user defined types yet so use the first number (101).
*/
if @typeid < 100
	select @typeid = 100

insert systypes (uid, variable, type, length, tdefault,
	domain, name, usertype, allownulls)
select user_id(), @var, @type, @len, 0, 0, @typename, @typeid + 1, @nullegal

print "Type added."

return (0)
go
grant execute on sp_addtype to public
go
/* addumpdevice 49.1 9/10/91 */
create procedure sp_addumpdevice
@devtype	varchar(10),		/* disk, tape, or special */
@logicalname	varchar(30),		/* logical name of the device */
@physicalname	varchar(127),		/* physical name of the device */
@cntrltype	smallint,		/* controller number */
@devstatus	varchar(40) = "noskip",	/* device characteristics */
@tapesize	int = null		/* capacity of tape in MB */
as

declare @status smallint		/* status bits for device */
declare @msg varchar(250)
declare @tapeblocksize int
declare @channels_supported     int     /* 1 means channels supported, 0 not */

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	print "Can't run sp_addumpdevice from within a transaction."
	return (1)
end

/*
**  You must be SA to execute this sproc.
*/
if suser_id() != 1 
begin
	print "You must be the System Administrator (SA) to execute this procedure."
	return (1)
end

/*
**  Check to see that the @logicalname is valid.
*/
declare @returncode	int
execute @returncode = sp_validname @logicalname
if @returncode != 0
begin
	select @msg = "'" + @logicalname + "' is not a valid name."
	print @msg
	return @returncode
end

/*
**  The rules for updating sysdevices are as follows:
**    devtype - may be disk, tape, or channel.  If disk then
**                    cntrltype will be 2,
**		if tape then 3-8 depending on
**                    whether there have already been tapes added.
**            if channel then 9-14 depending on
**                    whether there have already been channel devices added
**		NOTE:  These are completely host dependent.  They probably
**		need to be changed for each DataServer host type.
*******************
**  NETWARE386:
**		For disk devices:
**			devtype should be 'disk'
**			cntrltype should be 2
**		For floppy diskette devices:
**			devtype should be 'disk'
**			cntrltype should be 3
**		For tape devices:
**			devtype should be 'tape'
**			cntrltype should be between 4 and 8
**			physical name should be the device driver name
**			For example, for the non-SCSI Wangtek DIBI-2 driver
**			the tape device physical name should be 'wangtek'
*******************
**	logicalname - may be any identifier but must be unique
**	physicalname - may be anything and doesn't have to be unique
**		If it contains illegal id characters, e.g., '/', then
**		it must be in quotes.
**	status - for a tape device it may be 'skip'.  The default is 'noskip'.
**            For disk and channel devices it is ignored.
**	tapesize - for a tape device, this is the tape capacity in MB.  It
**		is ignored on VMS.
*/

/*
** Determine whether channel devices are supported.
*/
if exists (select * from spt_values where type = "G" and number = 0 and low =1)
      select @channels_supported = 1
else
      select @channels_supported = 0

/*
**  Check out the @devtype.
*/
if @devtype not in ("disk", "tape", "channel")
begin
	if (@channels_supported = 0)
		print "Unknown device type.  Use 'disk' or 'tape'."
	else
		print "Unknown device type.  Use 'disk', 'tape', or 'channel'."
	return (1)
end

/*
**  Check the args are not NULL.
*/
if @logicalname = null
begin
	print "@logicalname may not be NULL."
	return
end
if @physicalname = null
begin
	print "@physicalname may not be NULL."
	return
end
if @cntrltype = null
begin
	print "@cntrltype may not be NULL."
	return
end

/*
**  Make sure that a device with @logicalname doesn't already exist.
*/
if exists (select *
		from master.dbo.sysdevices
			where name = @logicalname)
begin
	print "Device with same logical name already exists."
	return (1)
end

/*
**  Check @cntrltype.  On UNIX, it must be 2 if @devtype = disk,
**  between 3 and 8 for @devtype = tape, and between 9 and 14 for
**  @devtype = channel.  For other hosts, it will undoubtedly be different.
**  NETWARE386: For 'disk' devtype the cntrltype should be 2 or 3.
**		For 'tape' devtype the cntrltype should be between 4 and 8.
*/
if @devtype = "disk" and (@cntrltype != 2 and @cntrltype != 3)
begin
	print "For disk devices, controller number parameter must be 2 or 3."
	return (1)
end

/*  @devtype = "tape" */
else if @devtype = "tape" and @cntrltype not between 4 and 8
begin
	print "For tape devices, controller number parameter must be between 4 and 8."
	return (1)
end
/*  @devtype = "channel" */
else if @devtype = "channel" and @cntrltype not between 9 and 14
begin
      print "For channel devices, controller number parameter must be between9 and 14."
      return (1)
end

/*
**  Always turn on the dump status bit.
*/
select @status = 16

/*
**  If @devtype is a tape then check to see if devstatus is 'skip'.
*/
if @devtype = "tape"
begin
	/*
	**  If this is not VMS, then @tapesize is required.
	*/
	if not exists (select *
			from master.dbo.spt_values
				where type = "E"
					and name = "vms")
	begin
		if @tapesize = null or @tapesize < 1
		begin
			print "Please specify media capacity in megabytes (1 MB minimum)."
			return (1)
		end

		/*
		**  @tapesize is given in MB but sysdevices expects number
                **  of tape blocks so do the conversion.
                **
                **  But first get the size of a tape block.  Default to 32k.
		*/
                select @tapeblocksize = low
                        from master.dbo.spt_values
                                where type = "E"
                                        and number = 4
                if @tapeblocksize = NULL
                begin
                        select @tapeblocksize = 32768
                end

                select @tapesize =
                        convert(int, (@tapesize * 1048576.) / @tapeblocksize)
	end
	else
	begin
		select @tapesize = 0
	end


	if @devstatus != "noskip" and @devstatus != "skip"
	begin
		print "The only legal option for a tape device is 'skip' or 'noskip'."
		return (1)
	end
	if @devstatus = "skip"
		select @status = @status | 8
end
else select @tapesize = 0
/* Tell the server about the device by inserting into sysdevices */
insert into sysdevices (low, high, status, cntrltype, name, phyname)
      values (0, @tapesize, @status, @cntrltype, @logicalname, @physicalname)

if @devtype = "disk"
	print "'Disk' device added."
else if @devtype = "tape"
	print "'Tape' device added."
else
	/* Must be a channel device */
	print "'Channel' device added."

/*
**  Warn about duplicate physical names.
*/
if (select count(*)
	from master.dbo.sysdevices
		where phyname = @physicalname) > 1
begin
	select @msg = "WARNING: physical device name '" + @physicalname +
		"' is not unique."
	print @msg
end

return (0)
go
dump transaction master with truncate_only
go
/* adduser 49.1 9/10/91 */
create procedure sp_adduser
@loginame varchar(30),			/* user's login name in syslogins */
@name_in_db varchar(30) = NULL,		/* user's name to add to current db */ 
@grpname varchar(30) = NULL		/* group to put new user in */
as

declare @suid int			/* user's system id */
declare @grpid int			/* group id of group to put user in */
declare @uid int			/* new user's id */
declare @msg varchar(250)

/*
**  You must be SA or the dbo to execute this sproc.
*/
if suser_id() != 1 and user_id() != 1
begin
	print "You must be the System Administrator (SA) or the Database Owner (dbo) to execute this procedure."
	return (1)
end

/*
**  If no new user name is given, use the login name.
*/
if @name_in_db = NULL
	select @name_in_db = @loginame

/*
**  Check to see that the @name_in_db is valid.
*/
declare @returncode	int
execute @returncode = sp_validname @name_in_db
if @returncode != 0
begin
	select @msg = "'" + @name_in_db + "' is not a valid name."
	print @msg
	return @returncode
end

/*
**  The name guest is a special case.  If it doesn't have a login it
**  can still be a valid user.  We'll catch it here and special case it.
*/
if @loginame = "guest" and not exists
	(select name
		from master.dbo.syslogins
			where name = @loginame)
begin
	if exists (select *
			from sysusers
		   where name = @loginame)
	begin
		print "A user with the same name already exists in the database."
		return (1)
	end

	/*
	**  Add the guest user and return.
	*/
	insert into sysusers (uid, suid, gid, name)
		values (2, -1, 0, "guest")

	return (0)
end

/*
**  Check to see that the user has a login name.
**  We'll also initialize @grpid to 0 while we're here.
*/
select @suid = suid, @grpid = 0
	from master.dbo.syslogins
where name = @loginame

if @suid = NULL
begin
	print "No login with the specified name exists."
	return (1)
end

/*
**  Now check to see if the user already exists in the database.
*/
if exists (select *
		   from sysusers
	   where name = @name_in_db)
begin
	print "A user with the same name already exists in the database."
	return (1)
end

/*
**  See if the user already has an account under a different name.
**  That is, is the user's suid already in the sysusers table.
*/
if exists (select *
	   from sysusers
	   where suid = @suid)
begin
	print "User already has a login under a different name."
	return (1)
end

/*
**  See if the user is known in the database already with an alias.
**  That is, does the user's suid appear in the sysalternates table.
*/
if exists (select *
	   from sysalternates
	   where suid = @suid)
begin
	print "User already has alias access to the database."
	return (1)
end

/*
**  If a group name is given, check to see that it is valid.
**  User ids are > 0 and <= 16383 and group ids are > 16383.
*/
if @grpname != NULL
begin
	select @grpid = -1
	select @grpid = gid
		from sysusers
	where name = @grpname and (uid > 16383 or uid = 0)

	if @grpid = -1
	begin
		print "No group with the specified name exists."
		return (1)
	end
end

/*
**  Add the user to the sysusers table.
**  Check to see if the special user 'guest' (uid = 2) has already
**  been added.  If not then the uid to use is 3, otherwise max(uid) + 1.
*/
select @uid = max(uid) + 1
	from sysusers
		where uid < 16384 and uid > 2

/* check if there's any more user id's available */
if @uid >= 16384
begin
	print "All user ids have been assigned."
	return (1)
end

/*
**  This is the first regular user to be added so give them the first
**  number.
*/
if @uid = NULL
	select @uid = 3

insert into sysusers (uid, suid, gid, name)
	values (@uid, @suid, @grpid, @name_in_db)

print "New user added."

return (0)
go
grant execute on sp_adduser to public
go
/* addremotelogin 49.1 9/10/91 */
create procedure sp_addremotelogin
@remoteserver	varchar(30),		/* name of remote server */
@loginame varchar(30) = NULL,		/* user's remote name */
@remotename varchar(30) = NULL		/* user's local user name */
as

declare	@msg	varchar(200)

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	print "Can't run sp_addremotelogin from within a transaction."
	return (1)
end

/*
**  Check that the server name is valid.
*/
if not exists (select *
			from master.dbo.sysservers
		where srvname = @remoteserver)
begin
	select @msg = "There is not a server named '" + @remoteserver + "'."
	print @msg
	return (1)
end

/*
**  If it's the local server don't bother.
*/
if exists (select *
		from master.dbo.sysservers
			where srvname = @remoteserver
				and srvid = 0)
begin
	select @msg = "'" + @remoteserver + "' is the local server - remote login not applicable."
	print @msg
	return (1)
end

/*
**  There are three cases to handle.
**
**	1) if only @remoteserver is given then a entry is made in
**		sysremotelogins that means anyone that doesn't have
**		an exact of mapped match in sysremotelogins will use
**		their remotename as their local name and it will be looked
**		up in syslogins.
**
**	2) if @remotename is omitted then it means that anyone from the
**		remote server logging in that doesn't have a complete
**		match in sysremotelogins will be mapped to @loginame.
**
**	3) if @remotename and @loginame are given then it is a straight
**		remote login for sysremotelogins.
*/

/*
**  Case 1:  Only @remoteserver given.
*/
if @loginame = null and @remotename = null
begin
	/*
	**  Check that there is not already an entry for local mapping.
	*/
	if exists (select *
		from master.dbo.sysremotelogins l, master.dbo.sysservers s
			where l.remoteserverid = s.srvid
				and s.srvname = @remoteserver
				and l.remoteusername = null)
	begin
		select @msg = "There is already a default-name mapping of a remote login from remote server '"
			+ @remoteserver + "'."
		print @msg
		return (1)
	end

	/*
	**  Add the entry.
	*/
	insert into master.dbo.sysremotelogins 
		(remoteserverid, remoteusername, suid, status)
	select srvid, null, -1, 0
		from master.dbo.sysservers
			where srvname = @remoteserver
	print "New remote login created."
	return (0)

end

/*
**  Check that the @loginame is valid.  These is needed for both
**  case 2 and 3.
*/
if not exists (select *
		from master.dbo.syslogins
			where name = @loginame)
begin
	select @msg = "'" + @loginame + "' isn't a local user -- remote login denied."
	print @msg
	return (1)
end

/*
**  Check to make sure that there is not already a @remotename for 
**  the @remoteserver.
*/
if exists (select *
		from master.dbo.sysremotelogins l, master.dbo.sysservers s
			where l.remoteserverid = s.srvid
				and s.srvname = @remoteserver
				and l.remoteusername = @remotename)
begin
	select @msg = "There is already a remote user named '" 
		+ isnull(@remotename, "NULL") + "' for remote server '" 
		+ @remoteserver + "'."
	print @msg
	return (1)
end
	

/*
**  Case 2: We want to make an entry into sysremotelogins that will map
**	any non-exact matches to a particular local user.
*/
if @remotename = null
begin
	/*
	**  Check that there is not already an entry for local mapping.
	*/
	if exists (select *
		from master.dbo.sysremotelogins l, master.dbo.sysservers s
			where l.remoteserverid = s.srvid
				and s.srvname = @remoteserver
				and l.remoteusername = null)
	begin
		select @msg = "There is already a default-name mapping of a remote login from remote server '"
			+ @remoteserver + "'."
		print @msg
		return (1)
	end

	/*
	**  Go ahead and make the entry.
	*/
	insert into master.dbo.sysremotelogins
		(remoteserverid, remoteusername, suid, status)
	select srvid, null, suser_id(@loginame), 0
		from master.dbo.sysservers
				where srvname = @remoteserver

	print "New remote login created."
	return (0)
end

/*
**  Case 3:  All the parameters have been supplied.  All we need to check
**	is that the entry isn't already in sysremotelogins.
**	We've verified the @remoteserver and @loginame above.
*/
if @loginame != null and @remotename != null
begin
	/*
	**  Make sure that the @loginame and @remotename are a
	**  unique combination.
	*/
	if exists (select *
		from master.dbo.sysremotelogins l, master.dbo.sysservers s
			where l.remoteusername = @remotename
				and l.remoteserverid = s.srvid
				and s.srvname = @remoteserver
				and l.suid = suser_id(@loginame))
	begin
		select @msg = "There is already a remote user named '" 
			+ @remotename + "' for remote server '" 
			+ @remoteserver + "'."
		print @msg
		return (1)
	end

	/*
	**  Go ahead the do the insert.
	*/
	insert into master.dbo.sysremotelogins
		(remoteserverid, remoteusername, suid, status)
	select srvid, @remotename, suser_id(@loginame), 0
		from master.dbo.sysservers
			where srvname = @remoteserver
	print "New remote login created."
	return (0)
end

/*
**  We got here because the syntax was incorrect.
*/
print "Usage: sp_addremotelogin remoteserver [, loginame [,remotename]]"
return (1)
go
dump transaction master with truncate_only
go
/* addsegment	49.1	9/10/91 */
create procedure sp_addsegment
@segname	varchar(30),	/* segment name */
@devname	varchar(30)	/* device name to put segment on */
as

declare @dbuid	smallint	/* id of the owner of the database */
declare @segbit	int		/* this is the bit to turn on in sysusages */
declare	@msg	char(100)
declare @retcode	int

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	print "Can't run sp_addsegment from within a transaction."
	return (1)
end

/*
**  You must be SA or the dbo to execute this sproc.
*/
if suser_id() != 1 and user_id() != 1
begin
	print "You must be the System Administrator (SA) or the Database Owner (dbo) to execute this procedure."
	return (1)
end

/*
**  See if the device exists.
*/
if not exists (select *
		from master.dbo.sysdevices
			where name like @devname)
begin
	print "No such device exists -- run sp_helpdb to list the devices for the current database."
	return (1)
end

/*
**	Check that the device is a database device.
*/
 
if not exists (select *
		from master.dbo.sysdevices
			where name like @devname and cntrltype = 0)
begin
	print "The specified device is not a database device."
	return (1)
end

/*
**  Now see if the @dbname uses the @devname
*/
if not exists (select *
		from master.dbo.sysusages u, master.dbo.sysdevices d
			where d.name = @devname
				and u.vstart between d.low and d.high
				and u.dbid = db_id())
begin
	print "The specified device is not used by the database."
	return (1)
end

/*
**  Check to see if the device is marked as a log device.
**  If so, print error.
*/
if exists (select *
		from master.dbo.sysusages u, master.dbo.sysdevices d
			where d.name = @devname
				and u.vstart between d.low and d.high
				and u.dbid = db_id()
				and segmap = 4)
begin
	select @msg = "'" + @devname + "' is reserved exclusively as a log device."
	print @msg
	return (1)
end

/*
** Check for valid identifier.
*/
execute @retcode = sp_validname @segname
if (@retcode != 0)
begin
	select @msg = "'" + @segname + "' is not a valid identifier."
	print @msg
	return (1)
end

/*
**  Now go ahead and define the new segment and add it to the segmap
**  of sysusages.
**  NOTE: Don't update master..sysusages and syssegments as a xact since
**  	it could cause problems for recovery.
*/

/*
**  Check that @segname doesn't already exist.
*/
if exists (select *
		from syssegments holdlock
			where name = @segname)
begin
	select @msg = "There is already a segment named '"
		+ @segname + "'."
	print @msg
	return (1)
end

/*
**  Figure out the next segment number to use.
**  Segment number may be 0-31.
*/
select @segbit = 3
while @segbit < 32
begin
	/*
	**  Did we find one?
	*/
	if exists (select *
			from syssegments
				where segment = @segbit)
	begin
		select @segbit = @segbit + 1
	end

	/*
	**  We found an opening so break out.
	*/
	else break

end

if @segbit >= 32
begin
	print "The maximum number of segments for the current database are already defined."
	return (1)
end

/*
**  Add the new segment.
*/
insert into syssegments (segment, name, status)
	values (@segbit, @segname, 0)

/*
**  Now set the segments on @devname sysusages.
*/
if (@segbit < 31)
	select @segbit = power(2, @segbit)
else
	/*
	**  Since this is segment 31, power(2, 31) will overflow
	**  since segmap is an int.  We'll grab the machine-dependent
	**  bit mask from spt_values to set the right bit.
	*/
	select @segbit = low
		from master.dbo.spt_values
			where type = "E"
				and number = 2
update master.dbo.sysusages
	set segmap = segmap | @segbit
		from master.dbo.sysusages u,
			master.dbo.sysdevices d
		where d.name = @devname
			and u.vstart between d.low and d.high
			and u.dbid = db_id()

/*
**  Now we need to activate the new segment map.
*/
declare @dbname	varchar(30)
select @dbname = db_name()
dbcc dbrepair (@dbname, remap)
print "Segment created."

return (0)
go
grant execute on sp_addsegment to public
go
/* addserver	49.1	9/10/91 */
create procedure sp_addserver
@server	varchar(30),		/* server name */
@local	varchar(10) = NULL	/* local server */
as

declare	@msg	varchar(100)

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	print "Can't run sp_addserver from within a transaction."
	return (1)
end

/*
**  Server names must be unique so check.
*/
if exists (select *
		from master.dbo.sysservers
			where srvname = @server)
begin
	select @msg = "There is already a server named '" + @server + "'."
	print @msg
	return (1)
end

/*
**  Check to see that the @server is valid.
*/
declare @returncode	int
execute @returncode = sp_validname @server
if @returncode != 0
begin
	select @msg = "'" + @server + "' is not a valid name."
	print @msg
	return @returncode
end

/*
**  If this is the not the local server, then its srvid = max(srvid) + 1.
*/
if @local = null
begin	
	insert into master.dbo.sysservers (srvid, srvstatus, srvname, srvnetname)
			select isnull(max(srvid), 0) + 1, 0, @server, @server
				from master.dbo.sysservers
end

/*
**  If @local = "local" then this is the local server and it's
**  srvid = 0.
*/
else
begin
	if @local != "local" and @local != "LOCAL"
	begin
		print "Usage: sp_addserver servername [, 'local']"
		return (1)
	end

	if exists (select *
			from master.dbo.sysservers
				where srvid = 0)
	begin
		print "There is already a local server."
		return (1)
	end

	insert into master.dbo.sysservers (srvid, srvstatus, srvname, srvnetname)
			values (0, 0, @server, @server)
end

select @msg = "Server added."
print @msg
return (0)
go
dump transaction master with truncate_only
go
/* addlanguage 49.1 9/10/91 */
create procedure sp_addlanguage 
@language varchar(30),
@alias varchar(30) = NULL,
@months varchar(251),
@shortmons varchar(119),
@days varchar(216),
@datefmt char(3),
@datefirst tinyint
as

declare @msg varchar(250)
declare @nextlangid smallint
declare @returncode	int 

/*  Check to see if the language exists. */
select @returncode = 0
execute @returncode = sp_validlang @language
if @returncode = 0
begin
	select @msg = "'" + @language + "' already exists in Syslanguages."
	print @msg
	return 1
end

/* Check to see that the list of full month names is valid. */
execute @returncode = sp_chklangparam @months, "full month", 12, 20
if @returncode != 0
	return 1

/* Check to see that the list of short month names is valid. */
execute @returncode = sp_chklangparam @shortmons, "short month", 12, 9
if @returncode != 0
	return 1

/* Check to see that the list of day names is valid. */
execute @returncode = sp_chklangparam @days, "day", 7, 30
if @returncode != 0
	return 1

/* Check to see that the @datefmt is valid. */
if (@datefmt != 'mdy' and @datefmt != 'dmy' and @datefmt != 'ymd' and @datefmt != 'ydm'
	and @datefmt != 'myd' and @datefmt != 'dym')
begin
	select @msg = "'" + @datefmt + "' is not a valid date order."
	print @msg
	return 1
end

/*
**  Check to see that the @datefirst is valid.
*/
if (@datefirst < 1 or @datefirst > 7)
begin
	select @msg = "'" + convert(char(3), @datefirst) + "' is not a valid first day." 
	print @msg
	return 1
end

/*
**  If the user didn't specify the alias name, the alias name is same as 
**  the official name.
*/
if @alias is null
begin
	select @alias =  @language
end

/*  Check to see if the alias exists. */
select @returncode = 0
execute @returncode = sp_validaltlang @alias
if @returncode = 0
begin
	select @msg = "'" + @alias + "' alias already exists in Syslanguages."
	print @msg
	return 1
end

if @language = 'us_english'
begin
	/*  The language id of us_english is 0. */
	insert syslanguages (langid, dateformat, datefirst, upgrade, 
		name, alias, months, shortmonths, days)
	select 0, @datefmt, @datefirst, 0, 
		@language, @alias, @months, @shortmons, @days
end
else
begin

	if (select max(langid) from syslanguages) is null
	begin
		select @nextlangid = 1
	end
	else
	begin
		select @nextlangid = (select max(langid)+1 
		from syslanguages)
	end

	insert syslanguages (langid, dateformat, datefirst, upgrade, 
		name, alias, months, shortmonths, days)
	select @nextlangid, @datefmt, @datefirst, 0, 
		@language, @alias, @months, @shortmons, @days
end


/* If the insert failed, say so. */
if @@error != 0
begin
	print "Language not inserted."
	return
end

print "New language inserted."
go
/* defaultlanguage 49.1 9/10/91 */
create procedure sp_defaultlanguage
@loginame varchar(30),			/* login name of the user */
@language varchar(30) = NULL		/* default language for the new user */
as

declare @msg varchar(250)
declare @returncode int

/*
**  Only the system administrator (sa) can run this command.
**  Check to make sure the executor is the sa.
*/
if (suser_id() != 1 and suser_id() != suser_id(@loginame))
begin
	select @msg = "Only the System Administrator (SA) or '" + @loginame + "' can change " + @loginame + "'s default language."
	print @msg
	return 1
end

/* 
**  Check to see that the @language is valid.
*/
if @language is not null
begin
	select @returncode = 0
	execute @returncode = sp_validlang @language
	if @returncode != 0
	begin
		if @language != "us_english"
		begin
			select @msg = "'" + @language + "' is not a valid official language name."
			print @msg
			return @returncode
		end
	end
end

/*
**  Make sure the login already exist.
*/
if not exists (select *
		  from syslogins
          where name = @loginame)
begin
	print "This user does not exist.  Run sp_addlogin to add this user in."
	return 1
end

/*
**  Set the default language for this user.
*/
update syslogins 
	set language = @language
	 	where name = @loginame

select @msg =  @loginame + "'s default language is changed to " + @language
print @msg

return 0
go
grant execute on sp_defaultlanguage to public
go
dump transaction master with truncate_only
go
/* helplanguage 49.1 9/10/91 */
create procedure sp_helplanguage 
@language varchar(30) = NULL
as

declare @msg varchar(250)

/* Print all languages if the user didn't give the language name. */
if @language is null
begin
	if exists (select * from syslanguages)
		select * from syslanguages
	else
		print "No alternate languages are available."

	/* Find out whether us_english is there or not. */
	if not exists (select * from syslanguages   
			where name = 'us_english') 
		print "us_english is always available, even though it is not in master.dbo.syslanguages."

	return 0
end

/*  Report information on this language. */
if exists (select * from syslanguages   
                where name = @language) 
begin
        select * from syslanguages 
                where name = @language
        return 0
end 

if exists (select * from syslanguages
		where alias = @language)
begin
	select * from syslanguages 
		where alias = @language
	return 0
end

/* Couldn't find this language. */
if @language = 'us_english'
begin
	print "us_english is always available, even though it is not in master.dbo.syslanguages."
	return 0
end
else
begin
	select @msg = "'" + @language + "' is not in Syslanguages."
	print @msg
	return 1
end
go
grant execute on sp_helplanguage to public
go
/* droplanguage 49.1 9/10/91 */
create procedure sp_droplanguage 
@language varchar(30),
@dropmessages varchar(30) = NULL
as

declare @msg varchar(250)
declare @langid smallint
declare @dropmsgs int


/*  Check to see if the language exists. */
declare @returncode	int 
select @returncode = 0
execute @returncode = sp_validlang @language
if @returncode != 0
begin
	select @msg = "'" + @language + "' is not in Syslanguages."
	print @msg
	return 1
end

/* Get language id from syslanguages. */
select @langid = (select langid 
			from syslanguages 
				where name = @language)

/*  Check to see if "dropmessages" is requested. */
select @dropmsgs = 0
if @dropmessages is null
begin
	if exists (select * from sysmessages 
			where langid = @langid)
	begin
		/* 
		**  Cannot drop a language if the language has associated
		**  entries in the master.dbo.sysmessages.
		*/
		select @msg = "Can't drop '" + @language + "' because there are associated entries in master.dbo.sysmessages.  Run sp_droplanguage with dropmessages flag."
		print @msg 
		return 1
	end
end
else
begin
	if @dropmessages != "dropmessages"
	begin
		print "The only legal value for @dropmessages is 'dropmessages'."
		return 1
	end

	select @dropmsgs = 1
end

/* 
**  Drop the language and delete messages from Sysmessages if there is any.
*/
if @dropmsgs = 1
begin
	delete sysmessages
		where langid = @langid
end

delete syslanguages 
	where langid = @langid

print "Language deleted."
 
go
dump transaction master with truncate_only
go
/* setlangalias 49.1 9/10/91 */
create procedure sp_setlangalias 
@language varchar(30),
@alias varchar(30)
as

declare @msg varchar(250)

/*  Check to see if the language exists. */
declare @returncode	int 
select @returncode = 0
execute @returncode = sp_validlang @language
if @returncode != 0
begin
	select @msg = "'" + @language + "' is not a valid language."
	print @msg
	return 1
end

/*  Check to see if the alias exists. */
select @returncode = 0
execute @returncode = sp_validaltlang @alias
if @returncode = 0
begin
	select @msg = "'" + @alias + "' alias already exists in Syslanguages."
	print @msg
	return 1
end

/* Reset the alternate language name. */
update syslanguages 
	set alias = @alias
		where name = @language

/* If the update failed, say so. */
if @@error != 0
begin
	print "Language alias not changed."
	return
end

print "Language alias reset."
go
/* bindefault 49.1 9/10/91 */
create procedure sp_bindefault
@defname varchar(92),			/* name of the default */
@objname varchar(61),			/* table or usertype name */
@futureonly varchar(15) = NULL		/* flag to indicate extent of binding */
as

declare @defid int			/* id of the default to bind */
declare @futurevalue varchar(15)	/* the value of @futureonly that causes
					** the binding to be limited */

set nocount on

select @futurevalue = "futureonly"	/* initialize @futurevalue */

/*
**  When a default or rule is bound to a user-defined datatype, it is also
**  bound, by default, to any columns of the user datatype that are currently
**  using the existing default or rule as their default or rule.  This default
**  action may be overridden by setting @futureonly = @futurevalue when the
**  procedure is invoked.  In this case existing columns with the user
**  datatype won't have their existing default or rule changed.
*/

/*
**  Check to see that the object names are local to the current database.
*/
if (@objname like "%.%.%")
   or
   (@defname like "%.%.%" and
	substring(@defname, 1, charindex(".", @defname) - 1) != db_name())
begin
	print "Default and table or usertype must be in 'current' database."
	return (1)
end

/*
**  Check that the @futureonly argument, if supplied, is correct.
*/
if (@futureonly != null)
begin
	if (@futureonly != @futurevalue)
	begin
		print "Usage: bindefault defaultname, objectname [, 'futureonly']"
		return (1)
	end
end

/*
**  Check to see that the default exists and get it's id.
*/
select @defid = id
	from sysobjects
where id = object_id(@defname)
	and sysstat & 7 = 6		/* default object */

if @defid is NULL
begin
	print "No such default exists.  You must create the default first."
	return (1)
end

/*
**  If @objname is of the form tab.col then we are binding to a column.
**  Otherwise its a datatype.  In the column case, we need to extract
**  and verify the table and column names and make sure the user owns
**  the table that is getting the default bound.
*/
if @objname like "%.%"
begin
	declare @tabname varchar(30)		/* name of table */
	declare @colname varchar(30)		/* name of column */

	/*
	**  Get the table name out.
	*/
	select @tabname = substring(@objname, 1, charindex(".", @objname) - 1)
	select @colname = substring(@objname, charindex(".", @objname) + 1, 61)

	/*
	**  If the column type is timestamp, disallow the bind.
	**  Defaults can't be bound to timestamp columns.
	*/
	if exists (select *
			from sysobjects o, syscolumns c
		where c.id = object_id(@tabname)
			and c.name = @colname
			and c.name = @colname
			and o.id = object_id(@tabname)
			and o.sysstat & 7 = 3
			and c.usertype = 80)
	begin
		print "You can't bind a default to a timestamp datatype column."
		return (1)
	end

	update syscolumns
		set cdefault = @defid
			from syscolumns, sysobjects
		where syscolumns.id = object_id(@tabname)
			and syscolumns.name = @colname
			and sysobjects.id = object_id(@tabname)
			and uid = user_id()
			and sysobjects.sysstat & 7 = 3      /* user table */

	/*
	**  Did the bind happen?
	*/
	if @@rowcount != 1
	begin
		print "You do not own a column of that name."
		return (1)
	end

	/*
	**  Since binding a default is a schema change, update schema count
	**  for the object in the sysobjects table.
	*/
	update sysobjects
		set schema = schema + 1
			from sysobjects
				where id = object_id(@tabname)
					and uid = user_id()

	print "Default bound to column."

end
else
begin
	/*
	**  We're binding to a user type.  In this case, the @objname
	**  is really the name of the user datatype.
	**  When we bind to a user type, any existing columns get changed
	**  to the new binding unless their current binding is not equal
	**  to the current binding for the usertype or if they set the
	**  @futureonly parameter to @futurevalue.
	*/
	declare @olddefault int			/* current default for type */

	/*
	**  Get the current default for the datatype.
	*/
	select @olddefault = tdefault
		from systypes
	where name = @objname
		and uid = user_id()
		and usertype > 100

	if @olddefault = null
	begin
		print "You do not own a datatype of that name."
		return (1)
	end

	update systypes
		set tdefault = @defid
			from systypes
		where name = @objname
			and uid = user_id()
			and usertype > 100


	print "Default bound to datatype."

	/*
	**  Now see if there are any columns with the usertype that
	**  need the new binding.
	*/
	if isnull(@futureonly, "") != @futurevalue
		and exists (select *
			from syscolumns, systypes
				where syscolumns.usertype = systypes.usertype
					and systypes.name = @objname
					and systypes.usertype > 100
					and systypes.uid = user_id()
					and (syscolumns.cdefault = @olddefault
					or syscolumns.cdefault = 0 ) )
	begin
		/*
		**  Update syscolumns with new binding.
		*/
		update syscolumns
			set cdefault = systypes.tdefault
				from syscolumns, systypes
			where syscolumns.usertype = systypes.usertype
				and systypes.name = @objname
				and systypes.usertype > 100
				and systypes.uid = user_id()
				and (syscolumns.cdefault = @olddefault
				or syscolumns.cdefault = 0 )

		/*
		**  Update the table schema to indicate that something
		**  has changed in the table's schema.
		*/
		update sysobjects
			set schema = schema + 1
				from sysobjects, syscolumns, systypes
			where sysobjects.id = syscolumns.id
				and syscolumns.usertype = systypes.usertype
				and systypes.name = @objname
				and systypes.usertype > 100
				and systypes.uid = user_id()
                                and (syscolumns.cdefault = @olddefault
                                          or  syscolumns.cdefault = 0 )

		print "The new default has been bound to columns(s) of the specified user datatype."
	end
end

return (0)
go
grant execute on sp_bindefault to public
go
dump transaction master with truncate_only
go
/* bindrule 49.1 9/10/91 */
create procedure sp_bindrule
@rulename varchar(92),			/* name of the rule */
@objname varchar(61),			/* table or usertype name */
@futureonly varchar(15) = NULL		/* column name */
as

declare @ruleid int			/* id of the rule to bind */
declare @futurevalue varchar(15)	/* the value of @futureonly that causes
					** the binding to be limited */

set nocount on

select @futurevalue = "futureonly"	/* initialize @futurevalue */

/*
**  When a default or rule is bound to a user-defined datatype, it is also
**  bound, by default, to any columns of the user datatype that are currently
**  using the existing default or rule as their default or rule.  This default
**  action may be overridden by setting @futureonly = @futurevalue when the
**  procedure is invoked.  In this case existing columns with the user
**  datatype won't have their existing default or rule changed.
*/

/*
**  Check to see that the object names are local to the current database.
*/
if (@objname like "%.%.%")
   or
   (@rulename like "%.%.%" and
	substring(@rulename, 1, charindex(".", @rulename) - 1) != db_name())
begin
	print "Rule and table or usertype must be in 'current' database."
	return (1)
end

/*
**  Check that the @futureonly argument, if supplied, is correct.
*/
if (@futureonly != null)
begin
	if (@futureonly != @futurevalue)
	begin
		print "Usage: bindrule rulename, objectname [, 'futureonly']"
		return (1)
	end
end

/*
**  Check to see that the rule exists and get it's id.
*/
select @ruleid = id
	from sysobjects
where id = object_id(@rulename)
	and sysstat & 7 = 7		/* rule object */

if @ruleid is NULL
begin
	print "No such rule exists.  You must create the rule first."
	return
end

/*
**  If @objname is of the form tab.col then we are binding to a column.
**  Otherwise its a datatype.  In the column case, we need to extract
**  and verify the table and column names and make sure the user owns
**  the table that is getting the rule bound.
*/
if @objname like "%.%"
begin
	declare @tabname varchar(30)		/* name of table */
	declare @colname varchar(30)		/* name of column */

	/*
	**  Get the table name out.
	*/
	select @tabname = substring(@objname, 1, charindex(".", @objname) - 1)
	select @colname = substring(@objname, charindex(".", @objname) + 1, 61)

	/*
	**  If the column type is image, text, or timestamp, disallow the bind.
	**  Rules can't be bound to image, text, or timestamp columns.
	**  The qualification to check for types is a little strange because
	**  text and image are real, basic data types while timestamp is not.
	**  Timestamp is really a binary.  The types are checked in case
	**  there is a user-defined datatype that is an image or text.
	**  User-defined datatypes mapping to timestamp are not allowed
	**  by sp_addtype.
	*/
	if exists (select *
			from sysobjects o, syscolumns c
		where c.id = object_id(@tabname)
			and c.name = @colname
			and c.name = @colname
			and o.id = object_id(@tabname)
			and o.sysstat & 7 = 3
			and (c.type in (35, 34) or c.usertype = 80))
	begin
		print "You can't bind a rule to a text, image, or timestamp datatype column."
		return (1)
	end

	update syscolumns
		set domain = @ruleid
			from syscolumns, sysobjects
		where syscolumns.id = object_id(@tabname)
			and syscolumns.name = @colname
			and sysobjects.id = object_id(@tabname)
			and uid = user_id()
			and sysobjects.sysstat & 7 = 3      /* user table */

	/*
	**  Did the bind happen?
	*/
	if @@rowcount != 1
	begin
		print "You do not own a column of that name."
		return (1)
	end

	/*
	**  Since binding a rule is a schema change, update schema count
	**  for the object in the sysobjects table.
	*/
	update sysobjects
		set schema = schema + 1
			from sysobjects
				where id = object_id(@tabname)
					and uid = user_id()

	print "Rule bound to table column."

end
else
begin
	/*
	**  We're binding to a user type.  In this case, the @objname
	**  is really the name of the user datatype.
	**  When we bind to a user type, any existing columns get changed
	**  to the new binding unless their current binding is not equal
	**  to the current binding for the usertype or if they set the
	**  @futureonly parameter to @futurevalue.
	*/
	declare @oldrule int			/* current rule for type */

	/*
	**  If the column type is image, text, or timestamp, disallow the bind.
	**  Rules can't be bound to image or text columns.
	*/
	if exists (select *
			from systypes
				where name = @objname
					and (type in (35, 34) or usertype = 80))
	begin
		print "You can't bind a rule to a text, image, or timestamp datatype."
		return (1)
	end

	/*
	**  Get the current rule for the datatype.
	*/
	select @oldrule = domain
		from systypes
	where name = @objname
		and uid = user_id()
		and usertype > 100

	if @oldrule = null
	begin
		print "You do not own a datatype of that name."
		return (1)
	end

	update systypes
		set domain = @ruleid
			from systypes
		where name = @objname
			and uid = user_id()
			and usertype > 100


	print "Rule bound to datatype."

	/*
	**  Now see if there are any columns with the usertype that
	**  need the new binding.
	*/
	if isnull(@futureonly, "") != @futurevalue
		and exists (select *
			from syscolumns, systypes
				where syscolumns.usertype = systypes.usertype
					and systypes.name = @objname
					and systypes.usertype > 100
					and systypes.uid = user_id()
                                	and (syscolumns.domain = @oldrule
                                  	or  syscolumns.domain = 0 ))
	begin
		print "The new rule has been bound to column(s) of the specified user datatype."
		/*
		**  Update syscolumns with new binding.
		*/
		update syscolumns
			set domain = systypes.domain
				from syscolumns, systypes
			where syscolumns.usertype = systypes.usertype
				and systypes.name = @objname
				and systypes.usertype > 100
				and systypes.uid = user_id()
                                and (syscolumns.domain = @oldrule
                                  or  syscolumns.domain = 0 )

		/*
		**  Update the table schema to indicate that something
		**  has changed in the table's schema.
		*/
		update sysobjects
			set schema = schema + 1
				from sysobjects, syscolumns, systypes
			where sysobjects.id = syscolumns.id
				and syscolumns.usertype = systypes.usertype
				and systypes.name = @objname
				and systypes.usertype > 100
				and systypes.uid = user_id()
                                and (syscolumns.domain = @oldrule
                                  or  syscolumns.domain = 0 )
	end
end

return (0)
go
grant execute on sp_bindrule to public
go
/* changedbowner 49.1 9/10/91 */
create procedure sp_changedbowner
@loginame varchar(30),         /* login to become dbo */
@map      varchar(10) = NULL   /* True to map aliases, else drop  */
as

declare @suid    smallint
declare @oldsuid smallint

/*
**  Only the SA can change the owner of a database.
*/
if suser_id() != 1
begin
	print "Only the System Administrator (SA) can change to owner of a database."
	return(1)
end

/*
**  Can't change the owner of the master database.
*/
if db_id() = 1
begin
	print "Can't change the owner of the master database."
	return(1)
end

/*
**  Make sure that @loginame exists and has a login.
*/
select @suid = suid
	from master.dbo.syslogins
		where name = @loginame

if @suid = NULL
begin
	print "No login with the specified name exists."
	return(1)
end

/*
**  Make sure that @loginame isn't already a user or alias in the database.
*/
if exists (select *
		from sysusers
			where suid = @suid)
begin
	print "The proposed new db owner already is a user in the database."
	return(1)
end
if exists (select *
		from sysalternates
			where suid = @suid)
begin
	print "The proposed new db owner already is aliased in the database."
	return(1)
end

/* 
** find old (current) dbo's suid
*/
select @oldsuid = suid
	from sysusers
		where uid = 1

begin transaction

/*
**  Now change the suid of the owner of the database to the suid of @loginame.
*/
update sysusers
	set suid = @suid
		where uid = 1

/*
** if the user requested that aliases be mapped to new dbo, do that.
*/
if @map = "true"
begin

	if exists (select *
			from sysalternates
				where altsuid = @oldsuid)
	begin
		update sysalternates
			set altsuid = @suid
				where altsuid = @oldsuid

		print "The dependent aliases were mapped to the new dbo."
	end
end
/* else drop the aliases to the old dbo */
else
begin

	if exists (select *
			from sysalternates
				where altsuid = @oldsuid)
	begin
		delete from sysalternates
			where altsuid = @oldsuid

		print "The dependent aliases were dropped."
	end
end


/*
**  Reflect the new owner of the database in master.dbo.sysdatabases.
*/
update master.dbo.sysdatabases
	set suid = @suid
		where dbid = db_id()

commit transaction

/*
**  Checkpoint the database so that the in-memory data structure for the
**  database will be consistent with sysdatabases.
*/
checkpoint

print "Database owner changed."

return (0)
go
dump transaction master with truncate_only
go
/* changegroup 49.1 9/10/91 */
create procedure sp_changegroup
@grpname varchar(30),			/* group name */
@username varchar(30)			/* user name to add to group */
as

declare @gid int			/* group id */
declare @uid int			/* user id */

/*
**  You must be SA or the dbo to execute this sproc.
*/
if suser_id() != 1 and user_id() != 1
begin
	print "You must be the System Administrator (SA) or the Database Owner (dbo) to execute this procedure."
	return (1)
end

/*
**  See if the group name exists.
*/
select @gid = uid
	from sysusers
where name = @grpname
	and (uid > 16383 or uid = 0)

/*
**  If no such group, quit.
**  User ids are <= 16383 and group ids are > 16383 or = 0.
*/
if @gid = NULL
begin
	print "No such group exists."
	return (1)
end

/*
**  See if the user name exists.
*/
select @uid = uid
	from sysusers
where name = @username
	and (uid <= 16383 and uid > 0)

/*
**  If no such user in the database, quit.
*/
if @uid = NULL
begin
	print "No such user exists."
	return (1)
end

/*
**  Everything is consistent so change the group.
*/
update sysusers
	set gid = @gid
		from sysusers
	where uid = @uid

/*
**  We need to invalidate the protection cache since objects have
**  changed ownership.  This command will invalidate the current
**  protection cache so when protections are checked the new and
**  correct protections will be used.
*/
grant all to null

print "Group changed."

return (0)
go
grant execute on sp_changegroup to public
go
/* checknames 49.1 9/10/91 */
create procedure sp_checknames
@mode varchar(20) = NULL		/* mode of operation; e.g. 'silent' */
as

declare @msilent	int		/* set to 1 if 'silent' mode is on */
declare @ret_val	int		/* set to 1 if we find funny char */
declare @codepoint	tinyint		/* set to 1 if we find funny char */
declare @dbname		varchar(30)	/* holds database name */
declare @msg		varchar(90)	/* used for messages to user */
declare @pat		varchar(132)	/* holds the pattern to search for */

set nocount on

if (@mode like '%help%')
begin
	print 'sp_checknames is used to search for non 7-bit ASCII characters'
	print 'in several important columns of system tables.  The following'
	print 'columns are searched:'
	print ' '
	print '    In "master":'
	print '        sysdatabases.name'
	print '        sysdevices.name'
	print '        syslogins.name'
	print '        syslogins.dbname'
	print '        syslogins.password'
	print '        sysremotelogins.remoteusername'
	print '        sysservers.srvname'
	print '        sysservers.srvnetname'
	print ' '
	print '    In all databases:'
	print '        syscolumns.name'
	print '        sysindexes.name'
	print '        sysobjects.name'
	print '        syssegments.name'
	print '        systypes.name'
	print '        sysusers.name'
	print ' '

	return (0)
end

/*
**  First, initialize return value, and set up mode variables:
*/
select @ret_val = 0

if (@mode like '%silent%')
	select @msilent = 1
else
	select @msilent = 0


/*
**  Now, initialize the pattern string we will search for:
*/
select @pat = '%[', @codepoint = 127
while (@codepoint < 255)
begin
	select @codepoint = @codepoint + 1
	select @pat = @pat + char(@codepoint)
end
select @pat = @pat + ']%'


/*
**  Get the database name we are in:
*/
select @dbname = db_name()

if (@msilent = 0)
begin
	print ' '
	select @msg = 'Looking for non 7-bit ASCII characters in the system ' +
			'tables of database:  "' + @dbname + '"'
	print @msg
	print ' '
end


/*
**  Look through these only if in the master database:
*/
if (@dbname = 'master')
begin
    if exists (select name from master.dbo.sysdatabases
		    where name like @pat)
    begin
	if (@msilent = 1)
	    return (1)

	select @ret_val = 1
	print ' '
	print '==============================================================='
	print 'Table.Column name:  "sysdatabases.name"'
	print ' '
	print 'The following database names contain non 7-bit ASCII characters.'
	print 'If you wish to change their names, use "sp_renamedb":'
	print ' '
	select dbid,name from master.dbo.sysdatabases
			where name like @pat
    end

    if exists (select name from master.dbo.sysdevices
		    where name like @pat)
    begin
	if (@msilent = 1)
	    return (1)

	select @ret_val = 1
	print ' '
	print '==============================================================='
	print 'Table.Column name:  "sysdevices.name"'
	print ' '
	print 'The following device names contain non 7-bit ASCII characters.'
	print 'If you wish to change their names, use "UPDATE":'
        print ' '
	select name from master.dbo.sysdevices
			where name like @pat
    end

    if exists (select name from master.dbo.syslogins
		    where name like @pat)
    begin
	if (@msilent = 1)
	    return (1)

	select @ret_val = 1
	print ' '
	print '==============================================================='
	print 'Table.Column name:  "syslogins.name"'
        print ' '
	print 'The following login names contain non 7-bit ASCII characters.'
	print 'If you wish to change these names, use "sp_droplogin" and'
	print '"sp_addlogin":'
        print ' '
	select suid,name from master.dbo.syslogins
			where name like @pat
    end

    if exists (select dbname from master.dbo.syslogins
		    where dbname like @pat)
    begin
	if (@msilent = 1)
	    return (1)

	select @ret_val = 1
	print ' '
	print '==============================================================='
	print 'Table.Column name:  "syslogins.dbname"'
	print ' '
	print 'The following logins have default database names that contain'
	print 'non 7-bit ASCII characters.  If you wish to change them use'
	print '"sp_defaultdb":'
        print ' '
	select suid,name,dbname from master.dbo.syslogins
			where dbname like @pat
    end

    if exists (select password from master.dbo.syslogins
		    where password like @pat)
    begin
	if (@msilent = 1)
	    return (1)

	select @ret_val = 1
	print ' '
	print '==============================================================='
	print 'Table.Column name:  "syslogins.password"'
	print ' '
	print 'The following logins have passwords that contain non 7-bit'
	print 'ASCII characters.  If you wish to change them use "sp_password";'
	print 'Remember, only the sa and the login itself may examine or change'
	print 'the syslogins.password column:'
        print ' '
	select suid,name from master.dbo.syslogins
			where password like @pat
    end

    if exists (select remoteusername from master.dbo.sysremotelogins
		    where remoteusername like @pat)
    begin
	if (@msilent = 1)
	    return (1)

	select @ret_val = 1
	print ' '
	print '==============================================================='
	print 'Table.Column name:  "sysremotelogins.remoteusername"'
        print ' '
	print 'The following remote login names contain non 7-bit ASCII'
	print 'characters.  If you wish to change these names, use'
	print '"sp_dropremotelogin" and "sp_addremotelogin":'
        print ' '
	select remoteserverid,remoteusername from master.dbo.sysremotelogins
			where remoteusername like @pat
    end

    if exists (select srvname from master.dbo.sysservers
		    where srvname like @pat)
    begin
	if (@msilent = 1)
	    return (1)

	select @ret_val = 1
	print ' '
	print '==============================================================='
	print 'Table.Column name:  "sysservers.srvname"'
        print ' '
	print 'The following server names contain non 7-bit ASCII characters.'
	print 'If you wish to change their names, use "sp_dropserver" and'
	print '"sp_addserver":'
        print ' '
	select srvid,srvname from master.dbo.sysservers
			where srvname like @pat
    end

    if exists (select srvnetname from master.dbo.sysservers
		    where srvnetname like @pat)
    begin
	if (@msilent = 1)
	    return (1)

	select @ret_val = 1
	print ' '
	print '==============================================================='
	print 'Table.Column name:  "sysservers.srvnetname"'
        print ' '
	print 'The following servers have "interface file" names that contain'
	print 'non 7-bit ASCII characters.  If you wish to change these names,'
	print 'use "UPDATE":'
        print ' '
	select srvid,srvname,srvnetname from master.dbo.sysservers
			where srvnetname like @pat
    end

end


/*
**  For *ALL* databases, we want to look through these:
*/
if exists (select name from dbo.syscolumns
	    where name like @pat)
begin
    if (@msilent = 1)
	return (1)

    select @ret_val = 1
    print ' '
    print '==============================================================='
    print 'Table.Column name:  "syscolumns.name"'
    print ' '
    print 'The following column and parameter names contain non 7-bit ASCII'
    print 'characters.  If you wish to change these names, use "sp_rename":'
    print ' '
    select objname=o.name,colname=c.name from dbo.syscolumns c, dbo.sysobjects o
		where c.name like @pat and o.id = c.id
end

if exists (select name from dbo.sysindexes
	    where name like @pat
	    and indid > 0)
begin
    if (@msilent = 1)
	return (1)

    select @ret_val = 1
    print ' '
    print '==============================================================='
    print 'Table.Column name:  "sysindexes.name"'
    print ' '
    print 'The following index names contain non 7-bit ASCII characters.'
    print 'If you wish to change these names, use "UPDATE":'
    print ' '
    select id,indid,name from dbo.sysindexes
		where name like @pat
		and indid > 0
end

if exists (select name from dbo.sysobjects
	    where name like @pat)
begin
    if (@msilent = 1)

	return (1)

    select @ret_val = 1
    print ' '
    print '==============================================================='
    print 'Table.Column name:  "sysobjects.name"'
    print ' '
    print 'The following object names contain non 7-bit ASCII characters.'
    print 'If you wish to change these names, use "sp_rename":'
    print ' '
    select owner=u.name,o.name from dbo.sysobjects o,dbo.sysusers u
		where o.name like @pat and o.uid=u.uid
end

if exists (select name from dbo.syssegments
	    where name like @pat)
begin
    if (@msilent = 1)
	return (1)

    select @ret_val = 1
    print ' '
    print '==============================================================='
    print 'Table.Column name:  "syssegments.name"'
    print ' '
    print 'The following segment names contain non 7-bit ASCII characters.'
    print 'If you wish to change these names, use "UPDATE":'
    print ' '
    select segment,name from dbo.syssegments
		where name like @pat
end

if exists (select name from dbo.systypes
	    where name like @pat)
begin
    if (@msilent = 1)
	return (1)

    select @ret_val = 1
    print ' '
    print '==============================================================='
    print 'Table.Column name:  "systypes.name"'
    print ' '
    print 'The following datatype names contain non 7-bit ASCII characters.'
    print 'If you wish to change these names, use "sp_rename":'
    print ' '
    select name from dbo.systypes
		where name like @pat
end

if exists (select name from dbo.sysusers
	    where name like @pat)
begin
    if (@msilent = 1)
	return (1)

    select @ret_val = 1
    print ' '
    print '==============================================================='
    print 'Table.Column name:  "sysusers.name"'
    print ' '
    print 'The following user or group names contain non 7-bit ASCII'
    print 'characters.  If you wish to change these names, use "UPDATE":'
    print ' '
    select suid,uid,name from dbo.sysusers
		where name like @pat
end

if (@ret_val = 0  and  @msilent = 0)
begin
    select @msg = 'Good news!  Database "' + @dbname + '" has no obj/user/etc.'
    print @msg
    print 'names that contain non 7-bit ASCII characters.'
end

return (@ret_val)
go
grant execute on sp_checknames to public
go
dump transaction master with truncate_only
go
CREATE TABLE	spt_committab
(
	commid	int, /* id used to refer to transaction */
	start	datetime, /* time transaction started */
	lastchange datetime, /* last time this row was updated */
	totnum	int,   	  /* number of servers 
			  ** initially involved in xact 
			  */
	outnum	int, 	  /* number of servers 
			  ** who still have not completed 
			  */
	status	char(1), /* 'a'- abort, 'c'- commit, 'b'- begin */
	applname varchar(30), /* application name */
	xactname varchar(30), /* transaction name */
	password varchar(30) NULL /* password protection for updating */
)
go
create unique clustered index commitclust on spt_committab(commid)
go

create procedure sp_start_xact 
	@applname varchar(30),
	@xactname varchar(30),
	@count	  int,
	@password varchar(30) = NULL
AS

set nocount on

BEGIN
	BEGIN TRANSACTION
		INSERT spt_committab VALUES 
		(
			0,
			getdate(),
			getdate(),
			@count, 
			@count, 
			'b',
			@applname, 
			@xactname,
			@password
		) 

		UPDATE spt_committab
			set commid = 1 + (select max(commid) from spt_committab)
			where commid = 0

		SELECT max(commid) from spt_committab
	COMMIT TRANSACTION
END
go

create procedure sp_commit_xact
	@commid	int,
	@password varchar(30) = NULL
AS
if exists (select *
	from spt_committab
	where commid = @commid
	and password = @password)
begin
	/*
	**  If status is aborted, return a 1 to indicate a failure.
	*/
	if exists (select *
			from spt_committab
				where commid = @commid
					and status = 'a')
	begin
		select 1
		return (1)
	end

	/*  Mark the xact as committed. */
	UPDATE spt_committab 
		SET status = 'c', lastchange = getdate()
		WHERE commid = @commid
	select 0
	return (0)
end
else
begin
	/* Error so return 1 */
	raiserror 30000 "Commit service xact id doesn't exist."
	select 1
	return (1)
end
go

CREATE PROCEDURE sp_abort_xact
	@commid	int,
	@password varchar(30) = NULL
AS
if exists (select *
	from spt_committab
	where commid = @commid
	and password = @password)
begin
	UPDATE spt_committab 
		SET status = 'a' , lastchange = getdate()
		WHERE commid = @commid
END
else
begin
	raiserror 30001 "Commit service xact id doesn't exist."
end
go

CREATE PROCEDURE sp_remove_xact
	@commid	int,
	@count	int,
	@password varchar(30) = NULL
AS
if exists (select *
	from spt_committab
	where commid = @commid
	and password = @password)
begin
	/*
	** Decrement outnum by @count.
	*/
	UPDATE spt_committab 
		SET outnum = outnum - @count, lastchange = GETDATE()
		WHERE commid = @commid

	/*
	**  Delete the row if outnum < 1
	*/
	DELETE spt_committab
		WHERE commid = @commid
			and outnum < 1

end
else
begin
	raiserror 30002 "Commit service xact id doesn't exist."
end
go

create procedure sp_stat_xact
	@commid	int
AS
BEGIN
	IF EXISTS 
	(
		SELECT status 
			FROM spt_committab
			WHERE commid = @commid
	)
		SELECT status 
			FROM spt_committab
			WHERE commid = @commid
	ELSE
		SELECT status = 'u'
END
go

create procedure sp_probe_xact
	@commid	int
AS
BEGIN
	declare @stat	char(1)

	begin tran
		IF EXISTS ( SELECT status 
				FROM spt_committab
					WHERE commid = @commid)
		begin
			SELECT @stat = status 
				FROM spt_committab
					WHERE commid = @commid
			
			if (@stat != 'c')
			begin
				update spt_committab
					set status = 'a'
						where commid = @commid
				select status = 'a'
			end
			else select status = @stat
		end
		else select status = 'u'
	commit tran

END
go

create procedure sp_scan_xact 
	@commid	int = NULL
as
BEGIN
	IF	@commid = -1 or @commid is NULL

		SELECT commid,start,lastchange,totnum,outnum,
		       status,applname,xactname
		FROM spt_committab
	ELSE
		SELECT commid,start,lastchange,totnum,outnum,
		       status,applname,xactname
		FROM spt_committab
		WHERE @commid = commid
END
go
go
grant execute on sp_start_xact to public
go
grant execute on sp_commit_xact to public
go
grant execute on sp_abort_xact to public
go
grant execute on sp_remove_xact to public
go
grant execute on sp_stat_xact to public
go
grant execute on sp_probe_xact to public
go
grant execute on sp_scan_xact to public
go
/* commonkey 49.1 9/10/91 */
create procedure sp_commonkey 
@tabaname  varchar(92),		/* name of first table in the key */
@tabbname varchar(92),		/* name of second table in the key */
@col1a     varchar(30), 	/* first column name of first table */
@col1b     varchar(30), 	/* first column name of second table */
@col2a     varchar(30) = NULL,
@col2b     varchar(30) = NULL,
@col3a     varchar(30) = NULL,
@col3b     varchar(30) = NULL,
@col4a     varchar(30) = NULL,
@col4b     varchar(30) = NULL,
@col5a     varchar(30) = NULL,
@col5b     varchar(30) = NULL,
@col6a     varchar(30) = NULL,
@col6b     varchar(30) = NULL,
@col7a     varchar(30) = NULL,
@col7b     varchar(30) = NULL,
@col8a     varchar(30) = NULL,
@col8b     varchar(30) = NULL
as

declare @objida int		/* id of table we are doing */
declare @objidb int		/* id of table with primary key */
declare @uida smallint		/* owner of the first table */
declare @cnt    int		/* how many columns are in the key */

declare @key1a int		/* colids of the first table */
declare @key2a int
declare @key3a int
declare @key4a int
declare @key5a int
declare @key6a int
declare @key7a int
declare @key8a int

declare @key1b int		/* colids of the second table */
declare @key2b int
declare @key3b int
declare @key4b int
declare @key5b int
declare @key6b int
declare @key7b int
declare @key8b int

/*
**  Check to see that the tabnames are local.
*/
if @tabaname like "%.%.%"
begin
	if substring(@tabaname, 1, charindex(".", @tabaname) - 1) != db_name()
	begin
		print "Table or view name must be in 'current' database."
		return (1)
	end
end
if @tabbname like "%.%.%"
begin
	if substring(@tabbname, 1, charindex(".", @tabbname) - 1) != db_name()
	begin
		print "Table or view name must be in 'current' database."
		return (1)
	end
end

/*
**  See if we can find the objects.  They must be a system table, user table,
**  or view.  The low 3 bits of sysobjects.sysstat indicate what the 
**  object type is -- it's more reliable than using sysobjects.type which
**  could change.
*/
select @objida = id, @uida = uid
	from sysobjects
		where id = object_id(@tabaname)
			and (sysstat & 7 = 1		/* system table */
				or sysstat & 7 = 2	/* view */
				or sysstat & 7 = 3)	/* user table */
/*
**  If either of the tables don't exist, quit.
*/
if @objida is NULL
begin
    print "First table in the common key doesn't exist."
    return (1)
end 
select @objidb = id
	from sysobjects
		where id = object_id(@tabbname)
			and (sysstat & 7 = 1
				or sysstat & 7 = 2
				or sysstat & 7 = 3)
if @objidb is NULL
begin
    print "Second table in the common key doesn't exist."
    return (1)
end 

/*
**  Only the owner of the table can define it's common keys.
*/
if @uida != user_id()
begin
	print "Only the table owner may define its common keys."
	return (1)
end

/*
**  Now check to see that the first key columns exist and have compatible types.
*/
select @cnt = 1, @key1a = a.colid, @key1b = b.colid
	from syscolumns a, syscolumns b, master.dbo.spt_values y,
		master.dbo.spt_values z
		where a.name = @col1a
			and a.id = @objida
			and b.name = @col1b
			and b.id = @objidb
			and y.type = "J"
			and a.type = y.low
			and z.type = "J"
			and b.type = z.low
			and y.number = z.number
if @key1a = NULL
begin
	print "The tables have no such first column or the columns are of different types."
	return (1)
end

if @col2a != NULL
begin
	select @cnt = @cnt + 1, @key2a = a.colid, @key2b = b.colid
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
			where a.name = @col2a
				and a.id = @objida
				and b.name = @col2b
				and b.id = @objidb
				and y.type = "J"
				and a.type = y.low
				and z.type = "J"
				and b.type = z.low
				and y.number = z.number
	if @key2a = NULL
	begin
		print "The tables have no such second column or the columns are of different types."
		return (1)
	end
end
else goto keys_ok

if @col3a != NULL
begin
	select @cnt = @cnt + 1, @key3a = a.colid, @key3b = b.colid
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
			where a.name = @col3a
				and a.id = @objida
				and b.name = @col3b
				and b.id = @objidb
				and y.type = "J"
				and a.type = y.low
				and z.type = "J"
				and b.type = z.low
				and y.number = z.number
	if @key3a = NULL
	begin
		print "The tables have no such third column or the columns are of different types."
		return (1)
	end
end
else goto keys_ok

if @col4a != NULL
begin
	select @cnt = @cnt + 1, @key4a = a.colid, @key4b = b.colid
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
			where a.name = @col4a
				and a.id = @objida
				and b.name = @col4b
				and b.id = @objidb
				and y.type = "J"
				and a.type = y.low
				and z.type = "J"
				and b.type = z.low
				and y.number = z.number
	if @key4a = NULL
	begin
		print "The tables have no such fourth column or the columns are of different types."
		return (1)
	end
end
else goto keys_ok

if @col5a != NULL
begin
	select @cnt = @cnt + 1, @key5a = a.colid, @key5b = b.colid
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
			where a.name = @col5a
				and a.id = @objida
				and b.name = @col5b
				and b.id = @objidb
				and y.type = "J"
				and a.type = y.low
				and z.type = "J"
				and b.type = z.low
				and y.number = z.number
	if @key5a = NULL
	begin
		print "The tables have no such fifth column or the columns are of different types."
		return (1)
	end
end
else goto keys_ok

if @col6a != NULL
begin
	select @cnt = @cnt + 1, @key6a = a.colid, @key6b = b.colid
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
			where a.name = @col6a
				and a.id = @objida
				and b.name = @col6b
				and b.id = @objidb
				and y.type = "J"
				and a.type = y.low
				and z.type = "J"
				and b.type = z.low
				and y.number = z.number
	if @key6a = NULL
	begin
		print "The tables have no such sixth column or the columns are of different types."
		return (1)
	end
end
else goto keys_ok

if @col7a != NULL
begin
	select @cnt = @cnt + 1, @key7a = a.colid, @key7b = b.colid
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
			where a.name = @col7a
				and a.id = @objida
				and b.name = @col7b
				and b.id = @objidb
				and y.type = "J"
				and a.type = y.low
				and z.type = "J"
				and b.type = z.low
				and y.number = z.number
	if @key7a = NULL
	begin
		print "The tables have no such seventh column or the columns are of different types."
		return (1)
	end
end
else goto keys_ok

if @col8a != NULL
begin
	select @cnt = @cnt + 1, @key8a = a.colid, @key8b = b.colid
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
			where a.name = @col8a
				and a.id = @objida
				and b.name = @col8b
				and b.id = @objidb
				and y.type = "J"
				and a.type = y.low
				and z.type = "J"
				and b.type = z.low
				and y.number = z.number
	if @key8a = NULL
	begin
		print "The tables have no such eighth column or the columns are of different types."
		return (1)
	end
end

/*
**  If we made it this far then all the columns for the common key are ok.
**  Everything is consistent so add the common key to syskeys.
*/
keys_ok:

insert syskeys (id, type, depid, keycnt, size, key1, key2, key3, key4, key5,
	key6, key7, key8, depkey1, depkey2, depkey3, depkey4, depkey5,
	depkey6, depkey7, depkey8)
values (@objida, 3, @objidb, @cnt, 0, @key1a, @key2a, @key3a, @key4a, @key5a,
	@key6a, @key7a, @key8a, @key1b, @key2b, @key3b, @key4b, @key5b,
	@key6b, @key7b, @key8b)   

print "New common key added."

return (0)
go
grant execute on sp_commonkey to public
go
dump transaction master with truncate_only
go
/* configure 49.1 9/10/91 */
create procedure sp_configure
@configname varchar(20) = NULL,		/* option name to configure */
@configvalue int = NULL			/* configure value */
as

declare @confignum int			/* number of option to be configured */
declare @configcount int		/* number of options like @configname */

/*
**  If no option name is given, the procedure will just print out all the
**  options and their values.
*/
if @configname is NULL
begin
	select name, minimum = low, maximum = high,
		config_value = sysconfigures.value,
		run_value = syscurconfigs.value
	from spt_values, sysconfigures, syscurconfigs
		where type = "C"
			and number *= sysconfigures.config
			and number *= syscurconfigs.config
			and number >= 0

	return (0)
end

set nocount on

/*
**  Use @configname and try to find the right option.
**  If there isn't just one, print appropriate diagnostics and return.
*/
select @configcount = count(*)
 	   from spt_values
		where name like "%" + @configname + "%" and type = "C"
			and number >= 0

/*
**  If no option, show the user what the options are.
*/
if @configcount = 0
begin
	print "Configuration option doesn't exist."

	/*
	** Show the user what the options are.
	*/
	select name, minimum = low, maximum = high,
		config_value = sysconfigures.value,
		run_value = syscurconfigs.value
	from spt_values, sysconfigures, syscurconfigs
		where type = "C"
			and number *= sysconfigures.config
			and number *= syscurconfigs.config
			and number >= 0
	return (0)
end

/*
**  If more than one option like @configname, show the duplicates and return.
*/
if @configcount > 1
begin
	print "Configuration option is not unique."

	select duplicate_options = name
		from spt_values
			where name like "%" + @configname + "%"
				and type = "C"
				and number >= 0

	return (1)
end

/*
** If @configvalue is NULL, just show the current state of the option.
*/
if @configvalue = NULL
begin
	select name, minimum = low, maximum = high,
		config_value = sysconfigures.value,
		run_value = syscurconfigs.value
	from spt_values, sysconfigures, syscurconfigs
		where type = "C"
			and number *= sysconfigures.config
			and number *= syscurconfigs.config
			and name like "%" + @configname + "%"
			and number >= 0
	return (0)
end

/*
**  Only the SA can execute the update part of this procedure so check.
*/
if suser_id() != 1
begin
	print "Only the System Administrator (SA) may change configuration parameters."
	return (1)
end

/*
**  Now get the configuration number.
*/
select @confignum = number
	from spt_values
		where type = "C" and (@configvalue between low and high
			or @configvalue = 0)
			and name like "%" + @configname + "%"
			and number >= 0


/*
**  If this is the number of devices configuration parameter,
**  we want to make sure that it's not being set to lower than the
**  number of devices in sysdevices.
*/
if @confignum = 116
begin
	/*
	**  Get the max vdevno.
	*/
	declare @maxvdevno	int
	select @maxvdevno = max(convert(tinyint, substring(convert(binary(4),
		d.low), v.low, 1)))
	from master.dbo.sysdevices d, master.dbo.spt_values v
		where v.type = "E"
		and v.number = 3

	/*
	**  If @configvalue == 0, then set it to the current number of devices.
	*/
	if @configvalue = 0
	select @configvalue = @maxvdevno + 1
	if (select low
		from master.dbo.spt_values
			where type = "C"
				and number = 116) > @configvalue
	begin
		select @configvalue = low
			from master.dbo.spt_values
				where type = "C"
					and number = 116
	end

	if ((@maxvdevno + 1) > @configvalue)
	begin
		print "You can't set the number of devices to be smaller than the highest vdevno defined in sysdevices."
		return (1)
	end
end

/* 
**  If this is the number of default language, we want to make sure
**  that the new value is a valid language id in Syslanguages.
*/ 
if @confignum = 124
begin
	if not exists (select *
		from syslanguages
			where langid = @configvalue)   
	begin
		/* 0 is Sybase default language, us_english */
		if @configvalue != 0
		begin
			print "You can't set the default language to a language ID that is not defined in Syslanguages."
			return (1)
		end
	end
end

/*
**  Although the @configname is good, @configvalue wasn't in range.
*/
if @confignum is NULL
begin
	print "Configuration option value is not legal."
	return (1)
end

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	print "Can't run sp_configure from within a transaction."
	return (1)
end

/*
**  Now update sysconfigure.
*/
update sysconfigures
	set value = @configvalue
		where config = @confignum

print "Configuration option changed. Run the RECONFIGURE command to install."

return (0)
go
grant execute on sp_configure to public
go
/* dboption 49.1 9/10/91 */
create procedure sp_dboption
@dbname varchar(30) = NULL,		/* database name to change */
@optname varchar(20) = NULL,		/* option name to turn on/off */
@optvalue varchar(10) = NULL		/* true or false */
as

declare @dbid int			/* dbid of the database */
declare @dbuid int			/* id of the owner of the database */
declare @statvalue smallint		/* number of option */
declare @optcount int			/* number of options like @optname */

/*
**  If no @dbname given, just list the possible dboptions.
**  Only certain status bits may be set or cleared.  
**	   settable                	    not settable
**      ------------------------------  --------------------------
**	allow select into/bulkcopy (4)	load only (512)
**	read only (1024)		not recovered (256)
**	dbo use only (2048)		dbname has changed (16384)
**	single user (4096)		don't recover (32)
**	truncate log on checkpoint (8)
**	no checkpoint on recovery (16)
**      ALL SETTABLE OPTIONS (7196)
*/
if @dbname = null
begin
	print "Settable database options."
	select database_options = name
		from spt_values
			where type = "D"
				and number in (4, 8, 16, 1024, 2048, 4096, 7196)
				and number > 0
		order by name
	return (0)
end

/*
**  Verify the database name and get the @dbid and @dbuid
*/
select @dbid = dbid, @dbuid = suid
	from sysdatabases
		where name = @dbname

/*
**  If @dbname not found, say so and list the databases.
*/
if @dbid = NULL
begin
	print "No such database -- run sp_helpdb to list databases."
	return (1)
end

/*
**  You can not change any of the options in master.  If the user tries to
**  do so tell them they can't.
*/
if @dbid = 1
begin
	print "The 'master' database's options can not be changed."
	return (1)
end

/*
**  Check remaining parameters.
*/
if @optname is NULL or @optvalue not in ("true", "false") or @optvalue = null
begin
	print "usage: sp_dboption [dbname, optname, {true | false}]"
	return (1)
end

/*
**  Use @optname and try to find the right option.
**  If there isn't just one, print appropriate diagnostics and return.
*/
select @optcount = count(*)
 	   from spt_values
		where name like "%" + @optname + "%" and type = "D"
			and number in (4, 8, 16, 1024, 2048, 4096, 7196)

/*
**  If no option, show the user what the options are.
*/
if @optcount = 0
begin
	print "Database option doesn't exist or can't be set by user."
	print "Run sp_dboption with no parameters to see options."
	return (0)
end

/*
**  If more than one option like @optname, show the duplicates and return.
*/
if @optcount > 1
begin
	print "Database option is not unique."

	select duplicate_options = name
		from spt_values
			where name like "%" + @optname + "%"
				and type = "D"
				and number in (4, 8, 16, 1024, 2048, 4096, 7196)
				and number > 0

	return (1)
end

/*
**  Only the SA or the dbo of @dbnbame can execute the update part
**  of this procedure so check.  Also the sproc must be executed in the master
**  database.
*/
if suser_id() != 1 and suser_id() != @dbuid
begin
	print "Only the System Administrator (SA) or the owner of the database may set db options."
	return (1)
end
if db_name() != "master"
begin
	print "You must be in the 'master' database in order to change database options."
	return (1)
end

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	print "Can't run sp_dboption from within a transaction."
	return (1)
end

/*
**  Get the number which is the bit value to set
*/
select @statvalue = number
 	   from spt_values
		where name like "%" + @optname + "%" and type = "D"
			and number in (4, 8, 16, 1024, 2048, 4096, 7196)
			and number > 0


/*
**  Now update sysdatabases.
*/
if @optvalue = "true"
begin
	/*
	**  If this the option to make the database read only,
	**  we need to do some checking first.
	**  Unless it's the master db, no one can be using it.
	**  If it's the master db, only the SA may be using it.
	*/
	if (@statvalue = 1024) and (select count(*)
					from master.dbo.sysprocesses
						where dbid = @dbid) > 0
	begin
		print "The database is currently in use -- 'read only' option disallowed."
		return (1)
	end

	update sysdatabases
		set status = status | @statvalue
			where dbid = @dbid
end

/*
**  We want to turn it off.
*/
else
begin
	update sysdatabases
		set status = status & ~@statvalue
			where dbid = @dbid
end

/*
**  Advise the user to run the CHECKPOINT command in the database that
**  was changed.
*/
print "Run the CHECKPOINT command in the database that was changed."

return (0)
go
grant execute on sp_dboption to public
go
dump transaction master with truncate_only
go
/* defaultdb 49.1 9/10/91 */
create procedure sp_defaultdb
@loginame varchar(30),			/* login name of the user */
@defdb varchar(30) 			/* default db for the user */
as

declare @suid int		/* the suid to use to qualify the change */

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	print "Can't run sp_defaultdb from within a transaction."
	return (1)
end

/*
**  Check that the account exists.
*/
if not exists (select *
			from syslogins
		where name = @loginame)
begin
	print "No such login exists."
	return (1)
end

/*
**  Check that the database name is valid.
*/
if not exists (select *
			from sysdatabases
		where name = @defdb)
begin
	print "Database name not valid -- default not changed."
	return (1)
end

/*
**  Both the owner of the account (@loginame) and the SA can run this
**  command.  If the SA is running it, set @suid to the suid of @loginame.
*/
select @suid = suser_id()
if @suid = 1
begin
	/*
	**  Get the suid for @loginame.  We know it exists because we
	**  checked above.
	*/
	select @suid = suid
		from syslogins 
			where name = @loginame
end
			
/*
**  Change the database
*/
update syslogins
	set dbname = @defdb
		where suid = @suid
			and name = @loginame

/*
**  If nothing got updated then it means that the the user tried to change
**  someone else's default.
*/
if @@rowcount < 1
begin
	print "You can't change someone else's default database."
	return (1)
end

print "Default database changed."

return (0)
go
grant execute on sp_defaultdb to public
go
/* depends 49.1 9/10/91 */
create procedure sp_depends
@objname varchar(92)		/* the object we want to check */
as

declare @objid int			/* the id of the object we want */
declare @found_some bit			/* flag for dependencies found */

/*
**  Make sure the @objname is local to the current database.
*/
if @objname like "%.%.%" and
	substring(@objname, 1, charindex(".", @objname) - 1) != db_name()
begin
	print "Object must be in your current database."
	return (1)
end

/*
**  See if @objname exists.
*/
select @objid = object_id(@objname)
if @objid = null
begin
	print "No such object in the current database."
	return (1)
end

/*
**  Initialize @found_some to indicate that we haven't seen any dependencies.
*/
select @found_some = 0

set nocount on

/*
**  Print out the particulars about the local dependencies.
*/
if exists (select *
		from sysdepends
			where id = @objid)
begin
	print "Things the object references in the current database."
	select object = substring((s.name + "." + o.name), 1, 40),
		type = substring(v.name, 1, 16),
		updated = substring(u.name, 1, 7),
		selected = substring(w.name, 1, 8)
			from sysobjects o, master.dbo.spt_values v, sysdepends d,
				master.dbo.spt_values u, master.dbo.spt_values w,
				sysusers s
			where o.id = d.depid
				and o.sysstat & 7 = v.number and v.type = 'O'
				and u.type = 'B' and u.number = d.resultobj
				and w.type = 'B' and w.number = d.readobj
				and d.id = @objid
				and o.uid = s.uid
	select @found_some = 1
end

/*
**  Now check for things that the objects depends upon
*/
if exists (select *
		from sysdepends
			where depid = @objid)
begin
	print "Things inside the current database that reference the object."
	select distinct object = substring((s.name + "." + o.name), 1, 40),
		type = substring(v.name, 1, 16)
			from sysobjects o, master.dbo.spt_values v, sysdepends d,
				sysusers s
			where o.id = d.id
				and o.sysstat & 7 = v.number and v.type = 'O'
				and d.depid = @objid
				and o.uid = s.uid
	select @found_some = 1
end

/*
**  Did we find anything in sysdepends?
*/
if @found_some = 0
begin
	print "Object doesn't reference any object and no objects reference it."
end

set nocount off

return (0)
go
grant execute on sp_depends to public
go
dump transaction master with truncate_only
go
/* diskdefault 49.1 9/10/91 */
create procedure sp_diskdefault
@logicalname	varchar(30),		/* logical name of the device */
@defstatus	varchar(15)		/* turn on or off */
as

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	print "Can't run sp_diskdefault from within a transaction."
	return (1)
end

/*
**  Only the SA can run this sproc.
*/
if suser_id() != 1
begin
	print "Only the System Administrator (SA) may execute this procedure."
	return (1)
end

/*
**  Make sure that a device with @logicalname exists.
*/
if not exists (select *
		from master.dbo.sysdevices
			where name = @logicalname)
begin
	print "No such device exists."
	return (1)
end

/*
**  Make sure that is a database disk and not a dump device.
*/
if exists (select *
		from master.dbo.sysdevices
			where name = @logicalname 
				and status & 16 = 16)
begin
	print "The device name supplied is not a database disk."
	return (1)
end

if @defstatus = "defaulton"
begin
	update master.dbo.sysdevices
		set status = status | 1
			where name = @logicalname
	return (0)
end

if @defstatus = "defaultoff"
begin
	update master.dbo.sysdevices
		set status = status & ~1
			where name = @logicalname
	return (0)
end

/*
**  @defstatus must be "defaulton" or "defaultoff"
*/
print "Usage: sp_diskdefault logicalname {defaulton | defaultoff}."

return (1)
go
/* dropalias 49.1 9/10/91 */
create procedure sp_dropalias
@loginame varchar(30)		/* account name of the user with the alias */
as

/*
**  You must be SA or the dbo to execute this sproc.
*/
if suser_id() != 1 and user_id() != 1
begin
	print "You must be the System Administrator (SA) or the Database Owner (dbo) to execute this procedure."
	return (1)
end

/*
**  Check to make sure that the @loginame has an account.
*/
if (select suser_id(@loginame)) = NULL
begin
	print "No login with the specified name exists."
	return (1)
end

/*
**  Delete the alias, if any, from sysalternates.
*/
delete from sysalternates
	where suid = suser_id(@loginame)

/*
**  If nothing happened (rowcount = 0), there was no alias.
*/
if @@rowcount > 0
begin
	print "Alias user dropped."
	return (0)
end
else
begin
	print "No alias for specified user exists."
	return (1)
end

go
grant execute on sp_dropalias to public
go
dump transaction master with truncate_only
go
/* dropdevice	49.1	9/10/91 */
create procedure sp_dropdevice
@logicalname	varchar(30)		/* logical name of the device */
as

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	print "Can't run sp_dropdevice from within a transaction."
	return (1)
end

/*
**  Only the system administrator (SA) can run this command.
**  Check to make sure the executor is the sa.
*/
if suser_id() != 1
begin
	print "Only the System Administrator (SA) may execute this procedure."
	return (1)
end

/*
**  Check and make sure that the device actually exists.
*/
if not exists (select * 
		from master.dbo.sysdevices
			where name = @logicalname)
begin
	print "No such device exists -- use sp_helpdevice."
	return (1)
end

/*
**  Check and make sure that no database is using the device.
**  If so, print out who is using it and exit.
*/
if exists (select *
	from sysdatabases, sysusages, sysdevices, spt_values
		where sysdatabases.dbid = sysusages.dbid
			and segmap >= 0
			and sysdevices.low <= size + vstart
			and sysdevices.high >= size + vstart - 1
			and sysdevices.status & 2 = 2 
			and type = "S"
			and sysdevices.name = @logicalname)
begin
	print "Device is being used by a database. You can't drop it."

	select database_name = substring(sysdatabases.name, 1, 23),
		device = substring(sysdevices.name, 1, 21),
		size = convert(varchar(8), size / 500) + " MB",
		usage = spt_values.name
	from sysdatabases, sysusages, sysdevices, spt_values
		where sysdatabases.dbid = sysusages.dbid
			and segmap >= 0
			and sysdevices.low <= size + vstart
			and sysdevices.high >= size + vstart - 1
			and sysdevices.status & 2 = 2 
			and type = "S"
			and sysdevices.name = @logicalname
	order by sysdatabases.name, sysdevices.name, spt_values.name,
		size

	return (1)
end

/*
**  Everything's ok so drop the device.
*/
delete sysdevices
	where name = @logicalname

print "Device dropped."

return (0)
go
/* dropdumpdevice 49.1 9/10/91 */
create procedure sp_dropdumpdevice
@logicalname varchar(30)		/* name of device to drop */
as

/*
**  N.B.  This sproc is redundant due to the addition of sp_dropdevice.
**  	  However, it is still included in installmaster for backwards
**	  compatibility with existing programs.
*/

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	print "Can't run sp_dropdumpdevice from within a transaction."
	return (1)
end

/*
**  Only the system administrator (SA) can run this command.
**  Check to make sure the executor is the sa.
*/
if suser_id() != 1
begin
	print "Only the System Administrator (SA) may execute this procedure."
	return (1)
end

/*
**  Delete the device.  Only dump devices may be dropped.
*/
delete from master.dbo.sysdevices
	where name = @logicalname
		and status & 16 = 16

/*
** Check @@rowcount when it works
*/
if @@rowcount > 0
begin
	print "Device dropped."
	return (0)
end
else
begin
	/*
	**  Nothing happened because the device doesn't exist or isn't
	**  a dump device.
	*/
	if not exists (select *
			from sysdevices
				where name = @logicalname)
	begin
		print "No device with specified logical name exists."
	end
	else print "Device is not a dump device and may not be dropped."

	return (1)
end
go
dump transaction master with truncate_only
go
/* dropgroup 49.1 9/10/91 */
create procedure sp_dropgroup
@grpname varchar(30)		/* group to be dropped */
as

declare @gid int		/* group id of the group to be dropped */

/*
**  You must be SA or the dbo to execute this sproc.
*/
if suser_id() != 1 and user_id() != 1
begin
	print "You must be the System Administrator (SA) or the Database Owner (dbo) to execute this procedure."
	return (1)
end

/*
**  See if the group exists.
**  User ids are <= 16383 and group ids are > 16383.
*/
select @gid = uid
	from sysusers
		where name = @grpname
			and (uid > 16383 or uid = 0)

if @gid = NULL
begin
	print "No group with the specified name exists."
	return (1)
end

/*
**  Can't drop the group public.
*/
if @gid = 0
begin
	print "Can't drop the group 'public'."
	return (1)
end

/*
**  Check to see if the group owns anything.  If so, return.
*/
if exists (select *
		   from sysobjects
			   where uid = @gid)
begin
	print "You cannot drop group because it owns objects in database."

	/*
	**  Show what is owned by the group.
	*/
	select s.name, s.type, owner = u.name
		from sysobjects s, sysusers u
			where s.id = @gid
				and u.uid = @gid
	return (1)
end


/*
**  Check to see that nobody is in the group.  If so, return.
*/
if (select count(*)
	from sysusers
		where gid = @gid
			and uid <= 16383) != 0
begin
	print "Group has members.  It must be empty before it can be dropped."

	/*
	**  Show who is in the group.
	*/
	select name
		from sysusers
			where gid = @gid
				and uid <= 16383
	
	return (1)
end

/*
**  Drop the group.
**  Also drop any references to the group in the sysprotects table.
*/
begin transaction

	delete from sysusers
		where uid = @gid

	delete from sysprotects
		where uid = @gid

commit transaction

print "Group has been dropped."

return (0)
go
grant execute on sp_dropgroup to public
go
/* dropkey 49.1 9/10/91 */
create procedure sp_dropkey
@keytype varchar(10), 			/* type of key to drop */
@tabname varchar(92),			/* table with the key */
@deptabname varchar(92) = null		/* dependent table */
as

declare @id int				/* id of @tabname */
declare @uid smallint			/* owner of @tabname */
declare @depid int			/* id of related table */
declare @depuid smallint		/* owner of @related table */

/*
**  First make sure that the key type is ok.
*/
if @keytype not in ("primary", "foreign", "common")
begin
	print "Usage: sp_dropkey {primary | foreign | common}, tabname [,deptabname]."
	print "Type must be 'primary', 'foreign', or 'common'."
	return (1)
end

/*
**  Check to see that the tabname is local.
*/
if @tabname like "%.%.%"
begin
	if substring(@tabname, 1, charindex(".", @tabname) - 1) != db_name()
	begin
		print "Table or view name must be in 'current' database."
		return (1)
	end
end
if @deptabname like "%.%.%"
begin
	if substring(@deptabname, 1, charindex(".", @deptabname) - 1) != db_name()
	begin
		print "Table or view name must be in 'current' database."
		return (1)
	end
end

/*
**  Get the ids of the @tabname and @deptabname.
*/
select @id = id, @depid = object_id(@deptabname), @uid = uid
		from sysobjects
			where id = object_id(@tabname)
if @id = null
begin
	print "The table or view named doesn't exist in the current database."
	return (1)
end

if @uid != user_id()
begin
	print "You must be the owner of the table or view to drop its key."
	return (1)
end

/*
**  If primary key, just drop it.
*/
if @keytype = "primary"
begin
	delete from syskeys
		where id = @id
			and type = 1

	if @@rowcount = 0
	begin
		print "No primary key for the table or view exists."
		return (1)
	end

	else
	begin
		print "Primary key for the table or view dropped."
	end

	/*
	**  Check to see if there are any foreign keys dependent on the
	**  primary key.  If so -- drop them.
	*/
	delete from syskeys
		where depid = @id
			and type = 2
	
	if @@rowcount != 0
	begin
		print "Dependent foreign keys were also dropped."
	end

	return (0)
end

/*
**  It's either a foreign or common key so we need to verify the
**  existence of the @deptabname.
*/
if @depid = null
begin
	/*
	**  Was the @deptabname supplied?
	*/
	if @deptabname = null
	begin
		print "You need to supply the dependent table or view as the third parameter."
		return (1)
	end

	/*
	**  It was supplied but it doesn't exist.
	*/
	print "The dependent table or view doesn't exist in the current database."
	return (1)
end


/*
**  If foreign key, get rid of it.
*/
if @keytype = "foreign"
begin
	/*
	**  Get rid of the foreign key entry.
	*/
	delete from syskeys
		where type = 2
			and id = @id
			and depid = @depid
	if @@rowcount = 0
	begin
		print "No foreign key for the table or view exists."
		return (1)
	end

	print "Foreign key dropped."

	return (0)
end

/*
**  Key type must be common so just get rid of the common keys
**  with the right ids and depids.  Since whenever a common key is defined
**  it is added to both of the tables involved, we'll get rid of both of
**  those entries.
*/
delete from syskeys
	where type = 3
		and id = @id
		and depid = @depid

if @@rowcount = 0
begin
	print "No common keys exist between the two tables or views supplied."
	return (1)
end

/*
**  Now get rid of the inverse common key entries.
*/
delete from syskeys
	where type = 3
		and id = @depid
		and depid = @id

print "Common keys dropped."

return (0)
go
grant execute on sp_dropkey to public
go
dump transaction master with truncate_only
go
/* droplogin 49.1 9/10/91 */
create procedure sp_droplogin
@loginame varchar(30)			/* name of login to drop */
as

/*
**  This procedure makes a weak attempt to check for any dependencies.
**  It looks in the current database to see if the suid is used in
**  sysusers or sysalternates.  If so, a diagnostic is issued and the
**  login is not dropped.
**
**  Ideally, this procedure should check each database to see if the login
**  is a user.  However, this is not yet possible since procedures do not
**  allow parameters to be used for database or table names.
*/

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	print "Can't run sp_droplogin from within a transaction."
	return (1)
end

/*
**  Only the system administrator (SA) can run this command.
**  Check to make sure the executor is the sa.
*/
if suser_id() != 1
begin
	print "Only the System Administrator (sa) may execute this procedure."
	return (1)
end

/*
**  Check sysusers.
*/
if exists (select *
		from sysusers
			where suid = suser_id(@loginame))
begin
	print "User exists in current database.  Drop user before dropping login."
	select database_name = db_name(), login_name = @loginame,
		name_in_database = name
			from sysusers where suser_id(@loginame) = suid
	return (1)
end

/*
**  Check sysalternates.
*/
if exists (select *
		from sysalternates
			where suid = suser_id(@loginame))
begin
	print "User exists as an alias in current database.  Drop alias before dropping login."
	select database_name = db_name(), login_name = @loginame,
		name_in_database = u.name
			from sysusers u, sysalternates a
				where suser_id(@loginame) = a.suid
					and a.altsuid = u.suid
	return (1)
end

/*
**  Delete the login.
*/
delete from syslogins
	where name = @loginame

/*
** Check @@rowcount when it works
*/
if @@rowcount > 0
begin
	print "Login dropped."
	return (0)
end
else
begin
	print "No login exists with supplied name."
	return (1)
end
go
/* droptype 49.1 9/10/91 */
create procedure sp_droptype
@typename varchar(30)			/* the user type to drop */
as

declare @typeid smallint		/* the typeid of the usertype to drop */

/*
**  Initialize @typeid so we can tell if we can't find it.
*/
select @typeid = 0

/*
**  Find the user type with @typename.  It must be a user type (usertype > 99)
**  and it must be owned by the person (or dbo) running the procedure.
*/
select @typeid = usertype
	from systypes
		where (uid = user_id() or user_id() = 1)
			and name = @typename
			and usertype > 99

if @typeid = 0
begin
	print "The type doesn't exist or you don't own it."
	return (1)
end

/*
**  Check to see if the type is being used.  If it is, it can't be dropped.
*/
if exists (select *
		   from syscolumns
			   where usertype = @typeid)
begin
	print "Type is being used. You cannot drop it."

	/*
	**  Show where it's being used.
	*/
	select object = o.name, type = o.type, owner = u.name, column = c.name,
		datatype = t.name
	from syscolumns c, systypes t, sysusers u, sysobjects o
		where c.usertype = @typeid
			and t.usertype = @typeid
			and o.uid = u.uid
			and c.id = o.id
	order by object, column

	return (1)
end

/*
**  Everything is consistent so drop the type.
*/
delete from systypes
	where usertype = @typeid

print "Type has been dropped."

return (0)
go
grant execute on sp_droptype to public
go
dump transaction master with truncate_only
go
/* dropuser 49.1 9/10/91 */
create procedure sp_dropuser
@name_in_db varchar(30)			/* user name to drop */
as

declare @suid int			/* suid of the user */
declare @uid int			/* uid of the user */
declare @objectcount int		/* count of objects user owns */
declare @typecount int			/* count of types user owns */
declare	@userdropped int		/* flag to indicate user was dropped */

/*
**  You must be SA or the dbo to execute this sproc.
*/
if suser_id() != 1 and user_id() != 1
begin
	print "You must be the System Administrator (SA) or the Database Owner (dbo) to execute this procedure."
	return (1)
end

/*
**  See if the user exists in the database.
**  User ids are <= 16383 and group ids are > 16383.
*/
select @uid = uid, @suid = suid
	from sysusers
		where name = @name_in_db
			and uid <= 16383 and uid > 0

/*
**  No such user so return.
*/
if @uid = NULL
begin
	print "No user exists with the supplied name."
	return (1)
end

/*
**  Big trouble if dbo is dropped so check. Only check if uid = 1 is not enough,
**  since if SA drops a user in master database, uid is not equal to 1, but the
**  user could be the dbo of the other database(s). So check to see whether suid
**  in sysdatabases.
*/
if exists (select * from sysdatabases 
		where suid = @suid) 
begin
	print "You cannot drop the 'database owner'."
	return (1)
end

/*
**  Trouble if guest gets dropped from master or tempdb, so check.
*/
if (@name_in_db = "guest" and (db_id() = 1 or db_id() = 2))
begin
	print "You cannot drop the 'guest' user from master or tempdb."
	return(1)
end

/*
**  If the user owns any objects or datatypes and we're not
**  forcing the drop, return without doing anything.
*/
select @objectcount = count(*)
	   from sysobjects
		   where uid = @uid
select @typecount = count(*)
	from systypes
		where uid = @uid

if @objectcount > 0 or @typecount > 0
begin
	if @objectcount > 0
	begin
		print "You cannot drop user because he or she owns objects in database."
		select name, type
			from sysobjects
				where uid = @uid
	end

	if @typecount > 0
	begin
		print "You cannot drop user because he or she owns types in database."
		select user_type = a.name, physical_type = b.name
			from systypes a, systypes b
				where a.uid = @uid
					and a.type = b.type
					and b.usertype < 100
	end

	return (1)
end


/*
**  Drop the user.
**  Also drop any references to the user in the sysprotects table.
**  If anyone is aliased to the user, drop them also.
*/
begin transaction

	delete from sysusers
		where suid = @suid
	select @userdropped = @@rowcount

	delete from sysprotects
		where uid = @uid

	/*
	**  Drop any dependent aliases.
	*/
	if exists (select *
			from sysalternates
				where altsuid = @suid)
	begin
		delete from sysalternates
			where altsuid = @suid

		print "The dependent aliases were also dropped."
	end

if @userdropped = 1
	commit transaction
else rollback transaction

print "User has been dropped from current database."

return (0)
go
grant execute on sp_dropuser to public
go
/* dropremotelogin 49.1 9/10/91 */
create procedure sp_dropremotelogin
@remoteserver	varchar(30),		/* name of remote server */
@loginame varchar(30) = NULL,		/* user's remote name */
@remotename varchar(30) = NULL		/* user's local user name */
as

declare	@msg	varchar(250)
declare @suid	smallint

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	print "Can't run sp_dropremotelogin from within a transaction."
	return (1)
end

/*
**  If @loginame is NULL then we want to set @suid = -1. Otherwise get
**  it real value.
*/
if @loginame = null
	select @suid = -1
else select @suid = suser_id(@loginame)

/*
**  Delete the remote login.
*/
delete master.dbo.sysremotelogins
	from master.dbo.sysremotelogins l, master.dbo.sysservers s
	where l.remoteserverid = s.srvid
		and s.srvname = @remoteserver
		and l.remoteusername = @remotename
		and l.suid = @suid

/*
** Check @@rowcount when it works
*/
if @@rowcount > 0
begin
	print "Remote login dropped."
	return (0)
end
else
begin
	select @msg = "There is no remote user '" + isnull(@remotename, "NULL")
		+ "' mapped to local user '" + isnull(@loginame, "NULL")
		+ "' from the remote server '" + @remoteserver + "'."
	print @msg
	return (1)
end
go
dump transaction master with truncate_only
go
/* dropsegment	49.1	9/10/91 */
create procedure sp_dropsegment
@segname	varchar(30),		/* segment name */
@device		varchar(30) = null	/* device name */
as

declare @dbuid	smallint	/* id of the owner of the database */
declare @segbit	int		/* this is the bit to turn on in sysusages */
declare	@msg	varchar(200)

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	print "Can't run sp_dropsegment from within a transaction."
	return (1)
end

/*
**  You must be SA or the dbo to execute this sproc.
*/
if suser_id() != 1 and user_id() != 1
begin
	print "You must be the System Administrator (SA) or the Database Owner (dbo) to execute this procedure."
	return (1)
end

/*
**  There are two drop cases:
**	1) dropping the segment
**	2) dropping a segment reference to a device
**  The sproc does things differently depending on which we're doing.
*/

/*
**  Check to see if the segment exists.
*/
if not exists (select *
		from syssegments
			where name = @segname)
begin
	select @msg = "There is no such segment as '" + @segname + "'."
	print @msg
	return (1)
end

/*
**  Get the segment number of @segname.
*/
select @segbit = segment
	from syssegments 
		where name = @segname

/*
**  Now convert the segment number to the right bit for segmap.
*/
if (@segbit < 31)
	select @segbit = power(2, @segbit)
else
	/*
	**  Since this is segment 31, power(2, 31) will overflow
	**  since segmap is an int.  We'll grab the machine-dependent
	**  bit mask from spt_values to clear the right bit.
	*/
	select @segbit = low
		from master.dbo.spt_values
			where type = "E"
				and number = 2

/*
**  Don't allow the segments 'default', 'system', or 'logsegment' to
**  be dropped completely.
*/
if @segname in ("system", "default", "logsegment")
begin
	if @device = null
	begin
		select @msg = "Can't drop the '" + @segname
			+ "' segment completely."
		print @msg
		return (1)
	end

	/*
	**  For the case where we are dropping the logsegment from a 
	**  device, the logic below works OK.  If this is the last
	**  device for the the segment, it won't let the segment be
	**  dropped.
	*/
end


/*
**  If we are dropping the segment, check to see that the segment isn't
**  being used by anyone.
*/
if @device = null
begin

	/*
	**  Check to see if the segment is being used.
	*/
	if exists (select *
			from sysindexes i, syssegments s
				where s.name = @segname
					and i.segment = s.segment)
	begin
		select @msg = "The segment '" + @segname + "' is being used."
		print @msg
		return (1)
	end
end

/*
**  If we are dropping the segment reference, check to see that arguments are
**  reasonable.
*/
if @device != null
begin
	/*
	**  Now see if the database even uses the @device
	*/
	if not exists (select *
			from sysusages u, sysdevices d
				where d.name = @device
					and u.vstart between d.low and d.high
					and u.dbid = db_id())
	begin
		select @msg = "The device '" + @device
			+ "' is not used by the database."
		print @msg
		return (1)
	end

	/*
	**  Now check that the segment references the device.
	*/
	if not exists (select *
			from master.dbo.sysusages u, master.dbo.sysdevices d
				where u.segmap & @segbit = @segbit
				and d.name = @device
				and d.low <= u.size + u.vstart
				and d.high >= u.size + u.vstart - 1 
				and u.dbid = db_id()
				and d.status & 2 = 2)
	begin
		select @msg = "Segment '" + @segname 
			+ "' does not reference device '" + @device + "'."
		print @msg
		return (1)
	end
	/*
	**  Now check to see if this is the last unique device reference for the
	**  segment.  If it is then we don't want to drop the reference.
	*/
	select distinct d.name into #temptable
		from master.dbo.sysusages u, master.dbo.sysdevices d
			where u.segmap & @segbit = @segbit
				and d.low <= u.size + u.vstart
				and d.high >= u.size + u.vstart - 1
				and u.dbid = db_id()
				and d.status & 2 = 2

	if (select count(*) from #temptable) <= 1
	begin
		select @msg = "There is only one unique device mapping for the segment '"
			+ @segname + "' -- use sp_dropsegment with no device argument."
		print @msg
		return (1)
	end

	drop table #temptable
end

/*
**  If we're dropping the segment, go ahead drop the segment and
**  clear its bit in sysusages.
*/
if @device = null
begin
	/*
	**  NOTE: Don't update master..sysusages and syssegments as a xact since
	**  	it could cause problems for recovery.
	*/

	delete syssegments
		where name = @segname

	/*
	**  Now clear the segment from device in sysusages.
	*/
	update master.dbo.sysusages
		set segmap = segmap & (~@segbit)
			from master.dbo.sysusages u, master.dbo.sysdevices d
				where d.low <= u.size + u.vstart
					and d.high >= u.size + u.vstart - 1
					and u.dbid = db_id()
					and d.status & 2 = 2
end

/*
**  We want to just clear the segment reference from the device.
*/
else
begin
	update master.dbo.sysusages
		set segmap = segmap & (~@segbit)
			from master.dbo.sysusages u, master.dbo.sysdevices d
				where d.low <= u.size + u.vstart
					and d.high >= u.size + u.vstart - 1
					and u.dbid = db_id()
					and d.status & 2 = 2
					and d.name = @device

end

/*
**  Now we need to activate the new segment map.
*/
declare @dbname	varchar(30)
select @dbname = db_name()
dbcc dbrepair (@dbname, remap)

if @device = null
	print "Segment dropped."
else print "Segment reference to device dropped."

/*
**  If there are no more segment references to the device,
**  print a warning.
*/
if exists (select *
		from master.dbo.sysusages
			where segmap = 0
				and dbid = db_id())
begin
	declare @nosegs	varchar(255),	/* list of unreferenced devices */
		@curdevice	varchar(30),
		@i	int
	
	select @curdevice = min(d.name)
		from master.dbo.sysusages u, master.dbo.sysdevices d
			where d.low <= u.size + u.vstart
				and d.high >= u.size + u.vstart - 1
				and u.dbid = db_id()
				and d.status & 2 = 2
				and segmap = 0
	select @nosegs = @curdevice, @i = 1
	while (@curdevice != null)
	begin
		select @curdevice = min(d.name)
			from master.dbo.sysusages u, master.dbo.sysdevices d
				where d.low <= u.size + u.vstart
					and d.high >= u.size + u.vstart - 1
					and u.dbid = db_id()
					and d.status & 2 = 2
					and segmap = 0
					and d.name > @curdevice
		if @curdevice != null
		begin
			select @nosegs = @nosegs + ", " + @curdevice
			select @i = @i + 1
		end
	end

	/*
	**  Get the device names.
	*/
	select @msg =  "WARNING: There are no longer any segments referencing "
	if @i > 1
		select @msg = @msg + "devices '"
	else select @msg = @msg + "device '"
	select @msg = @msg + @nosegs + "'. "
	if @i > 1
		select @msg = @msg + "These devices "
	else select @msg = @msg + "This device "
	select @msg = @msg + "will no longer be used for space allocation."
	print @msg
end
return (0)
go
grant execute on sp_dropsegment to public
go
/* dropserver	49.1	9/10/91 */
create procedure sp_dropserver
@server	varchar(30),			/* server name */
@droplogins	char(10) = NULL		/* drop all related logins? */
as

declare	@msg	varchar(200)

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	print "Can't run sp_dropserver from within a transaction."
	return (1)
end

/*
**  Check to see if the server exists.
*/
if not exists (select *
		from master.dbo.sysservers
			where srvname = @server)
begin
	select @msg = "There is no such server as '" + @server + "'."
	print @msg
	return (1)
end

/*
**  Check to see if there are any related logins in sysremotelogins.
*/
if @droplogins = NULL
begin
	if exists (select *
			from master.dbo.sysremotelogins l,
				master.dbo.sysservers s
			where s.srvid = l.remoteserverid
				and s.srvname = @server)
	begin
		select @msg = "There are still remote logins for the server '"
			+ @server + "'."
		print @msg
		return (1)
	end
end

/*
**  If @droplogins is true then drop any associated logins
*/
else if @droplogins = "droplogins"
begin
	begin transaction dropserver

		delete master.dbo.sysremotelogins
			from master.dbo.sysremotelogins l,
				master.dbo.sysservers s
			where s.srvid = l.remoteserverid
				and s.srvname = @server
		if @@rowcount > 0
		begin
			select @msg = "Remote logins for remote server '"
				+ @server + "' have been dropped."
			print @msg
		end

		delete master.dbo.sysservers
			where srvname = @server

		print "Server dropped."

	commit transaction dropserver

	return (0)
end

/*
**  Bad argument to @droplogins.
*/
else
begin
	print "Usage: sp_dropserver server [, droplogins]"
	return (1)
end
		
/*
**  Drop the server.
*/
delete master.dbo.sysservers
	where srvname = @server

print "Server dropped."

return (0)
go
dump transaction master with truncate_only
go
/* extendsegment	49.1	9/10/91 */
create procedure sp_extendsegment
@segname	varchar(30),	/* segment name */
@devname	varchar(30)	/* device name to put segment on */
as

declare @dbuid	smallint	/* id of the owner of the database */
declare @segbit	int		/* this is the bit to turn on in sysusages */
declare	@msg	char(100)
declare @retcode	int

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	print "Can't run sp_extendsegment from within a transaction."
	return (1)
end

/*
**  You must be SA or the dbo to execute this sproc.
*/
if suser_id() != 1 and user_id() != 1
begin
	print "You must be the System Administrator (SA) or the Database Owner (dbo) to execute this procedure."
	return (1)
end

/*
**  Check to see if the segment exists.
*/
if not exists (select *
		from syssegments
			where name = @segname)
begin
	select @msg = "There is no such segment as '" + @segname + "'."
	print @msg
	return (1)
end

/*
**  See if the device exists.
*/
if not exists (select *
		from master.dbo.sysdevices
			where name like @devname)
begin
	print "No such device exists -- run sp_helpdb to list the devices for the current database."
	return (1)
end

/*
**  Now see if the @dbname uses the @devname
*/
if not exists (select *
		from master.dbo.sysusages u, master.dbo.sysdevices d
			where d.name = @devname
				and u.vstart between d.low and d.high
				and u.dbid = db_id())
begin
	print "The specified device is not used by the database."
	return (1)
end

/*
**  Check to see if the device is marked as a log device.
**  If so, print error.
*/
if exists (select *
		from master.dbo.sysusages u, master.dbo.sysdevices d
			where d.name = @devname
				and u.vstart between d.low and d.high
				and u.dbid = db_id()
				and segmap = 4)
begin
	select @msg = "'" + @devname + "' is reserved exclusively as a log device."
	print @msg
	return (1)
end

/*
** Check for valid identifier.
*/
execute @retcode = sp_validname @segname
if (@retcode != 0)
begin
	select @msg = "'" + @segname + "' is not a valid identifier."
	print @msg
	return (1)
end

/*
**  Now go ahead and define the new segment and add it to the segmap
**  of sysusages.
**  NOTE: Don't update master..sysusages and syssegments as a xact since
**  	it could cause problems for recovery.
*/

/*
**  Get the segment number for @segname.
*/
select @segbit = segment
	from syssegments
		where name = @segname

/*
**  If @segbit is 2 then it's the logsegment and the logsegment
**  doesn't share devices with other segments.  In this case,
**  don't OR the @segbit in but just set segmap to 4.
*/
if @segbit = 2
begin
	update master.dbo.sysusages
		set segmap = 4
			from master.dbo.sysusages u,
				master.dbo.sysdevices d
			where d.name = @devname
				and u.vstart between d.low and d.high
				and u.dbid = db_id()
end

else
begin
	if (@segbit < 31)
		select @segbit = power(2, @segbit)
	else
		/*
		**  Since this is segment 31, power(2, 31) will
		**  overflow since segmap is an int.  We'll grab the
		**  machine-dependent bit mask from spt_values to set
		**  the right bit.
		*/
		select @segbit = low
			from master.dbo.spt_values
				where type = "E"
					and number = 2
	/*
	**  Add the segment to @devname in sysusages.
	*/
	update master.dbo.sysusages
		set segmap = segmap | @segbit
			from master.dbo.sysusages u,
				master.dbo.sysdevices d
			where d.name = @devname
				and u.vstart between d.low and d.high
				and u.dbid = db_id()
end

/*
**  Now we need to activate the new segment map.
*/
declare @dbname	varchar(30)
select @dbname = db_name()
dbcc dbrepair (@dbname, remap)
print "Segment extended."

/*
**  Get the segment number for @segname.
*/
select @segbit = segment
	from syssegments
		where name = @segname
/*
**  If we are extending the logsegment, print out a message about what it
**  means to do so.
*/
if @segbit = 2
begin
	select @msg = "Device '" + @devname + "' is now exclusively used by '"
		+ @segname + "'."
	print @msg
end

return (0)
go
grant execute on sp_extendsegment to public
go
/* fixindex 49.1 9/10/91 */
create procedure sp_fixindex
		@dbname		varchar(30),
		@tabname	varchar(30),  		/* system table name */
		@indid		int			/* index id value    */
as
	/*
	**	Description:	allow the SA to force a drop and then a
	**			create index on system catalogs.
	**
	**	Usage:		sp_fixindex  database, systemcatalog, ind_id
	**
	**	Note:		before using this procedure the database has to
	**			be in single user mode. The sp_dboption has to
	**			be used for user databases, and update of
	**			sysdatabases for master.
	**	
	**	History:	3/28/88		(robbie)
	*/

	declare	@ramboix smallint			/* mask for rambo indx*/
	declare @badlist  varchar(255)   /* name list of all tables that should
					      not have any indexes on them */
	/*
	**	Initialize name lists. These will be used in catching
	**	any attempts to fix indexes on fake tables or tables
	**	that have no indexes on them.
	*/
	select @badlist = "syslocks, sysprocesses, syscurconfig, 
			   syssegments, syslogckp"

	/*
	**	Make sure we are "fixing" a system catalog.
	*/
	if @tabname NOT LIKE  "sys%"
	begin
		print "Procedure should be used on system tables only."
		return (1)
	end

	/*
	**	Make sure that we are doing this on somenthing that 
	**	has indexes (or real tables).
	*/
	if @badlist LIKE  "%" + @tabname + "%"
	begin
		print "Cannot re-create index on this table."
		return (1)
	end

	/*
	**	At this point we are sure that the table has an index
	**	of requested type, so all there is to be done is to
	**	set the ramboix bit for this object unless we try to
	**	fix Sysobjects.
	*/
	if @tabname != "sysobjects"
	begin
		/* Use decimal integer equivalent of hex 1000 to avoid
		** byte order issues.
		*/
		select @ramboix = 4096
		update sysobjects set sysstat = sysstat | @ramboix
		where name = @tabname

		checkpoint
	end

	/*
	**	Call dbcc to do the job.
	*/
	dbcc dbrepair(@dbname, REPAIRINDEX, @tabname, @indid)

	/*
	**	Processing successfully done, so turn off the ramboix
	**	bit if not sysobjects, and tell the user that all is fine.
	*/
	if @tabname != "sysobjects"
	begin
		update sysobjects set sysstat = sysstat & ~@ramboix
		where name = @tabname
	 
		checkpoint
	end

	return (0)
go
dump transaction master with truncate_only
go
/* foreignkey	49.1	9/10/91 */
create procedure sp_foreignkey 
@tabname  varchar(92),		/* name of table that we are doing */
@pktabname varchar(92),		/* name of table with primary key */
@col1     varchar(30), 		/* column name of table we are doing */
@col2     varchar(30) = NULL,
@col3     varchar(30) = NULL,
@col4     varchar(30) = NULL,
@col5     varchar(30) = NULL,
@col6     varchar(30) = NULL,
@col7     varchar(30) = NULL,
@col8     varchar(30) = NULL
as

declare @objida int		/* id of table we are doing */
declare @objidb int		/* id of table with primary key */
declare @uid smallint		/* id of owner of the talbe */
declare @cnt    int		/* how many columns are in foreign key */

declare @pkey1 int		/* colids of the foreign key */
declare @pkey2 int
declare @pkey3 int
declare @pkey4 int
declare @pkey5 int
declare @pkey6 int
declare @pkey7 int
declare @pkey8 int

declare @fkey1 int		/* colids of the primary key */
declare @fkey2 int
declare @fkey3 int
declare @fkey4 int
declare @fkey5 int
declare @fkey6 int
declare @fkey7 int
declare @fkey8 int

/*
**  Check to see that the tabname is local.
*/
if @tabname like "%.%.%"
begin
	if substring(@tabname, 1, charindex(".", @tabname) - 1) != db_name()
	begin
		print "Table or view name must be in 'current' database."
		return (1)
	end
end
if @pktabname like "%.%.%"
begin
	if substring(@pktabname, 1, charindex(".", @pktabname) - 1) != db_name()
	begin
		print "Table or view name must be in 'current' database."
		return (1)
	end
end

/*
**  See if we can find the objects.  They must be a system table, user table,
**  or view.  The low 3 bits of sysobjects.sysstat indicate what the 
**  object type is -- it's more reliable than using sysobjects.type which
**  could change.
*/
select @objida = id, @uid = uid
	from sysobjects
		where id = object_id(@tabname)
			and (sysstat & 7 = 1		/* system table */
				or sysstat & 7 = 2	/* view */
				or sysstat & 7 = 3)	/* user table */
/*
**  If either of the tables don't exist, quit.
*/
if @objida is NULL
begin
    print "Foreign key table doesn't exist."
    return (1)
end 
select @objidb = id
	from sysobjects
		where id = object_id(@pktabname)
			and (sysstat & 7 = 1
				or sysstat & 7 = 2
				or sysstat & 7 = 3)
if @objidb is NULL
begin
    print "Primary key table doesn't exist."
    return (1)
end 

/*
**  Only the owner of the table can define it's foreign keys.
*/
if @uid != user_id()
begin
	print "Only the owner of the table may define a foreign key."
	return (1)
end

/*
**  Now check to see that the foreign key columns exist.
*/
select @cnt = 1, @fkey1 = colid
	from syscolumns
		where name = @col1 
			and id = @objida
if @fkey1 = NULL
begin
	print "The table has no such first column."
	return (1)
end

if @col2 != NULL
begin
	select @cnt = @cnt + 1, @fkey2 = colid
		from syscolumns
			where name = @col2 
				and id = @objida
	if @fkey2 is NULL
	begin
		print "The table has no such second column."
		return (1)
	end
end
else goto foreign_ok

if @col3 != NULL
begin
	select @cnt = @cnt + 1, @fkey3 = colid
		from syscolumns
			where name = @col3 
				and id = @objida
	if @fkey3 is NULL
	begin
		print "The table has no such third column."
		return (1)
	end
end
else goto foreign_ok

if @col4 != NULL
begin
	select @cnt = @cnt + 1, @fkey4 = colid
		from syscolumns
			where name = @col4 
				and id = @objida
	if @fkey4 is NULL
	begin
		print "The table has no such fourth column."
		return (1)
	end
end
else goto foreign_ok

if @col5 != NULL
begin
	select @cnt = @cnt + 1, @fkey5 = colid
		from syscolumns
			where name = @col5 
				and id = @objida
	if @fkey5 is NULL
	begin
		print "The table has no such fifth column."
		return (1)
	end
end
else goto foreign_ok

if @col6 != NULL
begin
	select @cnt = @cnt + 1, @fkey6 = colid
		from syscolumns
			where name = @col6 
				and id = @objida
	if @fkey6 is NULL
	begin
		print "The table has no such sixth column."
		return (1)
	end
end
else goto foreign_ok

if @col7 != NULL
begin
	select @cnt = @cnt + 1, @fkey7 = colid
		from syscolumns
			where name = @col7 
				and id = @objida
	if @fkey7 is NULL
	begin
		print "The table has no such seventh column."
		return (1)
	end
end
else goto foreign_ok

if @col8 != NULL
begin
	select @cnt = @cnt + 1, @fkey8 = colid
		from syscolumns
			where name = @col8 
				and id = @objida
	if @fkey8 is NULL
	begin
		print "The table has no such eighth column."
		return (1)
	end
end


/*
**  If we made it this far then all the columns for the foreign key are ok.
*/
foreign_ok:

/*
**  Now let's check out the primary key that the foreign key is on.
**  There must be the same number of columns in the key and the
**  base types of the columns must agree.
*/
select @pkey1 = key1, @pkey2 = key2, @pkey3 = key3, @pkey4 = key4,
	@pkey5 = key5, @pkey6 = key6, @pkey7 = key7, @pkey8 = key8
		from syskeys
	where id = @objidb
		and type = 1
		and keycnt = @cnt

/*
**  If @pkey1 is null then there is no such primary key or the number of
**  columns in the primary key are not the same as the number of columns
**  in the foreign key.
*/
if @pkey1 = NULL
begin
	if exists (select *
			from syskeys
		where id = @objidb
			and type = 1)
	begin
		print "Primary key does not exist with the same number of columns as the foreign key."
	end
	else
	begin
		print "Primary key does not exist."
	end
	return (1)
end

/*
**  Since we have the right number of columns in the foreign and primary keys,
**  check that there base datatypes agree.
*/
if not exists (select *
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
		where a.colid = @fkey1
			and a.id = @objida
			and b.colid = @pkey1
			and b.id = @objidb
			and y.type = "J"
			and a.type = y.low
			and z.type = "J"
			and b.type = z.low
			and y.number = z.number)
begin
	print "Datatypes of the first column in the keys are different."
	return (1)
end

if @fkey2 != NULL and not exists (select *
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
		where a.colid = @fkey2
			and a.id = @objida
			and b.colid = @pkey2
			and b.id = @objidb
			and y.type = "J"
			and a.type = y.low
			and z.type = "J"
			and b.type = z.low
			and y.number = z.number)
begin
	print "Datatypes of the second column in the keys are different."
	return (1)
end
else goto doinsert

if @fkey3 != NULL and not exists (select *
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
		where a.colid = @fkey3
			and a.id = @objida
			and b.colid = @pkey3
			and b.id = @objidb
			and y.type = "J"
			and a.type = y.low
			and z.type = "J"
			and b.type = z.low
			and y.number = z.number)
begin
	print "Datatypes of the third column in the keys are different."
	return (1)
end
else goto doinsert

if @fkey4 != NULL and not exists (select *
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
		where a.colid = @fkey4
			and a.id = @objida
			and b.colid = @pkey4
			and b.id = @objidb
			and y.type = "J"
			and a.type = y.low
			and z.type = "J"
			and b.type = z.low
			and y.number = z.number)
begin
	print "Datatypes of the fourth column in the keys are different."
	return (1)
end

if @fkey5 != NULL and not exists (select *
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
		where a.colid = @fkey5
			and a.id = @objida
			and b.colid = @pkey5
			and b.id = @objidb
			and y.type = "J"
			and a.type = y.low
			and z.type = "J"
			and b.type = z.low
			and y.number = z.number)
begin
	print "Datatypes of the fifth column in the keys are different."
	return (1)
end
else goto doinsert

if @fkey6 != NULL and not exists (select *
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
		where a.colid = @fkey6
			and a.id = @objida
			and b.colid = @pkey6
			and b.id = @objidb
			and y.type = "J"
			and a.type = y.low
			and z.type = "J"
			and b.type = z.low
			and y.number = z.number)
begin
	print "Datatypes of the sixth column in the keys are different."
	return (1)
end
else goto doinsert

if @fkey7 != NULL and not exists (select *
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
		where a.colid = @fkey7
			and a.id = @objida
			and b.colid = @pkey7
			and b.id = @objidb
			and y.type = "J"
			and a.type = y.low
			and z.type = "J"
			and b.type = z.low
			and y.number = z.number)
begin
	print "Datatypes of the seventh column in the keys are different."
	return (1)
end
else goto doinsert

if @fkey8 != NULL and not exists (select *
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
		where a.colid = @fkey8
			and a.id = @objida
			and b.colid = @pkey8
			and b.id = @objidb
			and y.type = "J"
			and a.type = y.low
			and z.type = "J"
			and b.type = z.low
			and y.number = z.number)
begin
	print "Datatypes of the eighth column in the keys are different."
	return (1)
end

/*
**  Everything is consistent so add the foreign key to syskeys.
*/
doinsert:

insert syskeys (id, type, depid, keycnt, size, key1, key2, key3, key4, key5,
	key6, key7, key8, depkey1, depkey2, depkey3, depkey4, depkey5,
	depkey6, depkey7, depkey8)
values (@objida, 2, @objidb, @cnt, 0, @fkey1, @fkey2, @fkey3, @fkey4, @fkey5,
	@fkey6, @fkey7, @fkey8, @pkey1, @pkey2, @pkey3, @pkey4, @pkey5,
	@pkey6, @pkey7, @pkey8)   

print "New foreign key added."

return (0)
go
grant execute on sp_foreignkey to public
go
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_helpdb')
begin
	drop procedure sp_helpdb
end
go
/* helpdb 49.1 9/10/91 */
create procedure sp_helpdb
@dbname varchar(30) = NULL			/* database name to change */
as

declare @showdev	bit
declare @allopts	int

set nocount on

/*
**  If no database name given, get 'em all.
*/
if @dbname = null
	select @dbname = "%", @showdev = 0
else select @showdev = 1

/*
**  Sure the database exists
*/
if not exists (select *
	from sysdatabases
		where name like @dbname)
begin
	print "No such database exists."
	return (1)
end

/*
**  Set allopts to be the sum of all possible user-settable database status
**  bits.
*/
select @allopts = 7196

/*
**  Since we examine the status bits in sysdatabase and turn them
**  into english, we need a temporary table to build the descriptions.
*/
create table #spdbdesc
(
	dbid	smallint null,
	dbdesc	varchar(102) null
)

/*
**  Initialize #spdbdesc from sysdatabases
*/
insert into #spdbdesc (dbid)
		select dbid 
			from sysdatabases
				where name like @dbname

/*
**  Now for each dbid in #spdbdesc, build the database status
**  description.
*/
declare @curdbid smallint		/* the one we're currently working on */
declare @dbdesc varchar(102)		/* the total description for the db */
declare @bitdesc varchar(30)		/* the bit description for the db */

/*
**  Set @curdbid to the first dbid.
*/
select @curdbid = min(dbid)
	from #spdbdesc
while @curdbid != NULL
begin
	/*
	**  Initialize @dbdesc.
	*/
	select @dbdesc = ""

	/*
	**  Check select into/bulk copy bit (4)
	*/
	select @bitdesc = null
	select @bitdesc = v.name
		from spt_values v, sysdatabases d
			where d.dbid = @curdbid
				and v.type = "D"
				and d.status & v.number = 4
				and v.number != @allopts       /* all options */
	if @bitdesc != null
	begin
		if @dbdesc != ""
			select @dbdesc = @dbdesc + ", " +  @bitdesc
		else select @dbdesc = @bitdesc
	end

	/*
	**  Check no checkpoint on recovery bit (16)
	*/
	select @bitdesc = null
	select @bitdesc = v.name
		from spt_values v, sysdatabases d
			where d.dbid = @curdbid
				and v.type = "D"
				and d.status & v.number = 16
				and v.number != @allopts /* all options */
	if @bitdesc != null
	begin
		if @dbdesc != ""
			select @dbdesc = @dbdesc + ", " +  @bitdesc
		else select @dbdesc = @bitdesc
	end

	/*
	**  Check single user bit (4096)
	*/
	select @bitdesc = null
	select @bitdesc = v.name
		from spt_values v, sysdatabases d
			where d.dbid = @curdbid
				and v.type = "D"
				and d.status & v.number = 4096
				and v.number != @allopts       /* all options */
	if @bitdesc != null
	begin
		if @dbdesc != ""
			select @dbdesc = @dbdesc + ", " +  @bitdesc
		else select @dbdesc = @bitdesc
	end

	/*
	**  Check dbo only bit (2048)
	*/
	select @bitdesc = null
	select @bitdesc = v.name
		from spt_values v, sysdatabases d
			where d.dbid = @curdbid
				and v.type = "D"
				and d.status & v.number = 2048
				and v.number != @allopts       /* all options */
	if @bitdesc != null
	begin
		if @dbdesc != ""
			select @dbdesc = @dbdesc + ", " +  @bitdesc
		else select @dbdesc = @bitdesc
	end

	/*
	**  Check read only bit (1024)
	*/
	select @bitdesc = null
	select @bitdesc = v.name
		from spt_values v, sysdatabases d
			where d.dbid = @curdbid
				and v.type = "D"
				and d.status & v.number = 1024
				and v.number != @allopts       /* all options */
	if @bitdesc != null
	begin
		if @dbdesc != ""
			select @dbdesc = @dbdesc + ", " +  @bitdesc
		else select @dbdesc = @bitdesc
	end

	/*
	**  Check load only bit (512)
	*/
	select @bitdesc = null
	select @bitdesc = v.name
		from spt_values v, sysdatabases d
			where d.dbid = @curdbid
				and v.type = "D"
				and d.status & v.number = 512
				and v.number != @allopts       /* all options */
	if @bitdesc != null
	begin
		if @dbdesc != ""
			select @dbdesc = @dbdesc + ", " +  @bitdesc
		else select @dbdesc = @bitdesc
	end

	/*
	**  Check not recovered only bit (256)
	*/
	select @bitdesc = null
	select @bitdesc = v.name
		from spt_values v, sysdatabases d
			where d.dbid = @curdbid
				and v.type = "D"
				and d.status & v.number = 256
				and v.number != @allopts       /* all options */
	if @bitdesc != null
	begin
		if @dbdesc != ""
			select @dbdesc = @dbdesc + ", " +  @bitdesc
		else select @dbdesc = @bitdesc
	end

	/*
	**  Check don't recover bit (32)
	*/
	select @bitdesc = null
	select @bitdesc = v.name
		from spt_values v, sysdatabases d
			where d.dbid = @curdbid
				and v.type = "D"
				and d.status & v.number = 32
				and v.number != @allopts       /* all options */
	if @bitdesc != null
	begin
		if @dbdesc != ""
			select @dbdesc = @dbdesc + ", " +  @bitdesc
		else select @dbdesc = @bitdesc
	end

	/*
	**  Check truncate log on checkpoint bit (8)
	*/
	select @bitdesc = null
	select @bitdesc = v.name
		from spt_values v, sysdatabases d
			where d.dbid = @curdbid
				and v.type = "D"
				and d.status & v.number = 8
				and v.number != @allopts       /* all options */
	if @bitdesc != null
	begin
		if @dbdesc != ""
			select @dbdesc = @dbdesc + ", " +  @bitdesc
		else select @dbdesc = @bitdesc
	end

	/*
	**  If not flags are set, say so.
	*/
	if @dbdesc = ""
	begin
		select @dbdesc = "no options set"
	end

	/*
	**  Save the description.
	*/
	update #spdbdesc
		set dbdesc = @dbdesc
			from #spdbdesc
				where dbid = @curdbid

	/*
	**  Now get the next, if any dbid.
	*/
	select @curdbid = min(dbid)
		from #spdbdesc
			where dbid > @curdbid
end 

/*
**  Now #spdbdesc is complete so we can print out the db info
*/
select distinct name = substring(sysdatabases.name, 1, 24),
		db_size = substring(convert(varchar(10),
			round(
			(spt_values.low * convert(float, sum(sysusages.size)))
			/ 1048576, 0))
			+ " " + "MB", 1, 8),
		owner = substring(syslogins.name, 1, 24),
		dbid = sysdatabases.dbid,
		created = convert(char(11), sysdatabases.crdate),
		status = #spdbdesc.dbdesc
			from sysdatabases, syslogins, sysusages, #spdbdesc,
				spt_values
		where sysdatabases.dbid = #spdbdesc.dbid
			and sysdatabases.suid = syslogins.suid
			and #spdbdesc.dbid = sysusages.dbid
			and spt_values.type = "E"
			and spt_values.number = 1
		group by #spdbdesc.dbid
		having sysdatabases.dbid = #spdbdesc.dbid
			and sysdatabases.suid = syslogins.suid
			and #spdbdesc.dbid = sysusages.dbid
			and spt_values.type = "E"
			and spt_values.number = 1
		order by sysdatabases.name

/*
**  If we are looking at one database, show it's device allocation.
*/
if @showdev = 1
begin
	select device_fragments = sysdevices.name, size =
		convert(varchar(10),
			round(
			(spt_values.low * convert(float, size))
			/ 1048576, 0)) + " " + "MB",
		usage = b.name
	from sysdatabases, sysusages, sysdevices, spt_values a, spt_values b
		where sysdatabases.dbid = sysusages.dbid
			and sysdevices.low <= size + vstart
			and sysdevices.high >= size + vstart - 1
			and sysdevices.status & 2 = 2 
			and sysdatabases.name = @dbname
			and a.type = "E"
			and a.number = 1
			and b.type = "S"
			and sysusages.segmap & 7 = b.number
	order by 1

	/*
	**  If there is only one database and we are in it, show the
	**  segments.
	*/
	if exists (select *
			from #spdbdesc
				where db_id() = dbid)
	begin
		declare @curdevice	varchar(30),
			@curseg		smallint,
			@segbit		int

		delete #spdbdesc

		select @curdevice = min(d.name)
			from  master.dbo.sysusages u, master.dbo.sysdevices d
				where u.dbid = db_id()
					and d.low <= size + vstart
					and d.high >= size + vstart - 1
					and d.status & 2 = 2 
		while (@curdevice != null)
		begin
			/*
			** We need an inner loop here to go through
			**  all the possible segment.
			*/
			select @curseg = min(segment)
					from syssegments
			while (@curseg != null)
			begin
				if (@curseg < 31)
					select @segbit = power(2, @curseg)
				else select @segbit = low
					from master.dbo.spt_values
						where type = "E"
							and number = 2
				insert into #spdbdesc
					select @curseg, @curdevice
						from master.dbo.sysusages u,
							master.dbo.sysdevices d,
							master.dbo.spt_values v
					where u.segmap & @segbit = @segbit
						and d.low <= u.size + u.vstart
						and d.high >= u.size + u.vstart - 1
						and u.dbid = db_id()
						and d.status & 2 = 2 
						and v.number = 1
						and v.type = "E"
						and d.name = @curdevice
				select @curseg = min(segment)
						from syssegments
							where segment > @curseg
			end

			select @curdevice = min(d.name)
				from  master.dbo.sysusages u,
					master.dbo.sysdevices d
				where u.dbid = db_id()
					and d.low <= size + vstart
					and d.high >= size + vstart - 1
					and d.status & 2 = 2 
					and d.name > @curdevice
		end

		/*
		**  One last check for any devices that have no segments.
		*/
		insert into #spdbdesc
			select null, d.name
				from master.dbo.sysusages u,
					master.dbo.sysdevices d
			where u.segmap = 0
				and d.low <= u.size + u.vstart
				and d.high >= u.size + u.vstart - 1
				and u.dbid = db_id()
				and d.status & 2 = 2 

		select distinct device = substring(dbdesc, 1, 30),
			segment = isnull(name, " -- unused by any segments --")
		from #spdbdesc, syssegments
			where dbid *= segment
		order by 1, 2
	end

end

drop table #spdbdesc
return (0)
go
grant execute on sp_helpdb to public
go
dump transaction master with truncate_only
go
/* helpdevice 49.1 9/10/91 */
create procedure sp_helpdevice
@devname varchar(30) = "%"		/* device to check out */
as

declare @tapeblocksize int

/*
**  See if the device exists.
*/
if not exists (select *
			from master.dbo.sysdevices
				where name like @devname)
begin
	print "No such i/o device exists."
	return (1)
end

/*
**  Create a temporary table where we can build up a translation of
**  the device status bits.
*/
create table #spdevtab
(
	name varchar(30),
	statusdesc varchar(250) null
)

set nocount on

/*
**  Initialize the temporary table with the names of the devices.
*/
insert into #spdevtab (name)
	select name
		from master.dbo.sysdevices
			where name like @devname


/*
**  Now figure out what kind of controller type it is.  The type are
**  COMPLETELY machine dependent and are for UNIX.
**  cntrltype = 0	special
**	        2	disk
**	      3-8	tape
**	      9-14	channel
*/
update #spdevtab
	set statusdesc = "special"
		from master.dbo.sysdevices d, #spdevtab
			where d.cntrltype = 0
				and #spdevtab.name = d.name
update #spdevtab
	set statusdesc = "disk"
		from master.dbo.sysdevices d, #spdevtab
			where d.cntrltype = 2
				and #spdevtab.name = d.name
update #spdevtab
	set statusdesc = "tape"
		from master.dbo.sysdevices d, #spdevtab
			where d.cntrltype >= 3 and d.cntrltype <= 8
				and #spdevtab.name = d.name
update #spdevtab
	set statusdesc = "channel"
		from master.dbo.sysdevices d, #spdevtab
			where d.cntrltype >= 9 and d.cntrltype <= 14
				and #spdevtab.name = d.name

/*
**  If a tape device, also figure out the tape capacity which is listed
**  in sysdevices.high in number of 32k blocks.
*/
if exists (select *
		from master.dbo.sysdevices d, #spdevtab
			where d.cntrltype >= 3 and d.cntrltype <= 8
				and d.high > 0
				and #spdevtab.name = d.name)
begin
        /*
        ** Find size of tape block.  Default to 32k.
        */
        select @tapeblocksize = low
                from master.dbo.spt_values
                        where type = "E"
                                and number = 4
        if @tapeblocksize = NULL
        begin
                select @tapeblocksize = 32768
        end

	update #spdevtab
		set statusdesc = statusdesc + ", " + convert(varchar(10),
			round((d.high *
                                convert(float, @tapeblocksize)) / 1048576, 0))
			+ " MB"
		from master.dbo.sysdevices d, #spdevtab
			where d.cntrltype >= 3 and d.cntrltype <= 8
				and d.high > 0
				and #spdevtab.name = d.name
end

update #spdevtab
	set statusdesc = "UNKNOWN DEVICE"
		from master.dbo.sysdevices d, #spdevtab
			where d.cntrltype > 14
				and #spdevtab.name = d.name

/*
**  Now check out the status bits and turn them into english.
**  The mirror status bits are >= 32.
*/
if exists (select *
	from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
		where v.type = "V" and v.number > -1
			and d.status >= 32
			and #spdevtab.name = d.name)
begin
	/*
	**  Check to see if the mirror is enabled. 0x200 (512) bit in status.
	*/
	if exists (select *
		from master.dbo.sysdevices d, #spdevtab
			where d.status & 512 = 512
				and #spdevtab.name = d.name)
	begin
		update #spdevtab
			set statusdesc = statusdesc + ", MIRROR ENABLED"
		from master.dbo.sysdevices d, #spdevtab
			where d.status & 512 = 512
				and #spdevtab.name = d.name
	end

	if exists (select *
		from master.dbo.sysdevices d, #spdevtab
			where d.status & 512 != 512
				and d.status >= 32
				and #spdevtab.name = d.name)
	begin
		update #spdevtab
			set statusdesc = statusdesc + ", MIRROR DISABLED"
		from master.dbo.sysdevices d, #spdevtab
			where d.status & 512 != 512
				and d.status >= 32
				and #spdevtab.name = d.name
	end

	update #spdevtab
		set statusdesc = statusdesc + ", " + v.name
		from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
			where v.type = "V" and v.number > -1
				and d.status >= 32
				and #spdevtab.name = d.name
	/* add mirror name */
	update #spdevtab
		set statusdesc = statusdesc + ", mirrored on '" + d.mirrorname
			+ "'"
		from master.dbo.sysdevices d, #spdevtab
			where #spdevtab.name = d.name
				and d.status >= 32
end

/*
**  Check to see if there is a mirrorname entry but mirroring not enabled.
**  If so, then one side of the mirror is off-line.
*/
else if exists (select *
	from master.dbo.sysdevices d, #spdevtab
		where #spdevtab.name = d.name
		and d.mirrorname != null)
begin
	/*
	**  Figure out which side of the mirror is disabled.
	**  If 0x100 is on then phyname is disabled and mirrorname is enabled.
	*/
	if exists (select *
		from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
			where v.type = "V" and v.number > -1
				and d.status & v.number = 256
				and #spdevtab.name = d.name)
	begin
		update #spdevtab
			set statusdesc = "only device '" + d.mirrorname 
				+ "' of mirror is enabled -- device '"
				+ d.phyname + "' is disabled"
			from master.dbo.sysdevices d, master.dbo.spt_values v,
				#spdevtab
			where v.type = "V" and v.number > -1
				and d.status & v.number = 256
				and #spdevtab.name = d.name
	end
	else if exists (select *
		from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
			where v.type = "V" and v.number > -1
				and d.status & v.number = 64
				and #spdevtab.name = d.name)
	begin
		update #spdevtab
			set statusdesc = "only device '" + d.phyname 
				+ "' of mirror is enabled -- device '"
				+ d.mirrorname + "' is disabled"
			from master.dbo.sysdevices d, master.dbo.sysdevices e,
				master.dbo.spt_values v, #spdevtab
			where v.type = "V" and v.number > -1
				and d.status & v.number = 64
				and #spdevtab.name = d.name
				and e.status & 256 != 256
				and #spdevtab.name = e.name
	end
end

/*
**  Status of 0x20 is "serial writes" for mirrored disks.
*/
if exists (select *
	from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
		where v.type = "V" and v.number > -1
			and d.status & v.number = 32
			and #spdevtab.name = d.name)
begin
	update #spdevtab
		set statusdesc = statusdesc + ", " + v.name
		from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
			where v.type = "V" and v.number > -1
				and d.status & v.number = 32
				and #spdevtab.name = d.name
end

	update #spdevtab
		set statusdesc = statusdesc + ", nonserial writes"
		from master.dbo.sysdevices d, #spdevtab
			where   d.status > 32
				and d.status & 32 != 32
				and #spdevtab.name = d.name

/*
**  Status of 0x80 is "reads mirrored" for mirrored disks.
*/
if exists (select *
	from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
		where v.type = "V" and v.number > -1
			and d.status & v.number = 128
			and #spdevtab.name = d.name)
begin
	update #spdevtab
		set statusdesc = statusdesc + ", " + v.name
		from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
			where v.type = "V" and v.number > -1
				and d.status & v.number = 128
				and #spdevtab.name = d.name
end

/*
**  Now check out the status bits and turn them into english.
**  Status of 0x10 is a dump device.
*/
if exists (select *
	from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
		where v.type = "V" and v.number > -1
			and d.status & v.number = 16
			and #spdevtab.name = d.name)
begin
	update #spdevtab
		set statusdesc = statusdesc + ", " + v.name
		from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
			where v.type = "V" and v.number > -1
				and d.status & v.number = 16
				and #spdevtab.name = d.name
end

/*
**  Now check out the status bits and turn them into english.
**  Status of 0x01 is a default disk.
*/
if exists (select *
	from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
		where v.type = "V" and v.number > -1
			and d.status & v.number = 1
			and #spdevtab.name = d.name)
begin
	update #spdevtab
		set statusdesc = statusdesc + ", " + v.name
		from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
			where v.type = "V" and v.number > -1
				and d.status & v.number = 1
				and #spdevtab.name = d.name
end

/*
**  Now check out the status bits and turn them into english.
**  Status of 0x02 is a physical disk.
*/
if exists (select *
	from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
		where v.type = "V" and v.number > -1
			and d.status & v.number = 2
			and #spdevtab.name = d.name)
begin
	update #spdevtab
		set statusdesc = substring(statusdesc, 1, 225) + ", " + v.name
		from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
			where v.type = "V" and v.number > -1
				and d.status & v.number = 2
				and #spdevtab.name = d.name
	/*
	**  Add in it's size in MB.
	*/
	update #spdevtab
		set statusdesc = statusdesc + ", " + convert(varchar(10),
			round(((d.high - d.low)
				* convert(float, v.low)) / 1048576, 0)) + " MB"
		from master.dbo.sysdevices d, #spdevtab, master.dbo.spt_values v
			where d.status & 2 = 2
				and #spdevtab.name = d.name
				and v.number = 1
				and v.type = "E"
end

/*
**  Now check out the status bits and turn them into english.
**  Status of 0x04 is a logical disk.
*/
if exists (select *
	from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
		where v.type = "V" and v.number > -1
			and d.status & v.number = 4
			and #spdevtab.name = d.name)
begin
	update #spdevtab
		set statusdesc = substring(statusdesc, 1, 225) + ", " + v.name
		from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
			where v.type = "V" and v.number > -1
				and d.status & v.number = 4
				and #spdevtab.name = d.name
end

/*
**  Now check out the status bits and turn them into english.
**  Status of 0x08 is a skip tape header.
*/
if exists (select *
	from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
		where v.type = "V" and v.number > -1
			and d.status & v.number = 8
			and #spdevtab.name = d.name)
begin
	update #spdevtab
		set statusdesc = substring(statusdesc, 1, 225) + ", " + v.name
		from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
			where v.type = "V" and v.number > -1
				and d.status & v.number = 8
				and #spdevtab.name = d.name
end

set nocount off

/*
**  The device number is in the high byte of sysdevices.low so
**  spt_values tells us which byte to pick out.
*/
select device_name = d.name, physical_name = substring(d.phyname, 1, 46),
	description = #spdevtab.statusdesc,
	d.status, d.cntrltype,
	device_number = convert(tinyint, substring(convert(binary(4), d.low),
		v.low, 1)),
	d.low, d.high
		from master.dbo.sysdevices d, #spdevtab, master.dbo.spt_values v
	where d.name = #spdevtab.name
		and v.type = "E"
		and v.number = 3

return (0)
go
grant execute on sp_helpdevice to public
go
/* helpgroup 49.1 9/10/91 */
create procedure sp_helpgroup
@grpname varchar(30) = NULL		/* group name of interest */
as

/*
**  If no group name given, list all the groups.
**  User ids are <= 16383 and group ids are > 16383 or = 0.
*/
if @grpname = NULL
begin
	select Group_name = name, Group_id = gid
		from sysusers
			where (uid > 16383 or uid = 0)
		order by name

	return (0)
end

/*
**  Check to see if group exists.
*/
if not exists (select *
			from sysusers
		where name = @grpname
			and (uid > 16383 or uid = 0))
begin
	print "No such group exists in the current database."
	return (1)
end

/*
**  List the particulars for the group.
*/
select Group_name = substring(g.name, 1, 25), Group_id = g.gid,
	Users_in_group = substring(u.name, 1, 25), Userid = u.uid
		from sysusers u, sysusers g
			where g.name like @grpname
			and g.uid = u.gid
			and (g.uid > 16383 or g.uid = 0)
			and u.uid != u.gid
		order by g.name, u.name

return (0)
go
grant execute on sp_helpgroup to public
go
dump transaction master with truncate_only
go
/*  helplog 49.1 9/10/91 */
create procedure sp_helplog
as
declare @firstpage int,
	@devname varchar(255),
	@msg varchar(255)


/* Get the first page of the log from sysindexes */
select @firstpage = first
	from sysindexes
		where id = 8

/*
**  Get the name of the device which contains the first page of the log.
**  The device number is in the high byte of d.low and u.vstart and which is the
**  high byte is defined in spt_values.
*/
select @devname = d.name 
	from master.dbo.sysdevices d, master.dbo.sysusages u,
		master.dbo.spt_values v
	where (d.status & 2 = 2 or d.status & 4 = 4) 
		and @firstpage >= u.lstart
		and @firstpage < u.lstart + u.size - 1
		and convert(tinyint, substring(convert(binary(4), d.low),
			v.low, 1))
		  = convert(tinyint, substring(convert(binary(4), u.vstart),
		       v.low, 1))
		and v.type = "E"
		and v.number = 3

/* Print out the name of the device which contains the first page of the log */
select @msg = "In database """ + (select db_name())
	+ """, the log starts on device """ + @devname + """."

print @msg

return (0)
go
grant execute on sp_helplog to public
go
/* helpindex 49.1 9/10/91 */
create procedure sp_helpindex
@objname varchar(92)			/* the table to check for indexes */
as

declare @objid int			/* the object id of the table */
declare @indid int			/* the index id of an index */
declare @keys varchar(200)		/* string to build up index key in */
declare @inddesc varchar(68)		/* string to build up index desc in */


/*
**  Check to see that the object names are local to the current database.
*/
if @objname like "%.%.%" and
	substring(@objname, 1, charindex(".", @objname) - 1) != db_name()
begin
	print "Object name must be in 'current' database."
	return (1)
end

/*
**  Check to see the the table exists and initialize @objid.
*/
select @objid = object_id(@objname)

/*
**  Table doesn't exist so return.
*/
if @objid is NULL
begin
	print "Object does not exist."
	return (1)
end

/*
**  See if the object has any indexes.
**  Since there may be more than one entry in sysindexes for the object,
**  this select will set @indid to the index id of the first index.
*/
select @indid = min(indid)
	from sysindexes
		where id = @objid
			and indid > 0
			and indid < 255

/*
**  If no indexes, return.
*/
if @indid is NULL
begin
	print "Object does not have any indexes."
	return (1)
end

/*
**  Now check out each index, figure out it's type and keys and
**  save the info in a temporary table that we'll print out at the end.
*/
create table #spindtab
(
	index_name	varchar(30),
	index_keys	varchar(255),
	index_description	varchar(68)
)

while @indid != NULL
begin
	
	/*
	**  First we'll figure out what the keys are.
	*/
	declare @i int
	declare @thiskey varchar(30)
	declare @lastindid int

	select @keys = "", @i = 1

	set nocount on

	while @i <= 16
	begin
		select @thiskey = index_col(@objname, @indid, @i)

		if @thiskey = NULL
		begin
			goto keysdone
		end

		if @i > 1
		begin
			select @keys = @keys + ", "
		end

		select @keys = @keys + index_col(@objname, @indid, @i)

		/*
		**  Increment @i so it will check for the next key.
		*/
		select @i = @i + 1

	end


	/*
	**  When we get here we now have all the keys.
	*/
	keysdone:
		set nocount off

	/*
	**  Initialize the index description by figuring out if it's a
	**  clustered or nonclustered index.
	*/
	if @indid = 1
	begin
		select @inddesc = "clustered"
	end
	if @indid > 1
	begin
		select @inddesc = "nonclustered"
	end

	/*
	**  Now we'll check out the status bits for this index and
	**  build an english description from them.
	*/

	/*
	**  See if the index is unique (0x02).
	*/
	if exists (select *
		from master.dbo.spt_values v, sysindexes i
			where i.status & v.number = v.number
				and v.type = "I"
				and v.number = 2
				and i.id = @objid
				and i.indid = @indid)
	begin
	select @inddesc = @inddesc + ", " + v.name
		from master.dbo.spt_values v, sysindexes i
			where i.status & v.number = v.number
				and v.type = "I"
				and v.number = 2
				and i.id = @objid
				and i.indid = @indid
	end

	/*
	**  See if the index is ignore_dupkey (0x01).
	*/
	if exists (select *
		from master.dbo.spt_values v, sysindexes i
			where i.status & v.number = v.number
				and v.type = "I"
				and v.number = 1
				and i.id = @objid
				and i.indid = @indid)
	begin
	select @inddesc = @inddesc + ", " + v.name
		from master.dbo.spt_values v, sysindexes i
			where i.status & v.number = v.number
				and v.type = "I"
				and v.number = 1
				and i.id = @objid
				and i.indid = @indid
	end

	/*
	**  See if the index is ignore_dup_row (0x04).
	*/
	if exists (select *
		from master.dbo.spt_values v, sysindexes i
			where i.status & v.number = v.number
				and v.type = "I"
				and v.number = 4
				and i.id = @objid
				and i.indid = @indid)
	begin
	select @inddesc = @inddesc + ", " + v.name
		from master.dbo.spt_values v, sysindexes i
			where i.status & v.number = v.number
				and v.type = "I"
				and v.number = 4
				and i.id = @objid
				and i.indid = @indid
	end

	/*
	**  See if the index is allow_dup_row (0x40).
	*/
	if exists (select *
		from master.dbo.spt_values v, sysindexes i
			where i.status & v.number = v.number
				and v.type = "I"
				and v.number = 64
				and i.id = @objid
				and i.indid = @indid)
	begin
	select @inddesc = @inddesc + ", " + v.name   
		from master.dbo.spt_values v, sysindexes i
			where i.status & v.number = v.number
				and v.type = "I"
				and v.number = 64
				and i.id = @objid
				and i.indid = @indid
	end

	/*
	**  Add the location of the data.
	*/
	select @inddesc = @inddesc + " located on " + s.name
		from syssegments s, sysindexes i
			where s.segment = i.segment
				and i.id = @objid
				and i.indid = @indid

	/*
	**  Now we have the whole description for the index so we'll add
	**  the goods to the temporary table.
	*/
	insert into #spindtab
		select name, @keys, @inddesc
			from sysindexes
				where id = @objid
					and indid = @indid
	/*
	**  Now move @indid to the next index.
	*/
	select @lastindid = @indid
	select @indid = NULL
	select @indid = min(indid)
		from sysindexes
			where id = @objid
				and indid > @lastindid
				and indid < 255
end

/*
**  Now print out the contents of the temporary index table.
*/
select index_name = substring(index_name, 1, 20),
	index_description = substring(index_description, 1, 56),
	index_keys = index_keys from #spindtab

drop table #spindtab

return (0)
go
grant execute on sp_helpindex to public
go
dump transaction master with truncate_only
go
/* helpjoins 49.1 9/10/91 */
create procedure sp_helpjoins
@lefttab varchar(92),			/* name of first table to join */
@righttab varchar(92)			/* name of first table to join */
as

declare @leftid int			/* id of first table */
declare @rightid int			/* id of second table */
declare @foundit bit			/* flag to indicate joins found */

/*
**  This procedure returns any foreign or common joins.
**  If none exists, then it returns any joins that have the same usertype.
**  If none exists, it returns any joins that have the same physical type.
*/

/*
**  Make sure the @objname is local to the current database.
*/
if @lefttab like "%.%.%" and
	substring(@lefttab, 1, charindex(".", @lefttab) - 1) != db_name()
begin
	print "Object must be in your current database."
	return (1)
end
if @righttab like "%.%.%" and
	substring(@righttab, 1, charindex(".", @righttab) - 1) != db_name()
begin
	print "Object must be in your current database."
	return (1)
end

/*
**  See if we can find the objects.  They must be a system table, user table,
**  or view.  The low 3 bits of sysobjects.sysstat indicate what the 
**  object type is -- it's more reliable than using sysobjects.type which
**  could change.
*/
select @leftid = id
	from sysobjects
		where id = object_id(@lefttab)
			and (sysstat & 7 = 1		/* system table */
				or sysstat & 7 = 2	/* view */
				or sysstat & 7 = 3)	/* user table */
select @rightid = id
	from sysobjects
		where id = object_id(@righttab)
			and (sysstat & 7 = 1		/* system table */
				or sysstat & 7 = 2	/* view */
				or sysstat & 7 = 3)	/* user table */

/*
**  If either of the tables don't exist, quit.
*/
if @leftid is NULL
begin
	print "First table doesn't exist."
	return (1)
end 
if @rightid is NULL
begin
	print "Second table doesn't exist."
	return (1)
end 

create table #hjtab
(
	a1	varchar(30),
	a2	varchar(30),
	b1	varchar(30) null,
	b2	varchar(30) null,
	c1	varchar(30) null,
	c2	varchar(30) null,
	d1	varchar(30) null,
	d2	varchar(30) null,
	e1	varchar(30) null,
	e2	varchar(30) null,
	f1	varchar(30) null,
	f2	varchar(30) null,
	g1	varchar(30) null,
	g2	varchar(30) null,
	h1	varchar(30) null,
	h2	varchar(30) null
)

/*
**  Look for foreign key joins.
*/
select @foundit = 0
if exists (select *
		from syskeys
			where type = 2
				and id = @leftid
				and depid = @rightid)
begin
	insert into #hjtab
	select distinct first_pair = col_name(id, key1), col_name(depid, depkey1),
		second_pair = col_name(id, key2), col_name(depid, depkey2),
		third_pair = col_name(id, key3), col_name(depid, depkey3),
		fourth_pair = col_name(id, key4), col_name(depid, depkey4),
		fifth_pair = col_name(id, key5), col_name(depid, depkey5),
		sixth_pair = col_name(id, key6), col_name(depid, depkey6),
		seventh_pair = col_name(id, key7), col_name(depid, depkey7),
		eighth_pair = col_name(id, key8), col_name(depid, depkey8)
	from syskeys
		where type = 2
			and id = @leftid
			and depid = @rightid

	select @foundit = 1
end

if exists (select *
		from syskeys
			where type = 2
				and id = @rightid
				and depid = @leftid)
begin
	insert into #hjtab
	select distinct first_pair = col_name(depid, depkey1), col_name(id, key1),
		second_pair = col_name(depid, depkey2), col_name(id, key2),
		third_pair = col_name(depid, depkey3), col_name(id, key3),
		fourth_pair = col_name(depid, depkey4), col_name(id, key4),
		fifth_pair = col_name(depid, depkey5), col_name(id, key5),
		sixth_pair = col_name(depid, depkey6), col_name(id, key6),
		seventh_pair = col_name(depid, depkey7), col_name(id, key7),
		eighth_pair = col_name(depid, depkey8), col_name(id, key8)
	from syskeys
		where type = 2
			and id = @rightid
			and depid = @leftid

	select @foundit = 1
end

/*
**  Look for common key joins.
*/
if exists (select *
		from syskeys
			where type = 3
				and id = @leftid
				and depid = @rightid)
begin
	insert into #hjtab
	select distinct first_pair = col_name(id, key1), col_name(depid, depkey1),
		second_pair = col_name(id, key2), col_name(depid, depkey2),
		third_pair = col_name(id, key3), col_name(depid, depkey3),
		fourth_pair = col_name(id, key4), col_name(depid, depkey4),
		fifth_pair = col_name(id, key5), col_name(depid, depkey5),
		sixth_pair = col_name(id, key6), col_name(depid, depkey6),
		seventh_pair = col_name(id, key7), col_name(depid, depkey7),
		eighth_pair = col_name(id, key8), col_name(depid, depkey8)
	from syskeys
		where type = 3
			and id = @leftid
			and depid = @rightid

	select @foundit = 1
end

if exists (select *
		from syskeys
			where type = 3
				and id = @rightid
				and depid = @leftid)
begin
	insert into #hjtab
	select distinct first_pair = col_name(depid, depkey1), col_name(id, key1),
		second_pair = col_name(depid, depkey2), col_name(id, key2),
		third_pair = col_name(depid, depkey3), col_name(id, key3),
		fourth_pair = col_name(depid, depkey4), col_name(id, key4),
		fifth_pair = col_name(depid, depkey5), col_name(id, key5),
		sixth_pair = col_name(depid, depkey6), col_name(id, key6),
		seventh_pair = col_name(depid, depkey7), col_name(id, key7),
		eighth_pair = col_name(depid, depkey8), col_name(id, key8)
	from syskeys
		where type = 3
			and id = @rightid
			and depid = @leftid

	select @foundit = 1
end

/*
**  We got a foreignkey and we didn't get a common key.
*/
if @foundit = 1
begin
	select distinct *
		from #hjtab

	drop table #hjtab

	return (0)
end

/*
**  We didn't find any defined joins so we'll look for common user types.
*/
if exists (select *
		from syscolumns a, syscolumns b
			where a.id = @leftid
				and b.id = @rightid
				and a.usertype = b.usertype
				and a.usertype > 99)
begin
	select distinct first_pair = col_name(a.id, a.colid),
		col_name(b.id, b.colid)
	from syscolumns a, syscolumns b
		where a.id = @leftid
			and b.id = @rightid
			and a.usertype = b.usertype
			and a.usertype > 99
	order by first_pair

	/*
	**  If we found something, we can stop.
	*/
	if @@rowcount > 0
		return (0)
end

/*
**  We couldn't find anything so far so we'll see if we have anything
**  that just shares the same physical type.
*/
if exists (select *
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
		where a.id = @leftid
			and b.id = @rightid
			and a.id != b.id
			and a.name = b.name
			and y.type = "J"
			and a.type = y.low
			and z.type = "J"
			and b.type = z.low
			and y.number = z.number)
begin
	select distinct first_pair = col_name(a.id, a.colid),
		col_name(b.id, b.colid)
	from syscolumns a, syscolumns b, master.dbo.spt_values y,
		master.dbo.spt_values z
	where a.id = @leftid
		and b.id = @rightid
		and a.id != b.id
		and a.name = b.name
		and y.type = "J"
		and a.type = y.low
		and z.type = "J"
		and b.type = z.low
		and y.number = z.number
	order by first_pair

end

return (0)
go
grant execute on sp_helpjoins to public
go
/* helpkey 49.1 9/10/91 */
create procedure sp_helpkey
@tabname varchar(92) = null	/* table or view we want to check */
as

declare	@tabid	int		/* id of table or view we want to check */

/*
**  Check to see that the object names are local to the current database.
*/
if @tabname like "%.%.%" and
	substring(@tabname, 1, charindex(".", @tabname) - 1) != db_name()
begin
	print "Table or view name must be in 'current' database."
	return (1)
end

/*
**  If @tabname is null, show all the keys.
*/
if @tabname = null
begin
	select keytype = substring(v.name, 1, 10), object = object_name(k.id),
		related_object = isnull(object_name(k.depid), " -- none --"),
		object_keys = substring(col_name(k.id, key1) + ", "
			+ isnull(col_name(k.id, key2), "*") + ", "
			+ isnull(col_name(k.id, key3), "*") + ", "
			+ isnull(col_name(k.id, key4), "*") + ", "
			+ isnull(col_name(k.id, key5), "*") + ", "
			+ isnull(col_name(k.id, key6), "*") + ", "
			+ isnull(col_name(k.id, key7), "*") + ", "
			+ isnull(col_name(k.id, key8), "*"), 1, 70),
		related_keys = substring(isnull(col_name(k.depid, depkey1), "*")
			+ ", "
			+ isnull(col_name(k.depid, depkey2), "*") + ", "
			+ isnull(col_name(k.depid, depkey3), "*") + ", "
			+ isnull(col_name(k.depid, depkey4), "*") + ", "
			+ isnull(col_name(k.depid, depkey5), "*") + ", "
			+ isnull(col_name(k.depid, depkey6), "*") + ", "
			+ isnull(col_name(k.depid, depkey7), "*") + ", "
			+ isnull(col_name(k.depid, depkey8), "*"), 1, 70)
	from syskeys k, master.dbo.spt_values v
		where k.type = v.number and v.type = 'K'
	order by object, keytype, related_object

	return (0)
end

/*
**  We're looking for a particular table or view.
*/
else
begin
	/*
	**  Make sure the table or view exists.
	*/
	select @tabid = object_id(@tabname)

	if @tabid = null
	begin
		print "No such table or view in the current database."
		return (1)
	end

	/*
	**  See if any keys exist.
	*/
	if not exists (select *
			from syskeys
			where id = @tabid or depid = @tabid)
	begin
		print "No defined keys for this object."
		return (1)
	end

	select keytype = substring(v.name, 1, 10), object = object_name(k.id),
		related_object = isnull(object_name(k.depid), " -- none --"),
		object_keys = substring(col_name(k.id, key1) + ", "
			+ isnull(col_name(k.id, key2), "*") + ", "
			+ isnull(col_name(k.id, key3), "*") + ", "
			+ isnull(col_name(k.id, key4), "*") + ", "
			+ isnull(col_name(k.id, key5), "*") + ", "
			+ isnull(col_name(k.id, key6), "*") + ", "
			+ isnull(col_name(k.id, key7), "*") + ", "
			+ isnull(col_name(k.id, key8), "*"), 1, 70),
		related_keys = substring(isnull(col_name(k.depid, depkey1), "*")
			+ ", "
			+ isnull(col_name(k.depid, depkey2), "*") + ", "
			+ isnull(col_name(k.depid, depkey3), "*") + ", "
			+ isnull(col_name(k.depid, depkey4), "*") + ", "
			+ isnull(col_name(k.depid, depkey5), "*") + ", "
			+ isnull(col_name(k.depid, depkey6), "*") + ", "
			+ isnull(col_name(k.depid, depkey7), "*") + ", "
			+ isnull(col_name(k.depid, depkey8), "*"), 1, 70)
	from syskeys k, master.dbo.spt_values v
		where k.type = v.number and v.type = 'K'
			and (k.id = @tabid or k.depid = @tabid)
	order by object, keytype, related_object

	return (0)
end
go
grant execute on sp_helpkey to public
go
dump transaction master with truncate_only
go
/* objectsegment 49.1 9/10/91 */
create procedure sp_objectsegment
@objid	int
as
	/* 
	** Print out the create date for the object and it's
	** data segment, if applicable.
	*/

	/*
	**  Objects have the following value for sysstat & 7:
	**	0 - trigger
	**	1 - system table
	**	2 - view
	**	3 - user table
	**	4 - sproc
	**	5 - NOT UNUSED
	**	6 - default
	**	7 - rule
	*/
	if exists (select *
			from sysobjects
				where id = @objid
					and sysstat & 7 in (1, 3))
	begin
		select Data_located_on_segment = s.name, When_created = crdate
			from sysobjects o, syssegments s, sysindexes i
				where o.id = @objid
					and i.id = o.id
					and i.indid < 2
					and i.segment = s.segment
	end

	/*
	**  It's not a table so segment is not applicable.
	*/
	else
	begin
		select Data_located_on_segment = "not applicable",
			When_created = crdate
		from sysobjects
			where id = @objid
	end

return (0)

go
grant execute on sp_objectsegment to public
go
/* help 49.1 9/10/91 */
create procedure sp_help
@objname varchar(92) = NULL			/* object name we're after */
as

declare @objid int				/* id of the object */
declare @sysstat smallint			/* the type of the object */

set nocount on

/*

**  If no @objname given, give a little info about all objects.
*/
if @objname = NULL
begin
	select Name = substring(o.name, 1, 15),
		Owner = substring(user_name(uid), 1, 15),
		Object_type = substring(v.name + x.name, 1, 22)
	from sysobjects o, master.dbo.spt_values v, master.dbo.spt_values x
		where o.sysstat & 7 = v.number
			and v.type = "O"
			and x.type = "R"
			and o.userstat & -32768 = x.number
	order by Object_type desc, Name asc

	select User_type = substring(s.name, 1, 15),
	       Storage_type = substring(st.name, 1, 15),
	       Length = s.length,
	       Nulls = s.allownulls,
	       Default_name=substring(object_name(s.tdefault), 1, 15),
	       Rule_name= substring(object_name(s.domain), 1, 15)
	from systypes s, systypes st
		where s.type = st.type
			and s.usertype > 99
			and st.usertype != 18 /* ignore sysname */
			and st.usertype < 100
	order by s.name

	return (0)
end

/*
**  Make sure the @objname is local to the current database.
*/
if @objname like "%.%.%" and
	substring(@objname, 1, charindex(".", @objname) - 1) != db_name()
begin
	print "Object must be in your current database."
	return  (1)
end

/*
**  Now check to see if the @objname is in sysobjects.  It has to be either
**  in sysobjects or systypes.
*/
select @objid = id, @sysstat = sysstat
	from sysobjects
		where id = object_id(@objname)

/*
**  It wasn't in sysobjects so we'll check in systypes.
*/
if @objid = NULL
begin
	select @objid = usertype
		from systypes
			where name = @objname

	/*
	**  Time to give up -- @objname is not in sysobjects or systypes.
	*/
	if @objid = NULL
	begin
		print "Object does not exist in this database."
		return  (1)
	end

	/*
	** Print help about a data type
	*/
	select Type_name = substring(s.name, 1, 15),
	       Storage_type = substring(st.name, 1, 15),
	       Length = s.length,
	       Nulls = s.allownulls,
	       Default_name=substring(object_name(s.tdefault), 1, 15),
	       Rule_name= substring(object_name(s.domain), 1, 15)
	from systypes s, systypes st
		where s.usertype = @objid
			and s.type = st.type
			and st.usertype != 18 /* ignore sysname */
			and st.usertype < 100

	return (0)
end

/*
**  It's in sysobjects so print out the information.
*/
select Name = o.name, Owner = user_name(uid), 
	Type = substring(v.name + x.name, 1, 16)
	from sysobjects o, master.dbo.spt_values v,
		master.dbo.spt_values x
	where o.id = @objid
		and o.sysstat & 7 = v.number
		and v.type = "O"
		and x.type = "R"
		and o.userstat & -32768 = x.number

execute sp_objectsegment @objid

/*
**  Objects have the following value for sysstat & 7:
**	0 - trigger
**	1 - system table
**	2 - view
**	3 - user table
**	4 - sproc
**	5 - NOT UNUSED
**	6 - default
**	7 - rule
**
**  If the object is a system table, view, or user table, we want to check
**  out the objects columns here. Since the moneyn, intn and floatn are 
**  internal representations, created a temporary table to save the values
**  and update those types to money, int and float when printing out.
*/
if @sysstat & 7 in (1, 2, 3)
begin

	create table #sphelptab
	(
		col_name	char (30),
		col_type	char (30),	
		col_len		tinyint,	
		col_status	tinyint,
		col_def		char (30)  null,
		col_dom		char (30)  null
	)

	insert into #sphelptab
		select c.name, t.name, c.length, c.status, 
	        object_name(c.cdefault),object_name(c.domain)
		from syscolumns c, systypes t
		where c.id = @objid
			and c.usertype *= t.usertype

	update #sphelptab
		set col_type = "money"
		where col_type = "moneyn"

	update #sphelptab
		set col_type = "float"
		where col_type = "floatn"

	update #sphelptab
		set col_type = "int"
		where col_type = "intn"

	update #sphelptab
		set col_type = "datetime"
		where col_type = "datetimn"

	select Column_name = substring(col_name, 1, 15),
	       Type = substring(col_type, 1, 15),
	       Length = col_len,
	       Nulls = convert(bit, (col_status & 8)),
	       Default_name=substring(col_def, 1, 15),
	       Rule_name = substring(col_dom, 1, 15)
	from #sphelptab
end

/*
**  For procedures, the parameters of the procedures are stored in syscolumns.
*/
if @sysstat & 7 = 4
begin
	/*
	**  Does the sproc have any parameters?
	*/
	if exists (select *
			from syscolumns c, systypes t
				where c.id = @objid
					and c.usertype *= t.usertype)
	begin
		select Parameter_name = substring(c.name,1,15),
		       Type = substring(t.name,1,15),
		       Length = c.length,
		       Param_order=c.colid
		from syscolumns c, systypes t
			where c.id = @objid
				and c.usertype *= t.usertype
	end
end

/*
**  If the object is a table, check out the indexes.
*/
if @sysstat & 7 in (1, 3)
	execute dbo.sp_helpindex @objname

/*
**  If the object is a table or view, check out the keys.
*/
if @sysstat & 7 in (1, 2, 3)
	execute dbo.sp_helpkey @objname

/*
** Drop the table if we created it
*/
if @sysstat & 7 in (1, 2, 3)
	drop table #sphelptab

return (0)
go
grant execute on sp_help to public
go
dump transaction master with truncate_only
go
/* helprotect 49.1 9/10/91 */
create procedure sp_helprotect
@name varchar(92),			/* name of object or user to check */
@username varchar(30) = NULL		/* name of user to restrict check */
as

declare @low int			/* range of userids to check */
declare @high int
declare @objid int			/* id of @name if object */

/*
**  Check to see that the object names are local to the current database.
*/
if @name like "%.%.%" and
	substring(@name, 1, charindex(".", @name) - 1) != db_name()
begin
	print "Name must be in 'current' database."
	return (1)
end

/*
**  Initialize the range of user ids to check.  We will either check all
**  users (the initial values) or just one in particular (@low = @high)
*/
select @low = 0, @high = 32767

if @username is not NULL
begin
	/*
	**  Set @low and @high so the search will be restricted to
	**  a particular user.
	*/
	select @low = uid, @high = uid
		from sysusers
			where name = @username

	/*
	**  @username isn't valid.
	*/
	if @@rowcount = 0
	begin
		print "No such user exists in the database."
		return (1)
	end
end

/*
**  There are two cases handled by this procedure.  If the first parameter
**  is an object (table, view, procedure) then @name is taken as an object
**  name and the procedure will figure out permissions for the object.
**
**  If the first parameter is not one of the objects mentioned it will be
**  taken as user name and all the permissions for the user or group name
**  will be shown.
*/

/*
**  Check to see if it's an object.
*/
if exists (select *
		from sysobjects
			where id = object_id(@name)
				and (sysstat & 7 = 1	/* system table */
				or sysstat & 7 = 2	/* view */
				or sysstat & 7 = 3	/* user table */
				or sysstat & 7 = 4))	/* procedure */
begin
	/*
	**  This is the case where we will show the various permissions for
	**  an object, possibly restricted by a particular user.
	*/
	select type = substring(b.name, 1, 6), action = a.name,
		user = substring(user_name(p.uid), 1, 15),
		column = substring(isnull(col_name(id, c.number), "All"), 1, 10)
			from sysprotects p, master.dbo.spt_values c,
				master.dbo.spt_values a, master.dbo.spt_values b
			where convert(tinyint, substring(isnull(p.columns, 0x1), c.low, 1))
				& c.high != 0
				and c.number <=
					(select count(*)
						from syscolumns
						where id = object_id(@name))
				and a.type = "T"
				and a.number = p.action
				and b.type = "T"
				and b.number = p.protecttype
				and p.id = object_id(@name)
				and p.uid between @low and @high
			order by type, action, user, column
	return (0)
end

/*
**  Since @name is not an object let's try it as a user.
*/
select @low = uid, @high = uid
	from sysusers
		where name = @name

/*
**  @name isn't a user either so return.
*/
if @@rowcount = 0
begin
	print "No such object or user exists in the database."
	return (1)
end

/*
**  Now we have the user so run the same protection query as before but
**  restrict on user and not on object.
*/
select distinct type = substring(b.name, 1, 6), action = a.name,
	object = substring(isnull(object_name(p.id), ""), 1, 15),
	column = substring(isnull(col_name(id, c.number), "All"), 1, 10)
		from sysprotects p, master.dbo.spt_values c,
			master.dbo.spt_values a, master.dbo.spt_values b
		where convert(tinyint, substring(isnull(p.columns, 0x1), c.low, 1))
			& c.high != 0
			and c.number <= 255
			and a.type = "T"
			and a.number = p.action
			and b.type = "T"
			and b.number = p.protecttype
			and p.uid = @low
		order by type, object, column, action

return (0)
go
grant execute on sp_helprotect to public
go
/* helptext 49.1 9/10/91 */
create procedure sp_helptext
@objname varchar(92)
as

/*
**  Make sure the @objname is local to the current database.
*/
if (@objname like "%.%.%" and
	substring(@objname, 1, charindex(".", @objname) - 1) != db_name() )
begin
	print "Object must be in your current database."
	return (1)
end

/*
** See if @objname exists.
*/
if (object_id(@objname) = NULL)
begin
	print "No such object in the current database."
	return (1)
end

/*
**  Find out howmany lines of text are coming back,
**	and return if there are none.
*/
select count(*)
	from syscomments
where id = object_id(@objname)

/*
**  Now get the text.
*/
select text
	from syscomments 
where id = object_id(@objname)

return (0)
go
grant execute on sp_helptext to public
go
dump transaction master with truncate_only
go
/* helpuser 49.1 9/10/91 */
create procedure sp_helpuser
@name_in_db varchar(30) = NULL
as

set nocount on

/*
**  If no @name_in_db, list all the users.
**  User ids are <= 16383 and group ids are > 16383.
*/
if @name_in_db = NULL
begin
	select Users_name = substring(u.name, 1, 17), ID_in_db = u.uid,
		Group_name = substring(g.name, 1, 17),
		Login_name = substring(m.name, 1, 17),
		Default_db = substring(m.dbname, 1, 15)
			from sysusers u, sysusers g,
				master.dbo.syslogins m
			where u.suid *= m.suid
				and u.gid *= g.uid
				and u.uid <= 16383 and u.uid > 0
			order by Users_name
	return (0)
end

/*
**  See if the @name_in_db is a user.  If so, print out the info for
**  the user, including users pretending to be the user (sysaliases).
*/
if exists (select *
		from sysusers
			where name = @name_in_db
				and uid <= 16383 and uid > 0)
begin
	select Users_name = substring(u.name, 1, 17), ID_in_db = u.uid,
		Group_name = substring(g.name, 1, 17),
		Login_name = substring(m.name, 1, 17),
		Default_db = substring(m.dbname, 1, 15)
			from sysusers u, sysusers g,
				master.dbo.syslogins m
			where u.suid *= m.suid
				and u.gid *= g.uid
				and u.name = @name_in_db
				and u.uid <= 16383 and u.uid > 0

	declare @suid	smallint

	select @suid = suid
		from sysusers 
			where name = @name_in_db

	/*
	** If anyone is using @name_in_db as an alias print it out.
	*/
	if exists (select *
			from sysalternates
		where altsuid = @suid)
	begin
		print "Users aliased to user."
		select Login_name = suser_name(suid)
			from sysalternates
				where altsuid = @suid
			order by Login_name
	end

	return (0)
end

/*
**  Maybe the @name_in_db is a group.  Is so print out the info.
*/
if exists (select *
		from sysusers
			where name = @name_in_db
				and (uid > 16383 or uid = 0))
begin
	print "The name supplied is a group name."
	execute sp_helpgroup @name_in_db
	return (0)
end

/*
**  Last thing to try is that the @name_in_db might be aliased.
*/
if exists (select *
		from sysalternates
			where suid = suser_id(@name_in_db))
begin
	print "The name supplied is aliased to another user."
	select Alias_name = substring(u.name, 1, 17), ID_in_db = u.uid,
		Group_name = substring(g.name, 1, 17),
		Login_name = substring(m.name, 1, 17),
		Default_db = substring(m.dbname, 1, 15)
			from sysusers u, sysusers g, sysalternates a,
				master.dbo.syslogins m
			where u.suid *= m.suid
				and u.gid *= g.uid
				and u.uid <= 16383 and u.uid > 0
				and a.suid = suser_id(@name_in_db)
				and a.altsuid = u.suid
	return (0)
end

print "The name supplied is not a user, group, or aliased."

return (1)
go
grant execute on sp_helpuser to public
go
/* lock 49.1 9/10/91 */
create procedure sp_lock
@spid1 int = NULL,		/* server process id to check for locks */
@spid2 int = NULL		/* other process id to check for locks */
as

/*
**  Show the locks for both parameters.
*/
if @spid1 is not NULL
begin
	select spid, locktype = name, table_id = id, page,
		dbname = substring(db_name(dbid), 1, 15)
	from syslocks, spt_values
		where syslocks.type = spt_values.number
			and spt_values.type = "L"
			and spid in (@spid1, @spid2)
end

/*
**  No parameters, so show all the locks.
*/
else
begin
	select spid, locktype = name, table_id = id, page,
		dbname = substring(db_name(dbid), 1, 15)
	from syslocks, spt_values
		where syslocks.type = spt_values.number
			and spt_values.type = "L"
	order by spid, dbname, table_id, locktype, page
end

return (0)
go
grant execute on sp_lock to public
go
dump transaction master with truncate_only
go
/* logdevice	49.1	9/10/91 */
create procedure sp_logdevice
@dbname	varchar(30),		/* database name that has the syslogs */
@devname	varchar(30)	/* device name to put syslogs on */
as

declare @dbid	smallint	/* dbid of the database to be changed */
declare @dbuid	smallint	/* id of the owner of the database */
declare @logbit	int		/* this is the bit to turn on in sysusages */

select @logbit = 4		/* bit 3 is the one to turn on */

/*
**  Verify the database name and get the @dbid and @dbuid
*/
select @dbid = dbid, @dbuid = suid
	from sysdatabases
		where name = @dbname

/*
**  If @dbname not found, say so and list the databases.
*/
if @dbid = NULL
begin
	print "No such database -- run sp_helpdb to list databases."
	return (1)
end

/*
**  See if the device exists.
*/
if not exists (select *
		from master.dbo.sysdevices
			where name like @devname)
begin
	print "No such device exists -- run sp_helpdevice to list the SQLServer devices."
	return (1)
end

/*
**  You must be SA or the dbo to execute this sproc.
*/
if suser_id() != 1 and suser_id() != @dbuid
begin
	print "Only the System Administrator (SA) or the Database Owner (dbo) may move the syslogs table."
	return (1)
end

/*
**  Now see if the @dbname uses the @devname
*/
if not exists (select *
		from sysusages u, sysdevices d
			where d.name = @devname
				and u.vstart between d.low and d.high
				and u.dbid = @dbid)
begin
	print "The specified device is not used by the database."
	return (1)
end

/*
**  Check if there are any additional segments on original device to be made
**  into log only (don't want to make the only segment not usable for data!)
*/
if (select count(*)
	from master.dbo.sysusages u, master.dbo.sysdevices d
		where d.name = @devname
			and u.vstart between d.low and d.high
			and u.dbid = @dbid
			and lstart != 0) = 0
begin
	print "Can't make the only segment on original device log-only"
	return (1)
end

/*
**  clear the bit from any database segments that aren't already log only
*/
update master.dbo.sysusages
	set segmap = segmap & ~@logbit
		from master.dbo.sysusages
			where dbid = @dbid
			and segmap != @logbit

/*
**  Now set the segments on @devname as log-only.
*/
update master.dbo.sysusages
	set segmap = @logbit
		from master.dbo.sysusages u, master.dbo.sysdevices d
			where d.name = @devname
				and u.vstart between d.low and d.high
				and u.dbid = @dbid
				and lstart != 0

/*
**  Now we need to activate the new segment map.
*/
dbcc dbrepair (@dbname, remap)
print "Syslogs moved."

return (0)
go
grant execute on sp_logdevice to public
go
/* lookup 49.1 9/10/91 */
create procedure sp_lookup
@typearg int,
@owname	varchar(30) = "%", /* owner of the desired objects (except indexes) */
@obname	varchar(30) = "%", /* name of the desired objects (including indexes) */
@indtab	varchar(30) = "%", /* table associated with the desired index */
@indown varchar(30) = "%"  /* owner of the desired index */
as
	create table #ddtab
		(name	varchar(30),
		 owner	varchar(30),
		 type	int,
		 indtab	varchar(30))

declare @table	int
declare @view	int
declare @index	int
declare @sproc	int
declare @trgr	int
declare @dflt	int
declare @rule	int
declare @dtype	int
declare @db	int
declare @report int

select @table = 1, @view = 2, @index = 4, @sproc = 8, @trgr = 16, @dflt = 32,
	@rule = 64, @dtype = 128, @db = 256, @report = 512

if (@typearg & @table = @table)
	insert into #ddtab
		select name, user_name(uid), @table, '' from dbo.sysobjects
			where name like @obname
				and user_name(uid) like @owname
				and (sysstat & 7 = 1	/* system table */
		  		or sysstat & 7 = 3)	/* user table */


if (@typearg & @view = @view)
	insert into #ddtab
		select name, user_name(uid), @view, '' from dbo.sysobjects
			where name like @obname
				and user_name(uid) like @owname
			  	and sysstat & 7 = 2		/* view */

if (@typearg & @index = @index)
	insert into #ddtab
		select i.name, user_name(o.uid), @index, o.name
			from dbo.sysindexes i, dbo.sysobjects o
				where i.name like @obname
					and i.indid > 0
					and i.id = o.id
					and user_name(o.uid) like @indown
					and o.name = object_name(o.id)
					and o.name like @indtab

if (@typearg & @report = @report)
	insert into #ddtab
		select name, user_name(uid), @report, '' from dbo.sysobjects
			where name like @obname
				and user_name(uid) like @owname
				and sysstat & 7 = 4		/* sproc */
				and userstat & -32768 = -32768	/* report */

if (@typearg & @sproc = @sproc)
begin
	/*
	**  If we also wanted reports, don't pick up reports again as sprocs.
	*/
	if (@typearg & @report = @report)
	begin
		insert into #ddtab
			select name, user_name(uid), @sproc, '' from dbo.sysobjects
			 where name like @obname
				and user_name(uid) like @owname
				and sysstat & 7 = 4	/* stored procedure */
				and userstat & -32768 != -32768	/* report */
	end
	else
	begin
		insert into #ddtab
			select name, user_name(uid), @sproc, '' from dbo.sysobjects
			 where name like @obname
				and user_name(uid) like @owname
				and sysstat & 7 = 4	/* stored procedure */
	end
end

if (@typearg & @trgr = @trgr)
	insert into #ddtab
		select name, user_name(uid), @trgr, '' from dbo.sysobjects
			where name like @obname
				and user_name(uid) like @owname
			  	and sysstat & 7 = 0	/* trigger */

if (@typearg & @dflt = @dflt)
	insert into #ddtab
		select name, user_name(uid), @dflt, '' from dbo.sysobjects
			 where name like @obname
			 	and user_name(uid) like @owname
			 	and sysstat & 7 = 6		/* default */

if (@typearg & @rule = @rule)
	insert into #ddtab
		select name, user_name(uid), @rule, '' from dbo.sysobjects
			 where name like @obname
			 	and user_name(uid) like @owname
			 	and sysstat & 7 = 7		/* rule */

if (@typearg & @dtype = @dtype)
	insert into #ddtab
		select name, user_name(uid), @dtype, '' from dbo.systypes
			where name like @obname
				and user_name(uid) like @owname

if (@typearg & @db = @db)
	insert into #ddtab
		select name, suser_name(suid), @db, ''
			from master.dbo.sysdatabases
				where (name like @obname)
					and suser_name(suid) like @owname

select * from #ddtab order by name

drop table #ddtab

return (0)
go
grant execute on sp_lookup to public
go
dump transaction master with truncate_only
go
/* helpremotelogin 49.1 9/10/91 */
create procedure sp_helpremotelogin
@remoteserver varchar(30) = NULL,	/* remote server name */
@remotename varchar(30) = NULL		/* remote login name */
as

declare	@msg	varchar(100)

set nocount on

/*
**  If no server given, get 'em all.
*/
if @remoteserver = null
begin
	select @remoteserver = "%"
end

else
begin
	if not exists (select *
			from master.dbo.sysservers s,
				master.dbo.sysremotelogins r
			where s.srvid = r.remoteserverid
				and s.srvname like @remoteserver
				and s.srvid > 0)
	begin
		if @remoteserver = "%"
		begin
			select @msg = "There are no remote servers defined."
			print @msg
			return (1)
		end

		select @msg = "There are no remote logins for the remote server '"
			+ @remoteserver + "'."
		print @msg
		return (1)
	end
end

/*
**  If no remotename given, get 'em all.
*/
if @remotename = null
begin
	select @remotename = "%"
end

else
begin
	if not exists (select *
			from master.dbo.sysremotelogins
			where isnull(remoteusername, "") like @remotename)
	begin
		if @remotename = "%"
		begin
			select @msg = "There are no remotelogins defined."
			print @msg
			return (1)
		end

		select @msg = "There are no remote logins for '" 
			+ @remotename + "'."
		print @msg
		return (1)
	end
end

/*
**  Check for empty results.
*/
if not exists (select *
		from master.dbo.sysremotelogins r, master.dbo.sysservers s
		where isnull(r.remoteusername, "") like @remotename
			and s.srvid = r.remoteserverid
				and s.srvname like @remoteserver)
begin
	if ((@remoteserver = '%') and (@remotename = '%'))
		select @msg = "There are no remote logins."
	else select @msg = "There are no remote logins for '" 
		+ @remotename + "' on remote server '" + @remoteserver + "'."
	print @msg
	return (1)
end

/*
**  Select the information.
*/
select server = substring(s.srvname, 1, 22),
	local_user_name = 
		substring(isnull(suser_name(r.suid), "** use local name **"), 1, 22),
	remote_user_name = 
		substring(isnull(r.remoteusername, "** mapped locally **"), 1, 22),
	options = substring(v.name, 1, 9)
		from master.dbo.sysservers s, master.dbo.sysremotelogins r,
			master.dbo.spt_values v
	where s.srvid = r.remoteserverid
		and s.srvname like @remoteserver
		and s.srvid > 0
		and isnull(r.remoteusername, "") like @remotename
		and v.type = "F"
		and v.number = r.status
order by server, remote_user_name

return (0)
go
grant execute on sp_helpremotelogin to public
go
/* helpsegment 49.1 9/10/91 */
create procedure sp_helpsegment
@segname varchar(30) = NULL		/* segment name */
as

declare	@segbit	int		/* this is the bit version of the segment # */
declare	@segment	int	/* the segment number of the segment */

set nocount on

/*
**  If no segment name given, get 'em all.
*/
if @segname = null
begin
	select *
		from syssegments
	return (0)
end

/*
**  Make sure the segment exists
*/
if not exists (select *
	from syssegments
		where name = @segname)
begin
	print "No such segment exists."
	return (1)
end

/*
**  Show the syssegment entry, then the fragments and size it is on,
**  then any dependent objects in the database.
*/
select *
	from syssegments
		where name = @segname

/*
**  Set the bit position for the segment.
*/
select @segment = segment
	from syssegments
		where name = @segname

/*
**  Now set the segments on @devname sysusages.
*/
if (@segment < 31)
	select @segbit = power(2, @segment)
else
	/*
	**  Since this is segment 31, power(2, 31) will overflow
	**  since segmap is an int.  We'll grab the machine-dependent
	**  bit mask from spt_values to set the right bit.
	*/
	select @segbit = low
		from master.dbo.spt_values
			where type = "E"
				and number = 2

select device = d.name, size = convert(varchar(20),
		round((u.size * convert(float, v.low)) / 1048576, 0)) + "MB"
	from master.dbo.sysusages u, master.dbo.sysdevices d,
		master.dbo.spt_values v
		where u.segmap & @segbit = @segbit
			and d.low <= u.size + u.vstart
			and d.high >= u.size + u.vstart - 1
			and u.dbid = db_id()
			and d.status & 2 = 2 
			and v.number = 1
			and v.type = "E"

if exists (select *
		from sysindexes i, syssegments s
			where s.name = @segname
				and s.segment = i.segment)
begin
	select table_name = object_name(i.id), index_name = i.name, i.indid
		from sysindexes i, syssegments s
			where s.name = @segname
				and s.segment = i.segment
		order by table_name, indid
end

return (0)
go
grant execute on sp_helpsegment to public
go
dump transaction master with truncate_only
go
/* @(#)helpsort	49.1	9/10/91 */
create procedure sp_helpsort
AS
set nocount on

declare @sortid tinyint, @charid tinyint, @status tinyint
declare @image binary(1)
declare @count int, @end_flag int
    

declare @string varchar(66)
create table #helpsort3 (string varchar(66))

/*
** Get the sortorder ID, character set ID, and status
*/
select @sortid = id, @charid = csid, @image = convert(binary(1), definition)
    from syscharsets, syscurconfigs
    where id = value and config = 123

/*
** Get the name and description of the character set and sort order
*/
if (@sortid = NULL)
 BEGIN
    select @sortid = 0, @charid = 0, @status = 0
    insert #helpsort3 values ("Character Set = 0, ascii_8")
    insert #helpsort3 values ("    8-bit ASCII Character Set - System Default")
    insert #helpsort3 values ("Sort Order = 0, bin_ascii_8")
    insert #helpsort3 values ("    Binary Ordering - System Default")
 END
else
 BEGIN
    select @status = convert(tinyint, @image)

    select @string = "Character Set = " + convert(varchar(4), id) + ", " + name
	    from syscharsets 
	    where id = @charid and type = 1001

    insert into #helpsort3 values (@string)

    select @count = 1
    select @end_flag = 1

    while (@end_flag != 0)
    begin
	    select @string = substring(description, @count, 62)
		    from syscharsets 
		    where id = @charid and type = 1001
	    select @end_flag = isnull(ascii(@string), 0)

	    if (@end_flag != 0)
	    begin
		    select @string = "    " + @string
		    insert #helpsort3 values (@string)
	    end
	    select @count = @count + 62
    end

    select @string = "Sort Order = " + convert(varchar(4), id) + ", " + name
	    from syscharsets 
	    where id = @sortid and type = 2001

    insert into #helpsort3 values (@string)

    select @count = 1
    select @end_flag = 1

    while (@end_flag != 0)
    begin
	    select @string = substring(description, @count, 62)
		    from syscharsets 
		    where id = @sortid and type = 2001
	    select @end_flag = isnull(ascii(@string), 0)

	    if (@end_flag != 0)
	    begin
		    select @string = "    " + @string
		    insert #helpsort3 values (@string)
	    end

	    select @count = @count + 62
    end
END

select "Sort Order Description" = string from #helpsort3

/*
** Build the sorted list of characters for this sort order.
** If it's not stored in spt_values yet, then put the results in there.
*/
if not exists (select * from spt_values where type = 'Z' and high = @sortid)
BEGIN
    create table #helpsort1 (char_val char(1))
     


    if @charid = 0       /*    ascii_8 has valid values from 32 to 126 */
	begin
    		select @count = 32
    		while @count <= 126
    		begin
    			insert #helpsort1 (char_val)
    				values (char(@count))
    			select @count = @count + 1
    		end

	end

    if @charid = 1  	/*     iso_1 has values from 32 to 126, 160 to 255 */
	begin
    		select @count = 32
    		while @count <= 126
    		begin
    			insert #helpsort1 (char_val)
    				values (char(@count))
    			select @count = @count + 1
    		end

        	select @count = 160
        	while @count <= 255
        	begin
    	   		insert #helpsort1 (char_val)
    		    		values (char(@count))
    	    		select @count = @count + 1
        	end
	end


    if @charid = 2      /*     cp850 has valid values from 0 to 255 */
	begin

    		select @count = 32
    		while @count <= 255
    		begin
    			insert #helpsort1 (char_val)
    				values (char(@count))
    			select @count = @count + 1
    		end
	end

    if @charid = 3      /*     cp437 has valid values from 0 to 255 */
	begin
    		select @count =32 
    		while @count <= 255
    		begin
    			insert #helpsort1 (char_val)
    				values (char(@count))
    			select @count = @count + 1
    		end
	end
    
     if @charid > 3     /* User Character Set Not recognised by sp_helpsort */
	begin
		
    		select "Unknown Character Set :   " + name from syscharsets 
	    			where id = @sortid and type = 2001
		return (0)
	end

    select (char_val) into #helpsort2
    	from #helpsort1
    	order by char_val
    
    declare @char char(1)
    declare @char_str varchar(20)
    declare @incr int
    declare @seq_num int
    declare @rel char(1)
    declare @old_char char(1)
    
    select @char = char(0), @seq_num = 0, @count = 0, @incr = 8, @end_flag = 1
    select @rel = " ", @old_char = NULL
    
    set rowcount 1
   
    while @end_flag != 0
    begin
    
        select @char_str = ""
    
	/* If PST_NOTUNIQ is set, then possibly caseless */
	if (@status & 8 = 8)
            while (@count < @incr  and  @end_flag != 0)
            begin
                select @char = char_val
    	            from #helpsort2
    	            where char_val >= @char
                select @end_flag = @@rowcount

		if (@end_flag != 0)
		begin
		    if (@char = @old_char)
			select @rel = "="
		    else
			select @rel = " "

		    select @old_char = @char
		    select @char_str = @char_str + @rel + @char
		    delete from #helpsort2 where ascii(@char) = ascii(char_val)
    
		    select @count = @count + 1
		end
            end
	else
            while (@count < @incr  and  @end_flag != 0)
            begin
                select @char = char_val 
    	            from #helpsort2
    	            where char_val > @char
                select @end_flag = @@rowcount

		if (@end_flag != 0)
		begin
		    select @char_str = @char_str + @rel + @char
		    delete from #helpsort2 where ascii(@char) = ascii(char_val)

		    select @count = @count + 1
		end
            end

        select @incr = @incr + 8, @seq_num = @seq_num + 1
        insert spt_values (name, number, type, low, high) 
		values (@char_str, @seq_num, 'Z', @charid, @sortid)
    end
    
    set rowcount 0
    
END

/*
** Display the sorted list of characters.
*/
select @count = 1
select @end_flag = 1
select @incr = 5

truncate table #helpsort3

while @end_flag != 0
BEGIN
	select @string = ""

	while @count < @incr
	begin
		select @string = @string + substring(name, 2, 19) 
			from spt_values
			where type = 'Z' and number = @count and high = @sortid
		select @end_flag = @@rowcount
		select @count = @count + 1
	end

	select @incr = @incr + 4

	insert into #helpsort3 values (@string)
END

select "Characters, in Order" = string 
	from #helpsort3

set nocount off

return(0)
go
grant execute on sp_helpsort to public
go
/* helpserver 49.1 9/10/91 */
create procedure sp_helpserver
@server varchar(30) = NULL		/* server name */
as

declare	@msg	varchar(100)

set nocount on

/*
**  If no server name given, get 'em all.
*/
if @server = null
begin
	select @server = "%"
end

/*
**  Does the server exist?
*/
if not exists (select *
		from master.dbo.sysservers 
			where srvname like @server
				or srvnetname like @server)
begin
	if @server = "%"
		select @msg = "There are no servers defined."
	else select @msg = "There is no server named '" + @server + "'."
	print @msg
	return (1)
end
	
/*
**  Display server information.
**  First put it into a temp table so we can blot inappropriate status 
**  for the local server.  It's ugly but I couldn't think of another way.
*/
create table #spt_server
(
	name	varchar(30),
	network	varchar(30),
	status	varchar(20),
	id	smallint
)
insert into #spt_server
	select s.srvname, s.srvnetname, status = isnull(v.name, ""), 
		id = s.srvid
	from master.dbo.sysservers s, master.dbo.spt_values v
		where s.srvstatus *= v.number
			and v.type = "A"
			and (s.srvname like @server
				or s.srvnetname like @server)
update #spt_server
	set status = ""
		from master.dbo.sysservers s, #spt_server t
			where s.srvid = 0
				and s.srvname = t.name

select name, network_name = substring(network, 1, 28), 
	status = substring(status, 1, 11), id = convert(char(4), id)
		from #spt_server
	order by name

return (0)
go
grant execute on sp_helpserver to public
go
dump transaction master with truncate_only
go
/* markreport 49.1 9/10/91 */
create procedure sp_markreport
@reportname varchar(92)		/* proc name we want to mark as report */
as

/*
**  Make sure the @reportname is local to the current database.
*/
if @reportname like "%.%.%" and
	substring(@reportname, 1, charindex(".", @reportname) - 1) != db_name()
begin
	print "Report must be in your current database."
	return (1)
end

/*
**  Make sure that it actually exists as a sproc.
*/
if not exists (select *
		from sysobjects
			where id = object_id(@reportname)
			and sysstat & 7 = 4	/* stored procedure */
			and uid = user_id())
begin
	print "No such report exists."
	return (1)
end

update sysobjects
	set userstat = userstat | -32768	/* high bit means report */
		from sysobjects
			where id = object_id(@reportname)
			and sysstat & 7 = 4		/* stored procedure */
			and uid = user_id()

return (0)
go
grant execute on sp_markreport to public
go
/* monitor 49.1 9/10/91 */
create procedure sp_monitor
as

/*
**  Declare variables to be used to hold current monitor values.
*/
declare @now 		datetime
declare @cpu_busy 	int
declare @io_busy	int
declare @idle		int
declare @pack_received	int
declare @pack_sent	int
declare @pack_errors	int
declare @connections	int
declare @total_read	int
declare @total_write	int
declare @total_errors	int

declare @oldcpu_busy 	int	/* used to see if DataServer has been rebooted */
declare @interval	int
declare @mspertick	int	/* milliseconds per tick */

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	print "Can't run sp_monitor from within a transaction."
	return (1)
end

/*
**  Set @mspertick.  This is just used to make the numbers easier to handle
**  and avoid overflow.
*/
select @mspertick = convert(int, @@timeticks / 1000.0)

/*
**  Get current monitor values.
*/
select
	@now = getdate(),
	@cpu_busy = @@cpu_busy,
	@io_busy = @@io_busy,
	@idle = @@idle,
	@pack_received = @@pack_received,
	@pack_sent = @@pack_sent,
	@connections = @@connections,
	@pack_errors = @@packet_errors,
	@total_read = @@total_read,
	@total_write = @@total_write,
	@total_errors = @@total_errors

/*
**  Check to see if DataServer has been rebooted.  If it has then the
**  value of @@cpu_busy will be less than the value of spt_monitor.cpu_busy.
**  If it has update spt_monitor.
*/
select @oldcpu_busy = cpu_busy
	from spt_monitor
if @oldcpu_busy > @cpu_busy
begin
	update spt_monitor
		set
			lastrun = @now,
			cpu_busy = @cpu_busy,
			io_busy = @io_busy,
			idle = @idle,
			pack_received = @pack_received,
			pack_sent = @pack_sent,
			connections = @connections,
			pack_errors = @pack_errors,
			total_read = @total_read,
			total_write = @total_write,
			total_errors = @total_errors
end

/*
**  Now print out old and new monitor values.
*/
set nocount on
select @interval = datediff(ss, lastrun, @now)
	from spt_monitor

/* To prevent a divide by zero error when run for the first 
** time after boot up
*/
if @interval = 0
	select @interval = 1
select last_run = lastrun, current_run = @now, seconds = @interval
	from spt_monitor

select
	cpu_busy = substring(convert(varchar(11),
		convert(int, ((@cpu_busy * @mspertick) / 1000)))
		+ "("
		+ convert(varchar(11), convert(int, (((@cpu_busy - cpu_busy)
		* @mspertick) / 1000)))
		+ ")"
		+ "-"
		+ convert(varchar(11), convert(int, ((((@cpu_busy - cpu_busy)
		* @mspertick) / 1000) * 100) / @interval))
		+ "%",
		1, 25),
	io_busy = substring(convert(varchar(11),
		convert(int, ((@io_busy * @mspertick) / 1000)))
		+ "("
		+ convert(varchar(11), convert(int, (((@io_busy - io_busy)
		* @mspertick) / 1000)))
		+ ")"
		+ "-"
		+ convert(varchar(11), convert(int, ((((@io_busy - io_busy)
		* @mspertick) / 1000) * 100) / @interval))
		+ "%",
		1, 25),
	idle = substring(convert(varchar(11),
		convert(int, ((@idle * @mspertick) / 1000)))
		+ "("
		+ convert(varchar(11), convert(int, (((@idle - idle)
		* @mspertick) / 1000)))
		+ ")"
		+ "-"
		+ convert(varchar(11), convert(int, ((((@idle - idle)
		* @mspertick) / 1000) * 100) / @interval))
		+ "%",
		1, 25)
from spt_monitor

select
	packets_received = substring(convert(varchar(11), @pack_received) + "(" +
		convert(varchar(11), @pack_received - pack_received) + ")", 1, 25),
	packets_sent = substring(convert(varchar(11), @pack_sent) + "(" +
		convert(varchar(11), @pack_sent - pack_sent) + ")", 1, 25),
	packet_errors = substring(convert(varchar(11), @pack_errors) + "(" +
		convert(varchar(11), @pack_errors - pack_errors) + ")", 1, 25)
from spt_monitor

select
	total_read = substring(convert(varchar(11), @total_read) + "(" +
		convert(varchar(11), @total_read - total_read) + ")", 1, 19),
	total_write = substring(convert(varchar(11), @total_write) + "(" +
		convert(varchar(11), @total_write - total_write) + ")", 1, 19),
	total_errors = substring(convert(varchar(11), @total_errors) + "(" +
		convert(varchar(11), @total_errors - total_errors) + ")", 1, 19),
	connections = substring(convert(varchar(11), @connections) + "(" +
		convert(varchar(11), @connections - connections) + ")", 1, 18)
from spt_monitor

/*
**  Now update spt_monitor
*/
update spt_monitor
	set
		lastrun = @now,
		cpu_busy = @cpu_busy,
		io_busy = @io_busy,
		idle = @idle,
		pack_received = @pack_received,
		pack_sent = @pack_sent,
		connections = @connections,
		pack_errors = @pack_errors,
		total_read = @total_read,
		total_write = @total_write,
		total_errors = @total_errors

return (0)
go
dump transaction master with truncate_only
go
/* password 49.1 9/10/91 */
create procedure sp_password
@old varchar(30) = NULL,		/* the old (current) password */
@new varchar(30),			/* the new password */
@loginame varchar(30) = NULL		/* user to change password on */
as

declare @suid int			/* suid of person to change pw on */

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	print "Can't run sp_password from within a transaction."
	return (1)
end

/*
**  If the system administrator (sa) is running this command, the sa can
**  change anyone's password and doesn't have to know the old password.
**  We have this case is suser_id() = 1 and @loginame is NOT NULL.
**  In this case, we'll fill in the old password and set the suid.
*/
if suser_id() != 1 and @loginame != NULL
begin
	/*
	**  Only the sa can use the @loginame.
	*/
	print "Only System Administrator (SA) can use loginame option -- password not changed."
	return (1)
end

/*
**  Does the SA want to change someone's password?
*/
if suser_id() = 1 and @loginame != NULL
begin
	/*  Check to see if the user exists. */
	select @suid = suid
		from syslogins
	where name = @loginame

	if @suid = NULL
	begin
		print "No such login -- no password changed."
		return (1)
	end

	/*
	**  Get the old password for the user.  If @old not given, don't
	**  bother checking against the old password.
	*/
	if @old != null
	begin
		select @suid = suid
			from syslogins
		where name = @loginame and password = @old

		if @suid = NULL
		begin
			print "Old (current) password incorrect for user -- password not changed."
			return (1)
		end
	end
end

/*
**  This is just the normal case when someone wants to change their own
**  password.  Set the @suid.
*/
else if @loginame = NULL
begin
	select @suid = suid
		from syslogins
	where password = @old
		and suid = suser_id()
end
if @suid = NULL
begin
	print "Old (current) password incorrect for user -- password not changed."
	return (1)
end

/*
**  This is the final case.  The sa is running the command to change
**  someone else's password and is supplying the old password.  Confirm
**  that the old password is correct.
*/
if suser_id() = 1
begin
	select @suid = suid
		from syslogins
	where password = @old
		and suid = suser_id(@loginame)

	if @suid = NULL
	begin
		print "Old (current) password incorrect for user -- password not changed."
		return (1)
	end
end

/*
**  If @suid still hasn't been set then the user running the procedure
**  doesn't have the right current password.
*/
if @suid = NULL
begin
	print "Old (current) password incorrect for user -- password not changed."
	return (1)
end

/*
**  Everything is consistent so change the password.
*/
update syslogins
	set password = @new
		where suid = @suid

print 'Password changed.'

return (0)
go
grant execute on sp_password to public
go
/* placeobject	49.1	9/10/91 */
create procedure sp_placeobject
@segname	varchar(30),	/* segment name */
@objname	varchar(62)	/* object name */
as

declare	@msg	char(100)
declare @objid	int
declare @tabname	varchar(30)
declare @indexname	varchar(30)
declare	@indexid	smallint
declare	@segment	smallint

/*
**  Check to see if the segment exists.
*/
select @segment = segment
		from syssegments
			where name = @segname
if @segment = null
begin
	select @msg = "There is no such segment as '" + @segname + "'."
	print @msg
	return (1)
end

/*
**  Are we dealing with a table or it's index?
*/
if @objname like "%.%"
begin

	/*
	**  Get the table name out.
	*/
	select @tabname = substring(@objname, 1, charindex(".", @objname) - 1)
	select @indexname = substring(@objname, charindex(".", @objname) + 1, 61)
end
else
begin
	select @tabname = @objname, @indexname = null
end

/*
**  Can't use placeobject to move syslogs.
*/
if (object_id(@tabname) = 8)
begin
	print "Use sp_logdevice to move syslogs table."
	return (1)
end

/*
**  Can't move system tables.
*/
if (object_id(@tabname) < 100)
begin
	print "You can't move system tables."
	return (1)
end

/*
**  If the user is not the dbo or the SA, make sure he/she owns it.
*/
if suser_id() != 1 and user_id() != 1
begin
	if not exists (select *
			from sysobjects
				where name = @tabname
					and uid = user_id())
	begin
		select @msg = "You do not own a table named '" + @tabname
			+ "'."
		print @msg
		return (1)
	end
end
else
begin
	/*
	**  If dbo or SA, make sure the table exists.
	*/
	if not exists (select *
			from sysobjects
				where name = @tabname)
	begin
		select @msg = "There is no table named '" + @tabname + "'."
		print @msg
		return (1)
	end
end

/*
**  If we are dealing with an index, make sure it exists.
*/
if @indexname != null and not exists (select *
					from sysindexes
						where id = object_id(@tabname)
							and name = @indexname)
begin
	select @msg = "There is no index named '" + @indexname
		+ "' for table '" + @tabname + "'."
	print @msg
	return (1)
end

/*
**  Everything's ok so change the segment for the object.
*/
if @indexname = null
begin
	select @indexid = indid
		from sysindexes
			where id = object_id(@tabname)
				and indid < 2
end
else
begin
	select @indexid = indid
		from sysindexes
			where id = object_id(@tabname)
				and name = @indexname
end

update sysindexes
set segment = @segment
	from sysindexes
		where id = object_id(@tabname)
			and indid = @indexid

declare @dbname	varchar(30)
select @dbname = db_name()
dbcc dbrepair (@dbname, remap)
select @msg = "'" + @objname + "' is now on segment '" + @segname + "'."
print @msg

return (0)
go
grant execute on sp_placeobject to public
go
dump transaction master with truncate_only
go
/* primarykey 49.1 9/10/91 */
create procedure sp_primarykey
@tabname  varchar(92),			/* table name that has the key */
@col1     varchar(30), 			/* columns that make up the key */
@col2     varchar(30) = NULL,
@col3     varchar(30) = NULL,
@col4     varchar(30) = NULL,
@col5     varchar(30) = NULL,
@col6     varchar(30) = NULL,
@col7     varchar(30) = NULL,
@col8     varchar(30) = NULL
as

declare @objid int			/* object id of the table */
declare @uid smallint			/* owner id of the object */
declare @cnt smallint			/* howmany columns in key */
declare @key1 tinyint			/* colids of the columns in the key */
declare @key2 tinyint
declare @key3 tinyint
declare @key4 tinyint
declare @key5 tinyint
declare @key6 tinyint
declare @key7 tinyint
declare @key8 tinyint

/*
**  Check to see that the tabname is local.
*/
if @tabname like "%.%.%" and
	substring(@tabname, 1, charindex(".", @tabname) - 1) != db_name()
begin
	print "Table or view name must be in 'current' database."
	return (1)
end

/*
**  See if we can find the object.  It must be a system table, user table,
**  or view.  The low 3 bits of sysobjects.sysstat indicate what the 
**  object type is -- it's more reliable than using sysobjects.type which
**  could change.
*/
select @objid = id, @uid = uid
	from sysobjects
		where id = object_id(@tabname)
			and (sysstat & 7 = 1		/* system table */
				or sysstat & 7 = 2	/* view */
				or sysstat & 7 = 3)	/* user table */

if @objid is NULL
begin
	print "No table or view exists with the supplied name."
	return (1)
end 

/*
**  Check to see that object owner is adding the key.
*/
if @uid != user_id()
begin
	print "Only the owner of the table may define a primary key."
	return (1)
end

/*
**  See if the primary key exists already.  Syskeys.type = 1 indicates
**  a primary key.
*/
if exists (select *
		from syskeys
			where id = @objid
				and type = 1)
begin
	print "Primary key already exists on table -- drop key first."
	return (1)
end

/*
**  Now check out each column argument to verify it's existence.
*/
select @cnt = 1, @key1 = colid
	from syscolumns
		where name = @col1 
			and id = @objid
if @key1 is NULL
begin
	print "The table has no such first column."
	return (1)
end

if @col2 != NULL
begin
	select @cnt = @cnt + 1, @key2 = colid
		from syscolumns
			where name = @col2 
				and id = @objid
	if @key2 is NULL
	begin
		print "The table has no such second column."
		return (1)
	end
end
else goto doinsert

if @col3 != NULL
begin
	select @cnt = @cnt + 1, @key3 = colid
		from syscolumns
			where name = @col3 
				and id = @objid
	if @key3 is NULL
	begin
		print "The table has no such third column."
		return (1)
	end
end
else goto doinsert

if @col4 != NULL
begin
	select @cnt = @cnt + 1, @key4 = colid
		from syscolumns
			where name = @col4 
				and id = @objid
	if @key4 is NULL
	begin
		print "The table has no such fourth column."
		return (1)
	end
end
else goto doinsert

if @col5 != NULL
begin
	select @cnt = @cnt + 1, @key5 = colid
		from syscolumns
			where name = @col5 
				and id = @objid
	if @key5 is NULL
	begin
		print "The table has no such fifth column."
		return (1)
	end
end
else goto doinsert

if @col6 != NULL
begin
	select @cnt = @cnt + 1, @key6 = colid
		from syscolumns
			where name = @col6 
				and id = @objid
	if @key6 is NULL
	begin
		print "The table has no such sixth column."
		return (1)
	end
end
else goto doinsert

if @col7 != NULL
begin
	select @cnt = @cnt + 1, @key7 = colid
		from syscolumns
			where name = @col7 
				and id = @objid
	if @key7 is NULL
	begin
		print "The table has no such seventh column."
		return (1)
	end
end
else goto doinsert

if @col8 != NULL
begin
	select @cnt = @cnt + 1, @key8 = colid
		from syscolumns
			where name = @col8 
				and id = @objid
	if @key8 is NULL
	begin
		print "The table has no such eighth column."
		return (1)
	end
end

/*
**  Type 1 is a primary key, 2 is a foreignkey, and 3 is a commonjoin.
*/
doinsert:

insert into syskeys
	(id, type, depid, keycnt, size, key1, key2, key3, key4, key5,
		key6, key7, key8)
values (@objid, 1, NULL, @cnt, 0, @key1, @key2, @key3, @key4, @key5,
		@key6, @key7, @key8)   

print "New primary key added."

return (0)
go
grant execute on sp_primarykey to public
go
/* recompile 49.1 9/10/91 */
create procedure sp_recompile
@objname	varchar(92)
as

declare @id		int
declare @type	smallint
declare @uid		smallint
declare @errmsg	varchar(250)

if @objname like '%%.%%.%%'
begin
	select @errmsg = 'Table ' + @objname + ' must be in current database (' + db_name() + ')'
	print @errmsg
	return
end

select @id = id, @type = sysstat & 7, @uid = uid
from sysobjects
where id = object_id(@objname)

if @id = null
begin
	select @errmsg = 'Object ' + @objname + ' is not a table in database ' + db_name() + '.'
	print @errmsg
	return
end

if @type = 1
begin
	select @errmsg = @objname + ' is a system table.'
	print @errmsg
	print 'sp_recompile cannot be used on system tables.'
	return
end
if @type != 3
begin
	select @errmsg = 'Object ' + @objname + ' is not a table.'
	print @errmsg
	return
end

if user_id() != 1 and @uid != user_id()
begin
	select @errmsg = 'You do not own table ' + @objname + '.'
	print @errmsg
	return
end

set nocount on

update sysobjects
set schema = schema + 1
where id = @id

select @errmsg = 'Each stored procedure and trigger that uses table ' + @objname
print @errmsg
print 'will be recompiled the next time it is executed.'
go
grant execute on sp_recompile to public
go
dump transaction master with truncate_only
go
/* remoteoption 49.1 9/10/91 */
create procedure sp_remoteoption
@remoteserver varchar(30) = NULL,	/* server name to change */
@loginame varchar(30) = NULL,		/* user's remote name */
@remotename varchar(30) = NULL,		/* user's local user name */
@optname varchar(20) = NULL,		/* option name to turn on/off */
@optvalue varchar(10) = NULL		/* true or false */
as

declare @statvalue smallint		/* number of option */
declare @optcount int			/* number of options like @optname */
declare	@msg	varchar(100)
declare @suid	smallint

/*
**  If no @server given, just list the possible remote login options.
**  Only certain status bits may be set or cleared.  
**	   settable                	    not settable
**      ------------------------------  --------------------------
**	trusted (1)
*/
if @remoteserver = null
begin
	print "Settable remote login options."
	select remotelogin_option = name
		from spt_values
			where type = "F"
				and number in (1, 1)
				and number > 0
		order by name
	return (0)
end

/*
**  If @loginame is NULL then we want to set @suid = -1. Otherwise get
**  it real value.
*/
if @loginame = null
	select @suid = -1
else select @suid = suser_id(@loginame)

/*
**  Verify the server name, local, and remote names. 
*/
if not exists (select *
		from master.dbo.sysremotelogins r, master.dbo.sysservers s
			where r.remoteserverid = s.srvid
				and s.srvname = @remoteserver
				and r.remoteusername = @remotename
				and r.suid = @suid)
begin
	select @msg = "There is no remote user '" + isnull(@remotename, "NULL")
		+ "' mapped to local user '" + isnull(@loginame, "NULL")
		+ "' on remote server '" + @remoteserver + "'."
	print @msg
	return (1)
end

/*
**  Check remaining parameters.
*/
if @optname is NULL or @optvalue not in ("true", "false") or @optvalue = null
begin
	print "Usage: sp_remoteoption [remoteserver, loginame, remotename, optname, {true | false}]"
	return (1)
end

/*
**  Use @optname and try to find the right option.
**  If there isn't just one, print appropriate diagnostics and return.
*/
select @optcount = count(*)
 	   from spt_values
		where name like "%" + @optname + "%" and type = "F"
			and number in (1, 1)
			and number > 0

/*
**  If no option, show the user what the options are.
*/
if @optcount = 0
begin
	print "Remote login option doesn't exist or can't be set by user."
	print "Run sp_remoteoption with no parameters to see options."
	return (1)
end

/*
**  If more than one option like @optname, show the duplicates and return.
*/
if @optcount > 1
begin
	print "Remote login option is not unique."

	select duplicate_option = name
		from spt_values
			where name like "%" + @optname + "%"
				and type = "F"
				and number in (1, 1)
				and number > 0

	return (1)
end

/*
**  Only the SA or the dbo of @dbnbame can execute the update part
**  of this procedure so check.  Also the sproc must be executed in the master
**  database.
*/
if suser_id() != 1
begin
	print "Only the System Administrator (SA) may set remote login options."
	return (1)
end

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	print "Can't run sp_remoteoption from within a transaction."
	return (1)
end

/*
**  Get the number which is the bit value to set
*/
select @statvalue = number
 	   from spt_values
		where name like "%" + @optname + "%" and type = "F"
			and number in (1, 1)
			and number > 0


/*
**  Now update sysremotelogins.
*/
if @optvalue = "true"
begin
	update master.dbo.sysremotelogins
		set status = status | @statvalue
		from master.dbo.sysremotelogins r, master.dbo.sysservers s
			where r.remoteserverid = s.srvid
				and s.srvname = @remoteserver
				and r.remoteusername = @remotename
				and r.suid = @suid
	select @msg = "Option '" + @optname + "' turned on."
	print @msg
	return (0)

end

/*
**  We want to turn it off.
*/
else
begin
	update master.dbo.sysremotelogins
		set status = status & ~@statvalue
		from master.dbo.sysremotelogins r, master.dbo.sysservers s
			where r.remoteserverid = s.srvid
				and s.srvname = @remoteserver
				and r.remoteusername = @remotename
				and r.suid = @suid
	select @msg = "Option '" + @optname + "' turned off."
	print @msg
	return (0)
end

return (0)
go
grant execute on sp_remoteoption to public
go
/* rename 49.1 9/10/91 */
create procedure sp_rename
@objname varchar(61),			/* old (current) object name */
@newname sysname(30)			/* new name we want to call it */
as

declare @objid int			/* object id of the thing to rename */
declare @msg varchar(250)
declare @returncode	int

if @objname like "%.%.%"
begin
	print "Object must be in the current database."
	return (1)
end

/*
**  Check to see that the @newname is valid.
*/
execute @returncode = sp_validname @newname
if @returncode != 0
begin
	select @msg = "'" + @newname + "' is not a valid name."
	print @msg
	return @returncode
end

/*
**  Check to see if we are renaming a table/column (or table/index)
**  or a table or usertype.
**  If @objname is of the form table.column then it's a column.
**  In the column case, we need to extract and verify the table and
**  column names and make sure the user owns the table that is getting
**  the rule bound.
*/
if @objname like "%.%"
begin
	declare @tabname varchar(30)		/* name of table */
	declare @colname varchar(30)		/* name of column */
	declare @colid tinyint			/* colid of the column */

	/*
	**  Get the table name out.
	*/
	select @tabname = substring(@objname, 1, charindex(".", @objname) - 1)
	select @colname = substring(@objname, charindex(".", @objname) + 1, 61)

	/*
	**  Now check to see that the column exists in a table owned
	**  by the user.
	*/
	select @objid = syscolumns.id, @colid = syscolumns.colid
		from sysobjects, syscolumns
	where syscolumns.id = sysobjects.id
		and sysobjects.name = @tabname
		and syscolumns.name = @colname
		and (sysobjects.sysstat & 7 = 2		/* user table */
		or sysobjects.sysstat & 7 = 3)		/* view */
		and sysobjects.uid = user_id()

	/*
	**  Did we find it?  If not, it might be an index name so we'll
	**  check in the next case.
	*/
	if @objid != null
	begin
		/*
		**  Check to make sure that there is no already a column
		**  that has the new name.
		*/
		if exists (select *
				from syscolumns
					where id = @objid
						and name = @newname)
		begin
			select @msg = "There is already a column named '"
				+ @newname + "'"
				+ " in table '"
				+ @tabname
				+ "'."
			print @msg
			return (1)
		end

		/*
		**  Go ahead and change the column name.
		*/
		update syscolumns
			set name = @newname
				from syscolumns
			where id = @objid
				and colid = @colid

		print "Column name has been changed."
		return (0)
	end

	/*
	**  Might be an index name.
	*/
	else
	begin
		select @objid = sysindexes.id, @colid = sysindexes.indid
			from sysobjects, sysindexes
		where sysindexes.id = sysobjects.id
			and sysobjects.name = @tabname
			and sysindexes.name = @colname
			and sysindexes.indid != 0
			and sysobjects.sysstat & 7 = 3	/* user table */
			and sysobjects.uid = user_id()

		/*
		**  If @objid is still NULL then that means it isn't an
		**  index name.  We checked above to see if it was a column
		**  name so now it's time to give up.
		*/
		if @objid = null
		begin
			print "You do not own a table or column (or index) of that name in the current database."
			return (1)
		end

		/*
		**  Check to make sure that there is no already an index
		**  that has the new name.
		*/
		if exists (select *
				from sysindexes
					where id = @objid
						and name = @newname)
		begin
			select @msg = "There is already an index named '"
				+ @newname + "'"
				+ " for table '"
				+ @tabname
				+ "'."
			print @msg
			return (1)
		end

		/*
		**  Go ahead and change the index name.
		*/
		update sysindexes
			set name = @newname
				from sysindexes
			where id = @objid
				and indid = @colid

		print "Index name has been changed."
		return (0)
	end
end

/*
**  Check to see if the object exists and is owned by the user.
**  It will either be in the sysobjects table or the systypes table.
**  Check sysobjects first.
**  System objects have ids < 100 and we don't allow their names to change.
*/
select @objid = id
	from sysobjects
		where id = object_id(@objname)
			and uid = user_id()
			and id > 99

/*
**  Don't allow the newname to begin with #.
*/
if @objid != null
begin
	if substring(@newname, 1, 1) = "#"
	begin
		print "Object names beginning with '#' are not allowed."
		return (1)
	end
end

/*
**  It's not in sysobjects so check systypes.
*/
if @objid is NULL
begin
	select @objid = usertype
		from systypes
			where name = @objname
				and uid = user_id()
				and usertype > 99

	/*
	**  It's nowhere to be found so quit.
	*/
	if @objid is NULL
	begin
		print "Object name cannot be changed either because it does not exist in this database, or you don't own it, or it is a system name."
		return (1)
	end

	/* Check that newname doesn't already exist. */
	if exists (select *
			from systypes
				where name = @newname)
	begin
		print "Newname already exists in systypes."
		return (1)
	end

	/*
	** Change the name of a datatype
	*/
	update systypes
		set name = @newname
			where usertype = @objid

	print "User datatype name has been changed."
	return (0)
end

/*
**  It might be a table so update the index entry for the table IF it has
**  no clustered index.  No clustered index means that there is an entry
**  for the table under the @objid with indid = 0.
*/
begin transaction

	/* Check that newname doesn't already exist. */
	if exists (select *
			from sysobjects
				where name = @newname)
	begin
		print "Newname already exists in sysobjects."
		rollback transaction
		return (1)
	end

	update sysobjects
		set name = @newname
			where id = @objid

	 /*
	 **  This might not do anything -- only if we are dealing with a
	 **  table that has no clustered index.
	 **  Also change the name of the text entry, if any.
	 */
	 update sysindexes
		set name = @newname
			where id = @objid
				and indid = 0
	 update sysindexes
		set name = "t" + @newname
			where id = @objid
				and indid = 255
commit transaction

print "Object name has been changed."

return (0)
go
grant execute on sp_rename to public
go
dump transaction master with truncate_only
go
/* renamedb 49.1 9/10/91 */
create procedure sp_renamedb
@dbname sysname(30),			/* old (current) db name */
@newname sysname(30)			/* new name we want to call it */
as

declare @objid int			/* object id of the thing to rename */
declare @msg varchar(250)
declare @bitdesc varchar(30)		/* bit description for the db */
declare @curdbid int			/* id of database to be changed */

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	print "Can't run sp_renamedb from within a transaction."
	return (1)
end

/*
**  Only the SA can do this.
*/
if suser_id() != 1
begin
	print "Only the System Administrator (SA) can change the name of a database."
	return (1)
end

/*
**  Make sure the database exists.
*/
if not exists (select *
		from master.dbo.sysdatabases
			where name = @dbname)
begin
	print "No specified database currently exists."
	return (1)
end

/*
**  Make sure that the @newname db doesn't already exist.
*/
if exists (select *
		from master.dbo.sysdatabases
			where name = @newname)
begin
	print "A database with the new name already exists."
	return (1)
end

/*
**  Check to see that the @newname is valid.
*/
declare @returncode	int
execute @returncode = sp_validname @newname
if @returncode != 0
begin
	select @msg = "'" + @newname + "' is not a valid name."
	print @msg
	return @returncode
end

/*
**  Don't allow the names of master, tempdb, and model to be changed.
*/
if @dbname in ("master", "model", "tempdb")
begin
	print "The databases 'master', 'model', and 'tempdb' cannot be renamed."
	return (1)
end

/* Get current database id */ 
select @curdbid = db_id(@dbname) 

/* 
** Check single user bit (4096) 
** Database must be in single user mode to necessitate the rid update in the
** database's DBTABLE
*/ 
select @bitdesc = null 
select @bitdesc = v.name
        from spt_values v, master.dbo.sysdatabases d 
                where d.dbid = @curdbid 
                        and v.type = "D" 
                        and d.status & v.number = 4096 
if @bitdesc = null 
begin 
        select @msg = "System Administrator (SA) must set database '" + @dbname + "'"
        print @msg
        print "to single-user mode with sp_dboption before using sp_renamedb."
        return(1)  
end  

/*
**  Everything is ok so do it.
*/
update master.dbo.sysdatabases
	set name = @newname
		where name = @dbname

print "Database is renamed and in single-user mode."
print "System Administrator (SA) must reset it to multi-user mode with sp_dboption."

return (0)
go
/* serveroption 49.1 9/10/91 */
create procedure sp_serveroption
@server varchar(30) = NULL,		/* server name to change */
@optname varchar(20) = NULL,		/* option name to turn on/off */
@optvalue varchar(10) = NULL		/* true or false */
as

declare @srvid int			/* id of the server */
declare @statvalue smallint		/* number of option */
declare @optcount int			/* number of options like @optname */

/*
**  If no @server given, just list the possible server options.
**  Only certain status bits may be set or cleared.  
**  The default is to allow timeouts (bit 0 is clear).
**	   settable                	    not settable
**      ------------------------------  --------------------------
**	  timeouts (0)
*/
if @server = null
begin
	print "Settable server options."
	select server_option = name
		from spt_values
			where type = "A"
				and number not in (-1, 1)
		order by name
	return (0)
end

/*
**  Verify the server name and get the @srvid
*/
select @srvid = srvid
	from master.dbo.sysservers
		where srvname = @server

/*
**  If @server not found, say so. 
*/
if @srvid = NULL
begin
	print "No such server -- run sp_helpserver to list servers."
	return (1)
end

/*
**  Check remaining parameters.
*/
if @optname is NULL or @optvalue not in ("true", "false") or @optvalue = null
begin
	print "usage: sp_serveroption [server, optname, {true | false}]"
	return (1)
end

/*
**  Use @optname and try to find the right option.
**  If there isn't just one, print appropriate diagnostics and return.
*/
select @optcount = count(*)
 	   from spt_values
		where name like "%" + @optname + "%" and type = "A"
			and number not in (-1, 1)

/*
**  If no option, show the user what the options are.
*/
if @optcount = 0
begin
	print "Server option doesn't exist or can't be set by user."
	print "Run sp_serveroption with no parameters to see options."
	return (1)
end

/*
**  If more than one option like @optname, show the duplicates and return.
*/
if @optcount > 1
begin
	print "Server option is not unique."

	select duplicate_option = name
		from spt_values
			where name like "%" + @optname + "%"
				and type = "A"
				and number not in (-1, 1)

	return (1)
end

/*
**  Only the SA or the dbo of @dbnbame can execute the update part
**  of this procedure so check.  Also the sproc must be executed in the master
**  database.
*/
if suser_id() != 1
begin
	print "Only the System Administrator (SA) may set server options."
	return (1)
end

/*
**  Currently there is only one option that can be set -- no timeouts --
**  and it only applies to remote servers.  If the current server is
**  local then reject it.
*/
if @srvid = 0
begin
	print "Option can be set for remote servers only -- not the local server."
	return (1)
end


/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	print "Can't run sp_serveroption from within a transaction."
	return (1)
end
/*
**  Get the number which is the bit value to set
*/
select @statvalue = number
 	   from spt_values
		where name like "%" + @optname + "%" and type = "A"
			and number > 0


/*
**  Now update sysservers.
**  The timeouts option is handled a little strangely since the default
**  is timeouts.  Therefore timeouts = true means to clear the bit
**  and timeouts = false means to set the bit.
*/
if @optvalue = "true"
begin
	update sysservers
		set srvstatus = srvstatus & ~@statvalue
			where srvid = @srvid
end

/*
**  We want to turn it off.
*/
else
begin
	update sysservers
		set srvstatus = srvstatus | @statvalue
			where srvid = @srvid
end

return (0)
go
grant execute on sp_serveroption to public
go
dump transaction master with truncate_only
go
/* spaceused 49.1 9/10/91 */
create procedure sp_spaceused
@objname varchar(92) = null		/* the object we want size on */
as

declare @id	int			/* the object id of @objname */
declare @type	smallint		/* the object type */
declare	@pages	int			/* working variable for size calc. */

/*
**  Check to see that the objname is local.
*/
if @objname != null
begin
	if @objname like "%.%.%" and
		substring(@objname, 1, charindex(".", @objname) - 1) != db_name()
	begin
		print "Object must be in 'current' database."
		return (1)
	end

	/*
	**  Try to find the object.
	*/
	select @id = id, @type = sysstat & 7
		from sysobjects
			where id = object_id(@objname)

	/*
	**  Does the object exist?
	*/
	if @id = null
	begin
		print "Object is not a table in the database."
		return (1)
	end

	/*
	**  See if it's a space object.
	**  types are:
	**	0 - trigger
	**	1 - system table
	**	2 - view
	**	3 - user table
	**	4 - sproc
	**	6 - default
	**	7 - rule
	*/
	if not exists (select *
			from sysindexes
				where @id = id
					and indid < 2)
	begin
		if @type in (0, 4, 6, 7)
		begin
			print "Object is stored in 'sysprocedures' and has no space allocated directly."
			return (1)
		end

		if @type = 2
		begin
			print "Views don't have space allocated."
			return (1)
		end
	end

end

/*
**  We need to create a temp table to do the calculation.
**  reserved: sum(reserved) where indid in (0, 1, 255)
**  data: sum(dpages) where indid < 2 + sum(used) where indid = 255 (text)
**  index: sum(used) where indid in (0, 1, 255) - data
**  unused: sum(reserved) - sum(used) where indid in (0, 1, 255)
*/
create table #spt_space
(
	rows		int null,
	reserved	int null,
	data		int null,
	indexp		int null,
	unused		int null
)
set nocount on

/*
**  If @id is null, then we want summary data.
*/
if @id = null
begin
	select distinct database_name = db_name(), database_size =
		substring(convert(varchar(10),
			round( (d.low * convert(float, sum(size)))
			/ 1048576, 0)) + " " + "MB", 1, 20)
		from master.dbo.sysusages, master.dbo.spt_values d
			where dbid = db_id()
				and d.number = 1
				and d.type = "E"
			having dbid = db_id()
				and d.number = 1
				and d.type = "E"

	/*
	**  Now calculate the summary data.
	**  reserved: sum(reserved) where indid in (0, 1, 255)
	*/
	insert into #spt_space (reserved)
		select sum(reserved)
			from sysindexes
				where indid in (0, 1, 255)

	/*
	** data: sum(dpages) where indid < 2
	**	+ sum(used) where indid = 255 (text)
	*/
	select @pages = sum(dpages)
			from sysindexes
				where indid < 2
	select @pages = @pages + isnull(sum(used), 0)
		from sysindexes
			where indid = 255
	update #spt_space
		set data = @pages

	
	/* index: sum(used) where indid in (0, 1, 255) - data */
	update #spt_space
		set indexp = (select sum(used)
				from sysindexes
					where indid in (0, 1, 255))
			    - data

	/* unused: sum(reserved) - sum(used) where indid in (0, 1, 255) */
	update #spt_space
		set unused = reserved 
				- (select sum(used)
					from sysindexes
						where indid in (0, 1, 255))

	select reserved = substring(convert(varchar(15),
		round((reserved * convert(float, d.low)) / 1024, 0))
			+ " " + "KB", 1, 15),
		data = substring(convert(varchar(15),
		round((data * convert(float, d.low)) / 1024, 0))
			+ " " + "KB", 1, 15),
		index_size = substring(convert(varchar(15),
		round((indexp * convert(float, d.low)) / 1024, 0))
			+ " " + "KB", 1, 15),
		unused = substring(convert(varchar(15),
		round((unused * convert(float, d.low)) / 1024, 0))
			+ " " + "KB", 1, 15)
			from #spt_space, master.dbo.spt_values d
		where d.number = 1
			and d.type = "E"
end

/*
**  We want a particular object.
*/
else
begin
	/*
	**  Now calculate the summary data.
	**  reserved: sum(reserved) where indid in (0, 1, 255)
	*/
	insert into #spt_space (reserved)
		select sum(reserved)
			from sysindexes
				where indid in (0, 1, 255)
					and id = @id

	/*
	** data: sum(dpages) where indid < 2
	**	+ sum(used) where indid = 255 (text)
	*/
	select @pages = sum(dpages)
			from sysindexes
				where indid < 2
					and id = @id
	select @pages = @pages + isnull(sum(used), 0)
		from sysindexes
			where indid = 255
				and id = @id
	update #spt_space
		set data = @pages

	
	/* index: sum(used) where indid in (0, 1, 255) - data */
	update #spt_space
		set indexp = (select sum(used)
				from sysindexes
					where indid in (0, 1, 255)
						and id = @id)
			    - data

	/* unused: sum(reserved) - sum(used) where indid in (0, 1, 255) */
	update #spt_space
		set unused = reserved 
				- (select sum(used)
					from sysindexes
						where indid in (0, 1, 255)
							and id = @id)
	update #spt_space
		set rows = i.rows
			from sysindexes i
				where i.indid < 2
					and i.id = @id

	select name = substring(object_name(@id), 1, 20),
		rows = convert(char(11), rows),
		reserved = substring(convert(varchar(15),
			round((reserved * convert(float, d.low)) / 1024, 0))
				+ " " + "KB", 1, 10),
		data = substring(convert(varchar(15),
			round((data * convert(float, d.low)) / 1024, 0))
				+ " " + "KB", 1, 10),
		index_size = substring(convert(varchar(15),
			round((indexp * convert(float, d.low)) / 1024, 0))
				+ " " + "KB", 1, 10),
		unused = substring(convert(varchar(15),
			round((unused * convert(float, d.low)) / 1024, 0))
				+ " " + "KB", 1, 10)
	from #spt_space, master.dbo.spt_values d
		where d.number = 1
			and d.type = "E"
end

return (0)
go
grant execute on sp_spaceused to public
go
/* unbindefault 49.1 9/10/91 */
create procedure sp_unbindefault
@objname varchar(61),			/* table/column or datatype name */
@futureonly varchar(15) = NULL		/* flag to indicate extent of binding */
as

declare @futurevalue varchar(15)	/* the value of @futureonly that causes
					** the binding to be limited */

select @futurevalue = "futureonly"	/* initialize @futurevalue */

/*
**  When a default or rule is bound to a user-defined datatype, it is also
**  bound, by default, to any columns of the user datatype that are currently
**  using the existing default or rule as their default or rule.  This default
**  action may be overridden by setting @futureonly = @futurevalue when the
**  procedure is invoked.  In this case existing columns with the user
**  datatype won't have their existing default or rule changed.
*/

/*
**  Check to see that the object names are local to the current database.
*/
if @objname like "%.%.%"
begin
	print "Column or usertype must be in 'current' database."
	return (1)
end

/*
**  If @objname is of the form tab.col then we are unbinding a column.
**  Otherwise its a datatype.  In the column case, we need to extract
**  and verify the table and column names and make sure the user owns
**  the table that is getting the default unbound.
*/
if @objname like "%.%"
begin
	declare @tabname varchar(30)		/* name of table */
	declare @colname varchar(30)		/* name of column */

	/*
	**  Get the table name out.
	*/
	select @tabname = substring(@objname, 1, charindex(".", @objname) - 1)
	select @colname = substring(@objname, charindex(".", @objname) + 1, 61)

	/*
	**  Find it and unbind it.
	*/
	if exists (select *
			from syscolumns, sysobjects
		where syscolumns.id = object_id(@tabname)
			and syscolumns.name = @colname
			and sysobjects.id = object_id(@tabname)
			and uid = user_id()
			and sysobjects.sysstat & 7 = 3)      /* user table */
	begin
		/*
		**  Is there something bound to it?
		*/
		if exists (select *
			from syscolumns, sysobjects
		where syscolumns.id = object_id(@tabname)
			and syscolumns.name = @colname
			and sysobjects.id = object_id(@tabname)
			and uid = user_id()
			and sysobjects.sysstat & 7 = 3      /* user table */
			and cdefault != 0)
		begin
			update syscolumns
				set cdefault = 0
					from syscolumns, sysobjects
				where syscolumns.id = object_id(@tabname)
					and syscolumns.name = @colname
					and sysobjects.id = object_id(@tabname)
					and uid = user_id()
					and sysobjects.sysstat & 7 = 3

			/*
			**  Since binding a default is a schema change,
			**  update schema count
			**  for the object in the sysobjects table.
			*/
			update sysobjects
				set schema = schema + 1
					from sysobjects
						where id = object_id(@tabname)
							and uid = user_id()

			print "Default unbound from table column."
			return (0)
		end

		else
		begin
			print "The specified column has no default."
			return (1)
		end
	end

	/*
	**  If we got here, there was no such object.
	*/
	print "You do not own a table with a column of that name."
	return (1)

end
else
begin
	/*
	**  We're unbinding to a user type.  In this case, the @objname
	**  is really the name of the user datatype.
	**  When we unbind to a user type, any existing columns get changed
	**  to the new binding unless their current binding is not equal
	**  to the current binding for the usertype or if they set the
	**  @futureonly parameter to @futurevalue.
	*/
	declare @olddefault int			/* current default for type */

	/*
	**  Get the current default for the datatype.
	*/
	select @olddefault = tdefault
		from systypes
	where name = @objname
		and uid = user_id()
		and usertype > 100

	if @olddefault = null
	begin
		print "You do not own a user datatype of that name."
		return (1)
	end

	if @olddefault = 0
	begin
		print "The specified user datatype has no default."
		return (1)
	end

	update systypes
		set tdefault = 0
			from systypes
		where name = @objname
			and uid = user_id()
			and usertype > 100

	print "Default unbound from datatype."

	/*
	**  Now see if there are any columns with the usertype that
	**  need the new binding.
	*/
	if isnull(@futureonly, "") != @futurevalue
		and exists (select *
			from syscolumns, systypes
				where syscolumns.usertype = systypes.usertype
					and systypes.name = @objname
					and systypes.usertype > 100
					and systypes.uid = user_id()
					and syscolumns.cdefault = @olddefault)
	begin
		/*
		**  Update syscolumns with new binding.
		*/
		update syscolumns
			set cdefault = systypes.tdefault
				from syscolumns, systypes
			where syscolumns.usertype = systypes.usertype
				and systypes.name = @objname
				and systypes.usertype > 100
				and systypes.uid = user_id()
				and syscolumns.cdefault = @olddefault

		/*
		**  Update the table schema to indicate that something
		**  has changed in the table's schema.
		*/
		update sysobjects
			set schema = schema + 1
				from sysobjects, syscolumns, systypes
			where sysobjects.id = syscolumns.id
				and syscolumns.usertype = systypes.usertype
				and systypes.name = @objname
				and systypes.usertype > 100
				and systypes.uid = user_id()
				and syscolumns.cdefault = systypes.tdefault

		print "Columns of the user datatype specified had their defaults unbound."
	end
end

return (0)
go
grant execute on sp_unbindefault to public
go
dump transaction master with truncate_only
go
/* unbindrule 49.1 9/10/91 */
create procedure sp_unbindrule
@objname varchar(61),			/* table/column or datatype name */
@futureonly varchar(15) = NULL		/* flag to indicate extent of binding */
as

declare @futurevalue varchar(15)	/* the value of @futureonly that causes
					** the binding to be limited */

select @futurevalue = "futureonly"	/* initialize @futurevalue */

/*
**  When a default or rule is bound to a user-defined datatype, it is also
**  bound, by default, to any columns of the user datatype that are currently
**  using the existing default or rule as their default or rule.  This default
**  action may be overridden by setting @futureonly = @futurevalue when the
**  procedure is invoked.  In this case existing columns with the user
**  datatype won't have their existing default or rule changed.
*/

/*
**  Check to see that the object names are local to the current database.
*/
if @objname like "%.%.%"
begin
	print "Column or user datatype must be in 'current' database."
	return (1)
end

/*
**  If @objname is of the form tab.col then we are unbinding a column.
**  Otherwise its a datatype.  In the column case, we need to extract
**  and verify the table and column names and make sure the user owns
**  the table that is getting the default unbound.
*/
if @objname like "%.%"
begin
	declare @tabname varchar(30)		/* name of table */
	declare @colname varchar(30)		/* name of column */

	/*
	**  Get the table name out.
	*/
	select @tabname = substring(@objname, 1, charindex(".", @objname) - 1)
	select @colname = substring(@objname, charindex(".", @objname) + 1, 61)

	/*
	**  Find it and unbind it.
	*/
	if exists (select *
			from syscolumns, sysobjects
		where syscolumns.id = object_id(@tabname)
			and syscolumns.name = @colname
			and sysobjects.id = object_id(@tabname)
			and uid = user_id()
			and sysobjects.sysstat & 7 = 3)      /* user table */
	begin
		/*
		**  Is there something bound to it?
		*/
		if exists (select *
			from syscolumns, sysobjects
		where syscolumns.id = object_id(@tabname)
			and syscolumns.name = @colname
			and sysobjects.id = object_id(@tabname)
			and uid = user_id()
			and sysobjects.sysstat & 7 = 3      /* user table */
			and domain != 0)
		begin
			update syscolumns
				set domain = 0
					from syscolumns, sysobjects
				where syscolumns.id = object_id(@tabname)
					and syscolumns.name = @colname
					and sysobjects.id = object_id(@tabname)
					and uid = user_id()
					and sysobjects.sysstat & 7 = 3

			/*
			**  Since binding a rule is a schema change,
			**  update schema count
			**  for the object in the sysobjects table.
			*/
			update sysobjects
				set schema = schema + 1
					from sysobjects
						where id = object_id(@tabname)
							and uid = user_id()

			print "Rule unbound from table column."
			return (0)
		end

		else
		begin
			print "The specified column has no rule."
			return (1)
		end
	end

	/*
	**  If we got here, there was no such object.
	*/
	print "You do not own a table with a column of that name."
	return (1)

end
else
begin
	/*
	**  We're unbinding to a user type.  In this case, the @objname
	**  is really the name of the user datatype.
	**  When we unbind to a user type, any existing columns get changed
	**  to the new binding unless their current binding is not equal
	**  to the current binding for the usertype or if they set the
	**  @futureonly parameter to @futurevalue.
	*/
	declare @oldrule int			/* current rule for type */

	/*
	**  Get the current rule for the datatype.
	*/
	select @oldrule = domain
		from systypes
	where name = @objname
		and uid = user_id()
		and usertype > 100

	if @oldrule = null
	begin
		print "You do not own a user datatype of that name."
		return (1)
	end

	if @oldrule = 0
	begin
		print "The specified user datatype has no rule."
		return (1)
	end

	update systypes
		set domain = 0
			from systypes
		where name = @objname
			and uid = user_id()
			and usertype > 100

	print "Rule unbound from datatype."

	/*
	**  Now see if there are any columns with the usertype that
	**  need the new binding.
	*/
	if isnull(@futureonly, "") != @futurevalue
		and exists (select *
			from syscolumns, systypes
				where syscolumns.usertype = systypes.usertype
					and systypes.name = @objname
					and systypes.usertype > 100
					and systypes.uid = user_id()
					and syscolumns.domain = @oldrule)
	begin
		/*
		**  Update syscolumns with new binding.
		*/
		update syscolumns
			set domain = systypes.domain
				from syscolumns, systypes
			where syscolumns.usertype = systypes.usertype
				and systypes.name = @objname
				and systypes.usertype > 100
				and systypes.uid = user_id()
				and syscolumns.domain = @oldrule

		/*
		**  Update the table schema to indicate that something
		**  has changed in the table's schema.
		*/
		update sysobjects
			set schema = schema + 1
				from sysobjects, syscolumns, systypes
			where sysobjects.id = syscolumns.id
				and syscolumns.usertype = systypes.usertype
				and systypes.name = @objname
				and systypes.usertype > 100
				and systypes.uid = user_id()
				and syscolumns.domain = systypes.domain

		print "Columns of the user datatype specified had their rules unbound."
	end
end

return (0)
go
grant execute on sp_unbindrule to public
go
/* who 49.1 9/10/91 */
create procedure sp_who @loginame varchar(30) = NULL as

declare @low int
declare @high int
declare @spidlow int
declare @spidhigh int

select @low = 0, @high = 32767, @spidlow = 0, @spidhigh = 32767

if @loginame is not NULL
begin
	select @low = suser_id(@loginame), @high = suser_id(@loginame)
	if @low is NULL
	begin
		if @loginame like "[0-9]%"
		begin
			select @spidlow = convert(int, @loginame),
			     @spidhigh = convert(int, @loginame),
			     @low = 0, @high = 32767
		end
		else
		begin
			print "No login exists with the supplied name."
			return (1)
		end
	end
end
select spid,status,loginame=substring(suser_name(suid),1,12),
   hostname,blk=convert(char(3),blocked),
   dbname=substring(db_name(dbid),1,10),cmd
from sysprocesses
where suid >= @low and suid <= @high
and spid >= @spidlow and spid <= @spidhigh

return (0)
go
grant execute on sp_who to public
go
dump transaction master with truncate_only
go
/* addprobe	49.1	9/10/91	*/
/*
**  This file add the account and user named "probe".  This account is
**  used the 2-phased commit service.
*/
use master
go

if not exists (select *
		from syslogins
			where name = "probe")
begin
	execute sp_addlogin probe
end
go

if not exists (select *
		from sysusers
			where name = "probe")
begin
	execute sp_adduser probe
end
go
go
/* definekey 49.1 9/10/91 */

/*
**  This file defines the primary, foreign, and common keys for the
**  system tables.
*/

/*
**  First do model, then do master.
*/
use model
go

/*
**  Do the primary keys for the system tables.
*/
if exists (select *
		from syskeys
	where type = 1 and id = object_id("sysalternates"))
		execute sp_dropkey primary, sysalternates
go
sp_primarykey sysalternates, suid
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("syscolumns"))
		execute sp_dropkey primary, syscolumns
go
sp_primarykey syscolumns, id, number, colid
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("syscomments"))
		execute sp_dropkey primary, syscomments
go
sp_primarykey syscomments, id, number, colid, texttype
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("sysdepends"))
		execute sp_dropkey primary, sysdepends
go
sp_primarykey sysdepends, id, number, depid, depnumber
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("sysindexes"))
		execute sp_dropkey primary, sysindexes
go
sp_primarykey sysindexes, id, indid
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("syskeys"))
		execute sp_dropkey primary, syskeys
go
sp_primarykey syskeys, id
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("sysobjects"))
		execute sp_dropkey primary, sysobjects
go
sp_primarykey sysobjects, id
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("sysprocedures"))
		execute sp_dropkey primary, sysprocedures
go
sp_primarykey sysprocedures, id, number, type, sequence
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("sysprotects"))
		execute sp_dropkey primary, sysprotects
go
sp_primarykey sysprotects, id, uid, action
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("systypes"))
		execute sp_dropkey primary, systypes
go
sp_primarykey systypes, name
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("sysusers"))
		execute sp_dropkey primary, sysusers
go
sp_primarykey sysusers, suid
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("syssegments"))
		execute sp_dropkey primary, syssegments
go
sp_primarykey syssegments, segment
go

/*
**  Now do the foreign keys and common keys.
*/
if exists (select *
		from syskeys
	where type = 2 and id = object_id("sysalternates"))
		execute sp_dropkey foreign, sysalternates, sysusers
go
sp_foreignkey sysalternates, sysusers, suid
go

if exists (select *
		from syskeys
	where type = 3 and id = object_id("syscolumns"))
		execute sp_dropkey common, syscolumns, syscomments
go
sp_commonkey syscolumns, syscomments, id, id
go

sp_dropkey common, syscolumns, syskeys
go
sp_commonkey syscolumns, syskeys, id, key1
go
sp_commonkey syscolumns, syskeys, id, depkey1
go

sp_dropkey common, syscolumns, sysobjects
go
sp_commonkey syscolumns, sysobjects, id, id
go

sp_dropkey common, syscolumns, systypes
go
sp_commonkey syscolumns, systypes, type, type
go
sp_commonkey syscolumns, systypes, usertype, usertype
go
sp_commonkey syscolumns, systypes, domain, domain
go
sp_commonkey syscolumns, systypes, cdefault, tdefault
go

if exists (select *
		from syskeys
	where type = 3 and id = object_id("syscomments"))
		execute sp_dropkey common, syscomments, sysobjects
go
sp_commonkey syscomments, sysobjects, id, id
go

if exists (select *
		from syskeys
	where type = 3 and id = object_id("sysdepends"))
		execute sp_dropkey common, sysdepends, sysobjects
go
sp_commonkey sysdepends, sysobjects, id, id
go

if exists (select *
		from syskeys
	where type = 3 and id = object_id("sysindexes"))
		execute sp_dropkey common, sysindexes, sysobjects
go
sp_commonkey sysindexes, sysobjects, id, id
go

sp_dropkey common, sysindexes, syssegments
go
sp_commonkey sysindexes, syssegments, segment, segment
go

if exists (select *
		from syskeys
	where type = 2 and id = object_id("syskeys"))
		execute sp_dropkey foreign, syskeys, sysobjects
go
sp_foreignkey syskeys, sysobjects, id
go

if exists (select *
		from syskeys
	where type = 3 and id = object_id("syskeys"))
		execute sp_dropkey common, syskeys, sysobjects
go
sp_commonkey syskeys, sysobjects, depid, id
go

if exists (select *
		from syskeys
	where type = 3 and id = object_id("sysobjects"))
		execute sp_dropkey common, sysobjects, sysprocedures
go
sp_commonkey sysobjects, sysprocedures, id, id
go

sp_dropkey common, sysobjects, sysprotects
go
sp_commonkey sysobjects, sysprotects, id, id
go

sp_dropkey common, sysobjects, sysusers
go
sp_commonkey sysobjects, sysusers, uid, uid
go

if exists (select *
		from syskeys
	where type = 3 and id = object_id("sysprotects"))
		execute sp_dropkey common, sysprotects, sysusers
go
sp_commonkey sysprotects, sysusers, uid, uid
go

if exists (select *
		from syskeys
	where type = 3 and id = object_id("systypes"))
		execute sp_dropkey common, systypes, sysusers
go
sp_commonkey systypes, sysusers, uid, uid
go

if exists (select *
		from syskeys
	where type = 3 and id = object_id("sysindexes"))
		execute sp_dropkey common, sysindexes, syssegments
go
sp_commonkey sysindexes, syssegments, segment, segment
go

/*
**  Now do the standard systems tables in master.
*/
use master
go

/*
**  Do the primary keys for the system tables.
*/
if exists (select *
		from syskeys
	where type = 1 and id = object_id("sysalternates"))
		execute sp_dropkey primary, sysalternates
go
sp_primarykey sysalternates, suid
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("syscolumns"))
		execute sp_dropkey primary, syscolumns
go
sp_primarykey syscolumns, id, number, colid
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("syscomments"))
		execute sp_dropkey primary, syscomments
go
sp_primarykey syscomments, id, number, colid, texttype
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("sysdepends"))
		execute sp_dropkey primary, sysdepends
go
sp_primarykey sysdepends, id, number, depid, depnumber
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("sysindexes"))
		execute sp_dropkey primary, sysindexes
go
sp_primarykey sysindexes, id, indid
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("syskeys"))
		execute sp_dropkey primary, syskeys
go
sp_primarykey syskeys, id
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("sysobjects"))
		execute sp_dropkey primary, sysobjects
go
sp_primarykey sysobjects, id
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("sysprocedures"))
		execute sp_dropkey primary, sysprocedures
go
sp_primarykey sysprocedures, id, number, type, sequence
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("sysprotects"))
		execute sp_dropkey primary, sysprotects
go
sp_primarykey sysprotects, id, uid, action
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("systypes"))
		execute sp_dropkey primary, systypes
go
sp_primarykey systypes, name
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("sysusers"))
		execute sp_dropkey primary, sysusers
go
sp_primarykey sysusers, suid
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("sysusages"))
		execute sp_dropkey primary, sysusages
go
sp_primarykey sysusages, dbid, lstart
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("sysservers"))
		execute sp_dropkey primary, sysservers
go
sp_primarykey sysservers, srvid
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("sysremotelogins"))
		execute sp_dropkey primary, sysremotelogins
go
sp_primarykey sysremotelogins, remoteserverid, remoteusername
go

/*
**  Now do the foreign keys and common keys.
*/
if exists (select *
		from syskeys
	where type = 2 and id = object_id("sysalternates"))
		execute sp_dropkey foreign, sysalternates, sysusers
go
sp_foreignkey sysalternates, sysusers, suid
go

if exists (select *
		from syskeys
	where type = 3 and id = object_id("syscolumns"))
		execute sp_dropkey common, syscolumns, syscomments
go
sp_commonkey syscolumns, syscomments, id, id
go

sp_dropkey common, syscolumns, syskeys
go
sp_commonkey syscolumns, syskeys, id, key1
go
sp_commonkey syscolumns, syskeys, id, depkey1
go

sp_dropkey common, syscolumns, sysobjects
go
sp_commonkey syscolumns, sysobjects, id, id
go

sp_dropkey common, syscolumns, systypes
go
sp_commonkey syscolumns, systypes, type, type
go
sp_commonkey syscolumns, systypes, usertype, usertype
go
sp_commonkey syscolumns, systypes, domain, domain
go
sp_commonkey syscolumns, systypes, cdefault, tdefault
go

if exists (select *
		from syskeys
	where type = 3 and id = object_id("syscomments"))
		execute sp_dropkey common, syscomments, sysobjects
go
sp_commonkey syscomments, sysobjects, id, id
go

if exists (select *
		from syskeys
	where type = 3 and id = object_id("sysdepends"))
		execute sp_dropkey common, sysdepends, sysobjects
go
sp_commonkey sysdepends, sysobjects, id, id
go

if exists (select *
		from syskeys
	where type = 3 and id = object_id("sysindexes"))
		execute sp_dropkey common, sysindexes, sysobjects
go
sp_commonkey sysindexes, sysobjects, id, id
go

sp_dropkey common, sysindexes, syssegments
go
sp_commonkey sysindexes, syssegments, segment, segment
go

if exists (select *
		from syskeys
	where type = 2 and id = object_id("syskeys"))
		execute sp_dropkey foreign, syskeys, sysobjects
go
sp_foreignkey syskeys, sysobjects, id
go

if exists (select *
		from syskeys
	where type = 3 and id = object_id("syskeys"))
		execute sp_dropkey common, syskeys, sysobjects
go
sp_commonkey syskeys, sysobjects, depid, id
go

if exists (select *
		from syskeys
	where type = 3 and id = object_id("sysobjects"))
		execute sp_dropkey common, sysobjects, sysprocedures
go
sp_commonkey sysobjects, sysprocedures, id, id
go

sp_dropkey common, sysobjects, sysprotects
go
sp_commonkey sysobjects, sysprotects, id, id
go

sp_dropkey common, sysobjects, sysusers
go
sp_commonkey sysobjects, sysusers, uid, uid
go

if exists (select *
		from syskeys
	where type = 3 and id = object_id("sysprotects"))
		execute sp_dropkey common, sysprotects, sysusers
go
sp_commonkey sysprotects, sysusers, uid, uid
go

if exists (select *
		from syskeys
	where type = 3 and id = object_id("systypes"))
		execute sp_dropkey common, systypes, sysusers
go
sp_commonkey systypes, sysusers, uid, uid
go

/*
**  These are in the master database only.
*/
/*  Define primary keys first */
if exists (select *
		from syskeys
	where type = 1 and id = object_id("sysconfigures"))
		execute sp_dropkey primary, sysconfigures
go
sp_primarykey sysconfigures, config
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("sysdatabases"))
		execute sp_dropkey primary, sysdatabases
go
sp_primarykey sysdatabases, name
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("sysdevices"))
		execute sp_dropkey primary, sysdevices
go
sp_primarykey sysdevices, name
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("syslogins"))
		execute sp_dropkey primary, syslogins
go
sp_primarykey syslogins, suid
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("sysmessages"))
		execute sp_dropkey primary, sysmessages
go
sp_primarykey sysmessages, error, dlevel
go

if exists (select *
		from syskeys
	where type = 1 and id = object_id("sysusages"))
		execute sp_dropkey primary, sysusages
go
sp_primarykey sysusages, dbid, lstart
go

/*
**  Now the foreign and common keys.
*/
if exists (select *
		from syskeys
	where type = 3 and id = object_id("syscurconfigs"))
		execute sp_dropkey common, syscurconfigs, sysconfigures
go
sp_commonkey syscurconfigs, sysconfigures, config, config
go

if exists (select *
		from syskeys
	where type = 3 and id = object_id("sysdatabases"))
		execute sp_dropkey common, sysdatabases, syslocks
go
sp_commonkey sysdatabases, syslocks, dbid, dbid
go

sp_dropkey common, sysdatabases, syslogins
go
sp_commonkey sysdatabases, syslogins, suid, suid
go

sp_dropkey common, sysdatabases, sysprocesses
go
sp_commonkey sysdatabases, sysprocesses, dbid, dbid
go

sp_dropkey common, sysdatabases, sysusages
go
sp_commonkey sysdatabases, sysusages, dbid, dbid
go

if exists (select *
		from syskeys
	where type = 3 and id = object_id("syslocks"))
		execute sp_dropkey common, syslocks, sysprocesses
go
sp_commonkey syslocks, sysprocesses, spid, spid
go

if exists (select *
		from syskeys
	where type = 3 and id = object_id("syslogins"))
		execute sp_dropkey common, syslogins, sysprocesses
go
sp_commonkey syslogins, sysprocesses, suid, suid
go

if exists (select *
		from syskeys
	where type = 3 and id = object_id("sysservers"))
		execute sp_dropkey common, sysservers, sysremotelogins
go
sp_commonkey sysservers, sysremotelogins, srvid, remoteserverid
go

if exists (select *
		from syskeys
	where type = 3 and id = object_id("sysremotelogins"))
		execute sp_dropkey common, sysremotelogins, sysusers
go
sp_commonkey sysremotelogins, sysusers, suid, suid
go

dump transaction master to diskdump with truncate_only
go

dump transaction model to diskdump with truncate_only
go

go
dump transaction master with truncate_only
go
dump transaction master to diskdump with truncate_only
go
use master
go
sp_configure "allow updates",0
go
reconfigure with override
go


/* 
NOTE:  you MUST change the last row inserted into MSserver_info
to be version number of this file.  the convention is VV.vvvv, where
VV is major version number ("00" until we ship), and vvvv is minor
version number in the form of month and day (mmdd) of the date you 
check in this file.  add 12 to the month to keep in sync with the
driver version numbers.  e.g. checking in on feb 5 would mean setting
the value to 00.1405.
*/

/****************************************************************************/
/* This portion sets up the ability to perform all the functions in this    */
/* script                                                                    */
/****************************************************************************/
use master
go
dump tran master with truncate_only
go

if exists (select * from sysobjects
           where name = 'sp_configure' and sysstat & 7 = 4)
begin
    execute sp_configure 'update',1
end
reconfigure with override
go
if (exists (select * from sysobjects where name = 'MSdatatype_info'))
    drop table MSdatatype_info
go
if (exists (select * from sysobjects where name = 'MStable_types'))
    drop table MStable_types
go
if (exists (select * from sysobjects where name = 'MSserver_info'))
    drop table MSserver_info
go
if (exists (select * from sysobjects where name = 'sp_tables'))
    drop proc sp_tables
go
if (exists (select * from sysobjects where name = 'sp_statistics'))
    drop proc sp_statistics
go
if (exists (select * from sysobjects where name = 'sp_columns'))
    drop proc sp_columns
go
if (exists (select * from sysobjects where name = 'sp_fkeys'))
    drop proc sp_fkeys
go
if (exists (select * from sysobjects where name = 'sp_pkeys'))
    drop proc sp_pkeys
dump tran master with truncate_only
go

go
if (exists (select * from sysobjects where name = 'sp_stored_procedures'))
    drop proc sp_stored_procedures
go
if (exists (select * from sysobjects where name = 'sp_sproc_columns'))
    drop proc sp_sproc_columns
go
if (exists (select * from sysobjects where name = 'sp_table_privileges'))
    drop proc sp_table_privileges
go
if (exists (select * from sysobjects where name = 'sp_column_privileges'))
	drop proc sp_column_privileges
go
if (exists (select * from sysobjects where name = 'sp_server_info'))
    drop proc sp_server_info
go
if (exists (select * from sysobjects where name = 'sp_datatype_info'))
    drop proc sp_datatype_info
go
if (exists (select * from sysobjects where name = 'sp_special_columns'))
    drop proc sp_special_columns
go
if (exists (select * from sysobjects where name = 'sp_databases'))
	drop proc sp_databases
go

dump tran master with truncate_only
go

print "creating table MSdatatype_info"
go
create table MSdatatype_info (ss_dtype       tinyint      not null,
                            type_name        varchar(32)  not null,
                            data_type        smallint     not null,
                            data_precision   int          null,
                            numeric_scale    smallint     null,
                            numeric_radix    smallint     null,
                            length           int          null,
                            literal_prefix   varchar(32)  null,
                            literal_suffix   varchar(32)  null,
                            create_params    varchar(32)  null,
                            nullable         smallint     not null,
                            case_sensitive   smallint     not null,
                            searchable       smallint     not null)
go

insert into MSdatatype_info
/* ss_type,name,data_type,prec,scale,rdx,len,prf, suf, cp,        nul,case,srch */
values (45,"binary",-2,   null,null,null,255,"0x",null,"max length",1,  1,   1)

insert into MSdatatype_info
/* ss_type,name,data_type,prec,scale,rdx,len,prf, suf, cp, nul,case,srch */
values (50,"bit",-7,        1,   0,   2,null, null,null,null,0,   1,   1)

insert into MSdatatype_info
/* ss_type,name,data_type,prec,scale,rdx,len,prf, suf, cp,       nul,case,srch */
values (47,"char",1,      null,null,null,255,"'", "'","max length",1, 1,   1)

insert into MSdatatype_info
/* ss_type,name, data_type,prec,scale,rdx,len,prf, suf, cp,nul,case,srch */
values (61,"datetime",11,   23,   3,  10,null,"'","'",null,1,  1,   1)

insert into MSdatatype_info
/* ss_type,name,    data_type,prec,scale,rdx,len,prf, suf, cp,nul,case,srch */
values (58,"smalldatetime",11, 23,   3,  10,null,"'","'",null,1,   1,  1)

insert into MSdatatype_info  /* sql server type is "datetimn" */
/* ss_type,name,    data_type,prec,scale,rdx,len,prf, suf, cp,nul,case,srch */
values (111,"datetime",11,     23,   3,   10,null,"'","'",null,1,  1,  1)

insert into MSdatatype_info
/* ss_type, name,data_type,prec,scale,rdx,len,prf, suf, cp,nul,case,srch */
values (62,"float",6,       15,  null,10,null,null,null,null,1,   1,  1)

insert into MSdatatype_info  /* sql server type is "floatn" */
/* ss_type, name,data_type,prec,scale,rdx,len,prf, suf, cp,nul,case,srch */
values (109,"float",6,     15,  null, 10,null, null,null,null,1,  1,  1)

insert into MSdatatype_info
/* ss_type, name,data_type,prec,scale,rdx,len,prf, suf, cp,nul,case,srch */
values (59,"real",7,        7,  null, 10,null, null,null,null,1,  1,  1)

insert into MSdatatype_info
/* ss_type, name, data_type,prec,scale,rdx,len,prf, suf, cp,nul,case,srch */
values(122,"smallmoney",3,    7,   4,   10,null, null,null,null,1,  1,  1)

insert into MSdatatype_info
/* ss_type, name, data_type,prec,scale,rdx,len,prf, suf, cp,nul,case,srch */
values (56,"int",  4,        10,   0,   10,null,null,null,null,1, 1,  1)

insert into MSdatatype_info  /* sql server type is "intn" */
/* ss_type, name, data_type,prec,scale,rdx,len,prf, suf, cp,nul,case,srch */
values (38,"int",   4,      10,   0,   10,null,null,null,null,1, 1,  1)

insert into MSdatatype_info
/* ss_type, name, data_type,prec,scale,rdx,len,prf, suf, cp,nul,case,srch */
values (60,"money", 3,       18,  4,    10,null,null,null,null,1, 1,  1)

insert into MSdatatype_info   /* sql server type is "moneyn" */
/* ss_type, name, data_type,prec,scale,rdx,len,prf, suf, cp,nul,case,srch */
values (110,"money", 3,     18,   4,   10,null,null,null,null,1, 1,  1)

insert into MSdatatype_info
/* ss_type, name, data_type,prec,scale,rdx,len,prf, suf, cp,nul,case,srch */
values (52,"smallint",5,      5,   0,   10,null,null,null,null,1,1,   1)

insert into MSdatatype_info
/* ss_type,name,data_type,prec,scale,rdx,len,        prf, suf,cp,nul,case,srch */
values (35,"text",-1,     null, null,null,2147483647,"'","'",null,1,  1,   1)

insert into MSdatatype_info
/* ss_type,name,data_type,prec,scale,rdx,len,prf, suf,   cp,     nul,case,srch */
values (37,"varbinary",-3,null,null,null,254,"0x",null,"max length",1,1,   1)

insert into MSdatatype_info
/* ss_type,name,data_type,prec,scale,rdx,len,prf, suf,   cp,nul,case,srch */
values (48,"tinyint",-6,   3,    0,   10,null,null,null,null,1,  1,   1)

insert into MSdatatype_info
/* ss_type,name,data_type,prec,scale,rdx,len,prf, suf,   cp,    nul,case,srch */
values (39,"varchar",12,   null,null,null,254,"'","'","max length",1,1,   1)

insert into MSdatatype_info
/* ss_type,name,data_type,prec,scale,rdx,len,prf, suf,   cp,nul,case,srch */
values (34,"image",-4,     null,null,null,2147483647,"0x",null,null,1,1,1)
go

print "creating table MStable_types"
go
create table MStable_types (ss_type char(1),sag_type varchar(32))
go

insert into MStable_types
    values ('S','SYSTEM TABLE')
insert into MStable_types
    values ('U','TABLE')
insert into MStable_types
    values ('V','VIEW')
go

dump tran master with truncate_only
go

print "creating table MSserver_info"
go
create table MSserver_info (attribute_id      int,
                          attribute_name  varchar(60),
                          attribute_value varchar(255))
go

insert into MSserver_info
    values (1,"DBMS_NAME","NETWARE SQL SERVER")
insert into MSserver_info
    values (2,"DBMS_VER","4.2.0")
insert into MSserver_info
    values (6,"DBE_NAME","")
insert into MSserver_info
    values (10,"OWNER_TERM","owner")
insert into MSserver_info
    values (11,"TABLE_TERM","table")
insert into MSserver_info
    values (12,"MAX_OWNER_NAME_LENGTH","30")
insert into MSserver_info
    values (16,"IDENTIFIER_CASE","MIXED")
insert into MSserver_info
    values (15,"COLUMN_LENGTH","30")
insert into MSserver_info
    values (13,"TABLE_LENGTH","30")
insert into MSserver_info
    values (100,"USERID_LENGTH","30")
insert into MSserver_info
    values (17,"TX_ISOLATION","2")
insert into MSserver_info
    values (18,"COLLATION_SEQ","")
insert into MSserver_info
    values (14,"MAX_QUAL_LENGTH","30")
insert into MSserver_info
    values (101,"QUALIFIER_TERM","database")
insert into MSserver_info
    values (19,"SAVEPOINT_SUPPORT","Y")
insert into MSserver_info
    values (20,"MULTI_RESULT_SETS","Y")
insert into MSserver_info
    values (102,"NAMED_TRANSACTIONS","Y")
insert into MSserver_info
    values (103,"SPROC_AS_LANGUAGE","Y")
insert into MSserver_info
    values (103,"REMOTE_SPROC","Y")
insert into MSserver_info
    values (22,"ACCESSIBLE_TABLES","Y")
insert into MSserver_info
    values (104,"ACCESSIBLE_SPROC","Y")
insert into MSserver_info
    values (105,"MAX_INDEX_COLS","16")
insert into MSserver_info
    values (106,"RENAME_TABLE","Y")
insert into MSserver_info
    values (107,"RENAME_COLUMN","Y")
insert into MSserver_info
    values (108,"DROP_COLUMN","N")
insert into MSserver_info
    values (109,"INCREASE_COLUMN_LENGTH","N")
insert into MSserver_info
    values (110,"DDL_IN_TRANSACTION","N")
insert into MSserver_info
    values (111,"DESCENDING_INDEXES","N")
insert into MSserver_info
    values (112,"SP_RENAME","Y")
insert into MSserver_info
    values (500,"SYS_SPROC_VERSION","42.1713")
go

print "creating sp_tables"
go

create procedure sp_tables(@table_name        varchar(32)  = null,
                           @table_owner     varchar(32)  = null,
                           @table_qualifier varchar(32)  = null,
                           @table_type        varchar(100) = null)
as
    declare @type1 char(1),
            @type2 char(1),
            @type3 char(1),
            @tableindex int
    if @table_qualifier is not null
    begin
        if db_name() != @table_qualifier
        begin
            print "Table qualifier must be name of current database"
            return
        end
    end
    if @table_type is null
    begin
        select @type1 = 'U'
        select @type2 = 'V'
        select @type3 = 'S'
    end
    else
    begin
        if (charindex("'TABLE'",@table_type) != 0)
            select @type1 = 'U'
        else
            select @type1 = 'X'
        if (charindex("'SYSTEM TABLE'",@table_type) != 0)
            select @type2 = 'S'
        else
            select @type2 = 'X'
        if (charindex("'VIEW'",@table_type) != 0)
            select @type3 = 'V'
        else
            select @type3 = 'X'
    end
    
    if @table_name is null
    begin
        select @table_name = '%'
    end 
	else begin
        if (@table_owner is null) and (charindex('%', @table_name) = 0)
        begin
            if exists (select * from sysobjects 
                        where uid = user_id()
                        and name = @table_name
                        and (type = 'U' or type = 'V' or type = 'S'))
            begin
                select @table_owner = user_name()
            end
        end
    end
    if @table_owner is null
        select @table_owner = '%'
    select
        table_qualifier = db_name(),
        table_owner=user_name(o.uid),
        table_name=o.name,
        table_type = t.sag_type,
        remarks = convert(varchar(254),null)
    from
        sysusers u,sysobjects o,master.dbo.MStable_types t
    where
        o.name like @table_name
        and user_name(o.uid) like @table_owner
        and o.type = t.ss_type
        and ( o.type = @type1 or o.type = @type2 or o.type = @type3)
        and u.uid=user_id() /* constrain sysusers uid for use in subquery */
        and (suser_id()=1    /* User is the System Administrator */
             or o.uid=user_id()   /* User created the object */
             /* here's the magic... select the highest precedence of permissions in the order (user,group,public)  */
             or ((select max(((sign(uid)*abs(uid-16383))*2)+(protecttype&1))
                  from sysprotects p
                  /* outer join to correlate with all rows in sysobjects */
                  where p.id =* o.id
                      /* get rows for public,current user,user's group */
                      and (p.uid=0 or p.uid=user_id() or p.uid=*u.gid)
                      /* check for SELECT,EXECUTE privilege */
                      and (action in (193,224)))&1     /* more magic...normalize GRANT */
                )=1    /* final magic...compare Grants    */
            )
go

grant execute on sp_tables to public
go

dump tran master with truncate_only
go

print "creating sp_statistics"
go

dump tran master with truncate_only
go


CREATE PROCEDURE sp_statistics (@table_name      varchar(32),
                             @table_owner      varchar(32) = null,
                             @table_qualifier varchar(32) = null,
                             @index_name      varchar(32) = '%',
                             @is_unique       char(1) = 'N')
AS
    DECLARE @indid                int
    DECLARE @lastindid            int
    DECLARE @table_id            int
    DECLARE @full_table_name    char(70)
    if @table_qualifier is not null
    begin
        if db_name() != @table_qualifier
        begin
            print "Table qualifier must be name of current database"
            return
        end
    end
    if @@trancount != 0
    begin
        raiserror 20001 "stored procedure sp_statistics can not be run while in a transaction"
        return
    end
    create table #TmpIndex( table_qualifier varchar(32),
                            table_owner     varchar(32),
                            table_name        varchar(32),
                            index_qualifier varchar(32) null,
                            index_name        varchar(32) null,
                            non_unique        smallint null,
                            type            smallint,
                            seq_in_index    smallint null,
                            column_name     varchar(32) null,
                            collation        char(1) null,
                            remarks         varchar(255) null,
                            index_id        int null,
                            cardinality     int,
                             pages            int,
                             status         smallint)
    if @table_owner is null
    begin
        SELECT @full_table_name = @table_name
    end
    else
    begin
        SELECT @full_table_name = @table_owner + '.' + @table_name
    end
    SELECT @table_id = object_id(@full_table_name)
    SELECT    @indid=min(indid)
    FROM sysindexes
    WHERE id=@table_id
        AND indid > 0
        AND indid < 255
    
    WHILE @indid != NULL
    BEGIN
        INSERT #TmpIndex
        SELECT
            DB_NAME(),                               /* table_qualifier */
            USER_NAME(o.uid),                         /* table_owner     */
            o.name,                                   /* table_name      */
            null,                                     /* index_qualifier */
            x.name,                                   /* index_name      */
            0,                                       /* non_unique      */
            3,                                       /* type            */
            colid,                                   /* seq_in_index    */
            INDEX_COL(@full_table_name,indid,colid), /* column_name     */
            "A",                                     /* collation       */
            "",                                       /*  remarks         */
            @indid,                                   /*  index_id        */
             x.rows,                                 /*  cardinality     */
             x.dpages,                               /* pages            */
            x.status                                 /* status           */
        FROM sysindexes x,syscolumns c,sysobjects o
        WHERE x.id=@table_id
            AND x.id = o.id
            AND x.id=c.id
            AND c.colid<keycnt+ (x.status&16)/16
            AND x.indid=@indid
        /*
        **    Now move @indid to the next index.
        */
        SELECT @lastindid = @indid
        SELECT @indid = NULL
        SELECT @indid = min(indid)
        FROM sysindexes
        WHERE id = @table_id
            AND indid > @lastindid
            AND indid < 255
    END
   
    UPDATE #TmpIndex
        SET non_unique = 1
        WHERE  status&0x2 != 2
    UPDATE #TmpIndex
        SET type = 1
        WHERE  index_id = 1


     /* now add row for table statistics */


      INSERT #TmpIndex  
        SELECT
            DB_NAME(),         /* table_qualifier */
            USER_NAME(o.uid),   /* table_owner     */
            o.name,             /* table_name      */
            null,               /* index_qualifier */ 
            null,               /* index_name      */
            0,                 /* non_unique      */
            0,                 /* type            */
            0,                 /* seq_in_index    */
            null,               /* column_name     */
            null,               /* collation       */
            "",                 /*  remarks         */
            0,                 /*  index_id        */
             x.rows,           /*  cardinality     */
             x.dpages,         /* pages            */
            0                   /* status           */
        FROM sysindexes x, sysobjects o
        WHERE o.id=@table_id
            AND x.id = o.id
            AND (x.indid=0 or x.indid=1)

 
    if @is_unique != 'Y'
        SELECT
            table_qualifier, 
            table_owner,     
            table_name,       
            non_unique,       
            index_qualifier, 
            index_name,       
            type,             
            seq_in_index,     
            column_name,     
            collation,       
            cardinality,     
            pages             
         FROM #TmpIndex       
        WHERE index_name like @index_name or index_name is null   
        ORDER BY non_unique,type,index_name,seq_in_index         
    else
        SELECT
            table_qualifier,
            table_owner,
            table_name,
            non_unique,
            index_qualifier,
            index_name,
            type,
            seq_in_index,
            column_name,
            collation,
            cardinality,
            pages
        FROM #TmpIndex
        WHERE non_unique = 0
            and (index_name like @index_name or index_name is null)
        ORDER BY non_unique,type,index_name,seq_in_index
    DROP TABLE #TmpIndex
go

grant execute on sp_statistics to public
go

dump tran master with truncate_only
go

print "creating sp_columns"
go

CREATE PROCEDURE sp_columns (@table_name varchar(32),
                             @table_owner varchar(32) = null,
                             @table_qualifier varchar(32) = null,
                             @column_name varchar(32) = null )
AS
    if @column_name is null
        select @column_name = '%'
    DECLARE @full_table_name    char(70)
    if @table_qualifier is not null
    begin
        if db_name() != @table_qualifier
        begin
            print "Table qualifier must be name of current database"
            return
        end
    end
		if @table_name is null
		begin
			select @table_name='%'
		end
    if @table_owner is null
    begin
        SELECT @full_table_name = @table_name
    end
    else
    begin
        SELECT @full_table_name = @table_owner + '.' + @table_name
    end
    if (charindex('%',@full_table_name) = 0)
    begin
        SELECT
            table_qualifier = DB_NAME(),
            table_owner = USER_NAME(o.uid),
            table_name = o.name,
            column_name = c.name,
            d.data_type,
            type_name = t.name,
            data_precision=isnull(d.data_precision, convert(int,c.length)),
            length=convert(int,c.length),
            d.numeric_scale,
            d.numeric_radix,
            nullable=convert(smallint, convert(bit, c.status&8)),
            remarks = c.name,
            ss_data_type = c.type
        FROM
        syscolumns c,sysobjects o,master.dbo.MSdatatype_info d, systypes t
        WHERE
            o.id=object_id(@full_table_name)
            AND c.id = o.id
            AND c.type = d.ss_dtype
        AND c.usertype *= t.usertype
            AND c.name like @column_name
    end else
    begin
        if @table_owner is null
            select @table_owner = '%'
        SELECT
            table_qualifier = DB_NAME(),
            table_owner = USER_NAME(o.uid),
            table_name = o.name,
            column_name = c.name,
            d.data_type,
            d.type_name,
            data_precision=isnull(d.data_precision, convert(int, c.length)),
            length=convert(int,c.length),
            d.numeric_scale,
            d.numeric_radix,
            nullable=convert(smallint, convert(bit, c.status&8)),
            remarks = null,
            ss_data_type = c.type
        FROM
            syscolumns c,sysobjects o,master.dbo.MSdatatype_info d, systypes t

        WHERE
            o.name like @table_name
            AND user_name(o.uid) like @table_owner
            AND c.id = o.id
        AND c.usertype *= t.usertype
            AND c.type = d.ss_dtype
            AND c.name like @column_name
    end

    
go

grant execute on sp_columns to public
go

dump tran master with truncate_only
go

print "creating sp_fkeys"
go

CREATE PROCEDURE sp_fkeys( @pktable_name      varchar(32) = null,
                           @pktable_owner      varchar(32) = null,
                           @pktable_qualifier varchar(32) = null,
                           @fktable_name      varchar(32) = null,
                           @fktable_owner      varchar(32) = null,
                           @fktable_qualifier varchar(32) = null )
as
    if (@pktable_name is null) and (@fktable_name is null)
    begin
        print "pk table name or fk table name must be given"
        return
    end
    if @fktable_qualifier is not null
    begin
        if db_name() != @fktable_qualifier
        begin
            print "Foriegn Key Table qualifier must be name of current database"
            return
        end
    end
    if @pktable_qualifier is not null
    begin
        if db_name() != @pktable_qualifier
        begin
            print "Primary Key Table qualifier must be name of current database"
            return
        end
    end

    if @pktable_name is null
        select @pktable_name = '%'
    if @pktable_owner is null
        select @pktable_owner = '%'
    if @fktable_name is null
        select @fktable_name = '%'
    if @fktable_owner is null
        select @fktable_owner = '%'

    if @@trancount != 0
    begin
        raiserror 20001 "catalog procedure sp_fkeys can not be run in a transaction"
        return
    end
    create table #fkeys( pktable_qualifier varchar(32),
                         pktable_owner       varchar(32),
                         pktable_name       varchar(32),
                         pkcolumn_name      varchar(32),
                         fktable_qualifier varchar(32),
                         fktable_owner       varchar(32),
                         fktable_name       varchar(32),
                         fkcolumn_name       varchar(32),
                         key_seq           smallint)
    insert into #fkeys
        select
            db_name(),
            (select user_name(uid) from sysobjects o where o.id = k.depid),
            object_name(k.depid),
            (    select name 
                    from syscolumns
                    where id = k.depid
                    and colid = k.key1),
             db_name(),
            (select user_name(uid) from sysobjects o where o.id = k.id),
            object_name(k.id),
            c.name,
            1
        from
            syskeys k,syscolumns c
        where
            c.id = k.id
            and k.type = 2
            and c.colid = depkey1
        if (@@rowcount    = 0)
            goto done
        insert into #fkeys
            select
                db_name(),
                (select user_name(uid) from sysobjects o where o.id = k.depid),
                object_name(k.depid),
                (select name 
                    from syscolumns
                    where id = k.depid
                    and colid = k.key2),
                db_name(),
                (select user_name(uid) from sysobjects o where o.id = k.id),
                object_name(k.id),
                c.name,
                2
            from
                syskeys k,syscolumns c
            where
                c.id = k.id
                and k.type = 2
                and c.colid = depkey2
        if (@@rowcount = 0)
            goto done
        insert into #fkeys
            select
                db_name(),
                (select user_name(uid) from sysobjects o where o.id = k.depid),
                object_name(k.depid),
                (select name 
                    from syscolumns
                    where id = k.depid
                    and colid = k.key3),
                 db_name(),
                (select user_name(uid) from sysobjects o where o.id = k.id),
                object_name(k.id),
                c.name,
                3
            from
                syskeys k,syscolumns c
            where
                c.id = k.id
                and k.type = 2
                and c.colid = depkey3
        if (@@rowcount = 0)
            goto done
        insert into #fkeys
        select
            db_name(),
            (select user_name(uid) from sysobjects o where o.id = k.depid),
                object_name(k.depid),
                (select name 
                    from syscolumns
                    where id = k.depid
                    and colid = k.key4),
                 db_name(),
                (select user_name(uid) from sysobjects o where o.id = k.id),
                object_name(k.id),
                c.name,
                4
            from
                syskeys k,syscolumns c
            where
                c.id = k.id
                and k.type = 2
                and c.colid = depkey4
        if (@@rowcount = 0)
            goto done
        insert into #fkeys
            select
                db_name(),
                (select user_name(uid) from sysobjects o where o.id = k.depid),
                object_name(k.depid),
                (select name 
                    from syscolumns
                    where id = k.depid
                    and colid = k.key5),
                 db_name(),
                (select user_name(uid) from sysobjects o where o.id = k.id),
                object_name(k.id),
                c.name,
                5
            from
                syskeys k,syscolumns c
            where
                c.id = k.id
                and k.type = 2
                and c.colid = depkey5
        if (@@rowcount = 0)
            goto done
        insert into #fkeys
            select
                db_name(),
                (select user_name(uid) from sysobjects o where o.id = k.depid),
                object_name(k.depid),
                (select name 
                    from syscolumns
                    where id = k.depid
                    and colid = k.key6),
                 db_name(),
                (select user_name(uid) from sysobjects o where o.id = k.id),
                object_name(k.id),
                c.name,
                6
            from
                syskeys k,syscolumns c
            where
                c.id = k.id
                and k.type = 2
                and c.colid = depkey6
        if (@@rowcount = 0)
            goto done
        insert into #fkeys
            select
                db_name(),
                (select user_name(uid) from sysobjects o where o.id = k.depid),
                object_name(k.depid),
                (select name 
                    from syscolumns
                    where id = k.depid
                    and colid = k.key7),
                 db_name(),
                (select user_name(uid) from sysobjects o where o.id = k.id),
                object_name(k.id),
                c.name,
                7
            from
                syskeys k,syscolumns c
            where
                c.id = k.id
                and k.type = 2
                and c.colid = depkey7
        if (@@rowcount    = 0)
            goto done
        insert into #fkeys
            select
                db_name(),
                (select user_name(uid) from sysobjects o where o.id = k.depid),
                object_name(k.depid),
                (select name 
                    from syscolumns
                    where id = k.depid
                    and colid = k.key8),
                 db_name(),
                (select user_name(uid) from sysobjects o where o.id = k.id),
                object_name(k.id),
                c.name,
                8
            from
                syskeys k,syscolumns c
            where
                c.id = k.id
                and k.type = 2
                and c.colid = depkey8
    done:
    select
        pktable_qualifier,
        pktable_owner,
        pktable_name,
        pkcolumn_name,
        fktable_qualifier,
        fktable_owner,
        fktable_name,
        fkcolumn_name,
        key_seq,
        update_delete_rule = 1
    from #fkeys
    where fktable_name like @fktable_name
        and fktable_owner like @fktable_owner
        and pktable_name  like @pktable_name
        and pktable_owner like @pktable_owner
    order by fktable_name,fktable_owner,key_seq
go

grant execute on sp_fkeys to public
go
dump tran master with truncate_only
go



print "creating sp_pkeys"
go

CREATE PROCEDURE sp_pkeys( @table_name    varchar(32),
                           @table_owner varchar(32) = null,
                           @table_qualifier varchar(32)= null )
as
    if @table_qualifier is not null
    begin
        if db_name() != @table_qualifier
        begin
            print "Table qualifier must be name of current database"
            return
        end
    end
    if @table_owner is null
        select @table_owner = '%'
    if @@trancount != 0
    begin
        raiserror 20001 "catalog procedure sp_pkeys can not be run in a transaction"
        return
    end
    create table #pkeys( table_qualifier varchar(32),
                         table_owner     varchar(32),
                         table_name      varchar(32),
                         column_name     varchar(32),
                         key_seq         smallint,
                         update_delete_rule smallint null )
    insert into #pkeys
        select
            db_name(),
            (select user_name(uid) from sysobjects o where o.id = k.id),
            object_name(k.id),
            c.name,
            1,
            null
        from
            syskeys k,syscolumns c
        where
            c.id = k.id
            and k.type = 1
            and c.colid = k.key1
    if (@@rowcount = 0)
        goto done
    insert into #pkeys
        select
            db_name(),
            (select user_name(uid) from sysobjects o where o.id = k.id),
            object_name(k.id),
            c.name,
            2,
            null
        from
            syskeys k,syscolumns c
        where
            c.id = k.id
            and k.type = 1
            and c.colid = key2
    if (@@rowcount = 0)
        goto done
    insert into #pkeys
        select
            db_name(),
            (select user_name(uid) from sysobjects o where o.id = k.id),
            object_name(k.id),
            c.name,
            3,
            null
        from
            syskeys k,syscolumns c
        where
            c.id = k.id
            and k.type = 1
            and c.colid = key3
    if (@@rowcount = 0)
        goto done
    insert into #pkeys
        select
            db_name(),
            (select user_name(uid) from sysobjects o where o.id = k.id),
            object_name(k.id),
            c.name,
            4,
            null
        from
            syskeys k,syscolumns c
        where
            c.id = k.id
            and k.type = 1
            and c.colid = key4
    if (@@rowcount = 0)
        goto done
    insert into #pkeys
        select
                db_name(),
                (select user_name(uid) from sysobjects o where o.id = k.id),
                object_name(k.id),
                c.name,
                5,
            null
        from
            syskeys k,syscolumns c
        where
            c.id = k.id
            and k.type = 1
            and c.colid = key5
    if (@@rowcount = 0)
        goto done
    insert into #pkeys
        select
            db_name(),
            (select user_name(uid) from sysobjects o where o.id = k.id),
            object_name(k.id),
            c.name,
            6,
            null
        from
            syskeys k,syscolumns c
        where
            c.id = k.id
            and k.type = 1
            and c.colid = key6
    if (@@rowcount = 0)
        goto done
    insert into #pkeys
        select
            db_name(),
            (select user_name(uid) from sysobjects o where o.id = k.id),
            object_name(k.id),
            c.name,
            7,
            null
        from
            syskeys k,syscolumns c
        where
            c.id = k.id
            and k.type = 1
            and c.colid = key7
    if (@@rowcount = 0)
        goto done
    insert into #pkeys
        select
            db_name(),
            (select user_name(uid) from sysobjects o where o.id = k.id),
            object_name(k.id),
            c.name,
            8,
            null
        from
            syskeys k,syscolumns c
        where
            c.id = k.id
            and k.type = 1
            and c.colid = key8
    done:
    select 
            table_qualifier,
            table_owner,
            table_name,
            column_name,
            key_seq
            from #pkeys
    where table_name like  @table_name
    and table_owner like @table_owner
    order by table_name,table_owner,key_seq
go

grant execute on sp_pkeys to public
go

dump tran master with truncate_only
go

print "creating sp_stored_procedures"
go

create procedure sp_stored_procedures( @sp_name      varchar(32) = null,
                                       @sp_owner     varchar(32) = null,
                                       @sp_qualifier varchar(32) = null)
as
    if @sp_qualifier is not null
    begin
        if db_name() != @sp_qualifier
        begin
            print "stored procedure qualifier must be name of current database"
            return
        end
    end
    
    if @sp_name is null
    begin
        select @sp_name = '%'
    end 
	else begin
        if (@sp_owner is null) and (charindex('%', @sp_name) = 0)
        begin
            if exists (select * from sysobjects 
                        where uid = user_id()
                        and name = @sp_name
                        and type = 'P')
            begin
                select @sp_owner = user_name()
            end
        end
    end
    if @sp_owner is null
        select @sp_owner = '%'

    select distinct
            sp_qualifier = db_name(),
            sp_owner = user_name(o.uid),
            sp_name = o.name,
            sp_number = p.number,
            sp_num_input_params = -1,
            sp_num_output_params = -1,
            sp_num_result_sets = -1,
            remarks = null
        from
            sysobjects o,sysprocedures p,sysusers u
        where
            o.name like @sp_name
            and user_name(o.uid) like @sp_owner
            and o.type = 'P'
            and p.id = o.id
            and u.uid=user_id()   /* constrain sysusers uid for use in subquery */
            and (suser_id()=1      /* User is the System Administrator */
                    or o.uid=user_id()     /* User created the object */
                    /* here's the magic... select the highest precedence of permissions in the order (user,group,public)  */
                    or ((select max(((sign(uid)*abs(uid-16383))*2)+(protecttype&1))
                         from sysprotects p
                         /* outer join to correlate with all rows in sysobjects */
                         where p.id =* o.id
                             /*  get rows for public,current user,user's group */
                             and (p.uid=0 or p.uid=user_id() or p.uid=*u.gid)
                             /* check for SELECT,EXECUTE privilege */
                             and (action in (193,224)))&1    /* more magic...normalize GRANT */
                        )=1    /* final magic...compare Grants    */
                )
go
grant execute on sp_stored_procedures to public
go

dump tran master with truncate_only
go


print "creating sp_sproc_columns"
go

CREATE PROCEDURE sp_sproc_columns( @sp_name      varchar(32),
                                   @sp_owner     varchar(32) = null,
                                   @sp_qualifier varchar(32) = null,
                           @sp_number  smallint = 1,
                                   @column_name  varchar(32) = null )
AS
    DECLARE @full_sp_name char(70)
    if @sp_qualifier is not null
    begin
        if db_name() != @sp_qualifier
        begin
            print "Table qualifier must be name of current database"
            return
        end
    end
    if @sp_owner is null
        SELECT @full_sp_name = @sp_name
    else
        SELECT @full_sp_name = @sp_owner + '.' + @sp_name
    SELECT
        sp_qualifier = DB_NAME(),
        sp_owner = USER_NAME(o.uid),
        sp_name = o.name,
        sp_number  = c.number,
        column_name = c.name,
        d.data_type,
        type_name = t.name,
        c.length,
        d.data_precision,
        d.numeric_scale,
        d.numeric_radix,
        d.nullable,
        remarks = null,
        ss_data_type = c.type,
        column_type = 1
    FROM
        syscolumns c,sysobjects o,master.dbo.MSdatatype_info d, systypes t
    WHERE o.id=object_id(@full_sp_name)
        AND c.id = o.id
        AND c.type = d.ss_dtype
    AND c.usertype *= t.usertype
        AND c.number = @sp_number
go

grant execute on sp_sproc_columns to public
go

                
print "creating sp_table_privileges"
go


CREATE PROCEDURE sp_table_privileges ( 
                        @table_name  varchar(32),
                        @table_owner varchar(32) = null,
                        @table_qualifier varchar(32)= null)
as        

    declare @table_id    int,
            @owner_id    int,
            @full_table_name char(70)
    
        
    if @table_qualifier is not null
    begin
        if db_name() != @table_qualifier
        begin
            print "Table qualifier must be name of current database"
            return
        end
    end
    if @table_owner is null
    begin
        SELECT @full_table_name = @table_name
    end
    else
    begin
        SELECT @full_table_name = @table_owner + '.' + @table_name
    end
    SELECT @table_id = object_id(@full_table_name)
    if @table_id = 0
    begin
        print "table not found"
        return
    end

    if @@trancount != 0
    begin
        raiserror 20001 "catalog procedure sp_table_privileges can not be run in a transaction"
        return
    end
    create table #table_privileges 
            (table_qualifier         varchar(32),
            table_owner         varchar(32),    
            table_name     varchar(32),
            grantor            varchar(32),
            grantee            varchar(32),
            select_privilege    int,
            select_grantable    int,
            insert_privilege    int,
            insert_grantable    int,
            update_privilege    int,
            update_grantable    int,
            delete_privilege    int,
            delete_grantable    int,
            references_privilege    int null,
            references_grantable    int null,
            uid                 int,
            gid                 int)

    insert into #table_privileges
    select distinct db_name(),
        user_name(o.uid),
        o.name,
        user_name(o.uid),
        u.name,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        null,
        null,
        u.uid,
        u.gid
    from sysusers u, sysobjects o
    where o.id = @table_id
    and u.uid != u.gid
    
    /* 
    ** now add row for table owner
    */    
    if exists (
        select * 
            from #table_privileges
            where grantor = grantee)
    begin
        update #table_privileges
            set select_privilege = 1,
                select_grantable = 1,
                update_privilege = 1,
                update_grantable = 1,
                insert_privilege = 1,
                insert_grantable = 1,
                delete_privilege = 1,
                delete_grantable = 1
            where grantor = grantee
    end
    else 
    begin
        insert into #table_privileges
        select  db_name(),
            user_name(o.uid),
            o.name,
            user_name(o.uid),
            user_name(o.uid),
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            null,
            null,
            o.uid,
            u.gid
        from sysobjects o, sysusers u
        where o.id = @table_id
        and u.uid = o.uid
    end     
             
    update #table_privileges 
        set select_privilege = 1 
        where exists (select * from sysprotects
            where id = @table_id
            and (#table_privileges.uid = uid
                or #table_privileges.gid = uid
                or uid = 0)
            and protecttype = 205
            and action = 193)
        and not exists (select * from sysprotects
            where id = @table_id
            and (#table_privileges.uid = uid
                or #table_privileges.gid = uid
                or uid = 0)
            and protecttype = 206
            and action = 193)

 
    update #table_privileges 
        set insert_privilege = 1 
        where exists (select * from sysprotects 
            where id = @table_id
            and (#table_privileges.uid = uid
                or #table_privileges.gid = uid
                or uid = 0)
            and protecttype = 205
            and action = 195)
        and not exists (select * from sysprotects
            where id = @table_id
            and (#table_privileges.uid = uid
                or #table_privileges.gid = uid
                or uid = 0)
            and protecttype = 206
            and action = 195)

    update #table_privileges 
        set delete_privilege = 1 
        where exists (select * from sysprotects 
            where id = @table_id
            and (#table_privileges.uid = uid
                or #table_privileges.gid = uid
                or uid = 0)
            and protecttype = 205
            and action = 196)
        and not exists (select * from sysprotects
            where id = @table_id
            and (#table_privileges.uid = uid
                or #table_privileges.gid = uid
                or uid = 0)
            and protecttype = 206
            and action = 196)

  


    update #table_privileges 
        set update_privilege = 1 
        where exists (select * from sysprotects 
            where id = @table_id
            and (#table_privileges.uid = uid
                or #table_privileges.gid = uid
                or uid = 0)
            and protecttype = 205
            and action = 197)
        and not exists (select * from sysprotects
            where id = @table_id
            and (#table_privileges.uid = uid
                or #table_privileges.gid = uid
                or uid = 0)
            and protecttype = 206
            and action = 197)

    select 
            table_qualifier,
            table_owner,
            table_name,
            grantor,
            grantee,
            select_privilege,
            select_grantable,
            insert_privilege,
            insert_grantable,
            update_privilege,
            update_grantable,
            delete_privilege,
            delete_grantable,
            references_privilege,
            references_grantable
    from #table_privileges
        where select_privilege != 0
        or insert_privilege != 0
        or delete_privilege != 0
        or update_privilege != 0


go
grant execute on sp_table_privileges to public
go
dump tran master with truncate_only
go
               
print "creating sp_column_privileges"
go

CREATE PROCEDURE sp_column_privileges ( 
                        @table_name  varchar(32),
                        @table_owner varchar(32) = null,
                        @table_qualifier varchar(32)= null,
                        @column_name varchar(32) = null)
as        

    declare @table_id    int,
        @owner_id    int
    DECLARE @full_table_name    char(70)

    declare @low int			/* range of userids to check */
    declare @high int
    declare @objid int			/* id of @name if object */
    declare @owner_name varchar(32)

    select @low = 0, @high = 32767

    if @column_name is null
        select @column_name = '%'

    if @table_qualifier is not null
    begin
        if db_name() != @table_qualifier
        begin
            print "Table qualifier must be name of current database"
            return
        end
    end
    if @table_owner is null
    begin
        SELECT @full_table_name = @table_name
    end
    else
    begin
        SELECT @full_table_name = @table_owner + '.' + @table_name
    end
    select @table_id = 0    
    select @table_id = object_id(@full_table_name) 
    if @table_id = 0
    begin
        print "table not found"
        return
    end

    if @@trancount != 0
    begin
        raiserror 20001 "catalog procedure sp_column_privileges can not be run in a transaction"
        return
    end

    /*
    ** We need to create a table which will contain a row for every row to
    ** be returned to the client.  
    */

    create table #column_privileges 
            (table_qualifier     varchar(32),
            table_owner         varchar(32),    
            table_name         varchar(32),
            column_name         varchar(32),
            grantor            varchar(32),
            grantee            varchar(32),
            select_privilege    int,
            select_grantable    int,
            insert_privilege    int,
            insert_grantable    int,
            update_privilege    int,
            update_grantable    int,
            delete_privilege    int,
            delete_grantable    int,
            references_privilege    int null,
            references_grantable    int null,
            uid                 int,
            gid                 int)

/* 
** insert a row for the table owner (who has all permissions)
*/
    select @owner_name = (select user_name(uid) 
                            from sysobjects 
                                where id = @table_id)


    insert into #column_privileges
    select
            db_name(),
            @owner_name,
            @table_name,
            name,
            @owner_name,
            @owner_name,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            null,
            null,
            user_id(@owner_name),
            0
        from syscolumns 
        where id = @table_id

/* 
** now stick a row in the table for every user in the database        
** we will need to weed out those who have no permissions later
** (and yes this is a cartesion product: the uid field in sysprotects
** can also have a group id, in which case we need to extend those 
** privileges to all group members).
*/
    
    insert into #column_privileges
    select distinct 
        db_name(),
        user_name(o.uid),
        @table_name,
        c.name,
        user_name(o.uid),
        u.name,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        null,
        null,
        u.uid,
        u.gid
    from sysusers u, syscolumns c, sysobjects o
    where o.id = @table_id
        and c.id = o.id
        and u.gid != u.uid
        and u.name != @owner_name

    /*
    ** we need to create another temporary table to contain all the various
    ** protection information for the table in question
    */
    create table #protects (uid smallint,
                            action tinyint,
                            protecttype tinyint,
                            name    varchar(32))
    insert into #protects
	select  p.uid,
            p.action,
            p.protecttype,
		    isnull(col_name(id, c.number), "All")
		from sysprotects p, master.dbo.spt_values c,
				master.dbo.spt_values a, master.dbo.spt_values b
			where convert(tinyint, substring(isnull(p.columns, 0x1), c.low, 1))
				& c.high != 0
				and c.number <=
					(select count(*)
						from syscolumns
						where id = @table_id)
				and a.type = "T"
				and a.number = p.action
				and b.type = "T"
				and b.number = p.protecttype
				and p.id = @table_id
				and p.uid between @low and @high


    update #column_privileges 
        set select_privilege = 1 
        where exists 
            (select * from #protects
            where protecttype = 205
            and action = 193
            and ( name = #column_privileges.column_name
                  or name = 'All')
            and ( uid = 0 
                  or uid = #column_privileges.gid
                  or uid = #column_privileges.uid))
        and not exists (select * from #protects
            where protecttype = 206
            and action = 193
            and ( name = #column_privileges.column_name
                  or name = 'All')
            and ( uid = 0 
                  or uid = #column_privileges.gid
                  or uid = #column_privileges.uid))

  
          
    update #column_privileges 
        set insert_privilege = 1 
        where exists (select * from #protects 
            where protecttype = 205
            and action = 195
            and ( name = #column_privileges.column_name
                  or name = 'All')
            and  ( uid = 0 
                  or uid = #column_privileges.gid
                  or uid = #column_privileges.uid))
        and not exists (select * from #protects
            where protecttype = 206
            and action = 195
            and ( name = #column_privileges.column_name
                  or name = 'All')
            and ( uid = 0 
                  or uid = #column_privileges.gid
                  or uid = #column_privileges.uid))


            
    update #column_privileges 
        set insert_privilege = 1 
        where exists (select * from #protects 
            where protecttype = 205
            and action = 196
            and ( name = #column_privileges.column_name
                  or name = 'All')
            and ( uid = 0 
                  or uid = #column_privileges.gid
                  or uid = #column_privileges.uid))
        and not exists (select * from #protects
            where protecttype = 206
            and action = 196
            and ( name = #column_privileges.column_name
                  or name = 'All')
            and ( uid = 0 
                  or uid = #column_privileges.gid
                  or uid = #column_privileges.uid))

 
    update #column_privileges
        set update_privilege = 1 
        where exists (select * from #protects 
            where protecttype = 205
            and action = 197
            and ( name = #column_privileges.column_name
                  or name = 'All')
            and ( uid = 0 
                  or uid = #column_privileges.gid
                  or uid = #column_privileges.uid))
        and not exists (select * from #protects
            where protecttype = 206
            and action = 197
            and ( name = #column_privileges.column_name
                  or name = 'All')
            and ( uid = 0 
                  or uid = #column_privileges.gid
                  or uid = #column_privileges.uid))

 
          
    select 
            table_qualifier,
            table_owner,
            table_name,
            column_name,
            grantor,
            grantee,
            select_privilege,
            select_grantable,
            insert_privilege,
            insert_grantable,
            update_privilege,
            update_grantable,
            delete_privilege,
            delete_grantable,
            references_privilege,
            references_grantable
    from #column_privileges
        where column_name like @column_name
        and ( select_privilege != 0
        or insert_privilege != 0
        or delete_privilege != 0
        or update_privilege != 0)




drop table #column_privileges
drop table #protects
go
grant execute on sp_column_privileges to public
go
dump tran master with truncate_only



print "creating sp_server_info"
if (exists (select * from sysobjects where name = 'sp_server_info'))
    drop proc sp_server_info
go

create proc sp_server_info (@attribute_id  int = null)
as
    if @attribute_id is not null
        select *
        from master.dbo.MSserver_info
        where attribute_id = @attribute_id
    else
        select *
        from master.dbo.MSserver_info

go

grant execute on sp_server_info to public
go

print "creating sp_datatype_info"
if (exists (select * from sysobjects where name = 'sp_datatype_info'))
    drop proc sp_datatype_info
go

/* the messiness of 'data_type' was to get around the problem of
returning the correct lengths for user defined types.  the join
on the type name ensures all user defined types are returned, but
this puts a null in the data_type column.  by forcing an embedded
select and correlating it with the current row in systypes, we get
the correct data_type mapping even for user defined types  (kwg) */

create proc sp_datatype_info (@data_type int = 0)
as
    if @data_type = 0
        select
            type_name = t.name,
            d.data_type,
            t.length,
            d.literal_prefix,
            d.literal_suffix,
            d.create_params,
            d.nullable,
            d.case_sensitive,
            d.searchable
        from master.dbo.MSdatatype_info d, systypes t
        where d.ss_dtype = t.type and
          t.type not in (111,109,38,110)  /* get rid of nullable types */
    else
        select
            type_name = t.name,
            d.data_type,
            t.length,
            d.literal_prefix,
            d.literal_suffix,
            d.create_params,
            d.nullable,
            d.case_sensitive,
            d.searchable
        from master.dbo.MSdatatype_info d, systypes t
        where data_type = @data_type and
             d.ss_dtype = t.type and
          t.type not in (111,109,38,110)
go

grant execute on sp_datatype_info to public
go

dump tran master with truncate_only
go

print "creating sp_special_columns"
if (exists (select * from sysobjects where name = 'sp_special_columns'))
    drop proc sp_special_columns
go

dump tran master with truncate_only
go


CREATE PROCEDURE sp_special_columns (@table_name      varchar(32),
                             @table_owner      varchar(32) = null,
                             @table_qualifier varchar(32) = null,
                             @col_type       char(1) = 'R')
AS
    DECLARE @indid                int
    DECLARE @table_id            int
    DECLARE @full_table_name    char(70)
    DECLARE @msg          char(70)

    if @table_qualifier is not null
    begin
        if db_name() != @table_qualifier
        begin
            print "Table qualifier must be name of current database"
            return
        end
    end
    if @table_owner is null
    begin
        SELECT @full_table_name = @table_name
    end
    else
    begin
        SELECT @full_table_name = @table_owner + '.' + @table_name
    end
    SELECT @table_id = object_id(@full_table_name)
    
  /* if we just need ROWVER, just run that query */
    if @col_type = 'V'
  BEGIN
    SELECT   
        scope = 1,
        column_name = c.name,
        d.data_type,
            type_name = t.name,
            data_precision=isnull(d.data_precision, c.length),
            c.length,
            d.numeric_scale
      FROM
            systypes t,syscolumns c,  master.dbo.MSdatatype_info d
      WHERE
          c.id=@table_id
          AND c.type = d.ss_dtype
      AND t.type = c.type 
      AND t.usertype = 80 
    RETURN
  END
  /* now find the id of the 'best' index for this table */

  SELECT @indid = (
    SELECT MIN(indid) 
      FROM sysindexes
          WHERE  status&2 = 2
      AND id = @table_id
      AND indid > 0)

   SELECT
      scope = 3,
      column_name = INDEX_COL(@full_table_name,indid,colid),
      d.data_type,
       d.type_name,
      data_precision=isnull(d.data_precision, c.length),
      c.length,
      d.numeric_scale
    FROM sysindexes x,syscolumns c,  master.dbo.MSdatatype_info d
    WHERE x.id=@table_id
        AND x.id=c.id
        AND c.colid<keycnt+ (x.status&16)/16
        AND x.indid=@indid
      AND c.type = d.ss_dtype

go  
grant execute on sp_special_columns to public
go




print "creating sp_databases"
if (exists (select * from sysobjects where name = 'sp_databases'))
  drop proc sp_databases
go

create procedure sp_databases
        as
        create table #databases ( database_name varchar(32),
                                  size int)
        insert into #databases                          
        select  name,
            (select sum(size) from master.dbo.sysusages
          where dbid = d.dbid )
        from master.dbo.sysdatabases d
        select database_name, database_size = size*2, remarks = null
        from #databases
go
grant execute on sp_databases to public
go

dump tran master with truncate_only
go






/*******************************************************************************/
/* This portion returns everything back to normal                   */
/*******************************************************************************/
use master
go

if exists (select * from sysobjects
           where name = 'sp_configure' and sysstat & 7 = 4)
begin
    execute sp_configure 'update',0
end
reconfigure with override
go
checkpoint
go
print 'Loading of master database is complete.'
go
