/***********************************************************************/
//
//	  DOCSAPI.H : Header file for the PC DOCS Open Toolkit
//	  Copywrite (c) 1994 PC DOCS, INC.
//
/************************************************************************/

// So this is only included once...
#ifndef ___DOCSAPI_H_
#define ___DOCSAPI_H_


// Column Types for the SQLView objects methods...
typedef enum COLUMN_TYPE
   {
   COLTYPE_DATE,          // DATE 		-> 0
   COLTYPE_TIME,		  // TIME 		-> 1
   COLTYPE_STRING,		  // STRING 	-> 2
   COLTYPE_INT,			  // INTEGER 	-> 3
   COLTYPE_CHAR,		  // CHAR 		-> 4
   COLTYPE_FOREIGNKEY	  // FOREIGNKEY -> 5
   };

// So C code will compile as well as C++
#ifdef __cplusplus
extern "C" {
#endif

// DMS API functions
int FAR _export PASCAL DOCSAddDocumentComponent( LPSTR app, LPSTR fileIn, LPSTR componentPath );
int FAR _export PASCAL DOCSCloseDocument( LPSTR app, LPSTR fileName );
int FAR _export PASCAL DOCSOpenDocument( LPSTR app, LPSTR fileName );
int FAR _export PASCAL DOCSOpenDocumentReadOnly( LPSTR app, LPSTR fileName );
int FAR _export PASCAL DOCSOpenSelectedDocument( LPSTR documentNumber, LPSTR libraryName, LPSTR appName, LPSTR fileName );
int FAR _export PASCAL DOCSQBEOpenDocument( LPSTR searchCriteria, LPSTR app, LPSTR fileName );
int FAR _export PASCAL DOCSQBESelectDocument( LPSTR searchCriteria, LPSTR documentNumber, LPSTR libraryName );
int FAR _export PASCAL DOCSReleaseReadOnlyDocument( LPSTR app, LPSTR fileName );
int FAR _export PASCAL DOCSSaveAsAttachment( LPSTR app, LPSTR fileIn, int flags, LPSTR versionLabel, LPSTR docPath, LPSTR shadowPath );
int FAR _export PASCAL DOCSSaveDoc( LPSTR app, LPSTR fileIn, int flags, LPSTR docPath, LPSTR shadowPath );
int FAR _export PASCAL DOCSSaveDocAs( LPSTR app, LPSTR fileIn, int flags, LPSTR docPath, LPSTR shadowPath );
int FAR _export PASCAL DOCSSaveDocument( LPSTR app, LPSTR fileIn, LPSTR docPath, LPSTR shadowPath );
int FAR _export PASCAL DOCSSaveDocumentAs( LPSTR app, LPSTR fileIn, LPSTR docPath, LPSTR shadowPath );
int FAR _export PASCAL DOCSSelectDocument( LPSTR documentNumber, LPSTR libraryName );

// SQLView class integration
int FAR _export PASCAL DOCSSQLNewView( LPSTR libraryName, LPSTR tableName );
int FAR _export PASCAL DOCSSQLAddColumn( int hSQLView, LPSTR columnName, int dataType );
int FAR _export PASCAL DOCSSQLAddJoinColumn( int hSQLView, LPSTR columnName, int dataType,LPSTR foreignTable, int candidateKey );
int FAR _export PASCAL DOCSSQLSetColumnValue( int hSQLView, LPSTR columnName, LPSTR value );
int FAR _export PASCAL DOCSSQLSelect( int hSQLView );
int FAR _export PASCAL DOCSSQLInsert( int hSQLView );
int FAR _export PASCAL DOCSSQLUpdate( int hSQLView, LPSTR whereClause );
int FAR _export PASCAL DOCSSQLDelete( int hSQLView, LPSTR whereClause );
int FAR _export PASCAL DOCSSQLGetColumnValue( int hSQLView, LPSTR columnName, LPSTR buffer, int bufferSize );
int FAR _export PASCAL DOCSSQLNextRow( int hSQLView );
int FAR _export PASCAL DOCSSQLFreeResultSet( int hSQLView );
int FAR _export PASCAL DOCSSQLFreeView( int hSQLView );
int FAR _export PASCAL DOCSSQLGetError( int hSQLView );

// DocumentProfile class interface
int FAR _export PASCAL DOCSNewProfile( LPSTR libraryName );
int FAR _export PASCAL DOCSSetProfileValue( int hProfile, LPSTR columnName, LPSTR value );
int FAR _export PASCAL DOCSSaveProfile( int hProfile, int flags, LPSTR documentPath );
int FAR _export PASCAL DOCSAddProfileComponent( int hProfile, LPSTR componentPath );
int FAR _export PASCAL DOCSFreeProfile( int hProfile );
int FAR _export PASCAL DOCSGetProfileError( int hProfile );

// Utility API functions
int FAR _export PASCAL DOCSAddPrintActivity( LPSTR appID, LPSTR openFileID, UINT pages, LPSTR billable );
int FAR _export PASCAL DOCSAppExit( LPSTR app );
int FAR _export PASCAL DOCSAssignFileACL( LPSTR app, LPSTR fileIn );
int FAR _export PASCAL DOCSGetMessageText( LPSTR messageID, LPSTR messageBuffer, UINT bufferLen );
int FAR _export PASCAL DOCSGetProfileInfo( LPSTR openDocumentID, LPSTR itemName, LPSTR itemBuffer, UINT bufferLen );
int FAR _export PASCAL DOCSSetProfileDefault( LPSTR itemName, LPSTR value, UINT disable );
int FAR _export PASCAL DOCSSwitchToDesktop();
int FAR _export PASCAL PerformLookUp( LPSTR library, LPSTR lookUpID, LPSTR SQLItem, LPSTR SQLFilter, LPSTR retBuffer );
int FAR _export PASCAL RemoveCloseOption( int menu );
int FAR _export PASCAL DOCSViewDocument ( LPSTR docNum, LPSTR version, LPSTR library);
int FAR _export PASCAL DOCSPrintDocument( LPSTR docNum, LPSTR version, LPSTR library);
int FAR _export PASCAL DOCSGetCurrentLibrary (LPSTR libName);
int FAR _export PASCAL DOCSGetNetUserID (LPSTR userName);


#ifdef _cplusplus
}
#endif



#endif        // if not defined __DOCSAPI_H_