//*********************************************************
//
//   PC DOCS Open ToolKit Sample Application Series
//   ----------------------------------------------
//
//   Program Name: API3 - A SQLView example
//
//   Description: This application provides an example
//   of how to use the SQLView Object interface.
//   This was created with Borland C v4.0 in Large Model.
//   It was tested against PC DOCS Open v2.0
//
//   WARNING! This is a sample application and should
//   be used in a test environment only. These examples
//   have been tested but are EXAMPLES only and are not
//   to be presented as 100% error free.
//
//   Copyright 1994 by PCDOCS,INC.
//
//*********************************************************
#define STRICT         // Do strict type checking
#include <Windows.h>   // Windows API include file
#include "docsapi.h"   // Include file for PC DOCS Open API
#include "api.h"       // Include file for API samples series...

// Column Types needed for SQLView Functions
typedef enum COLUMN_TYPE
   {
   COLTYPE_DATE,
   COLTYPE_TIME,
   COLTYPE_STRING,
   COLTYPE_INT,
   COLTYPE_CHAR,
   COLTYPE_FOREIGNKEY
   };

HWND      hWndMain;            // hWnd of main window
HINSTANCE hInst;               // We will need this in several places later...
LPSTR     lpAppId = "PCDAPI";  // Application ID registered with PC DOCS
LPSTR     lpCaption = "PC DOCS Open API Sample App";

// Our Function prototypes
int                      DoSQLView4Me(HWND);
int      PASCAL          WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int cmdShow);
BOOL FAR PASCAL  _export About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL  _export ApiDialog(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK _export ApiWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);


/************************************************************************/
//  Windows Main Function - 
//  Purpose: Setup the application and start the message loop
/************************************************************************/
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
   MSG msg;
   WNDCLASS wcTstAppClass;

   hInst = hInstance;       // save for use by window procs

   if (hPrevInstance == 0)
      {
      // fill in window class information only for 1st instance of program
      wcTstAppClass.lpszClassName = lpAppId;
      wcTstAppClass.hInstance     = hInstance;
      wcTstAppClass.lpfnWndProc   = ApiWndProc;
      wcTstAppClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
      wcTstAppClass.hIcon         = LoadIcon(hInstance, lpAppId);
      wcTstAppClass.lpszMenuName  = (LPSTR) "PCDAPI3";
      wcTstAppClass.hbrBackground = (HBRUSH) (COLOR_BACKGROUND + 1);
      wcTstAppClass.style         = CS_HREDRAW | CS_VREDRAW;
      wcTstAppClass.cbClsExtra    = 0;
      wcTstAppClass.cbWndExtra    = 0;

      // register the class
      RegisterClass(&wcTstAppClass);
      }

   hWndMain = CreateWindow(
               lpAppId,                          // window class name
               "PC DOCS OPEN - SQLView Sample",  // window title
               WS_OVERLAPPEDWINDOW,              // type of window
               150,                              // x  window location
               200,                              // y
               500,                              // cx and size
               150,                              // cy
               NULL,                             // no parent for this window
               NULL,                             // use the class menu
               hInstance,                        // who created this window
               NULL);                            // no parms to pass on

   // Putup the window
   ShowWindow(hWndMain, nCmdShow);
   UpdateWindow(hWndMain);

   // Our message loop
   while( GetMessage( &msg, NULL, 0, 0 ) )
      {
      TranslateMessage( &msg );
      DispatchMessage( &msg );
      }

   // Tell PC DOCS that we are exiting
   DOCSAppExit(lpAppId);   
   return msg.wParam;
}

/************************************************************************/
//  Windows Callback function for our Main Window
//  Purpose: Handle all messages for the main window
/************************************************************************/
LRESULT CALLBACK _export ApiWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
   FARPROC lpproc;

   switch (message)
      {
      case WM_COMMAND:
         switch (wParam)
            {
            case IDM_QUIT:
               // User has selected QUIT from menu.
               PostMessage(hWnd, WM_CLOSE, 0, 0L);
               break;

            case IDM_API:
               // User wants to run a SQL Query
               // So, put up a dialog box to handle this...
               lpproc = MakeProcInstance((FARPROC)ApiDialog, hInst);
               DialogBox(hInst, (LPCSTR)"APIDIALOG3", hWnd, (DLGPROC)lpproc);
               FreeProcInstance(lpproc);
               break;

            case IDM_ABOUT:
               // User has selected ABOUT from menu.
               lpproc = MakeProcInstance((FARPROC)About, hInst);
               DialogBox(hInst, (LPCSTR)"ABOUTAPI", hWnd, (DLGPROC)lpproc);
               FreeProcInstance(lpproc);
               break;

            default:
               break;
            }
         break;

      case WM_DESTROY:
         // This is the end if we were closed by a DestroyWindow call.
         PostQuitMessage(0);    // this is the end...
         break;

      case WM_QUERYENDSESSION:
         // If we return TRUE we are saying it's ok with us to end the
         // windows session.
         return((long) TRUE);   // we agree to end session.

      case WM_CLOSE:
         // Tell windows to terminate us.
         DestroyWindow(hWnd);
         break;

      default:
         // Let windows handle all messages we choose to ignore.
         return(DefWindowProc(hWnd, message, wParam, lParam));
      }

    return(0L);
}

/************************************************************************/
//  Dialog box Callback function for our About Dialog box
//  Purpose: Handle all messages for the About dialog box
/************************************************************************/
BOOL FAR PASCAL _export About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
   // We get this message when the dialog box is about to be put up on the screen
   if (message == WM_INITDIALOG)
      return(TRUE);

   else if (message == WM_COMMAND)
      {
      switch (wParam)
         {
         // If they hit the ok button End the dialog box
         case IDOK:
            EndDialog(hDlg, TRUE);
            return(TRUE);

         default:
            return(TRUE);
         }
      }
      
   return(FALSE);
}

/************************************************************************/
//  Dialog box Callback function for our "SQLView" dialog box
//  Purpose: Handle all messages for the "SQLView" dialog box
/************************************************************************/
BOOL FAR PASCAL _export ApiDialog(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
   // Initializing the dialog box - we don't care...
   if (message == WM_INITDIALOG)
      return(TRUE);

   // We have the dialog box up and running and they hit a button...
   else if (message == WM_COMMAND)
      {
      switch (wParam)
         {
         case IDOK:
            // User hit the "Run Query" button and wants me
            // to run the SQLView query for them...
            DoSQLView4Me(hDlg);
            return(TRUE);

         case IDCANCEL:
            // User hit the Cancel button so exit dialog box
            EndDialog(hDlg, FALSE);
            return(TRUE);

         default:
            // All other messages we don't want to deal with
            return(TRUE);
         }
      }
   // They choose "Close" from the system menu of the dialog box
   else if (message == WM_CLOSE)
      {
      EndDialog(hDlg, TRUE);
      return (TRUE);
      }

   return(FALSE);
}

/************************************************************************/
//  DoSQLView4Me
//  Purpose: To execute a SQLView Query for me.
/************************************************************************/
int DoSQLView4Me(HWND hDlg)
{
   // Our variable declarations
   char Table[144] = "PROFILE";
   char Library[144], UserID[144] = " ";
   char DocNumber[144], DocName[144];
   char LineOut[256];
   int  hSqlView;
   int  rc;

   // Set the cursor to the hour glass
   HCURSOR hOldCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
   SendDlgItemMessage(hDlg, ID_LISTBOX, LB_RESETCONTENT, (WPARAM)0, (LPARAM)0L);
   EnableWindow(GetDlgItem(hDlg, IDOK), FALSE);
   EnableWindow(GetDlgItem(hDlg, IDCANCEL), FALSE);

   // Grab the Library and UserID off the dialog box
   GetDlgItemText(hDlg, ID_LIBRARY, Library, sizeof(Library));
   GetDlgItemText(hDlg, ID_USERID,  UserID, sizeof(UserID));

   // Check to make suer user entered values for both Library and UserID
   if (lstrlen(Library) == 0)
      {
      MessageBox(hDlg, "You need to enter a value for the Library", lpCaption, MB_OK|MB_ICONSTOP);
      SetFocus(GetDlgItem(hDlg, ID_LIBRARY));
      EnableWindow(GetDlgItem(hDlg, IDOK), TRUE);
      EnableWindow(GetDlgItem(hDlg, IDCANCEL), TRUE);
      return 0;
      }

   if (lstrlen(UserID) == 0)
      {
      rc = MessageBox(hDlg, "Do you want to get every document from your library?", lpCaption, MB_YESNO|MB_ICONQUESTION);
      if (rc == IDNO)
         {
         SetFocus(GetDlgItem(hDlg, ID_USERID));
         EnableWindow(GetDlgItem(hDlg, IDOK), TRUE);
         EnableWindow(GetDlgItem(hDlg, IDCANCEL), TRUE);
         return 0;
         }
      }

   // Get a new SQLView object from DOCS...
   hSqlView = DOCSSQLNewView(Library, Table);

   // Add Columns to our SQLView that we want values back for...
   DOCSSQLAddColumn(hSqlView, "DOCNUMBER", COLTYPE_INT);
   DOCSSQLAddColumn(hSqlView, "DOCNAME",   COLTYPE_STRING);

   // We need to add this column in order to join with the People table
   DOCSSQLAddColumn(hSqlView, "AUTHOR", COLTYPE_STRING);

   // We need to Join with the PEOPLE table to validate against the UserID
   DOCSSQLAddJoinColumn(hSqlView, "AUTHOR.USER_ID", COLTYPE_STRING, "PEOPLE", 1);

   // if they entered a UserID set it in our View...
   if (lstrlen(UserID) != 0)
      DOCSSQLSetColumnValue(hSqlView, "AUTHOR.USER_ID", UserID);

   // Our SQLView now looks like this to DOCS...
   // Select Profile.DocNumber, Profile.DocName
   // From Profile, People
   // Where Profile.Author = People.System_id
   //   and People.User_id = {UserID}

   // Issue the above SQLView to DOCS to run it for us...
   if ((rc = DOCSSQLSelect(hSqlView)) == 0)
      MessageBox(hDlg, "Either Select Failed\r\nOr Returned no data!", lpCaption, MB_OK|MB_ICONSTOP);

   while (rc != 0)
      {
      // Get the DOCNUMBER and DOCNAME from DOCS...
      DOCSSQLGetColumnValue(hSqlView, "DOCNUMBER", DocNumber, sizeof(DocNumber));
      DOCSSQLGetColumnValue(hSqlView, "DOCNAME",   DocName,   sizeof(DocName));
      wsprintf((LPSTR)LineOut, "%s\t%s", (LPSTR)DocNumber, (LPSTR)DocName);
      // Put it up on the list box
      SendDlgItemMessage(hDlg, ID_LISTBOX, LB_ADDSTRING, (WPARAM)0, (LPARAM)(LPCSTR)LineOut);

      // Get the Next Row from DOCS (move the cursor to the next logical row)
      rc = DOCSSQLNextRow(hSqlView);
      }

   // Free the Result set from memory (both server and client)
   DOCSSQLFreeResultSet(hSqlView);
   // Free the View from DOCS memory
   DOCSSQLFreeView(hSqlView);

   // Return the cursor to what it was before
   SetCursor(hOldCursor);
   EnableWindow(GetDlgItem(hDlg, IDOK), TRUE);
   EnableWindow(GetDlgItem(hDlg, IDCANCEL), TRUE);
   MessageBox(hDlg, "Done retrieving data.\r\nThanks for your patience!", lpCaption, MB_OK|MB_ICONINFORMATION);
   return 1;
}
