//*********************************************************
//
//   PC DOCS Open ToolKit Sample Application Series
//   ----------------------------------------------
//
//   Program Name: API2 - Import a document
//
//   Description: This application provides examples
//   for the DocumentProfile Object Interface.
//   This was created with Borland C v4.0 in Large Model.
//   It was tested against PC DOCS Open v2.0
//
//   WARNING! This is a sample application and should
//   be used in a test environment only. These examples
//   have been tested but are EXAMPLES only and are not
//   to be presented as 100% error free.
//
//   Copyright 1994 by PCDOCS,INC.
//
//*********************************************************
#define STRICT         // Do strict type checking
#include <Windows.h>   // Windows API include file
#include <Commdlg.h>   // include for File Open common dialog box
#include <Mem.h>       // For file operations
#include <dos.h>
#include <dir.h>
#include <io.h>
#include "docsapi.h"   // Include file for PC DOCS Open API
#include "api.h"       // Include file for API samples series...

// Name of our DOCS Library - taken off the Dialog box
char far  glpLibName[50];

HWND      hWndMain;            // hWnd of main window
HINSTANCE hInst;               // We will need this in several places later...
LPSTR     lpAppId = "PCDAPI";  // Application ID registered with PC DOCS
LPSTR     lpCaption = "PC DOCS Open API Sample App";

// Our function prototypes
int                      ImportDoc4Me(HWND hDlg, LPSTR lpFileName);
int                      GetAFileToImport(HWND hDlg, LPSTR lpFileName);
int                      FileCopy( const char *source, const char *dest );
int      PASCAL          WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int cmdShow);
BOOL FAR PASCAL  _export About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL  _export ApiDialog (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK _export ApiWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

/************************************************************************/
//  Windows Main Function - 
//  Purpose: Setup the application and start the message loop
/************************************************************************/
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
   MSG msg;
   WNDCLASS wcTstAppClass;

   hInst = hInstance;       // save for use by window procs

   if (hPrevInstance == 0)
      {
      // fill in window class information only for 1st instance of program
      wcTstAppClass.lpszClassName = lpAppId;
      wcTstAppClass.hInstance     = hInstance;
      wcTstAppClass.lpfnWndProc   = ApiWndProc;
      wcTstAppClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
      wcTstAppClass.hIcon         = LoadIcon(hInstance, lpAppId);
      wcTstAppClass.lpszMenuName  = (LPSTR) "PCDAPI2";
      wcTstAppClass.hbrBackground = (HBRUSH) (COLOR_BACKGROUND + 1);
      wcTstAppClass.style         = CS_HREDRAW | CS_VREDRAW;
      wcTstAppClass.cbClsExtra    = 0;
      wcTstAppClass.cbWndExtra    = 0;

      // register the class
      RegisterClass(&wcTstAppClass);
      }

   hWndMain = CreateWindow(
               lpAppId,                            // window class name
               "PC DOCS OPEN - Import a document", // window title
               WS_OVERLAPPEDWINDOW,                // type of window
               150,                                // x  window location
               200,                                // y
               500,                                // cx and size
               150,                                // cy
               NULL,                               // no parent for this window
               NULL,                               // use the class menu
               hInstance,                          // who created this window
               NULL);                              // no parms to pass on

   // Putup the window
   ShowWindow(hWndMain, nCmdShow);
   UpdateWindow(hWndMain);

   // Our message loop
   while( GetMessage( &msg, NULL, 0, 0 ) )
      {
      TranslateMessage( &msg );
      DispatchMessage( &msg );
      }

   // Tell PC DOCS that we are exiting
   DOCSAppExit(lpAppId);
   return msg.wParam;
}

/************************************************************************/
//  Windows Callback function for our Main Window
//  Purpose: Handle all messages for the main window
/************************************************************************/
LRESULT CALLBACK _export ApiWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
   FARPROC lpproc;

   switch (message)
      {
      case WM_COMMAND:
         switch (wParam)
            {
            case IDM_QUIT:
               // User has selected QUIT from menu.
               PostMessage(hWnd, WM_CLOSE, 0, 0L);
               break;

            case IDM_API:
               // User wants to import a document
               // So, put up a dialog box to handle this...
               lpproc = MakeProcInstance((FARPROC)ApiDialog, hInst);
               DialogBox(hInst, (LPCSTR)"APIDIALOG2", hWnd, (DLGPROC)lpproc);
               FreeProcInstance(lpproc);
               break;

            case IDM_ABOUT:
               // User has selected ABOUT from menu.
               lpproc = MakeProcInstance((FARPROC)About, hInst);
               DialogBox(hInst, (LPCSTR)"ABOUTAPI", hWnd, (DLGPROC)lpproc);
               FreeProcInstance(lpproc);
               break;

            default:
               break;
            }
         break;

      case WM_DESTROY:
         // This is the end if we were closed by a DestroyWindow call.
         PostQuitMessage(0);    // this is the end...
         break;

      case WM_QUERYENDSESSION:
         // If we return TRUE we are saying it's ok with us to end the
         // windows session.
         return((long) TRUE);   // we agree to end session.

      case WM_CLOSE:
         // Tell windows to terminate us.
         DestroyWindow(hWnd);
         break;

      default:
         // Let windows handle all messages we choose to ignore.
         return(DefWindowProc(hWnd, message, wParam, lParam));
      }

    return(0L);
}

/************************************************************************/
//  Dialog box Callback function for our About Dialog box
//  Purpose: Handle all messages for the About dialog box
/************************************************************************/
BOOL FAR PASCAL _export About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
   // We get this message when the dialog box is about to be put up on the screen
   if (message == WM_INITDIALOG)
      return(TRUE);

   else if (message == WM_COMMAND)
      {
      switch (wParam)
         {
         // If they hit the ok button End the dialog box
         case IDOK:
            EndDialog(hDlg, TRUE);
            return(TRUE);

         default:
            return(TRUE);
         }
      }
      
   return(FALSE);
}

/************************************************************************/
//  Dialog box Callback function for our "Import a file" dialog box
//  Purpose: Handle all messages for the "Import a file" dialog box
/************************************************************************/
BOOL FAR PASCAL _export ApiDialog(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
   static char szFileName[144] = "\0";   // The file to import

   if (message == WM_INITDIALOG)
      {
      // When start up the dialog box, get the file to import
      if (GetAFileToImport(hDlg, szFileName) == 0)
         {
         // Unable to get a file to import, so abort the attempt
         EndDialog(hDlg, FALSE);
         return FALSE;
         }
      return(TRUE);
      }

   // We have the dialog box up and running and they hit a button...
   else if (message == WM_COMMAND)
      {
      switch (wParam)
         {
         case IDOK:    // Hit the OK button
            // We will thus call function to import the doc for me
            if (ImportDoc4Me(hDlg, szFileName) == 1)
               EndDialog(hDlg, TRUE);  // Did it, so quit
            else  // Import failed - let them back to dialog box
               SetFocus(GetDlgItem(hDlg, ID_DOCNAME));   
            return(TRUE);

         // Hit the Cancel button from dialog box
         case IDCANCEL:
            EndDialog(hDlg, FALSE);
            return(TRUE);

         // We don't know what it is or care...
         default:
            return(TRUE);
         }
      }
   // Choose close from system menu of dialog box
   else if (message == WM_CLOSE)
      {
      EndDialog(hDlg, TRUE);
      return (TRUE);
      }

   return(FALSE);
}

/************************************************************************/
//  ImportDoc4Me
//  Purpose: Import a file via PC DOCS Open API
/************************************************************************/
int ImportDoc4Me(HWND hDlg, LPSTR lpFileName)
{
   // Declare my variables
   char buffer[128];
   char szDocName[144];
   char szAuthor[25];
   char szTypist[25];
   char szAppName[25];
   char szTypeId[25];
   char szClientId[25];
   char szMatterId[25];
   char Abstract[144];
   char documentPath[144];
   int  hProfile, iError;
   HCURSOR hOldCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));

   // Grab info off the Dialog Box...
   GetDlgItemText(hDlg, ID_DOCNAME,  szDocName,  sizeof(szDocName));
   GetDlgItemText(hDlg, ID_AUTHOR,   szAuthor,   sizeof(szAuthor));
   GetDlgItemText(hDlg, ID_TYPIST,   szTypist,   sizeof(szTypist));
   GetDlgItemText(hDlg, ID_APPID,    szAppName,  sizeof(szAppName));
   GetDlgItemText(hDlg, ID_TYPEID,   szTypeId,   sizeof(szTypeId));
   GetDlgItemText(hDlg, ID_CLIENTID, szClientId, sizeof(szClientId));
   GetDlgItemText(hDlg, ID_MATTERID, szMatterId, sizeof(szMatterId));
   GetDlgItemText(hDlg, ID_ABSTRACT, Abstract,   sizeof(Abstract));
   GetDlgItemText(hDlg, ID_LIBRARY,  glpLibName, sizeof(glpLibName));

   // Get a new profile from DOCS 
   if ((hProfile = DOCSNewProfile(glpLibName)) == 0)
      {
      // It failed, tell the people
      MessageBox(hDlg, "Unable to get new profile", "API Failure", MB_OK|MB_ICONSTOP);
      DOCSFreeProfile(hProfile);
      SetCursor(hOldCursor);
      return 0;
      }

   // Set values on the profile
   DOCSSetProfileValue(hProfile, "DOCNAME",                    szDocName);
   DOCSSetProfileValue(hProfile, "AUTHOR.USER_ID",             szAuthor);
   DOCSSetProfileValue(hProfile, "TYPIST.USER_ID",             szTypist);
   DOCSSetProfileValue(hProfile, "APPLICATION.APPLICATION",    szAppName);
   DOCSSetProfileValue(hProfile, "DOCUMENTTYPE.TYPE_ID",       szTypeId);
   DOCSSetProfileValue(hProfile, "MATTER.CLIENT_ID.CLIENT_ID", szClientId);
   DOCSSetProfileValue(hProfile, "MATTER.MATTER_ID",           szMatterId);
   DOCSSetProfileValue(hProfile, "ABSTRACT",                   Abstract);

   // Save the profile and check to see if it succeeded or not
   if ((DOCSSaveProfile(hProfile, 1, documentPath) == 0) || (documentPath[0] == '\0'))
      {
      iError = DOCSGetProfileError(hProfile);
      wsprintf((LPSTR)buffer, "The error code was: %d", iError);
      MessageBox(hDlg, (LPSTR)buffer, "DOCSSaveProfile failed", MB_OK|MB_ICONSTOP);
      SetCursor(hOldCursor);
      return 0;        
      }

   // Copy the file to the document path provided by PC DOCS in save profile
   FileCopy(lpFileName, documentPath);

   // Free our profile instance - very important to free up
   DOCSFreeProfile(hProfile);
   SetCursor(hOldCursor);
                       
   return 1;
}

//-----------------------------------------------------------------------
//
//    Utility functions to get a file to import and saving it.
// 
//-----------------------------------------------------------------------

/************************************************************************/
//  GetAFileToImport
//  Purpose: Put up FILE OPEN common dialog box and get a file name
/************************************************************************/
int GetAFileToImport(HWND hDlg, LPSTR lpFileName)
{
   char szCaption[] = "PC DOCS API - Open a Document";
   char szDirName[256] = "c:\\";
   char szFile[256], szFileTitle[256];
   char szFilter[256] = "All Files\0*.*\0";
   OPENFILENAME ofn;

   szFile[0] = '\0';

   /* Set all structure members to zero. */
   memset(&ofn, 0, sizeof(OPENFILENAME));

   // Setup for call to put up FILE OPEN common dialog box
   ofn.lStructSize     = sizeof(OPENFILENAME);
   ofn.hwndOwner       = hDlg;
   ofn.lpstrFilter     = szFilter;
   ofn.nFilterIndex    = 1;
   ofn.lpstrFile       = szFile;
   ofn.nMaxFile        = sizeof(szFile);
   ofn.lpstrFileTitle  = szFileTitle;
   ofn.nMaxFileTitle   = sizeof(szFileTitle);
   ofn.lpstrInitialDir = szDirName;
   ofn.lpstrTitle      = szCaption;
   ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

   // Note: We will have them choose a filename from somewhere
   // Windows API call to put up the FILE OPEN common dialog box
   if (GetOpenFileName(&ofn))
      {
      lstrcpy(lpFileName, szFile);
      return 1;
      }
   else
      {
      MessageBox(hDlg, "Import Document Canceled", lpCaption, MB_OK|MB_ICONSTOP);
      return 0;
      }
}

/************************************************************************/
//  MyGetFreeSpace
//  Purpose: Check the amount of free disk space on a drive
/************************************************************************/
long MyGetFreeSpace( char drive )
{
   struct diskfree_t free;
   long avail = 0L;

   if(!_dos_getdiskfree( drive - 'A' + 1, &free ) )
      {
      avail = (long) free.avail_clusters
            * (long) free.bytes_per_sector
            * (long) free.sectors_per_cluster;
      }
   return( avail );
}

/************************************************************************/
//  FileCopy
//  Purpose: Copy source file to dest file
/************************************************************************/
#define MIN_THRESHOLD 300000L
int FileCopy( const char *source, const char *dest )
{
   int        retVal = 0,
              cbRead, cbWrite;
   long       fSize = (long)0;
   char       driveLetter = dest[0];
   HFILE      hfSource, hfDest;
   OFSTRUCT   sStruct, dStruct;
   PBYTE      pbBuf;

   // open source
   hfSource = OpenFile( source, &sStruct, OF_READ );
   if( hfSource == HFILE_ERROR )
      retVal = -1;
      
   else
      {
      // enough room on dest for source?
      fSize = filelength(hfSource);
      if( MyGetFreeSpace( driveLetter ) < MIN_THRESHOLD + fSize )
         return( -1 );

      // Open dest   
      hfDest = OpenFile( dest, &dStruct, OF_CREATE );
      if( hfDest == HFILE_ERROR )
         retVal = -1;
      else
         {
         pbBuf = (PBYTE) LocalAlloc( LMEM_FIXED, 2048 );
         do
            {
            cbRead = _lread( hfSource, pbBuf, 2048 );
            if( cbRead == HFILE_ERROR ) // READ failed
               retVal = -1;
            else if( cbRead > 0 )
               {
               cbWrite = _lwrite( hfDest, pbBuf, cbRead );
               if( cbWrite != cbRead )  // WRITE failed
                  retVal = -1;
               }
            } while( !retVal && cbRead != 0 );
         LocalFree( (HLOCAL) pbBuf );
         _lclose( hfDest );
         }
      _lclose( hfSource );
      }
   return( retVal );
}
