//*********************************************************
//
//   PC DOCS Open ToolKit Sample Application Series
//   ----------------------------------------------
//
//   Program Name: API1 - Opening a document
//
//   Description: This application provides an example
//   of how to open a document and handle return values.
//   This was created with Borland C v4.0 in Large Model.
//   It was tested against PC DOCS Open v2.0
//
//   WARNING! This is a sample application and should
//   be used in a test environment only. These examples
//   have been tested but are EXAMPLES only and are not
//   to be presented as 100% error free.
//
//   Copyright 1994 by PCDOCS,INC.
//
//*********************************************************
#define STRICT         // Do strict type checking
#include <Windows.h>   // Windows API include file
#include "docsapi.h"   // Include file for PC DOCS Open API
#include "api.h"       // Include file for API samples series...

HWND      hWndMain;            // hWnd of main window
HINSTANCE hInst;               // We will need this in several places later...
LPSTR     lpAppId = "PCDAPI";  // Application ID registered with PC DOCS
LPSTR     lpCaption = "PC DOCS Open API Sample App";

// Our Function prototypes
int                      OpenDocument4Me(HWND);
int      PASCAL          WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int cmdShow);
BOOL FAR PASCAL  _export About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL  _export ApiDialog(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK _export ApiWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);


/************************************************************************/
//  Windows Main Function - 
//  Purpose: Setup the application and start the message loop
/************************************************************************/
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
   MSG msg;
   WNDCLASS wcTstAppClass;

   hInst = hInstance;       // save for use by window procs

   if (hPrevInstance == 0)
      {
      // fill in window class information only for 1st instance of program
      wcTstAppClass.lpszClassName = lpAppId;
      wcTstAppClass.hInstance     = hInstance;
      wcTstAppClass.lpfnWndProc   = ApiWndProc;
      wcTstAppClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
      wcTstAppClass.hIcon         = LoadIcon(hInstance, lpAppId);
      wcTstAppClass.lpszMenuName  = (LPSTR) "PCDAPI1";
      wcTstAppClass.hbrBackground = (HBRUSH) (COLOR_BACKGROUND + 1);
      wcTstAppClass.style         = CS_HREDRAW | CS_VREDRAW;
      wcTstAppClass.cbClsExtra    = 0;
      wcTstAppClass.cbWndExtra    = 0;

      // register the class
      RegisterClass(&wcTstAppClass);
      }

   hWndMain = CreateWindow(
               lpAppId,                          // window class name
               "PC DOCS OPEN - Open a document", // window title
               WS_OVERLAPPEDWINDOW,              // type of window
               150,                              // x  window location
               200,                              // y
               500,                              // cx and size
               150,                              // cy
               NULL,                             // no parent for this window
               NULL,                             // use the class menu
               hInstance,                        // who created this window
               NULL);                            // no parms to pass on

   // Putup the window
   ShowWindow(hWndMain, nCmdShow);
   UpdateWindow(hWndMain);

   // Our message loop
   while( GetMessage( &msg, NULL, 0, 0 ) )
      {
      TranslateMessage( &msg );
      DispatchMessage( &msg );
      }

   // Tell PC DOCS that we are exiting
   DOCSAppExit(lpAppId);   
   return msg.wParam;
}

/************************************************************************/
//  Windows Callback function for our Main Window
//  Purpose: Handle all messages for the main window
/************************************************************************/
LRESULT CALLBACK _export ApiWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
   FARPROC lpproc;

   switch (message)
      {
      case WM_COMMAND:
         switch (wParam)
            {
            case IDM_QUIT:
               // User has selected QUIT from menu.
               PostMessage(hWnd, WM_CLOSE, 0, 0L);
               break;

            case IDM_API:
               // User wants to open a document
               // So, put up a dialog box to handle this...
               lpproc = MakeProcInstance((FARPROC)ApiDialog, hInst);
               DialogBox(hInst, (LPCSTR)"APIDIALOG1", hWnd, (DLGPROC)lpproc);
               FreeProcInstance(lpproc);
               break;

            case IDM_ABOUT:
               // User has selected ABOUT from menu.
               lpproc = MakeProcInstance((FARPROC)About, hInst);
               DialogBox(hInst, (LPCSTR)"ABOUTAPI", hWnd, (DLGPROC)lpproc);
               FreeProcInstance(lpproc);
               break;

            default:
               break;
            }
         break;

      case WM_DESTROY:
         // This is the end if we were closed by a DestroyWindow call.
         PostQuitMessage(0);    // this is the end...
         break;

      case WM_QUERYENDSESSION:
         // If we return TRUE we are saying it's ok with us to end the
         // windows session.
         return((long) TRUE);   // we agree to end session.

      case WM_CLOSE:
         // Tell windows to terminate us.
         DestroyWindow(hWnd);
         break;

      default:
         // Let windows handle all messages we choose to ignore.
         return(DefWindowProc(hWnd, message, wParam, lParam));
      }

    return(0L);
}

/************************************************************************/
//  Dialog box Callback function for our About Dialog box
//  Purpose: Handle all messages for the About dialog box
/************************************************************************/
BOOL FAR PASCAL _export About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
   // We get this message when the dialog box is about to be put up on the screen
   if (message == WM_INITDIALOG)
      return(TRUE);

   else if (message == WM_COMMAND)
      {
      switch (wParam)
         {
         // If they hit the ok button End the dialog box
         case IDOK:
            EndDialog(hDlg, TRUE);
            return(TRUE);

         default:
            return(TRUE);
         }
      }
      
   return(FALSE);
}

/************************************************************************/
//  Dialog box Callback function for our "Open a document" dialog box
//  Purpose: Handle all messages for the "Open a document" dialog box
/************************************************************************/
BOOL FAR PASCAL _export ApiDialog(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
   // Initializing the dialog box - we don't care...
   if (message == WM_INITDIALOG)
      return(TRUE);

   // We have the dialog box up and running and they hit a button...
   else if (message == WM_COMMAND)
      {
      switch (wParam)
         {
         case IDOK:
            // User hit the OK button so exit dialog box
            EndDialog(hDlg, TRUE);
            return(TRUE);

         case IDCANCEL:
            // User hit the Cancel button so exit dialog box
            EndDialog(hDlg, FALSE);
            return(TRUE);

         case ID_OPENDOC:
            // User hit the "Open a document" button so call function
            // to open a document for me
            OpenDocument4Me(hDlg);
            return(TRUE);

         default:
            // All other messages we don't want to deal with
            return(TRUE);
         }
      }
   // They choose "Close" from the system menu of the dialog box
   else if (message == WM_CLOSE)
      {
      EndDialog(hDlg, TRUE);
      return (TRUE);
      }

   return(FALSE);
}

/************************************************************************/
//  OpenDocument4Me
//  Purpose: To open a PC DOCS document via PC DOCS Open API
/************************************************************************/
int OpenDocument4Me(HWND hDlg)
{
   char netFileName[144];      // Path to Opened File(if this app ownes it)
   int  retcode;               // return code from functions
   char buffer[128];           // a buffer for a message or output

   // Note: This call will also launch the application that the selected
   //       document was created with (whatever the app id is on the profile)
   //       if it is not "PCDAPI".
   retcode = DOCSOpenDocument(lpAppId, netFileName);
   switch (retcode)
      {
      // DOCSOpenDocument failed...
      case 0:
         wsprintf((LPSTR)buffer, "Open Doc Failed\r\nRetCode: %d", retcode);
         SetDlgItemText(hDlg, ID_BUFFER, (LPSTR)buffer);
         return 0;
     
      // DOCSOpenDocument succeeded...
      case 1:
         wsprintf((LPSTR)buffer, "Opened the document\r\n%s", (LPSTR)netFileName);
         SetDlgItemText(hDlg, ID_BUFFER, (LPSTR)buffer);

         // Assign File Level security to the document and then close it...
         DOCSAssignFileACL(lpAppId, netFileName);
         DOCSCloseDocument(lpAppId, netFileName);
         return 1;

      // Either User canceled select or AppId on profile was different
      // and DOCS launched the app with the selected document in it.
      case 2:
         lstrcpy((LPSTR)buffer, "Either the user canceled the select OR\r\nPC DOCS opened"
            " the document in another application");
         SetDlgItemText(hDlg, ID_BUFFER, (LPSTR)buffer);
         return 0;

      // Readonly copy
      case 100:
         SetDlgItemText(hDlg, ID_BUFFER, "A Read Only copy was returned to us.\r\nReturn Code 100");
         DOCSReleaseReadOnlyDocument(lpAppId, netFileName);
         return 1;

      // Inserted document???
      case 200:
         SetDlgItemText(hDlg, ID_BUFFER, "A Read Only copy was returned to us.\r\nReturn Code 200");
         DOCSReleaseReadOnlyDocument(lpAppId, netFileName);
         return 0;

      // Something wierd happened...
      default:
         wsprintf((LPSTR)buffer, "DOCSOpenDocument returned: %d", retcode); 
         SetDlgItemText(hDlg, ID_BUFFER, (LPSTR)buffer);
         return 0;
      }
}
