#ifndef _IMAGE_H_
#define _IMAGE_H_


// supported image formats
#define IMG_PCX     0
#define IMG_DCX     1
#define IMG_UNKNOWN 0xffff
#define IMG_BMP     0xff

// conversion types           (src format) << 8 + (dst format)

#define IMG_BMP2DCX 0xff01
#define IMG_DCX2BMP 0x01ff
#define IMG_BMP2PCX 0xff00
#define IMG_PCX2BMP 0x00ff

#define IMG_PCX2PCX 0x0000
#define IMG_PCX2DCX 0x0001
#define IMG_DCX2PCX 0x0100
#define IMG_DCX2DCX 0x0101


// Image rotation values

#define IMG_ROT0    0
#define IMG_ROT90   1
#define IMG_ROT180  2
#define IMG_ROT270  3


// define far pointer to old style bitmap struct
#ifndef LPBITMAP
#define LPBITMAP BITMAP FAR *
#endif

#ifndef HFILE
#define HFILE WORD
#endif

typedef struct {
	HFILE  	hFile;            // File handle to image file
	WORD    wHeight;          // Height of page in pixels
	WORD    wWidth;           // Width of picture in pixels
	WORD    wHorzRes;         // Pixels-per-inch, horizontal
	WORD    wVertRes;         // Pixels-per-inch, vertical
	WORD    wTotPages;        // Total number of pages in image
	WORD    wPage;            // Current page number
	WORD    wImageType;       // Conversion type
	BYTE    bFlags;           // Transpose/invert/last/fine/drop
	BYTE    byRotate;         // IMG_ROT0, IMG_ROT90, IMG_ROT180, IMG_ROT270

	union {
		BYTE    b[12];
		WORD    w[6];
		DWORD   dw[3];
	} Extra;

} IMAGE, * PIMAGE, FAR * LPIMAGE;

// bFlags bit-fields
#define FLANDSCAPE  0x01
#define FINVERT     0x02
#define FENDOFPAGE  0x04
#define FFINERES    0x08
#define FDROPNULLS  0x10

// DCX/PCX specific aliases
#define wPcxPages   Extra.w[4]
#define dwPcxPtr    Extra.dw[0]
#define dwTotBytes  Extra.dw[1]
#define hPcxTable   Extra.w[5]


#define LEN_FORMAT_NAME 16

typedef struct {
	BOOL document;
	char name[LEN_FORMAT_NAME];
	char ext[5];
} IMAGEINFO, * PIMAGEINFO, FAR * LPIMAGEINFO;




#ifdef __cplusplus
extern "C" {
#endif
BOOL FAR PASCAL _export WriteImage(LPBITMAP lpBitmap, LPIMAGE lpImage);
BOOL FAR PASCAL _export OpenImage(LPIMAGE lpImage);
BOOL FAR PASCAL _export CloseImage(LPIMAGE lpImage);
BOOL FAR PASCAL _export ReadImage(VOID FAR *lpBuffer, LPIMAGE lpImage,  LPRECT lpRect);
BOOL FAR PASCAL _export PageImage(LPIMAGE lpImage);
WORD FAR PASCAL _export GetFormat(HFILE hFile);
VOID FAR PASCAL _export ImageInfo(LPIMAGEINFO lpInfo, WORD wIndex);
WORD FAR PASCAL _export FormatCount(VOID);
WORD FAR PASCAL _export CopyImage(LPIMAGE lpDstImg, LPIMAGE lpSrcImg);
#ifdef __cplusplus
}
#endif


#endif
