#if 0
Copyright 1987-1992 Alcom Incorporated
All rights reserved worldwide

This source code, architectural data, and related information in any
form for EasyGate, LanFax, or any other Alcom products constitutes
confidential, proprietary, and/or trade secret information of Alcom
Incorporated and is an unpublished work of authorship protected by
copyright laws of the United States.  Unauthorized copying or use of this
document or the program contained herein, in original or modified form,
is in violation of Federal and State law.

Possession and use of copies of this source code is subject to
confidential provisions of non-disclosure, non-compete, and use-license
agreements of Alcom Incorporated.

#endif

#ifndef _CASDLL_H_
#define _CASDLL_H_

#define NOT_INSTALLED           0x00
#define NOT_INSTALLED_NOT_OK    0x01
#define INSTALLED               0xFF

#define MATCH_ANY               -1
#define MATCH_UNTOUCHED         0
#define MATCH_OPENED            1
#define MATCH_MOVED             2
#define MATCH_DELETED           3

#define DIRECTION_OLDTONEW      0
#define DIRECTION_NEWTOOLD      1

#define MODE_TCF                0
#define MODE_RCF                1
#define MODE_LCF                2

#define EVENT_SEND              0
#define EVENT_RECV              1
#define EVENT_PSEND             2
#define EVENT_PRECV             3

#define XFER_FINE               0
#define XFER_STANDARD           1
#define XFER_BINARY             2

#define EVSTAT_COMPLETE         0
#define EVSTAT_WAITING          1
#define EVSTAT_NUMDIALED        2
#define EVSTAT_SENDING          3
#define EVSTAT_RECEIVING        4
#define EVSTAT_ABORTED          5
#define EVSTAT_ERROR            -1

#define ERRCLASS_FAXWARNING     0
#define ERRCLASS_DOSWARNING     1
#define ERRCLASS_FATAL          2
#define ERRCLASS_DOSFATAL       3
#define ERRCLASS_FAX            4

#define ERRTYPE_WARNING         0
#define ERRTYPE_RETRY           1
#define ERRTYPE_FAIL            2

#define ERRCAS_INVALIDHANDLE    -0x0209

#define CAS_WKSSTATE_OK         0x4b4f
#define CAS_WKSSTATE_ON         0x4e4f
#define CAS_WKSSTATE_OFF        0x464f

#define FONT_80                 0
#define FONT_132                1
#define COVER_ON                1
#define COVER_OFF               0

#define COVERLINES              36
#define COVERWIDTH              80
#define MAXNFILES               100
#define FTR_LENGTH              128

#define IDS_RETRYSTR            101
#define IDS_BUSYSTR             102

#define CO_NOPROMPT             1
#define CO_PROMPTOK             2
#define CO_RETRYCANCEL          3

#define DIAGS_START             1
#define DIAGS_PROGRESS          0
#define PROGRESS_RUNNING        0x40

// buffer copy flags for CASCall
#define   CWB_IN        1    // copy buffer in (down) to CAS (BEFORE CAS call)
#define   CWB_OUT       2    // copy buffer out (up) from CAS (AFTER CAS call)
#define   CWB_INANDOUT  3    // copy buffer before AND after calling CAS

//
// RAM type values
//
enum RamTypes {
  rtNormal = 0, // normal memory
  rtEMS,        // expanded memory
  rtXMS,        // extended memory via XMS
  rtEXT,        // extended memory via BIOS
  rtNone,       // no memory
};

//
// Server Option Bits
//
enum ServerOptionBits {
  soArchival      = 0x0001,
  soPrinting      = 0x0002,
  soRegistered    = 0x0004,
  soPCL5          = 0x0008,
  soFileCAS       = 0x0010,
  soPublicFaxes   = 0x0020,
  soPublicBFTs    = 0x0040,
  soAutoInPrint   = 0x0080,    // Automatic printing of incoming on?
  soAutoOutPrint  = 0x0100,    // Automatic printing of outgoing on?
  soBilling       = 0x0200,    // Billing enforced?
};

//
// Rights of a user
//
#define ADM_ROUTER      0x0001  // Router Rights
#define ADM_FIND        0x0002  // Find first/next entry
#define ADM_DELETE      0x0004  // Delete a file
#define ADM_DELALL      0x0008  // Delete all files in a queue
#define ADM_CONFIG      0x0010  // Configuration privilege
#define ADM_CANCEL      0x0020  // Right to cancel any event
#define ADM_PB          0x0040  // PhoneBook admin rights
#define ADM_RUSH        0x0080  // Does the user have rights for rush jobs
#define ADM_DOWNLOAD    0x0100  // Does the user have rights for dowload files from the server
#define ADM_10          0x0200
#define ADM_11          0x0400
#define ADM_12          0x0800
#define ADM_13          0x1000
#define ADM_14          0x2000
#define ADM_15          0x4000
#define ADM_NOENTRY     0x8000  // Sign on refused for this user

//
// Board Capabilities
//
#define bcCanSend           's' // Board is used for send only
#define bcCanReceive        'r' // Board is used for receive only
#define bcCanSendAndReceive 'b' // Board is used bidirectionally
#define bcNotAvailable      'n' // Board not available to user or server
#define bcNonExisting       'i' // Board does not exist [hw-wise]

//
// Board Status values
//
#define bsSending   's'         // Board sending
#define bsReceiving 'r'         // Board receiving
#define bsIdle      'i'         // Board idle
#define bsAbort     'a'         // Board aborting event
#define bsDialing   'd'         // Board dialing
#define bsWaiting   'w'         // Event waiting on board [very rare]
#define bsError     'e'         // Board or event @ board in error
#define bsWhoa      '?'         // Undefined board status
#define bsProblem   'p'         // A stuck item

//
// Phonebook Search Directions
//
enum PhonebookSearchDirections {
  pbsdForward = 0,
  pbsdBackward
};

//
// Stream CAS Queues
//
enum StreamCasQueues {
  scqTransmit = 0,
  scqReceive,
  scqLog
};

//
// Standard CAS Queues
//
enum StandardCasQueues {
  ncqTask = 0,
  ncqReceive,
  ncqLog
};

//
// Server Option Commands
//
enum ServerOptionCommands {
  socPrinterType = 0,
  socPrintingStatus,
  socSecurity,
  socConversion,
  socRegistration,
  socClearLogByDays,
  socClearLogByEvents,
  socArchivalStatus
};

//
// Server Printer Types
//
enum ServerPrinterTypes {
  sptLaserJetII = 0,
  sptLaserJetIIP,
  sptLaserJetIII
};

//
// Server Printing Status
//
enum ServerPrintingStatus {
  spsPrintNone = 0,
  spsPrintIncoming,
  spsPrintOutgoing,
  spsPrintBoth
};

//
// Server Incoming Security
//
enum ServerIncomingSecurity {
  sisPublic = 0,
  sisPrivate
};

//
// Server Conversion Status
//
enum ServerConversionStatus {
  scsNoConversion = 0,
  scsConvertToPCL
};

//
// Server Registration Status
//
enum ServerRegistrationStatus {
  srsNoRegistration = 0,
  srsRegistrationReqd
};

//
// Server Archival Status
//
enum ServerArchivalStatus {
  sasArchiveNone = 0,
  sasArchiveIncoming,
  sasArchiveOutgoing,
  sasArchiveBoth
};

//
// Board Status Commands
//
enum BoardStatusCommands {
  bscDeactivateBoard = 0,
  bscSendOnly,
  bscReceiveOnly,
  bscBoth
};

typedef WORD HEVENT, FAR *LPHEVENT;
typedef WORD HCAS;

//=====================================================================
//Data Structures
//=====================================================================
//
// ServerStatus -- returned by GetServerStatus call
//
typedef struct {
  char RevNum[6];     // server version "3.0"
  DWORD UpTime;       // # of seconds since startup
  BYTE IdleBoards;    // # of idle boards
  BYTE TotalBoards;   // total # of boards
  WORD IPSendEvents;  // # of send events in process
  WORD RecEvents;     // # of received events
  WORD SendEvents;    // # of send events
  WORD CurrUsers;     // # of users logged in
  WORD TotalSrvUsers; // # of users available [server]
  WORD TotalNetUsers; // # of users available [network]
  WORD Mailboxes;     // # of mailboxes in use
  WORD TotalMailboxes;// total # of mailboxes
  DWORD DiskSpace;    // # of bytes available at server disk
  DWORD DiskSize;     // # of bytes at server
  DWORD ArchSpace;    // # of bytes available at archive site
  DWORD ArchSize;     // # of bytes at archive site
  DWORD RamConv;      // # of bytes conventional memory
  DWORD RamExt;       // # of bytes external memory available
  DWORD RamTotalExt;  // # of bytes external memory
  BYTE RamType;       // type of external memory
  WORD Options;       // server options
  BYTE ParadoxNOS;    // NOS for Paradox
  WORD TotalEvents;   // Total # of events available
  WORD Events;        // # of events in use
  WORD PrintEvents;   // # of print events
} SRVSTAT, FAR * LPSRVSTAT;

//
// BoardStatus -- two of these are returned by GetBoardStatus call
//
typedef struct {
  char CapBoard;      // board capabilities
  char StatBoard;     // board status
  char SenderName[80];
  char DestName[80];
  char PhoneNum[50];
  WORD ConnectionTime;
} BRDSTAT, FAR * LPBRDSTAT;

typedef struct {
  char Name[80];
  WORD Mbox;           // If zero, then consider this an ADD user
  WORD InBoard;
  WORD OutBoard;
  WORD Rights;
  char Password[16];
  WORD LastY;          // If all zeroes, then default to today when SETting
  BYTE LastM;
  BYTE LastD;
  WORD FirstY;         // If all zeroes, then default to today when SETting
  BYTE FirstM;
  BYTE FirstD;
  char FaxingName[80];  // EOE 15May92: new field
} UPROFILE, FAR * LPUPROFILE;

typedef struct {
  long FileSize;       // Allows server to determine if enough disk space
  WORD Time;           // For date/time determination
  WORD Date;
  BYTE EventType;      // EventType from CAS [Send/Receive/Polled Receive]
  char phone_number[47];// Phone number to call
  char Billing[64];    // For authorization code checking
} AUTTRANS, FAR * LPAUTTRANS;

#ifndef DATEDEFINED
#define DATEDEFINED
typedef struct {
  WORD Day    :5;
  WORD Month  :4;
  WORD Year   :7;
} DATE, FAR * LPDATE;
  
  
typedef struct {
  WORD Second :5;
  WORD Minute :6;
  WORD Hour   :5;
} TIME, FAR * LPTIME;
#endif


typedef struct {
  WORD nChanges;
  WORD nControlFiles;
  WORD nReceived;
} QINFO, FAR * LPQINFO;


typedef struct {
  unsigned char filetype;
  unsigned char font;
  unsigned char status;
  long          bytes;
  long          totbytes;
  int           pages;
  int           totpages;
  char          filename[80];
  unsigned char pagelen_8ths;
  unsigned char pagelen_inches;
  char          pad[31];
} FILE_TRANSFER_RECORD;

typedef struct {
  unsigned char eventtype;
  unsigned char xfertype;
  int           status;
	int           dostime;
  int           dosdate;
  int           totalfiles;
  int           ftroffset;
  char          phonenum[47];
  char          isvtag[64];
  char          reserved1;
  unsigned char duration_secs;
  unsigned char duration_mins;
  unsigned char duration_hours;
  long          totalpages;
  long          npages;
  int           nfiles;
  unsigned char coverflag;
  int           nerrors;
  //------------ CAS 1.2
  unsigned char deleteflag;
  unsigned int  parenthandle;
  char          reserved[53];
  char          internal[20];
  unsigned char coverreadflag;
  unsigned char suppresshdrflag;
  //-------------CAS 1.0
  // char       reserved[78];
  //-----------------------
  char          csid[21];
  char          destname[32];
  char          sender[32];
  char          logopath[80];
} CONTROL_RECORD;

#define TCFLOGOPATHLEN 80

typedef CONTROL_RECORD CONTROLREC, FAR *LPCONTROLREC;
typedef FILE_TRANSFER_RECORD FILETREC, FAR *LPFILETREC;

typedef struct {
  CONTROL_RECORD        cr;
  FILE_TRANSFER_RECORD  ftr;
} STATUSBLOCK, FAR *LPSTATUSBLOCK;

typedef struct {
  unsigned char majorver;
  unsigned char minorver;
  char          defdirectory[68];
  char          defphonebook[13];
  char          deflogo[13];
  char          sender[32];
  char          csid[21];
  char          pad[107];
} EDB, FAR *LPEDB;


typedef struct {
  unsigned char xfertype;
  unsigned char font;
  int           dostime;
  int           dosdate;
  char          destname[32];
  char          filepath[80];
  char          phonenum[47];
  char          isvtag[65];
  unsigned char coverflag;
  char          reserved[23];
  char          text[COVERLINES*COVERWIDTH];
} SFTC, FAR *LPSFTC;

typedef struct {
  char          flag[14];
  int           errorcnt;
  long          filelen;
  char          pad[10];
  char          csid[21];
} HWSTATUS, FAR *LPHWSTATUS;

//----------------
// EOE 17JUl92/000: STRICT: HCAS, HFILE, LPHFILE, HINSTANCE
#ifndef LPHFILE
#define LPHFILE HFILE FAR *
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define CASPROC int FAR PASCAL _export

CASPROC CASOpen(HINSTANCE hInstance, WORD wMode);
CASPROC CASClose(HCAS hCAS);
CASPROC CASSetMultiPlex(HCAS hCAS, BYTE byValue);
CASPROC CASGetMultiPlex(HCAS hCAS);
CASPROC CASSingleUser(HCAS hCAS);
CASPROC CASCall(HCAS hCAS, BYTE CASFunc, LPWORD lpCASbx, LPWORD lpCAScx,
                LPWORD lpCASdx, LPVOID lpBuf, WORD wBufSize, WORD wBufFlags);
DWORD FAR PASCAL  _export CASGetInstalledState(HCAS hCAS,WORD QueryType,
                                              LPBYTE majVer,LPBYTE minVer);
CASPROC CASGetEventDate(HCAS hCAS, LPDATE lpDate, HEVENT hEvent,
                        BYTE byQueue);
CASPROC CASSubmitTask(HCAS hCAS, LPSTR lpstrTaskControl);
CASPROC CASAbortCurrentEvent(HCAS hCAS);
CASPROC CASFindFirst(HCAS hCAS, LPHEVENT lphEvent, WORD wStatus,
                      BYTE byDirection, BYTE byQueue);
CASPROC CASFindNext(HCAS hCAS, LPHEVENT lphEvent, BYTE byQueue);
CASPROC CASResetFindNext(HCAS hCAS);
CASPROC CASOpenFile(HCAS hCAS, LPHFILE lphFile, HEVENT hEvent,
                    WORD wFileNumber, BYTE byQueue);
CASPROC CASDeleteFile(HCAS hCAS, HEVENT hEvent, WORD wFileNumber,
                      BYTE byQueue);
CASPROC CASDeleteAll(HCAS hCAS, BYTE byQueue);
CASPROC CASSetTaskDate(HCAS hCAS, HEVENT hEvent, DATE Date);
CASPROC CASGetEventTime(HCAS hCAS, LPTIME lpTime, HEVENT hEvent,
                        BYTE byQUEUE);
CASPROC CASSetTaskTime(HCAS hCAS, HEVENT hEvent, TIME Time);
CASPROC CASGetExtDataBlock(HCAS hCAS, LPEDB lpedbExternalData);
CASPROC CASAutoReceiveState(HCAS hCAS, BYTE byFunction, BYTE byNumber);
CASPROC CASGetCurEventStatus(HCAS hCAS, LPHEVENT lphEvent,
                              LPSTATUSBLOCK lpsbStatus);
CASPROC CASGetQueueStatus(HCAS hCAS, LPQINFO lpQueueInfo, BYTE byQueue);
CASPROC CASGetHWStatus(HCAS hCAS, LPHWSTATUS lpHWStatus);
CASPROC CASRunDiags(HCAS hCAS, BYTE byMode);
CASPROC CASMoveFile(HCAS hCAS, HEVENT hEvent, WORD wNumber,
                    LPSTR lpstrFileSpec);
CASPROC CASSubmit1File(HCAS hCAS, LPSFTC lpSingleFileTaskControl);

CASPROC CASSetCoverPageFlag(HCAS hCAS, HEVENT hEvent, BYTE byRead);
CASPROC SCASFindFirst(HCAS hCAS, LPHEVENT lphEvent, LPBYTE lpbyQueue,
                      BYTE byDir, LPBYTE lpbyExtStatus, LPSTR lpstrTaskControl);
CASPROC SCASFindNext(HCAS hCAS, LPHEVENT lphEvent, LPBYTE lpbyQueue,
                      LPBYTE lpbyExtStatus, LPSTR lpstrTaskControl);
CASPROC SCASFind(HCAS hCAS, LPHEVENT lphEvent, LPBYTE lpbyQueue,
                LPBYTE  lpbyExtStatus, LPSTR lpstrTaskControl);
CASPROC SCASForward(HCAS hCas, LPHEVENT,LPSTR);
CASPROC CASGetServerStatus(HCAS hCAS,LPSRVSTAT lpSrvStat);
CASPROC CASGetBoardStatus(HCAS hCAS, BYTE byBank, LPBYTE lpbyBoards,
                          LPSTR lpStatus);
CASPROC PCASOpenPB(HCAS hCAS, LPWORD lpPbNumEnt, LPWORD lpPbCASh,
                    LPVOID lpPbTR, WORD bufSZ);
CASPROC PCASClosePB(HCAS hCAS, WORD pbCASh);
CASPROC PCASGetStat(HCAS hCAS, LPBYTE lpPbCU, LPBYTE lpPbMCU,
                    LPWORD lpPbNumOE, LPWORD lpPbNumOC);
CASPROC PCASFindFirst(HCAS hCAS, WORD pbCASh, LPVOID lpPbTR, WORD bufSZ);
CASPROC PCASFindNext(HCAS hCAS, BYTE pbDir, WORD pbCASh, LPVOID lpPbTR,
                    WORD bufSZ);
CASPROC PCASAddEntry(HCAS hCAS, LPWORD lpIndex, WORD pbCASh, LPVOID lpPbTR,
                      WORD bufSZ);
CASPROC PCASDeletePBEntry(HCAS hCAS, WORD pbCASh, WORD pbIDdelete);
CASPROC PCASAddEntry2Group(HCAS hCAS, WORD pbIDgroup, WORD pbCASh,
                          WORD pbIDadd);
CASPROC PCASDeleteEntryFromGroup(HCAS hCAS, WORD pbIDgroup, WORD pbCASh,
                                  WORD pbIDdelete);
CASPROC PCASGetEntriesOfGroup(HCAS hCAS, WORD wGroup, LPWORD lpEntries,
                              WORD wPage, LPVOID lpEntryBuf, WORD bufSZ);
CASPROC CASPrintEvent(HCAS hCAS, HEVENT hEvent, BYTE byOper);
CASPROC CASGetSrvOption(HCAS hCAS, BYTE byOption, LPWORD lpValue);
CASPROC CASSetSrvOption(HCAS hCAS, BYTE byOption, WORD wValue);
CASPROC CASGetSetBrdStatus(HCAS hCAS, BOOL bSet, BYTE byBoardNo,
                           LPBYTE lpbyStatus);
CASPROC CASGetSetRetrySeq(HCAS hCAS, BOOL bSet, LPVOID lpSeqBuf);
CASPROC CASSetUserProfile(HCAS hCAS, LPUPROFILE lpProfBuf);
CASPROC CASFindUserName(HCAS hCAS, BYTE byDir, LPWORD lpNextMbox,
                        LPUPROFILE lpNameBuf);
CASPROC CASFindUserMbox(HCAS hCAS, BYTE byDir, LPWORD lpMbox,
                        LPUPROFILE lpNameBuf);
CASPROC CASKillSession(HCAS  hCAS, WORD wMbox);
CASPROC CASKillMbox(HCAS  hCAS, WORD wMbox);
CASPROC CASWhoAmI(HCAS  hCAS, LPWORD lpMbox, LPWORD lpAccess,
                  LPWORD lpSession);
CASPROC CASAutTransmission(HCAS  hCAS, LPAUTTRANS lpAutBuf);
CASPROC CASCancelEvent(HCAS  hCAS, WORD wEvent, BOOL bDel);
CASPROC CASRegAlcomApp(HCAS hCAS, WORD wID);

CASPROC CASReschedule(HCAS hCAS, HEVENT hEvent, DATE date, TIME time);
CASPROC CASOpenLib(HCAS hCAS, LPSTR lpFileName, LPHFILE lphFile);
CASPROC CASCheckAttach(HCAS hCAS, HEVENT hEvent, int iFileNum, LPWORD lpwStatus);

#ifdef __cplusplus
}
#endif


#define DynaLogin(x)  CASGetInstalledState(x, CAS_WKSSTATE_ON, NULL, NULL)
#define DynaLogout(x) CASGetInstalledState(x, CAS_WKSSTATE_OFF, NULL, NULL)
#endif

