#if 0
---------------------------------------------------------------------------
fmlist.h - definitions for linked list of handles

---------------------------------------------------------------------------
Changes:
	EOE: 07JUL92****: Beta C Freeze
										2.05 release freeze
---------------------------------------------------------------------------
#endif

#ifndef __FMLIST_H__
#define __FMLIST_H__

#define NOLENGTH	-1		// to store null terminated string
#define LISTF_INSHEAD	1	// insert at head not tail
#define LISTF_INSTAIL	0	// append to tail (default)
#define SUCCESS 1
#define FAILURE	0
//---------
// EOE 17JUL92/000: CHANGE:
// typedef LOCALHANDLE LISTHANDLE;
#define LISTHANDLE HLOCAL

typedef struct fmlist {
	LISTHANDLE next;
} FMLIST, FAR *LPFMLIST;

// access indexes for preallocated list headers
enum FMLISTNAME {
	FMLIST_DEST,          // Destination list
	FMLIST_TRFILE,				// File list
	FMLIST_DIR,						// Not used in this version.
	FMLIST_MAX=FMLIST_DIR
};

extern "C" LPFMLIST 	FAR PASCAL _export FmListNew( FMLISTNAME listi, WORD size, int insflag);
extern "C" int 				FAR PASCAL _export FmListCount( FMLISTNAME i);
extern "C" int 				FAR PASCAL _export FmListReset(FMLISTNAME);
extern "C" LPFMLIST 	FAR PASCAL _export FmListNext(FMLISTNAME);
extern "C" LISTHANDLE FAR PASCAL _export FmListUnlock( LPFMLIST l);
extern "C" LPFMLIST 	FAR PASCAL _export FmListLock( LISTHANDLE h);

extern "C" HGLOBAL 		FAR PASCAL _export FmMemGloStore(LPSTR buf, int len);
extern "C" HLOCAL 		FAR PASCAL _export FmMemLocStore( LPSTR buf, int len);
extern "C" LPSTR 			FAR PASCAL _export FmMemGloAllocPtr( int len);
// EOE 17JUL92/000: CHANGE: int -> HGLOBAL, GLOBALHANDLE -> HGLOBAL
extern "C" HGLOBAL		FAR PASCAL _export FmMemGloFree( HGLOBAL h);
extern "C" HGLOBAL		FAR PASCAL _export FmMemGloFreePtr( LPSTR p);
//--------------
// EOE 17JUL92/000: CHANGE: int -> HLOCAL, LOCALHANDLE -> HLOCAL
extern "C" HLOCAL 		FAR PASCAL _export FmMemLocFree(HLOCAL h);

#endif