///////////////////////////////////////////////////////////////////////////
// FMWIN2 - fmdest.h  - Struct and associated defs for xmit destination(s)
//
// DEST structs are handled by a manager module which handles all memory
// allocation & deallocation. The manager uses long pointers so it may more
// easily reside in a DLL, and so that it may be switched to using
// global segment allocation.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef __FMDEST_H__
#define __FMDEST_H__

#include "fmlist.h"


// Indexes into the handle array
#define DSTI_NAME   	0
#define DSTI_FAXNO    1
#define DSTI_COVER    2
#define DSTI_AUDIT    3
#define DSTI_MAX    DSTI_AUDIT
#define DST_BADI(i) (i < 0 || i >DSTI_MAX)

#define DSTF_HIDE   1     // flag value for iterations

enum covloc {
	covmem = 0,
	covfile,
	covnone
};

typedef struct dest {
	FMLIST	_list;
	BYTE    xfertype;
	WORD    dostime;
	WORD    dosdate;
	covloc  covloc;
	DWORD   phbookid;
	HANDLE  handles[DSTI_MAX+1];
} DEST, FAR* LPDEST;

typedef LISTHANDLE HDEST;


#define FMDST_UNLOCK(lpDest)  (HDEST)   FmListUnlock((LPFMLIST) lpDest)
#define FMDST_LOCK(hDest)     (LPDEST)  FmListLock((LISTHANDLE)hDest)
#define FMDST_DELETEH(hDest)            FmDstDelete(FMDST_LOCK(hDest))
#define FMDST_NEW()       		(LPDEST)  FmListNew(FMLIST_DEST, sizeof(DEST), LISTF_INSTAIL)
#define FMDST_COUNT()        		  	  	FmListCount(FMLIST_DEST)
#define FMDST_LISTRESET()       	    	FmListReset(FMLIST_DEST)
#define FMDST_LISTNEXT()  		(LPDEST)  FmListNext(FMLIST_DEST)


extern "C" int    FAR PASCAL _export FmDstDelete(LPDEST lpDest);
extern "C" int    FAR PASCAL _export FmDstListDelete();
extern "C" int    FAR PASCAL _export FmDstGetIndexField(LPDEST lpDest,  int iIndex, LPSTR lpBuffer, int len);
extern "C" LPSTR  FAR PASCAL _export FmDstGetIndexFieldPtr(LPDEST lpDest, int iIndex);
extern "C" int    FAR PASCAL _export FmDstUnlockIndexField(LPDEST lpDest, int iIndex);
extern "C" int    FAR PASCAL _export FmDstSetIndexField(LPDEST lpDest,  int iIndex, LPSTR lpBuffer, int len);

#endif