
/************************************************************/
/* Type defines                                             */
/************************************************************/

typedef unsigned char  byte;
typedef unsigned int   word;
typedef unsigned long dword;

/************************************************************/
/* Global defines                                           */
/************************************************************/

#define  FALSE             0
#define  TRUE              1
#define  MPX_INT           0x2f		/*Main int     */

byte Mpx = 0xCB;

//
// ServerStatus -- returned by GetServerStatus call
//
struct ServerStatus {
	char RevNum[6];	// server version "3.0"
	dword UpTime;	// # of seconds since startup
	byte IdleBoards;	// # of idle boards
	byte TotalBoards;	// total # of boards
	word IPSendEvents;	// # of send events in process
	word RecEvents;	// # of received events
	word SendEvents;	// # of send events
	word CurrUsers;	// # of users logged in
	word TotalSrvUsers; // # of users available [server]
	word TotalNetUsers; // # of users available [network]
	word Mailboxes;	// # of mailboxes in use
	word TotalMailboxes;// total # of mailboxes
	dword DiskSpace;	// # of bytes available at server disk
	dword DiskSize;	// # of bytes at server
	dword ArchSpace;	// # of bytes available at archive site
	dword ArchSize;	// # of bytes at archive site
	dword RamConv;	// # of bytes conventional memory
	dword RamExt;	// # of bytes external memory available
	dword RamTotalExt;	// # of bytes external memory
	byte RamType;	// type of external memory
	word Options;	// server options
	byte ParadoxNOS;	// NOS for Paradox
};

//
// BoardStatus -- two of these are returned by GetBoardStatus call
//
struct BoardStatus {
	char CapBoard;	// board capabilities
	char StatBoard;	// board status
	char SenderName[80];
	char DestName[80];
	char PhoneNum[50];
	word ConnectionTime;
};

/************************************************************/
/* Control file format                                      */
/************************************************************/
typedef struct	{
   byte  event_type;          /*Event type                  */
   byte  transfer_type;       /*Transfer type               */
   word  event_status;        /*Event status                */
   word  send_time;           /*Time to send                */
   word  send_date;           /*Date to send                */
   word  nbr_to_send;         /*Number of files to send     */
   word  first_record_offset; /*Offset of first FTR record  */
   char  phone_number[47];    /*Phone number to call        */
   char  isv_specific[64];    /*App-specific tag field      */
   byte  reserved1;           /*Reserved, set to zero       */
   byte  conn_seconds;        /*Connect time - seconds      */
   byte  conn_minutes;        /*Connect time - minutes      */
   byte  conn_hours;          /*Connect time - hours        */
   dword nbr_pages;           /*Number of pages - all files */
   dword nbr_xmitted;         /*Number of pages transmitted */
   word  files_xmitted;       /*Number of files transmitted */
   byte  cover_flag;          /*Cover page flag             */
   word  xmit_errors;         /*Number of transmit errors   */
   byte  Delete_files_flag;   /*V1.2                        */
   word  Handle_for_parent;   /*V1.2                        */
   char  reserved2[73];       /*Reserved, set to zero       */
   char  Cover_Page_flag;     /*V1.2                        */
   char  Suppress_page_header;/*V1.2                        */
   char  remote_csid[21];     /*Remote CCITT ID field       */
   char  destination_name[32];/*Destination name 'TO:' field*/
   char  sender_name[32];     /*Sender name 'FROM:' field   */
   char  logo_path[80];       /*Path and name of PCX logo   */
/*   byte  cover_start;         First char of cover page    */
}control_fmt;

/************************************************************/
/* File transfer record (FTR) format                        */
/************************************************************/
typedef struct	{
   byte  file_type;           /*File type - only for faxes  */
   byte  text_size;           /*Text size - only for faxes  */
   byte  status;              /*Status of file              */
   dword bytes_xmitted;       /*Number of bytes sent so far */
   dword files_size;          /*File size                   */
   word  pages_sent;          /*Pages sent so far           */
   word  pages_total;         /*Pages in file               */
   char  path[80];            /*Path of file to send        */
   byte  length_eighths;      /*Page length additional 1/8s */
   byte  length_inches;       /*Page length - inches        */
   char  reserved[31];        /*Reserved                    */
}ftr_fmt;

struct   single_event {
   byte  transfer_type;
   byte  text_size;
   word  send_time;
   word  send_date;
   byte  dest_name[32];
   byte  path[80];
   byte  phone_number[47];
   byte  isv_specific[64];
   byte  reserved1;
   byte  cover_flag;
   byte  reserved2[23];
/*   byte  cover_start; */
};

struct CASTime
{
	byte hour;
	byte min;
	byte sec;
};

struct   edb {
	   byte  cas_maj_version;
	   byte  cas_min_version;
	   char  dir_path[68];
	   char  phone_name[13];
	   char  logo_name[13];
	   char  default_sender[32];
	   char  csid[21];
	   byte  reserved[107];
};


enum QUEUES {
	TASK_QUEUE = 0,
	RECV_QUEUE,
	LOG_QUEUE
};

struct UProfile {
   char Name[80];
   word Mbox;           // If zero, then consider this an ADD user
   word InBoard;
   word OutBoard;
   word Rights;
   char Password[16];
   word LastY;          // If all zeroes, then default to today when SETting
   byte LastM;
   byte LastD;
   word FirstY;         // If all zeroes, then default to today when SETting
   byte FirstM;
   byte FirstD;
};


//Prototypes
int pascal CASGetInstalledState(word &Query_type);
int pascal CASSubmitTask(word &Eventhandle, void far *ControlFile);
int pascal CASAbortCurrentEvent(void);
int pascal CASFindFirst(word &Eventhandle, int Status, byte Direction, byte Queue);
int pascal CASFindNext(word &Eventhandle,byte Queue);
int pascal CASOpenFile(int &Doshandle, word Eventnum, word Filenum, byte Queue);
int pascal CASDeleteFile(word Eventhandle, word Filenum, byte Queue);
int pascal CASDeleteAll(byte Queue);
int pascal CASGetEventDate(word Eventhandle, byte Queue, struct date &Eventdate);
int pascal CASSetTaskDate(word Eventhandle, struct date &Eventdate);
int pascal CASGetEventTime(word Eventhandle, byte Queue, struct time &Eventtime);
int pascal CASSetTaskTime(word Eventhandle, struct time &Eventtime);
int pascal CASGetExtDataBlock(void far *ExtDataBlock);
int pascal CASAutoReceiveState(byte Function, byte Number);
int pascal CASGetCurEventStatus(word &Eventnum, void far *ControlFile);
int pascal CASGetQueueStatus(word &Queue,int &NumberOfCTRF, int &NumberOfReceivedFiles);
int pascal CASMoveReceivedFile(word Eventnum, int Filenum, void far *FileName);

//	**************************
//	*						 *
//	* EXTENDED CAS FUNCTIONS *
//	*						 *
//	**************************

int pascal SCASFindFirst(word &Eventhandle, byte &Queue, byte direc, byte &status, control_fmt &ControlFile);
int pascal SCASFindNext(word &Eventhandle, byte &Queue, byte &status, control_fmt &ControlFile);
int pascal SCASFind(word &Eventhandle, byte &Queue, byte &status, control_fmt &ControlFile);
int pascal SCASForward(word &Eventhandle, void far *ControlFile);
int pascal SCASPrint(word Eventhandle,word &Operation);
int pascal SCASGetServerStatus(void far *ControlFile);
int pascal SCASGetBoardStatus(void far *ControlFile, int &BoardNum);
int pascal SCASGetServerOption(int &OptionNum);
int pascal SCASSetServerOption(int OptionNum, int OptionValue);
int pascal SCASSetBoardStatus(byte BoardNum, byte &BoardStatus, int GetOpt);
int pascal SCASSetRetrySequence(void far *InList, int GetOpt);
int pascal SCASSetUserProfile(void far *UserRecord);
int pascal SCASFindUserByName(void far *UserRecord);
int pascal SCASFindUserByMbox(void far *UserRecord, int Mbox,byte direc, int &NextPrevMbox);
int pascal SCASKillSession(int Mbox);
int pascal SCASKillMailbox(int Mbox);
int pascal SCASWhoAmI(int &Mbox, word &rights, word&session);
int pascal SCASAuthorize(void far *Autho_data);
int pascal SCASCancelEvent(word eventnum, byte option);
int pascal SCASRegisterUI(word option);

//	**************************
//	*						 *
//	*  PHONE BOOK FUNCTIONS	 *
//	*						 *
//	**************************

int pascal SCASOpenPhonebook(void far *PbRecord, int &Handle, word &MaxNum);
int pascal SCASClosePhonebook(int Handle);
int pascal SCASGetPhonebookStatus(byte &NumUsers, byte &TotUsers, word &MaxNum, int &NumChanges);
int pascal SCASFindFirstPhonebook(word Handle, void far *PbRecord);
int pascal SCASFindNextPhonebook(int Handle, byte Direction, void far *PbRecord);
int pascal SCASAddPhonebookEntry(int Handle, word &index, void far *PbRecord);
int pascal SCASDeletePhonebookEntry(int Handle, word RecordId);
int pascal SCASAddPhonebookGroupEntry(word RecordId, word GroupId);
int pascal SCASDeletePhonebookGroupEntry(word RecordId, word GroupId);
int pascal SCASGetPhonebookGroupEntry(void far *GroupList, word GroupId,
	int PageNum, int &NumEntry);
