REM ********************************************************************
REM * Handler return codes code fragment                                
REM *
REM * Note that negative values are warnings, positive values are
REM * errors, and zero is success.
REM ********************************************************************



REM ***** The following constants are permanent

CONST _ipret_no_records_updated	 =  -2
CONST _ipret_no_data_avail       =  -1
CONST _ipret_success             =   0
CONST _ipret_profile_error       =   1



REM ***** Errors produced before any interface interaction

CONST _ipret_lost_profperm       = 101
CONST _ipret_serial_prof_in_use  = 102
CONST _ipret_token_in_use        = 103

CONST _ipret_interface_unavail   = 104

CONST _ipret_unsupported_op      = 105
CONST _ipret_missing_parm        = 106
CONST _ipret_invalid_parm        = 107

CONST _ipret_not_connected       = 108
CONST _ipret_already_connected   = 109

CONST _ipret_parm_conflict       = 110



REM ***** Errors produced by a mismatch between a structure and the
REM ***** format of data returned by the interface

CONST _ipret_bad_field_count     = 201
CONST _ipret_bad_field_type      = 202
CONST _ipret_bad_field_name      = 203
CONST _ipret_range_check_failed  = 204
CONST _ipret_already_bound       = 205
CONST _ipret_unsupported_type    = 206 



REM ***** Errors produced due to interface restrictions on the given handler

CONST _ipret_long_type_error     = 301
CONST _ipret_bulk_unavail        = 302
CONST _ipret_command_too_long    = 303
CONST _ipret_misc_error          = 304



REM ***** Infopump interface code failure errors

CONST _ipret_unknown_type        = 901
CONST _ipret_code_failure        = 902
CONST _ipret_memory_error        = 903
CONST _ipret_os_error            = 904
