rem	Copyright (c) 1993 by the Oracle Corporation
 
rem	$Header: /netdev/RCS/oracle/network/nm/nmc/RCS/nmcbild.sql,v 1.9 1993/10/22 23:18:46 markl Exp $

rem	Name
rem   	  nmcbild.sql

rem 	Function
rem	  build database tables for storing ROS information

rem 	Notes
rem

rem 	Owner
rem  	  markl

rem	Modified
rem
rem	$Log: nmcbild.sql,v $
rem    Revision 1.9  1993/10/22  23:18:46  markl
rem    Flip PASS and DOMAIN_P columns in TOPO and DOMAIN tables; ROS files
rem      (testing only) care about this.
rem
rem    Revision 1.8  1993/10/19  23:48:23  dstowell
rem    version 2.1.2.0.0 Beta
rem
rem    Revision 1.7  1993/10/13  21:13:22  markl
rem    Table names now start with NMO_
rem
rem    Revision 1.6  1993/10/05  00:33:42  markl
rem    Change 4 255-byte data columns to a single LONG column
rem
rem    Revision 1.5  1993/10/04  23:13:29  markl
rem    remove blob index
rem
rem    Revision 1.4  1993/10/04  19:12:25  markl
rem    Add ONRS tables
rem
rem  

create table NMO_MASTER (
    DID     decimal(10),
    VERS_V  decimal(10),
    VERS_R  decimal(10),
    VERS_U  decimal(10),
    VERS_PR decimal(10),
    VERS_PU decimal(10)
    );
create public synonym NMO_MASTER for system.NMO_MASTER;

delete from NMO_MASTER;
insert into NMO_MASTER (DID, VERS_V, VERS_R, VERS_U, VERS_PR, VERS_PU) 
    values(0, 2, 1, 2, 2, 0);

commit;

create table NMO_INFORMATION (
    NAME_P    varchar2(255),
    DID       decimal(10),
    SEQNUMBER decimal(10),
    LOCKED    decimal(10),
    LASTW_P   varchar2(255),
    OWNER_P   varchar2(255),
    LOCKER_P  varchar2(255)
    );
create public synonym NMO_INFORMATION for system.NMO_INFORMATION;

create table NMO_BLOB (
	BLOB  long raw,
	DID   number not null,
	SEQNO number not null);

create public synonym NMO_BLOB for system.NMO_BLOB;

create table ONRS_SERIAL (
    DOCUMENTID decimal(10),
    SERIAL decimal(10)
    );
create public synonym ONRS_SERIAL for system.ONRS_SERIAL;

create table ONRS_CONFIG (
    DOCUMENTID  decimal(10),
    SRV_NAME_P  varchar2(255),
    CP_NAME_P   varchar2(255),
    CP_VALUE1_P varchar2(255),
    CP_VALUE2_P varchar2(255),
    CP_VALUE3_P varchar2(255)
    );
create public synonym ONRS_CONFIG for system.ONRS_CONFIG;

create table ONRS_TOPO (
    DOCUMENTID    decimal(10),
    PASS          decimal(10),
    DOMAIN_NAME_P varchar2(255),
    NAME_P        varchar2(255),
    ZD_VALUE1_P   varchar2(255),
    ZD_VALUE2_P   varchar2(255),
    ZD_VALUE3_P   varchar2(255)
    );
create public synonym ONRS_TOPO for system.ONRS_TOPO;

create table ONRS_DOMAIN (
    DOCUMENTID    decimal(10),
    PASS          decimal(10),
    DOMAIN_NAME_P varchar2(255),
    NAME_P        varchar2(255),
    ZD_VALUE1_P   varchar2(255),
    ZD_VALUE2_P   varchar2(255),
    ZD_VALUE3_P   varchar2(255)
    );
create public synonym ONRS_DOMAIN for system.ONRS_DOMAIN;

