// cleanuse.c             Telix Usage Log Cleaner
// Written by Phil Crown, 1:124/6108.2
// Donated to the Public Domain 1994
// Written in Borland Turbo C++ v3.0 for DOS
//---------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>
#include <io.h>
#include <dos.h>
#include <dir.h>
#include <errno.h>
#include <process.h>
#include <time.h>
#define BUFSIZE    255
#define NAME      "Telix Usage Log Cleaner v1.01"
//---------------------------------------------------------------------------
void main ( int argc, char *argv[] )
{
  FILE            *infile, *outfile;
  char            *tmp,
                  *inbuf,
                  *outbuf = "TXXXXXX",
                  *buf,
                  *buf2,
                  *pathvar;
  int             y=4, line=0;
  struct find_t   find;
  time_t          starttime, endtime, elaptime;

  if( argc < 2 ) {
    cprintf("\r\n%s" NAME );
		cprintf("\r\nCLEANUSE [telix.use]\r\n" );
		exit(1);
	}

	tmp     = (char *)malloc(BUFSIZE);
	buf     = (char *)malloc(BUFSIZE);
	buf2    = (char *)malloc(BUFSIZE);
	inbuf   = (char *)malloc(BUFSIZE);

	time( &starttime );

	strcpy( inbuf, argv[1] );
	mktemp(outbuf);
	setdisk(toupper(inbuf[0]) - 65);
	chdir( inbuf );

	// check if TELIX.use file exists
	if ( _dos_findfirst ( inbuf, 0xffff, &find ) ) {
		strupr ( inbuf );
    cprintf ( "\r\nTelix.Use file Cleaner\r\nFile not found %s\r\n", inbuf );
    exit(1);
  }
  if((infile = fopen ( inbuf, "r" ))==NULL) {
    cprintf ( "\r\n%s Error opening file:  %s\r\n", inbuf );
    exit(1);
  }
  if((outfile = fopen ( outbuf, "wt" ))==NULL) {
    fclose(infile);
    cprintf ( "\r\nError opening file:  %s\r\n", outbuf );
    exit(1);
  }
  clrscr();
  _setcursortype(_NOCURSOR);
  textcolor ( 14 );
  gotoxy ( 1,1 );
  cprintf ( "                   Telix Usage Log Cleaner 1.0 Crown Software\r\n" );
  cprintf(";");
  textcolor ( 7 );

  while ( !feof ( infile ) ) {
    if( kbhit() )
      if( getch() == 27 )
      exit(2);
    gotoxy ( 3,1 );
    cprintf( "Line [%d]", line++ );
    gotoxy( 1, y );
    fgets ( buf, BUFSIZE, infile );
    /*---------------------------------------------------
     following if's determine what to save from Telix.use
    -----------------------------------------------------*/
    if ( strstr ( buf, "Connected with :" ) != NULL )
      fprintf( outfile, "\n%s", buf );

    else if ( strstr ( buf, "++ Ending Point Session" ) != NULL )
      continue;

    else if ( strstr ( buf, "Download" ) != NULL )
      fputs ( buf, outfile );

    else if ( strstr ( buf, "Upload" ) != NULL )
      fputs ( buf, outfile );

    else if ( strstr ( buf, "++ " ) != NULL )
      fputs ( buf, outfile );

    if ( strstr ( buf, "Elapsed" ) != NULL ) {
      strset( tmp, '\0' );
      memmove ( tmp, buf + 46, 2 );
      if ( atoi ( tmp ) )
        fputs ( buf, outfile );
    }
    y = wherey();
  }
  fclose ( infile );
  fclose ( outfile );
  remove ( inbuf );
  rename ( outbuf, inbuf );
  remove ( outbuf );
  gotoxy( 1, 2 );
  time ( &endtime );
  elaptime = endtime - starttime;
  cprintf ("\r\n[Elapsed time:  %02ld:%02ld:%02ld]",
           elaptime / 3600,
          (elaptime % 3600) / 60,
          (elaptime % 3600) % 60);
  _setcursortype(_NORMALCURSOR);
  //spawnlp( 0, "list", "list", inbuf, "/e" );
  free( tmp   );
  free( buf   );
  free( buf2  );
  free( inbuf );
  exit(0);
}
