echo off

cls

echo This program is used to apply patches to FoxPro version 2.6.
echo.
echo IMPORTANT NOTICE!
echo.
echo This batch file and all other patch files must be 
echo located in the directory where FoxPro is located!
echo If the patch files are not located in the directory
echo where FoxPro is located, please press CTRL+C to
echo terminate this program now.
echo.
echo This program uses the ATTRIB program to turn off the
echo read only bit for all FoxPro files.  If the FoxPro
echo files are marked as read only, and this program cannot
echo use the ATTRIB program, the patch process may fail.
echo If the patch process fails because the FoxPro files
echo are marked as read only, please mark the files as
echo read/write then re-execute this program.
echo.

pause

REM ---------------------------------------------------------------------------------
REM Check for required files
REM ---------------------------------------------------------------------------------

	if exist fpw.exe goto prequired
	if exist fpw_dk.exe goto prequired
	if exist fpd.exe goto prequired
	if exist fpd_dk.exe goto prequired

	cls

	echo WARNING!
	echo.
	echo The required files were not found.  The required 
	echo files are one of: FPW.EXE, FPW_DK.EXE, FPD.EXE, 
	echo and/or FPD_DK.EXE.  These required files are used
	echo to patch FoxPro from version 2.6 to 2.6a.  If you
	echo install optional files but do not install one of
	echo the required files, FoxPro will not function properly.
	echo.
	echo This program will now proceed to install any optional
	echo files which may exist in this directory on the assumption
	echo that you have previously patched FoxPro and now wish to 
	echo add update optional files.  If you have not previously
	echo patched FoxPro, then it is imperative that you download
	echo one of the required files and re-execute this procedure.
	echo.
	echo If you do not wish to proceed, please press CTRL+C
	echo to terminate this program now.
	echo.
	pause

REM ---------------------------------------------------------------------------------
REM Apply the patches to FoxPro
REM ---------------------------------------------------------------------------------

:prequired
	
	:pfpw
	if exist fpw.exe goto fpw

	:pfpw_dk
	if exist fpw_dk.exe goto fpw_dk

	:pfpd
	if exist fpd.exe goto fpd

	:pfpd_dk
	if exist fpd_dk.exe goto fpd_dk

	goto poptional

REM ---------------------------------------------------------------------------------
REM Apply the patches to FoxPro for Windows without DK
REM ---------------------------------------------------------------------------------

:fpw

	cls
	echo Applying patches to FoxPro for Windows without DK
	fpw.exe -o
	attrib -r foxpr*.exe
	attrib -r fox*.esl
	attrib -r fox*.eso
	attrib -r fox*.ovl
	patch -p
	attrib +r foxpr*.exe
	attrib +r fox*.esl
	attrib +r fox*.eso
	attrib +r fox*.ovl
	call vpatch
	del patch.dbf
	del patch.exe
	del sdk.fpf
	del w26a.fpf
	goto pfpw_dk

REM ---------------------------------------------------------------------------------
REM Apply the patches to FoxPro for Windows with DK
REM ---------------------------------------------------------------------------------

:fpw_dk

	cls
	echo Applying patches to FoxPro for Windows with DK
	fpw_dk.exe -o
	attrib -r foxpr*.exe
	attrib -r fox*.esl
	attrib -r fox*.eso
	attrib -r fox*.ovl
	patch -p
	attrib +r foxpr*.exe
	attrib +r fox*.esl
	attrib +r fox*.eso
	attrib +r fox*.ovl
	call vpatch
	del patch.dbf
	del patch.exe
	del esl.fpf
	del w26a.fpf
	goto pfpd

REM ---------------------------------------------------------------------------------
REM Apply the patches to FoxPro for MS-DOS without DK
REM ---------------------------------------------------------------------------------

:fpd

	cls
	echo Applying patches to FoxPro for MS-DOS with DK
	fpd.exe -o
	attrib -r foxpr*.exe
	attrib -r fox*.esl
	attrib -r fox*.eso
	attrib -r fox*.ovl
	patch -p
	attrib +r foxpr*.exe
	attrib +r fox*.esl
	attrib +r fox*.eso
	attrib +r fox*.ovl
	call vpatch
	del patch.dbf
	del patch.exe
	del dos.fpf
	del dosx.fpf
	del ovl.fpf
	goto pfpd_dk

REM ---------------------------------------------------------------------------------
REM Apply the patches to FoxPro for MS-DOS with DK
REM ---------------------------------------------------------------------------------

:fpd_dk

	cls
	echo Applying patches to FoxPro for MS-DOS with DK
	fpd_dk.exe -o
	attrib -r foxpr*.exe
	attrib -r fox*.esl
	attrib -r fox*.eso
	attrib -r fox*.ovl
	patch -p
	attrib +r foxpr*.exe
	attrib +r fox*.esl
	attrib +r fox*.eso
	attrib +r fox*.ovl
	call vpatch
	del patch.dbf
	del patch.exe
	del DESL.FPF        
	del DOSDK.FPF        
	del DOSXDK.FPF       
	del DXESL.FPF       
	del ESO.FPF       
	del LIBM.FPF       
	del LIBR.FPF       
	del MATHM.FPF       
	del MATHR.FPF       
	del OSXLIB.FPF       
	del OVLDK.FPF       
	del PROLIB.FPF       
	del ROSLIB.FPF       
	del WOVLIB.FPF       
	del OXT.FPF       
	del RTT.FPF       
	del FOXT.FPF       
	goto poptional

REM ---------------------------------------------------------------------------------
REM Check to see which optional files have been downloaded, and execute
REM each of the optional files
REM ---------------------------------------------------------------------------------

:poptional

	:papps
	if exist apps.exe goto apps
	:pdbhlpd
	if exist dbhlpd.exe goto dbhlpd
	:pdbhlpw
	if exist dbhlpw.exe goto dbhlpw
	:pfoxapp
	if exist foxapp.exe goto foxapp
	:pfpwhlp
	if exist fpwhlp.exe goto fpwhlp
	:pgenpd
	if exist genpd.exe goto genpd
	:pgens
	if exist gens.exe goto gens
	:pwizcat
	if exist wizcat.exe goto wizcat
	:pck
	if exist ck.exe goto ck

	goto end

REM ---------------------------------------------------------------------------------
REM Update the BEAUTIFY.APP, FOXAPP.APP, FOXSTART.APP, MIGRATE.APP, and SPELLCHK.APP files
REM ---------------------------------------------------------------------------------

:apps

	cls
	echo Updating various .APP files
	APPS -o -d

goto pdbhlpd

REM ---------------------------------------------------------------------------------
REM Update the DBF style help file (FPD)
REM ---------------------------------------------------------------------------------

:dbhlpd

	cls
	echo Updating DBF help file (FPD)
	DBHLPD -o -d

goto pdbhlpw

REM ---------------------------------------------------------------------------------
REM Update the DBF style help file (FPW)
REM ---------------------------------------------------------------------------------

:dbhlpw

	cls
	echo Updating DBF help file (FPW)
	DBHLPW -o -d

goto pfoxapp

REM ---------------------------------------------------------------------------------
REM Update the FoxApp files
REM ---------------------------------------------------------------------------------

:foxapp

	cls
	echo Updating FoxApp files
	FOXAPP -o -d

goto pfpwhlp

REM ---------------------------------------------------------------------------------
REM Update the FoxPro/Windows Help files
REM ---------------------------------------------------------------------------------

:fpwhlp

	cls
	echo Updating FoxPro for Windows help file
	FPWHLP -o -d

goto pgenpd

REM ---------------------------------------------------------------------------------
REM Update the DRIVER2.FLL, GEN_PD.PRG, GENPD.APP, GENPD.PJT, and GENPD.PJX files
REM ---------------------------------------------------------------------------------

:genpd

	cls
	echo Updating Printer Driver files
	GENPD -o -d

goto pgens

REM ---------------------------------------------------------------------------------
REM Update the GENGRAPH.APP, GENMENU.PRG, GENSCRN.PRG, GENXTAB.PRG, and TRANSPRT.PRG files
REM ---------------------------------------------------------------------------------

:gens

	cls
	echo Updating gen* files
	GENS -o -d

goto pwizcat

REM ---------------------------------------------------------------------------------
REM Update the CATALOG MANAGER and WIZARDS
REM ---------------------------------------------------------------------------------

:wizcat

	cls
	echo Updating Catalog Manager and Wizards
	WIZCAT -o -d

goto pck

REM ---------------------------------------------------------------------------------
REM Update the Connectivity Kit
REM ---------------------------------------------------------------------------------

:ck

	cls
	echo Applying patches to FoxPro Connectivity Kit
	CK -o -d
	attrib -r foxpr*.exe
	attrib -r fox*.esl
	attrib -r fox*.eso
	attrib -r fox*.ovl
	patch -p
	attrib +r foxpr*.exe
	attrib +r fox*.esl
	attrib +r fox*.eso
	attrib +r fox*.ovl
	call vpatch
	del patch.dbf
	del patch.exe
	del fll.fpf
	del plb.fpf
	DEL wizards\wizard.dbf
	DEL wizards\wizard.fpt  

goto end

REM ---------------------------------------------------------------------------------
REM End of Patch Application Area
REM ---------------------------------------------------------------------------------

:end

	cls

REM ---------------------------------------------------------------------------------
REM File Deletion
REM ---------------------------------------------------------------------------------

if exist foxapp.exe attrib -r foxapp.exe

if "%1" == "delete" goto delorig
if "%1" == "DELETE" goto delorig
goto delnone

:delorig

	echo Automatic File Deletion was selected.  
	echo.
	echo The files which were originally downloaded will 
	echo now be deleted from the current directory.
	
	if exist apps.exe del apps.exe
	if exist ck.exe del ck.exe
	if exist dbhlpd.exe del dbhlpd.exe
	if exist dbhlpw.exe del dbhlpw.exe
	if exist foxapp.exe del foxapp.exe
	if exist fpd.exe del fpd.exe 
	if exist fpd_dk.exe del fpd_dk.exe 
	if exist fpw.exe del fpw.exe 
	if exist fpw_dk.exe del fpw_dk.exe 
	if exist fpwhlp.exe del fpwhlp.exe
	if exist genpd.exe del genpd.exe
	if exist gens.exe del gens.exe
	if exist wizcat.exe del wizcat.exe

	goto final

:delnone

	echo Automatic File Deletion was not selected.  
	echo.
	echo The files which were originally downloaded will 
	echo not be deleted from the current directory.
	echo.
	echo If the patches have been applied and you no longer
	echo need the files which were originally downloaded,
	echo you can delete the following files:
	echo.
	echo apps.exe 
	echo ck.exe 
	echo dbhlpd.exe 
	echo dbhlpw.exe 
	echo foxapp.exe 
	echo fpd.exe 
	echo fpd_dk.exe 
	echo fpw.exe 
	echo fpw_dk.exe 
	echo fpwhlp.exe 
	echo genpd.exe
	echo gens.exe 
	echo wizcat.exe 

	goto final

:final

	if exist vpatch.bat del vpatch.bat

	echo.

	pause

	cls

	if exist gens.exe goto :gensnote

	goto goodbye

:gensnote

	echo WARNING!
	echo.
	echo The file GENS.EXE exists in the FoxPro directory.
	echo This file will conflict with FoxPro.  To avoid
	echo a conflict between GENS.EXE and FoxPro, please 
	echo do one of the following before you execute 
	echo FoxPro:
	echo.
	echo 1) Delete the file GENS.EXE, or
	echo 2) Rename the file GENS.EXE, or
	echo 3) Copy the file GENS.EXE to another
	echo    location then delete the copy of GENS.EXE
	echo    which currently resides in the FoxPro directory.
	echo.
	echo.

	pause

	goto goodbye

:goodbye

	cls

	echo The patch process is finished.
	echo.
	echo Thank you for using Microsoft FoxPro






