USHORT GetMMPMINIFile(VOID);
VOID BuildSection    (PSZ, PSZ);       /* Builds the section field          */
VOID BuildEntry      (PSZ, PSZ);       /* Builds the entry field            */
PSZ  FindSection     (PSZ, PSZ);       /* Find start of a given [section]   */
BOOL SectionStart    (PSZ);            /* Does INI line denote a [section]? */
VOID FormatEntryLine (PSZ);            /* Formats an entry line in INI file */
VOID AppendLine      (PSZ, PSZ);       /* Appends a string as the last line */
CHAR * CopyNBytes(  CHAR *pchTarget, CHAR *pchSource, ULONG cbNumBytes);
CHAR * ScootString( CHAR *pchString, LONG  sNumBytes);
ULONG  StringLength(CHAR *pchLine);
VOID   StripFrontWhite     (PSZ);
PSZ    NextLine            (PSZ);
VOID   CopyLine            (PSZ, PSZ);
LONG   InsertString        (PSZ, PSZ, PSZ);
//        ******************************
/* ķ */
/*     .INI routine return codes                                          */
/* Ľ */
                                         /*Ŀ*/
                                         /* ReadFileToBuffer              */
                                         /**/
#define INI_OK                  0        /* Successful                      */
#define INI_NO_SECTION          1        /* Section not found               */
#define INI_NO_ENTRY            2        /* Entry not found                 */
#define INI_MEM_ALLOC           3        /* Error on buffer allocation      */
#define INI_BUFLEN_TOO_SMALL    4        /* Error on buffer allocation      */
#define INI_INDEX_TOO_LARGE     5        /* Error on buffer allocation      */
#define BUFFER_TOO_SMALL        FALSE    /* Buffer toosmall                 */
#define APPEND_OK               TRUE     /* Successful                      */
/* ķ */
/*     String type declarations                                           */
/* Ľ */
#define T_STRING                1        /* Character string                */
#define T_NUMERIC               2        /* Numberic Value                  */
#define COMMA             (CHAR)','      /* Comma                           */
#define QUOTE             (CHAR)'"'      /* Quote                           */
#define END_OF_STRING           0        /* No more delimiters found        */
#define DELETE                  1        /* Delete original comments then add*/
#define APPEND                  2        /* Append to original comments     */

struct kwrds
   {
   CHAR INI_Keyword [32];
   struct kwrds *NextKeyword;
   };
/* ķ */
/*    Forward Function Declarations                                       */
/* Ľ */
                                         /*Ŀ*/
                                         /* Routines supplied to others   */
                                         /**/
ULONG  IniQuery          (PSZ, PSZ, PSZ, PSZ *, PSZ);
ULONG  IniUpdate         (PSZ, PSZ, PSZ, PSZ);
ULONG  IniDelete         (PSZ, PSZ, PSZ);
BOOL   IniAppendToken    (PSZ, ULONG, PVOID, ULONG);
ULONG  IniParseEntryLine (PSZ, PULONG, ULONG, PVOID, ULONG);
ULONG  IniKeywordQuery   (PSZ, PSZ, PSZ, ULONG);
//        ******************************
/* String processing definitions */
#define CR                       (CHAR) '\r'
#define LF                       (CHAR) '\n'
#define EOFFILE                  (CHAR) '\x1A'                         //P1A
#define BLANK                    (CHAR) ' '
#define TAB                      (CHAR) '\t'
#define EQUAL                    (CHAR) '='
#define COLON                    (CHAR) ':'
#define SEMICOLON                (CHAR) ';'
#define ZEND                     (CHAR) '\0'

#define CRLF                     "\r\n"
#define EOFLINE                  "\r\n\x1A"                            //P1A
#define BLANK_TAB                " \t"
#define BLANK_TAB_EOFLINE        " \t\r\n\x1A"                         //P1A
#define SEMIC_EOFLINE            ";\r\n\x1A"                           //P1A

/* ķ */
/*     Various program defines                                            */
/* Ľ */


#define FOUR_K                   4*1024
#define SEG_SIZE                 (ULONG)65536



/* ķ */
/*     return codes                                                       */
/* Ľ */
                                         /*Ŀ*/
                                         /* ReadFileToBuffer              */
                                         /**/
//#define RF_OK_0                 0      /* Successful                      */
//#define RF_ABOVE_64K            1      /* Buffer exceeds a segment size   */
//#define RF_0_READ               2      /* 0 Bytes read on DosRead         */
//#define RF_MEM_ALLOC            3      /* Error on buffer allocation      */
//#define RF_NOT_FOUND            4      /* DosOpen file not found          */
//#define RF_OPEN_FAIL            5      /* DosOpen other error             */

//#define RF_FAIL         "Fail to open file "                    P1D
//#define WF_FAIL         "Fail to write file "                   P1D

/* ķ */
/*    Forward Function Declarations                                       */
/* Ľ */
                                         /*Ŀ*/
                                         /* Routines supplied to others   */
                                         /**/
ULONG FAR ReadFileToBuffer     (PSZ, ULONG, PSZ *, ULONG *, PHFILE );
ULONG FAR WriteBufferToFile    (HFILE, PSZ);
ULONG FAR IniFileClose         (HFILE);
                                         /*Ŀ*/
                                         /* Routines used locally         */
                                         /**/
VOID   FAR BuildAssignment     (ULONG , PSZ, PSZ);
VOID   FAR FormatLine          (PSZ, PSZ);

#define ENABLE_EXCEPTIONS 0
#define DISABLE_EXCEPTIONS 2
#define ENABLE_HARDERRORS 1
#define DISABLE_HARDERRORS 0
#define DISABLE_ERRORPOPUP DISABLE_EXCEPTIONS | DISABLE_HARDERRORS
#define ENABLE_ERRORPOPUP ENABLE_EXCEPTIONS | ENABLE_HARDERRORS
