;  VCA32.H   
VCAERR_SUCCESS	EQU	0 
VCAERR_INVALID_BUFFER	EQU	1 
VCAERR_INVALID_RECT	EQU	2 
VCAERR_INVALID_PARM	EQU	3 
VCAERR_UNSUPPORTED_CMD	EQU	4 
VCAERR_HW_ERROR	EQU	5 
;  IOCTL Commands   
VCAI_INIINFO	EQU	60H 
VCAI_SETCAPTRECT	EQU	6BH 
VCAI_GETIMAGESCALE	EQU	6CH 
VCAI_GETDEVINFO	EQU	6DH 
VCAI_VIDEOADJ	EQU	75H 
VCAI_SETFPS	EQU	7EH 
VCAI_SETMONITOR	EQU	80H 
VCAI_EDCOLORKEY	EQU	81H 
VCAI_SETCOLORKEY	EQU	82H 
;  Common Cature Rectangle Define   

CRECT	STRUC
CR_X_Left	DD	?
CR_Y_Top	DD	?
CR_Y_Height	DD	?
CR_X_Width	DD	?
CRECT	ENDS
;  IOCTL category 140 code 6Bh - Set Source and Destination Capture Rectangles   

VCASETCAPTURERECT	STRUC
CR_Source_X_Left	DD	?
CR_Source_Y_Top	DD	?
CR_Source_Y_Height	DD	?
CR_Source_X_Width	DD	?
CR_Dest_X_Left	DD	?
CR_Dest_Y_Top	DD	?
CR_Dest_Y_Height	DD	?
CR_Dest_X_Width	DD	?
VCASETCAPTURERECT	ENDS
;  IOCTL category 140 code 6Ch - Get Image and Scale Into RAM Buffer   

VCAGETIMAGESCALE	STRUC
GIS_Capture_Buf_Len	DD	?
GIS_Capture_Buf_Ptr	DD	?
GIS_Source_X_Left	DD	?
GIS_Source_Y_Top	DD	?
GIS_Source_Y_Height	DD	?
GIS_Source_X_Width	DD	?
GIS_Dest_X_Left	DD	?
GIS_Dest_Y_Top	DD	?
GIS_Dest_Y_Height	DD	?
GIS_Dest_X_Width	DD	?
VCAGETIMAGESCALE	ENDS
;  IOCTL category 140 code 6Dh - Get Devinfo   

vcadevinfo	STRUC
DI_Length	DD	?
DI_ProdInfo	DB	30 DUP (?)
DI_ManInfo	DB	30 DUP (?)
DI_Version	DB	10 DUP (?)
DI_ImgFormat	DD	?        ;  Image Format Supported by the card              
DI_BitsPerPEL	DW	?       ;  Bit Per PEL in this image format                
DI_Overlay	DW	?          ;  Device has overlay support                      
DI_Brightness	DD	?       ;  Default Video Attributes for the card           
DI_hue	DD	?
DI_saturation	DD	?
DI_contrast	DD	?
DI_Sharpness	DD	?
DI_unused1	DD	?
DI_S_X_Left	DD	?         ;  Default Source Coordinates                      
DI_S_Y_Top	DD	?
DI_S_Y_Height	DD	?
DI_S_X_Width	DD	?
DI_D_X_Left	DD	?         ;  Default Destination Coordinates                 
DI_D_Y_Top	DD	?
DI_D_Y_Height	DD	?
DI_D_X_Width	DD	?
DI_D_ScaleFactor	DD	?    ;  Default Scale Factor on copy                    
DI_S_X_MAX	DD	?          ;  Maximum X size for the digitized Source         
DI_S_Y_MAX	DD	?          ;  Maximun Y size for the digitized Source         
DI_D_X_MAX	DD	?          ;  Maximun X size for the Destination              
DI_D_Y_MAX	DD	?          ;  Maximun Y size for the Destination              
DI_O_X_MAX	DD	?          ;  Maximun X size for the Overlay Destination      
DI_O_Y_MAX	DD	?          ;  Maximun Y size for the Overlay Destination      
DI_VideoInputs	DW	?      ;  Number of Software Switchable video Inputs      
DI_CanRestore	DW	?
DI_CanStretch	DW	?
DI_CanDistort	DW	?
DI_HasVolume	DW	?        ;  Has Volume  Control                             
DI_HasBalance	DW	?       ;  Has Balance Control                             
DI_CanScale	DW	?         ;  Can Scale Down on GetImage                      
DI_CanStream	DW	?        ;  Can do streaming of Images to Stream Handler    
DI_ulFileNum	DD	?        ;  System File Number used in Streaming            
vcadevinfo	ENDS
DI_IMAGEFORMAT_RGB_565	EQU	1 ; ;  bits 0-4 =Red, 5-10 =Green, 11-15 Blue     
DI_IMAGEFORMAT_YUV_411	EQU	2 ; ;  4 bytes of Y, 1 Byte of U, 1 Byte of V     
DI_BITSPERPEL_16	EQU	16 ; ;  16 Bits Per PEL                            
DI_NotSupported	EQU	-1 ; ;  Not Supported                              
DI_Supported	EQU	1 ; ;  Supported                                  
;  IOCTL category 140 code 6Eh - Set Streaming Capture Image Size   

VCACAPISIZE	STRUC
CS_X_Left	DD	?
CS_Y_Top	DD	?
CS_Y_Height	DD	?
CS_X_Width	DD	?
CS_ScaleFactor	DD	?
VCACAPISIZE	ENDS
;  IOCTL category 140 code 6Fh - Get Image Into RAM Buffer   

VCAGETIMAGE	STRUC
GI_Capture_Buf_Len	DD	?
GI_Capture_Buf_Ptr	DD	?
VCAGETIMAGE	ENDS
;  IOCTL category 140 code 70h - get buffer addressing   

VCABUFFER	STRUC
BA_buf_addr	DD	?   ;  32 bit linear address                                   
BA_buf_len	DD	?    ;  buffer length in bytes                                  
BA_buf_banks	DD	?  ;  number of banks (1 if full aperature)                   
VCABUFFER	ENDS
;  IOCTL category 140 code 71h - set current VRAM bank number   

VCASELECTBANK	STRUC
SB_bank_num	DD	?   ;  number of bank to select (0-39)                         
VCASELECTBANK	ENDS
;  IOCTL category 140 code 75h - set/query video adjustments    

VCASETVIDEO	STRUC
SV_set_brightness	DD	?   ;  1=min, 255=max, 128=norm, -1=no change, -2=reset default     
SV_set_hue	DD	?          ;  1=min, 255=max, 128=neutral, -1=no change, -2=reset default  
SV_set_saturation	DD	?   ;  1=min, 255=max, 128=norm, -1=no change, -2=reset default     
SV_set_contrast	DD	?     ;  1=min, 255=max, 128=norm, -1=no change, -2=reset default     
SV_ret_brightness	DD	?   ;  1=min, 255=max   
SV_ret_hue	DD	?          ;  1=min, 255=max   
SV_ret_saturation	DD	?   ;  1=min, 255=max   
SV_ret_contrast	DD	?     ;  1=min, 255=max   
VCASETVIDEO	ENDS
;  IOCTL category 140 code 76h - set Frame Rate for Streaming   

VCASETFPS	STRUC
SF_set_FPS	DD	?          ;  Frames to Second to stream to the Stream Handler     
SF_resv1	DD	?            ;  Reserved and set to Zero                             
VCASETFPS	ENDS
;  IOCTL category 140 code 60h - Init Info from .INI file  Generic Format    

VCAINITG	STRUC
INI_ulBrightness	DD	?   ;  1=min, 255=max                      
INI_ulHue	DD	?          ;  1=min, 255=max  or Tint             
INI_ulSaturation	DD	?   ;  1=min, 255=max  or Color            
INI_ulContrast	DD	?     ;  1=min, 255=max                      
INI_bD_Info	DB	512 DUP (?)   ;  Device Specific Info                
VCAINITG	ENDS
;  IOCTL category 140 code 60h - Init Info from .INI file       

VCAINIT	STRUC
IN_ulBrightness	DD	?   ;  1=min, 255=max                      
IN_ulHue	DD	?          ;  1=min, 255=max  or Tint             
IN_ulSaturation	DD	?   ;  1=min, 255=max  or Color            
IN_ulContrast	DD	?     ;  1=min, 255=max                      
IN_bControl	DB	?      ;  see ulControl Defines               
IN_bCapPos	DB	?      ;  see ulCappos  Defines               
VCAINIT	ENDS
;  ulControl Defines   
;   For More Info Refer to the Video Capture Adapter/A Reference manual    
;   Register 14 Control Register                                           
VCAC_YC_DECODE	EQU	80H 
VCAC_FORMAT_565	EQU	40H 
VCAC_CURSOR_ENABLE	EQU	20H 
VCAC_DISPLAY_ENABLE	EQU	10H 
VCAC_GEN_LOCK	EQU	08H 
VCAC_OUTOUT_SYNC_GREEN	EQU	04H 
VCAC_NTSC_or_YC	EQU	00H 
VCAC_PAL_or_YC	EQU	00H 
VCAC_RGB	EQU	01H 
;  ulCappos Defines   
;   NI = Non-Interlaced   
;   I  = Interlaced       
;   The First 3 bit determine what type of signal to decode                
;   The Last  5 bit determine synchronization lock position  0=rightmost   
;   For More Info Refer to the Video Capture Adapter/A Reference manual    
;   Register 12 Screen\Capture Position Controls                           
VCACP_NI262_field_1	EQU	80H 
VCACP_NI262_field_2	EQU	0A0H 
VCACP_NI263_field_1	EQU	0C0H 
VCACP_NI263_field_2	EQU	0E0H 
VCACP_I262_5_field_both	EQU	00H 
VCACP_I262_5_field_2	EQU	20H 
VCACP_I262_5_field_1	EQU	40H 
VCACP_I262_5_field_2B	EQU	60H 
VCACP_Default_Pos	EQU	0CH 
;*********************** ********************** ***************************  
;*********************** Overlay Card Functions ***************************  
;*********************** ********************** ***************************  
;  IOCTL category 140 code 80h - Enable/Disable Monitor         

VCASETMONITOR	STRUC
EDM_bMonitor	DD	?               ;  1=TRUE=ON, 0=FALSE=OFF      
VCASETMONITOR	ENDS
;  IOCTL category 140 code 81h - Enable/Disable Transparrent Color    

VCAEDCOLORKEY	STRUC
EDCK_bColorKeying	DD	?           ;  1=TRUE=ON, 0=FALSE=OFF            
VCAEDCOLORKEY	ENDS
;  IOCTL category 140 code 82h - Set Color Key / Transparrent Color   

VCASETCOLORKEY	STRUC
SCK_ulColorKey	DD	?             ;  Transparrent Color               
VCASETCOLORKEY	ENDS
