/* VCA32.H */

#define VCAERR_SUCCESS            0
#define VCAERR_INVALID_BUFFER     1
#define VCAERR_INVALID_RECT       2
#define VCAERR_INVALID_PARM       3
#define VCAERR_UNSUPPORTED_CMD    4
#define VCAERR_HW_ERROR           5

/* IOCTL Commands */
#define  VCAI_INIINFO          0x60
#define  VCAI_SETCAPTRECT      0x6B
#define  VCAI_GETIMAGESCALE    0x6C
#define  VCAI_GETDEVINFO       0x6D
#define  VCAI_VIDEOADJ         0x75
#define  VCAI_SETFPS           0x7E
#define  VCAI_SETMONITOR       0x80
#define  VCAI_EDCOLORKEY       0x81
#define  VCAI_SETCOLORKEY      0x82


/* Common Cature Rectangle Define */
typedef struct CRECT {     /* CR */
   ULONG X_Left;
   ULONG Y_Top;
   ULONG Y_Height;
   ULONG X_Width;
} CRECT;

/* XLATOFF */
#pragma pack(1)
/* XLATON */

/* IOCTL category 140 code 6Bh - Set Source and Destination Capture Rectangles */
typedef struct VCASETCAPTURERECT{      /* CR */
   ULONG  Source_X_Left;
   ULONG  Source_Y_Top;
   ULONG  Source_Y_Height;
   ULONG  Source_X_Width;
   ULONG  Dest_X_Left;
   ULONG  Dest_Y_Top;
   ULONG  Dest_Y_Height;
   ULONG  Dest_X_Width;
} VCASETCAPTURERECT;
typedef VCASETCAPTURERECT FAR * PVCASETCAPTURERECT;

/* IOCTL category 140 code 6Ch - Get Image and Scale Into RAM Buffer */
typedef struct VCAGETIMAGESCALE{      /* GIS */
   ULONG  Capture_Buf_Len;
   ULONG  Capture_Buf_Ptr;
   ULONG  Source_X_Left;
   ULONG  Source_Y_Top;
   ULONG  Source_Y_Height;
   ULONG  Source_X_Width;
   ULONG  Dest_X_Left;
   ULONG  Dest_Y_Top;
   ULONG  Dest_Y_Height;
   ULONG  Dest_X_Width;
} VCAGETIMAGESCALE;
typedef VCAGETIMAGESCALE FAR * PVCAGETIMAGESCALE;


/* IOCTL category 140 code 6Dh - Get Devinfo */
typedef struct _vcadevinfo {     /* DI */
   ULONG  Length;
   CHAR   ProdInfo[30];
   CHAR   ManInfo[30];
   CHAR   Version[10];
   ULONG  ImgFormat;        /* Image Format Supported by the card            */
   USHORT BitsPerPEL;       /* Bit Per PEL in this image format              */
   USHORT Overlay;          /* Device has overlay support                    */
   ULONG  Brightness;       /* Default Video Attributes for the card         */
   ULONG  hue;
   ULONG  saturation;
   ULONG  contrast;
   ULONG  Sharpness;
   ULONG  unused1;
   ULONG  S_X_Left;         /* Default Source Coordinates                    */
   ULONG  S_Y_Top;
   ULONG  S_Y_Height;
   ULONG  S_X_Width;
   ULONG  D_X_Left;         /* Default Destination Coordinates               */
   ULONG  D_Y_Top;
   ULONG  D_Y_Height;
   ULONG  D_X_Width;
   ULONG  D_ScaleFactor;    /* Default Scale Factor on copy                  */
   ULONG  S_X_MAX;          /* Maximum X size for the digitized Source       */
   ULONG  S_Y_MAX;          /* Maximun Y size for the digitized Source       */
   ULONG  D_X_MAX;          /* Maximun X size for the Destination            */
   ULONG  D_Y_MAX;          /* Maximun Y size for the Destination            */
   ULONG  O_X_MAX;          /* Maximun X size for the Overlay Destination    */
   ULONG  O_Y_MAX;          /* Maximun Y size for the Overlay Destination    */
   USHORT VideoInputs;      /* Number of Software Switchable video Inputs    */
   USHORT CanRestore;
   USHORT CanStretch;
   USHORT CanDistort;
   USHORT HasVolume;        /* Has Volume  Control                           */
   USHORT HasBalance;       /* Has Balance Control                           */
   USHORT CanScale;         /* Can Scale Down on GetImage                    */
   USHORT CanStream;        /* Can do streaming of Images to Stream Handler  */
   ULONG  ulFileNum;        /* System File Number used in Streaming          */
} VCADEVINFO;

typedef VCADEVINFO FAR * PVCADEVINFO;

/* XLATOFF */
#pragma pack()
/* XLATON */

#define DI_IMAGEFORMAT_RGB_565        1; /* bits 0-4 =Red, 5-10 =Green, 11-15 Blue   */
#define DI_IMAGEFORMAT_YUV_411        2; /* 4 bytes of Y, 1 Byte of U, 1 Byte of V   */
#define DI_BITSPERPEL_16             16; /* 16 Bits Per PEL                          */
#define DI_NotSupported              -1; /* Not Supported                            */
#define DI_Supported                  1; /* Supported                                */

/* IOCTL category 140 code 6Eh - Set Streaming Capture Image Size */
typedef struct VCACAPISIZE {     /* CS */
   ULONG X_Left;
   ULONG Y_Top;
   ULONG Y_Height;
   ULONG X_Width;
   ULONG ScaleFactor;
} VCACAPISIZE;
typedef VCACAPISIZE FAR * PVCACAPISIZE;

/* IOCTL category 140 code 6Fh - Get Image Into RAM Buffer */
typedef struct VCAGETIMAGE{      /* GI */
   ULONG  Capture_Buf_Len;
   ULONG  Capture_Buf_Ptr;
} VCAGETIMAGE;
typedef VCAGETIMAGE FAR * PVCAGETIMAGE;


/* IOCTL category 140 code 70h - get buffer addressing */
typedef struct VCABUFFER{        /* BA */
   ULONG buf_addr;   /* 32 bit linear address                                 */
   ULONG buf_len;    /* buffer length in bytes                                */
   ULONG buf_banks;  /* number of banks (1 if full aperature)                 */
} VCABUFFER;
typedef VCABUFFER FAR * PVCABUFFER;

/* IOCTL category 140 code 71h - set current VRAM bank number */
typedef struct VCASELECTBANK{    /* SB */
   ULONG bank_num;   /* number of bank to select (0-39)                       */
} VCASELECTBANK;
typedef VCASELECTBANK FAR * PVCASELECTBANK;

/* IOCTL category 140 code 75h - set/query video adjustments  */
typedef struct VCASETVIDEO{      /* SV */
   ULONG set_brightness;   /* 1=min, 255=max, 128=norm, -1=no change, -2=reset default   */
   ULONG set_hue;          /* 1=min, 255=max, 128=neutral, -1=no change, -2=reset default*/
   ULONG set_saturation;   /* 1=min, 255=max, 128=norm, -1=no change, -2=reset default   */
   ULONG set_contrast;     /* 1=min, 255=max, 128=norm, -1=no change, -2=reset default   */
   ULONG ret_brightness;   /* 1=min, 255=max */
   ULONG ret_hue;          /* 1=min, 255=max */
   ULONG ret_saturation;   /* 1=min, 255=max */
   ULONG ret_contrast;     /* 1=min, 255=max */
} VCASETVIDEO;
typedef VCASETVIDEO FAR * PVCASETVIDEO;

/* IOCTL category 140 code 76h - set Frame Rate for Streaming */
typedef struct VCASETFPS{        /* SF */
   ULONG set_FPS;          /* Frames to Second to stream to the Stream Handler   */
   ULONG resv1;            /* Reserved and set to Zero                           */
} VCASETFPS;
typedef VCASETFPS FAR * PVCASETFPS;

/* IOCTL category 140 code 60h - Init Info from .INI file  Generic Format  */
typedef struct VCAINITG {      /* INI */
   ULONG ulBrightness;   /* 1=min, 255=max                    */
   ULONG ulHue;          /* 1=min, 255=max  or Tint           */
   ULONG ulSaturation;   /* 1=min, 255=max  or Color          */
   ULONG ulContrast;     /* 1=min, 255=max                    */
   BYTE  bD_Info[512];   /* Device Specific Info              */
} VCAINITG;
typedef VCAINITG FAR * PVCAINITG;

/* IOCTL category 140 code 60h - Init Info from .INI file     */
typedef struct VCAINIT {      /* IN */
   ULONG ulBrightness;   /* 1=min, 255=max                    */
   ULONG ulHue;          /* 1=min, 255=max  or Tint           */
   ULONG ulSaturation;   /* 1=min, 255=max  or Color          */
   ULONG ulContrast;     /* 1=min, 255=max                    */
   BYTE  bControl ;      /* see ulControl Defines             */
   BYTE  bCapPos  ;      /* see ulCappos  Defines             */
} VCAINIT;
typedef VCAINIT FAR * PVCAINIT;

/* ulControl Defines */
/*  For More Info Refer to the Video Capture Adapter/A Reference manual  */
/*  Register 14 Control Register                                         */
#define  VCAC_YC_DECODE         0x80
#define  VCAC_FORMAT_565        0x40
#define  VCAC_CURSOR_ENABLE     0x20
#define  VCAC_DISPLAY_ENABLE    0x10
#define  VCAC_GEN_LOCK          0x08
#define  VCAC_OUTOUT_SYNC_GREEN 0x04
#define  VCAC_NTSC_or_YC        0x00
#define  VCAC_PAL_or_YC         0x00
#define  VCAC_RGB               0x01

/* ulCappos Defines */
/*  NI = Non-Interlaced */
/*  I  = Interlaced     */
/*  The First 3 bit determine what type of signal to decode              */
/*  The Last  5 bit determine synchronization lock position  0=rightmost */
/*  For More Info Refer to the Video Capture Adapter/A Reference manual  */
/*  Register 12 Screen\Capture Position Controls                         */
#define  VCACP_NI262_field_1      0x80
#define  VCACP_NI262_field_2      0xA0
#define  VCACP_NI263_field_1      0xC0
#define  VCACP_NI263_field_2      0xE0
#define  VCACP_I262_5_field_both  0x00
#define  VCACP_I262_5_field_2     0x20
#define  VCACP_I262_5_field_1     0x40
#define  VCACP_I262_5_field_2B    0x60
#define  VCACP_Default_Pos        0x0C


/*********************** ********************** ****************************/
/*********************** Overlay Card Functions ****************************/
/*********************** ********************** ****************************/

/* IOCTL category 140 code 80h - Enable/Disable Monitor       */
typedef struct VCASETMONITOR {   /* EDM */
   BOOL  bMonitor;               /* 1=TRUE=ON, 0=FALSE=OFF    */
} VCASETMONITOR;
typedef VCASETMONITOR FAR * PVCASETMONITOR;

/* IOCTL category 140 code 81h - Enable/Disable Transparrent Color  */
typedef struct VCAEDCOLORKEY {   /* EDCK */
   BOOL  bColorKeying;           /* 1=TRUE=ON, 0=FALSE=OFF          */
} VCAEDCOLORKEY;
typedef VCAEDCOLORKEY FAR * PVCAEDCOLORKEY;

/* IOCTL category 140 code 82h - Set Color Key / Transparrent Color */
typedef struct VCASETCOLORKEY {   /* SCK */
   ULONG  ulColorKey;             /* Transparrent Color             */
} VCASETCOLORKEY;
typedef VCASETCOLORKEY FAR * PVCASETCOLORKEY;

