.386p
INCL_DOSMISC    EQU     1
INCL_DOSERRORS  EQU     1
INCL_TYPES      EQU     1
INCL_DEF        EQU     1

EXTRN   TIMEINTRPT:FAR               ; Generic Timer Interrupt Handler
EXTRN    _VCACopyBuf:FAR             ;       Full aperture Image Copy
EXTRN    _VCACopyBuf2:FAR            ; Not a Full aperture Image Copy
;*********************************************
; Define the C calling macros
LBegin  macro len
        push    ebp
        mov     ebp,esp
        sub     esp,len
        endm
LEnd    macro
        mov     esp,ebp
        pop     ebp
        endm
;*********************************************

MAIN            EQU     1             ; used in ssmdd.inc
.xlist
        include devsym.inc
        include basemaca.inc
        include basedef.inc
        include devhlp.inc
;       include bse.inc
        include infoseg.inc

;        include ptrace.inc              ; PTRACE macros
        include os2medef.inc
        include meerror.inc
        include ssm.inc
        include shdd.inc
        include vididc.inc
        include video.inc
.list



DATA   SEGMENT  DWORD USE16 PUBLIC 'DATA'      ; changed from code to data
;        ASSUME   CS: FLAT, DS: FLAT, SS: FLAT, ES: FLAT

ALIGN 4
        EXTRN   device_hlp:DWORD
        EXTRN   SI_CURR:DWORD         ; Current Stream handler Instances
        EXTRN   IOBASE:WORD           ; IO Port base address
        EXTRN   PAGES:WORD            ; Number of Pages in the cards aperture
        EXTRN   lin_addr:DWORD        ; 32 bit linear address  (GLOBAL) for H/W buffer
        EXTRN   REG12:BYTE            ; Field Info

IDC       equ   es:[bx]                 ; Pointer to IDC Request packet

REG5_Intr_on_mask    equ  00000100b     ; Reg 5 interrupts on  mask
REG5_Intr_off_mask   equ  11111011b     ; Reg 5 interrupts off mask
REG5_Intr_on_EFrame  equ  00000000b     ; Reg 5 interrupt End of Frame
REG5_Intr_on_EField  equ  11000001b     ; Reg 5 interrupt End of Field
REG5_Intr_source     equ  11111100b     ; Reg 5 interrupt source maskd
Field_info  equ 11100000B               ; Reg 12 Field Info
DATA   ENDS


_TEXT   SEGMENT  DWORD USE16 PUBLIC 'CODE'
        ASSUME   CS: FLAT, DS: FLAT, SS: FLAT, ES: FLAT




;************************** I D C   S T A R T    S T R E A M I N G *************************
subttl IDC FUNC CONTROL START
page
;            Start the Timer Interrupts
;
Procedure IDC_START_S, FAR
        ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

        pushfd
        push  dx
        cli

        ; Turn Interrupts on
        mov   dx,iobase               ; get I/O address
        add   dx,5                    ; DX = reg 5 (Interrupt Select)
        in    al,dx                   ; Read Reg5
        and   al,REG5_Intr_source     ; Clear Interrupt source area
        or    al,REG5_Intr_on_EFrame  ; Interrupt on End of Frame
        or    al,REG5_Intr_on_mask    ; Turn ON Interrupt
        mov   dx,iobase               ; get I/O address
        add   dx,5                    ; DX = reg 5 (Interrupt Select)
        out   dx,al                   ; Tell the card


        mov   ax,0                    ; !!! Say Function worked

START_DONE:
        pop   dx
        popfd
        ret
ENDPROC IDC_START_S

;************************** I D C   S T O P    S T R E A M I N G ***************************
subttl IDC STOP STREAMING
page
Procedure IDC_STOP_S, FAR
        ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

        pushfd
        push  dx
        cli

        ; Turn off interrupts
        mov   dx,iobase               ; get I/O address
        add   dx,5                    ; DX = reg 5 (Interrupt Select)
        in    al,dx                   ; Read Reg5
        and   al,REG5_Intr_off_mask   ; Turn off Interrupts
        out   dx,al                   ; Tell the card


        mov   ax,0                    ; !!! Say Function worked

STOP_DONE:
        pop   dx
        popfd
        RET
ENDPROC IDC_STOP_S

;************************** I D C   P A U S E   S T R E A M I N G  *************************
subttl IDC PAUSE STREAMING
page
Procedure IDC_PAUSE_S, FAR
        ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING


        CALL   IDC_STOP_S                   ; Turn Off the interrupts

        mov     ax,0                        ; !!! Say Function worked

        RET
ENDPROC IDC_PAUSE_S

;************************** I D C   R E S U M E   S T R E A M I N G ***********************
subttl RESUME Streaming Capture
page
Procedure IDC_RESUME_S, FAR
        ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING


        CALL   IDC_START_S                  ; Turn ON the interrupts


        RET
ENDPROC IDC_RESUME_S


;***************************************************************************
;  GetImage to Streaming Buffer
;
;
;***************************************************************************
Procedure IDC_GETIMAGE_S,FAR
        ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

       PUSHFD
;      CLI

ReadImage:
       ; Put Parameters on the stack for the Call to the Copy Image buffer routines
       mov       eax,[SI_Curr]        ; Get Current Stream Instance buffers address

       ; Put Parameters on the stack for the Call to the Copy Image buffer routines

       ; Is Scanline Double required (Only 1 fields captured and Scale = 1)
       xor       ebx,ebx                       ; Assume Double not required
       mov       edx,fs:[eax].SI_ScaleFactor   ; Scale
       mov       cl,reg12
       and       cl,field_info                 ; Bot Fields captured?
       jz        Double_info                   ; Both fields were captured
       cmp       edx,1                         ; Scale = 1?
       jne       Double_info                   ; Scale not equal to 1
       mov       ebx,1                         ; Double of scanlines required
double_info:
       push      ebx                           ; Double
       push      edx                           ; Scale Factor

       mov       ecx,fs:[eax].SI_Y_Height      ; Y_Height
       push      ecx

       mov       ecx,fs:[eax].SI_X_Width       ; X_Width
       push      ecx

       mov       ecx,fs:[eax].SI_Y_Top         ; Y_Top
       push      ecx

       mov       ecx,fs:[eax].SI_X_Left        ; X_Left
       push      ecx

       mov       ecx,fs:[eax].SI_pCur_Img_Free ; Destination Buffer
       ADD       ecx,size VIDEO_FRAME_HDR      ; allow room for header
       push      ecx

       mov       ecx,[Lin_addr]          ; Source Buffer
       push      ecx

       ; is this VCA setup with a full aperture
       mov       ax,pages               ; Number of pages in a bank
       cmp       ax,40                  ; 40 pages in a bank is Full Aperture
       jne       I_multibankcopy        ; NOT full aperture

I_singlebankcopy:                        ; Image in a single bank
       call      _VCACopyBuf             ; R E A D    I N    T H E    I M A G E
       jmp       I_bankcopydone

I_multibankcopy:                         ; Image in multiple banks
       call      _VCACopyBuf2            ; R E A D    I N    T H E    I M A G E

I_bankcopydone:
       add       esp,4*8                 ; Remove the parameters from the stack


       POPFD
       ret

EndProc IDC_GETIMAGE_S

_TEXT   ENDS
END
