#define  MAX_NUM_HVSDS   64              // Maximun Number of HVSDs
#define  MAX_NUM_PDDS    16              // Maximun Number of PDD

/* PDDs that have been Opened (one open per PDD) */
   typedef struct {
      PVOID                 pNextPDD;                  // Next PDD in the List
      PVOID                 pPrevPDD;                  // Previous PDD in the List
      CHAR                  szPDDName[MAX_DEVICE_NAME];// Name of PDD Opened
      ULONG                 Use_Count;                 // Number of HVSD using this PDD
      HFILE                 CaptureDevHandle;          // file handle for image capture device
   } PDD_INSTANCE;


/* HVSD instance information for each OPEN connection */
   typedef struct {
      PVOID                 pNextHVSD;                 // Next VSD in the List
      PVOID                 pPrevHVSD;                 // Previous VSD in the List
      PVOID                 hVSD_ID;                   // Handle/ID for this VSD (not a pointer)
      ULONG                 ulState;                   // 1=Restored/Active 0=Saved\Inactive
      ULONG                 ulFlags;                   //
      IRECT                 SourceRect;                // Source Rectangle info
      IRECT                 DestRect;                  // Destination Rectangle info
      VSD_QUERYIMAGEEXTENTS_PARMS IExtents;            // Image Extents
      VSD_QUERYVIDEOEXTENTS_PARMS VExtents;            // Video Extents
      VSD_QUERYOVERLAYEXTENTS_PARMS OExtents;          // Overlay Extents
      ULONG                 ulFPS;                     // Frames Per Second for streaming
      ULONG                 ulImgHSize;                // Size of Current Image Header in Bytes
      ULONG                 ulScaleFactor;             // Scale Factor from Source to Destination Rectangle
      VSD_VIDEOATTRIBUTES_PARMS  VIDEOATTRIB;          // Hue, Brightness, Color, ect.
      VSD_VIDEOATTRIBUTES_PARMS  VIDEOATTRIB_Defaults; // Default Hue, Brightness, Color, ect.
      ULONG                 ulImageFormat;             // RGB16, YUV411, ect.
      USHORT                usBitsPerPEL;              // Bits Per PEL at the Current Image Format
      ULONG                 ulFreeze;                  // Frozen or Unfrozen image
      ULONG                 ulNTSC;                    // NTSC or PAL
      ULONG                 ulVSource;                 // Video Input Source from which connector
      HFILE                 CaptureDevHandle;          // file handle for image capture device
      ULONG                 ulFileNum;                 // Instance ID for Streaming
      PDD_INSTANCE        * pPDD;                      // PDD Instance Info
      USHORT              * bankbuf;                   // pointer to hardware image capture buffer
      BOOL                  bankswitch;                // TRUE if hardware buffer not full aperature
      DWORD                 banksize;                  // bank size in bytes
      DWORD                 numbanks;                  // number of banks if bank switching
      BYTE                * vcalinearbuf;              // VCA linear buffer (to hold coallesced image)
      ULONG                 ulNumFormats;              // Number of Image Formats supported
      VSD_GETDEVCAPS_PARMS  DC;                        // Device Capabilities Info
      VSD_QUERYIMAGEFORMAT_PARMS * pImg_Formats;       // Valid Image Format(s) supported
      PVOID                 pINI_Parms;                // Card Specific infor from .INI file
      ULONG                 Len_INI_Parms;             // Lenght of .INI info
      ULONG                 ulColor;                   // Transparent Color
      BOOL                  bColorKeying;              // Color Keying Enabled
      BOOL                  bViewPort;                 // View Port Enabled
      ULONG                 VideoMode;                 // Video Mode
   } HVSD_INSTANCE;

/* Different states for the Device  (ulState)  */
#define VSD_ulState_Saved             0
#define VSD_ulState_Restored          1

